/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.satellite;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.Rlog;
import android.telephony.satellite.SatelliteSubscriberInfo;
import com.android.internal.telephony.util.TelephonyUtils;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
public class SatelliteSubscriberProvisionStatus
implements Parcelable {
    private SatelliteSubscriberInfo mSubscriberInfo;
    private boolean mProvisioned;
    @NonNull
    public static final Parcelable.Creator<SatelliteSubscriberProvisionStatus> CREATOR = new Parcelable.Creator<SatelliteSubscriberProvisionStatus>(){

        @Override
        public SatelliteSubscriberProvisionStatus createFromParcel(Parcel in) {
            return new SatelliteSubscriberProvisionStatus(in);
        }

        public SatelliteSubscriberProvisionStatus[] newArray(int size) {
            return new SatelliteSubscriberProvisionStatus[size];
        }
    };

    public SatelliteSubscriberProvisionStatus(@NonNull Builder builder) {
        this.mSubscriberInfo = builder.mSubscriberInfo;
        this.mProvisioned = builder.mProvisioned;
    }

    private SatelliteSubscriberProvisionStatus(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeParcelable(this.mSubscriberInfo, flags);
        out.writeBoolean(this.mProvisioned);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public SatelliteSubscriberInfo getSatelliteSubscriberInfo() {
        return this.mSubscriberInfo;
    }

    public boolean isProvisioned() {
        return this.mProvisioned;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SatelliteSubscriberInfo:");
        sb.append(Rlog.pii(TelephonyUtils.IS_DEBUGGABLE, (Object)this.mSubscriberInfo));
        sb.append(",");
        sb.append("ProvisionStatus:");
        sb.append(this.mProvisioned);
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.mSubscriberInfo, this.mProvisioned);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SatelliteSubscriberProvisionStatus)) {
            return false;
        }
        SatelliteSubscriberProvisionStatus that = (SatelliteSubscriberProvisionStatus)o;
        return Objects.equals(this.mSubscriberInfo, that.mSubscriberInfo) && this.mProvisioned == that.mProvisioned;
    }

    private void readFromParcel(Parcel in) {
        this.mSubscriberInfo = in.readParcelable(SatelliteSubscriberInfo.class.getClassLoader(), SatelliteSubscriberInfo.class);
        this.mProvisioned = in.readBoolean();
    }

    public static class Builder {
        private SatelliteSubscriberInfo mSubscriberInfo;
        private boolean mProvisioned;

        @NonNull
        public Builder setSatelliteSubscriberInfo(@NonNull SatelliteSubscriberInfo satelliteSubscriberInfo) {
            this.mSubscriberInfo = satelliteSubscriberInfo;
            return this;
        }

        @NonNull
        public Builder setProvisioned(boolean provisioned) {
            this.mProvisioned = provisioned;
            return this;
        }

        @NonNull
        public SatelliteSubscriberProvisionStatus build() {
            return new SatelliteSubscriberProvisionStatus(this);
        }
    }
}

