/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.satellite;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.Rlog;
import com.android.internal.telephony.util.TelephonyUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
@FlaggedApi(value="com.android.internal.telephony.flags.satellite_system_apis")
public class SatelliteSubscriberInfo
implements Parcelable {
    @NonNull
    private String mSubscriberId;
    private int mCarrierId;
    private String mNiddApn;
    private int mSubscriptionId;
    public static final int SUBSCRIBER_ID_TYPE_ICCID = 0;
    public static final int SUBSCRIBER_ID_TYPE_IMSI_MSISDN = 1;
    private int mSubscriberIdType;
    @NonNull
    public static final Parcelable.Creator<SatelliteSubscriberInfo> CREATOR = new Parcelable.Creator<SatelliteSubscriberInfo>(){

        @Override
        public SatelliteSubscriberInfo createFromParcel(Parcel in) {
            return new SatelliteSubscriberInfo(in);
        }

        public SatelliteSubscriberInfo[] newArray(int size) {
            return new SatelliteSubscriberInfo[size];
        }
    };

    private SatelliteSubscriberInfo(Parcel in) {
        this.readFromParcel(in);
    }

    public SatelliteSubscriberInfo(@NonNull Builder builder) {
        this.mSubscriberId = builder.mSubscriberId;
        this.mCarrierId = builder.mCarrierId;
        this.mNiddApn = builder.mNiddApn;
        this.mSubscriptionId = builder.mSubscriptionId;
        this.mSubscriberIdType = builder.mSubscriberIdType;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        out.writeString(this.mSubscriberId);
        out.writeInt(this.mCarrierId);
        out.writeString(this.mNiddApn);
        out.writeInt(this.mSubscriptionId);
        out.writeInt(this.mSubscriberIdType);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public String getSubscriberId() {
        return this.mSubscriberId;
    }

    public int getCarrierId() {
        return this.mCarrierId;
    }

    @NonNull
    public String getNiddApn() {
        return this.mNiddApn;
    }

    public int getSubscriptionId() {
        return this.mSubscriptionId;
    }

    public int getSubscriberIdType() {
        return this.mSubscriberIdType;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SubscriberId:");
        sb.append(Rlog.pii(TelephonyUtils.IS_DEBUGGABLE, (Object)this.mSubscriberId));
        sb.append(",");
        sb.append("CarrierId:");
        sb.append(this.mCarrierId);
        sb.append(",");
        sb.append("NiddApn:");
        sb.append(this.mNiddApn);
        sb.append(",");
        sb.append("SubscriptionId:");
        sb.append(this.mSubscriptionId);
        sb.append(",");
        sb.append("SubscriberIdType:");
        sb.append(this.mSubscriberIdType);
        return sb.toString();
    }

    public int hashCode() {
        return Objects.hash(this.mSubscriberId, this.mCarrierId, this.mNiddApn, this.mSubscriptionId, this.mSubscriberIdType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SatelliteSubscriberInfo)) {
            return false;
        }
        SatelliteSubscriberInfo that = (SatelliteSubscriberInfo)o;
        return Objects.equals(this.mSubscriberId, that.mSubscriberId) && this.mCarrierId == that.mCarrierId && Objects.equals(this.mNiddApn, that.mNiddApn) && this.mSubscriptionId == that.mSubscriptionId && this.mSubscriberIdType == that.mSubscriberIdType;
    }

    private void readFromParcel(Parcel in) {
        this.mSubscriberId = in.readString();
        this.mCarrierId = in.readInt();
        this.mNiddApn = in.readString();
        this.mSubscriptionId = in.readInt();
        this.mSubscriberIdType = in.readInt();
    }

    public static class Builder {
        @NonNull
        private String mSubscriberId;
        private int mCarrierId;
        @NonNull
        private String mNiddApn;
        private int mSubscriptionId;
        private int mSubscriberIdType;

        @NonNull
        public Builder setSubscriberId(@NonNull String subscriberId) {
            this.mSubscriberId = subscriberId;
            return this;
        }

        @NonNull
        public Builder setCarrierId(int carrierId) {
            this.mCarrierId = carrierId;
            return this;
        }

        @NonNull
        public Builder setNiddApn(@NonNull String niddApn) {
            this.mNiddApn = niddApn;
            return this;
        }

        @NonNull
        public Builder setSubscriptionId(int subId) {
            this.mSubscriptionId = subId;
            return this;
        }

        @NonNull
        public Builder setSubscriberIdType(int subscriberIdType) {
            this.mSubscriberIdType = subscriberIdType;
            return this;
        }

        @NonNull
        public SatelliteSubscriberInfo build() {
            return new SatelliteSubscriberInfo(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SubscriberIdType {
    }
}

