/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.satellite;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.satellite.AntennaPosition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@SystemApi
public class SatelliteCapabilities
implements Parcelable {
    @NonNull
    private Set<Integer> mSupportedRadioTechnologies;
    private boolean mIsPointingRequired;
    private int mMaxBytesPerOutgoingDatagram;
    @NonNull
    private Map<Integer, AntennaPosition> mAntennaPositionMap;
    @NonNull
    public static final Parcelable.Creator<SatelliteCapabilities> CREATOR = new Parcelable.Creator<SatelliteCapabilities>(){

        @Override
        public SatelliteCapabilities createFromParcel(Parcel in) {
            return new SatelliteCapabilities(in);
        }

        public SatelliteCapabilities[] newArray(int size) {
            return new SatelliteCapabilities[size];
        }
    };

    public SatelliteCapabilities(@Nullable Set<Integer> supportedRadioTechnologies, boolean isPointingRequired, int maxBytesPerOutgoingDatagram, @NonNull Map<Integer, AntennaPosition> antennaPositionMap) {
        this.mSupportedRadioTechnologies = supportedRadioTechnologies == null ? new HashSet() : supportedRadioTechnologies;
        this.mIsPointingRequired = isPointingRequired;
        this.mMaxBytesPerOutgoingDatagram = maxBytesPerOutgoingDatagram;
        this.mAntennaPositionMap = antennaPositionMap;
    }

    private SatelliteCapabilities(Parcel in) {
        this.readFromParcel(in);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel out, int flags) {
        if (this.mSupportedRadioTechnologies != null && !this.mSupportedRadioTechnologies.isEmpty()) {
            out.writeInt(this.mSupportedRadioTechnologies.size());
            for (int technology : this.mSupportedRadioTechnologies) {
                out.writeInt(technology);
            }
        } else {
            out.writeInt(0);
        }
        out.writeBoolean(this.mIsPointingRequired);
        out.writeInt(this.mMaxBytesPerOutgoingDatagram);
        if (this.mAntennaPositionMap != null && !this.mAntennaPositionMap.isEmpty()) {
            int size = this.mAntennaPositionMap.size();
            out.writeInt(size);
            for (Map.Entry<Integer, AntennaPosition> entry : this.mAntennaPositionMap.entrySet()) {
                out.writeInt(entry.getKey());
                out.writeParcelable(entry.getValue(), flags);
            }
        } else {
            out.writeInt(0);
        }
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SupportedRadioTechnology:");
        if (this.mSupportedRadioTechnologies != null && !this.mSupportedRadioTechnologies.isEmpty()) {
            for (int technology : this.mSupportedRadioTechnologies) {
                sb.append(technology);
                sb.append(",");
            }
        } else {
            sb.append("none,");
        }
        sb.append("isPointingRequired:");
        sb.append(this.mIsPointingRequired);
        sb.append(",");
        sb.append("maxBytesPerOutgoingDatagram:");
        sb.append(this.mMaxBytesPerOutgoingDatagram);
        sb.append(",");
        sb.append("antennaPositionMap:");
        sb.append(this.mAntennaPositionMap);
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SatelliteCapabilities that = (SatelliteCapabilities)o;
        return Objects.equals(this.mSupportedRadioTechnologies, that.mSupportedRadioTechnologies) && this.mIsPointingRequired == that.mIsPointingRequired && this.mMaxBytesPerOutgoingDatagram == that.mMaxBytesPerOutgoingDatagram && Objects.equals(this.mAntennaPositionMap, that.mAntennaPositionMap);
    }

    public int hashCode() {
        return Objects.hash(this.mSupportedRadioTechnologies, this.mIsPointingRequired, this.mMaxBytesPerOutgoingDatagram, this.mAntennaPositionMap);
    }

    @NonNull
    public Set<Integer> getSupportedRadioTechnologies() {
        return this.mSupportedRadioTechnologies;
    }

    public boolean isPointingRequired() {
        return this.mIsPointingRequired;
    }

    public int getMaxBytesPerOutgoingDatagram() {
        return this.mMaxBytesPerOutgoingDatagram;
    }

    public void setMaxBytesPerOutgoingDatagram(int maxBytesPerOutgoingDatagram) {
        this.mMaxBytesPerOutgoingDatagram = maxBytesPerOutgoingDatagram;
    }

    @NonNull
    public Map<Integer, AntennaPosition> getAntennaPositionMap() {
        return this.mAntennaPositionMap;
    }

    private void readFromParcel(Parcel in) {
        this.mSupportedRadioTechnologies = new HashSet<Integer>();
        int numSupportedRadioTechnologies = in.readInt();
        if (numSupportedRadioTechnologies > 0) {
            for (int i = 0; i < numSupportedRadioTechnologies; ++i) {
                this.mSupportedRadioTechnologies.add(in.readInt());
            }
        }
        this.mIsPointingRequired = in.readBoolean();
        this.mMaxBytesPerOutgoingDatagram = in.readInt();
        this.mAntennaPositionMap = new HashMap<Integer, AntennaPosition>();
        int antennaPositionMapSize = in.readInt();
        for (int i = 0; i < antennaPositionMapSize; ++i) {
            int key = in.readInt();
            AntennaPosition antennaPosition = in.readParcelable(AntennaPosition.class.getClassLoader(), AntennaPosition.class);
            this.mAntennaPositionMap.put(key, antennaPosition);
        }
    }
}

