/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.satellite;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.telephony.satellite.SatelliteAccessConfiguration;

public interface ISatelliteCommunicationAccessStateCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.telephony.satellite.ISatelliteCommunicationAccessStateCallback";

    public void onAccessAllowedStateChanged(boolean var1) throws RemoteException;

    public void onAccessConfigurationChanged(SatelliteAccessConfiguration var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISatelliteCommunicationAccessStateCallback {
        static final int TRANSACTION_onAccessAllowedStateChanged = 1;
        static final int TRANSACTION_onAccessConfigurationChanged = 2;

        public Stub() {
            this.attachInterface(this, ISatelliteCommunicationAccessStateCallback.DESCRIPTOR);
        }

        public static ISatelliteCommunicationAccessStateCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISatelliteCommunicationAccessStateCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ISatelliteCommunicationAccessStateCallback) {
                return (ISatelliteCommunicationAccessStateCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onAccessAllowedStateChanged";
                }
                case 2: {
                    return "onAccessConfigurationChanged";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISatelliteCommunicationAccessStateCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    boolean _arg0 = data.readBoolean();
                    data.enforceNoDataAvail();
                    this.onAccessAllowedStateChanged(_arg0);
                    break;
                }
                case 2: {
                    SatelliteAccessConfiguration _arg0 = data.readTypedObject(SatelliteAccessConfiguration.CREATOR);
                    data.enforceNoDataAvail();
                    this.onAccessConfigurationChanged(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 1;
        }

        private static class Proxy
        implements ISatelliteCommunicationAccessStateCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISatelliteCommunicationAccessStateCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAccessAllowedStateChanged(boolean isAllowed) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISatelliteCommunicationAccessStateCallback.DESCRIPTOR);
                    _data.writeBoolean(isAllowed);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAccessConfigurationChanged(SatelliteAccessConfiguration satelliteAccessConfiguration) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(ISatelliteCommunicationAccessStateCallback.DESCRIPTOR);
                    _data.writeTypedObject(satelliteAccessConfiguration, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ISatelliteCommunicationAccessStateCallback {
        @Override
        public void onAccessAllowedStateChanged(boolean isAllowed) throws RemoteException {
        }

        @Override
        public void onAccessConfigurationChanged(SatelliteAccessConfiguration satelliteAccessConfiguration) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

