/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.stub;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.RemoteException;
import android.telephony.SmsMessage;
import android.telephony.ims.aidl.IImsSmsListener;
import android.util.Log;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

@SystemApi
public class ImsSmsImplBase {
    private static final String LOG_TAG = "SmsImplBase";
    public static final int SEND_STATUS_OK = 1;
    public static final int SEND_STATUS_ERROR = 2;
    public static final int SEND_STATUS_ERROR_RETRY = 3;
    public static final int SEND_STATUS_ERROR_FALLBACK = 4;
    public static final int DELIVER_STATUS_OK = 1;
    public static final int DELIVER_STATUS_ERROR_GENERIC = 2;
    public static final int DELIVER_STATUS_ERROR_NO_MEMORY = 3;
    public static final int DELIVER_STATUS_ERROR_REQUEST_NOT_SUPPORTED = 4;
    public static final int STATUS_REPORT_STATUS_OK = 1;
    public static final int STATUS_REPORT_STATUS_ERROR = 2;
    public static final int RESULT_NO_NETWORK_ERROR = -1;
    private final Object mLock = new Object();
    private IImsSmsListener mListener;
    private Executor mExecutor;

    public ImsSmsImplBase() {
    }

    public ImsSmsImplBase(@NonNull Executor executor) {
        this.mExecutor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSmsListener(IImsSmsListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = listener;
        }
    }

    public void sendSms(int token, int messageRef, String format, String smsc, boolean isRetry, byte[] pdu) {
        try {
            this.onSendSmsResult(token, messageRef, 2, 1);
        }
        catch (RuntimeException e) {
            Log.e(LOG_TAG, "Can not send sms: " + e.getMessage());
        }
    }

    public void onMemoryAvailable(int token) {
    }

    public void acknowledgeSms(int token, int messageRef, int result) {
        Log.e(LOG_TAG, "acknowledgeSms() not implemented.");
    }

    public void acknowledgeSms(int token, int messageRef, int result, @NonNull byte[] pdu) {
        Log.e(LOG_TAG, "acknowledgeSms() not implemented. acknowledgeSms(int, int, int) called.");
        this.acknowledgeSms(token, messageRef, result);
    }

    public void acknowledgeSmsReport(int token, int messageRef, int result) {
        Log.e(LOG_TAG, "acknowledgeSmsReport() not implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSmsReceived(int token, String format, byte[] pdu) throws RuntimeException {
        IImsSmsListener listener = null;
        Object object = this.mLock;
        synchronized (object) {
            listener = this.mListener;
        }
        if (listener == null) {
            throw new RuntimeException("Feature not ready.");
        }
        try {
            listener.onSmsReceived(token, format, pdu);
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Can not deliver sms: " + e.getMessage());
            SmsMessage message = SmsMessage.createFromPdu(pdu, format);
            if (message != null && message.mWrappedSmsMessage != null) {
                this.acknowledgeSms(token, message.mWrappedSmsMessage.mMessageRef, 2);
            }
            Log.w(LOG_TAG, "onSmsReceived: Invalid pdu entered.");
            this.acknowledgeSms(token, 0, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSendSmsResultSuccess(int token, int messageRef) throws RuntimeException {
        IImsSmsListener listener = null;
        Object object = this.mLock;
        synchronized (object) {
            listener = this.mListener;
        }
        if (listener == null) {
            throw new RuntimeException("Feature not ready.");
        }
        try {
            listener.onSendSmsResult(token, messageRef, 1, 0, -1);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void onSendSmsResult(int token, int messageRef, int status, int reason) throws RuntimeException {
        IImsSmsListener listener = null;
        Object object = this.mLock;
        synchronized (object) {
            listener = this.mListener;
        }
        if (listener == null) {
            throw new RuntimeException("Feature not ready.");
        }
        try {
            listener.onSendSmsResult(token, messageRef, status, reason, -1);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSendSmsResultError(int token, int messageRef, int status, int reason, int networkErrorCode) throws RuntimeException {
        IImsSmsListener listener = null;
        Object object = this.mLock;
        synchronized (object) {
            listener = this.mListener;
        }
        if (listener == null) {
            throw new RuntimeException("Feature not ready.");
        }
        try {
            listener.onSendSmsResult(token, messageRef, status, reason, networkErrorCode);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMemoryAvailableResult(int token, int result, int networkErrorCode) throws RuntimeException {
        IImsSmsListener listener = null;
        Object object = this.mLock;
        synchronized (object) {
            listener = this.mListener;
        }
        if (listener == null) {
            throw new RuntimeException("Feature not ready.");
        }
        try {
            listener.onMemoryAvailableResult(token, result, networkErrorCode);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void onSmsStatusReportReceived(int token, int messageRef, String format, byte[] pdu) throws RuntimeException {
        IImsSmsListener listener = null;
        Object object = this.mLock;
        synchronized (object) {
            listener = this.mListener;
        }
        if (listener == null) {
            throw new RuntimeException("Feature not ready.");
        }
        try {
            listener.onSmsStatusReportReceived(token, format, pdu);
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Can not process sms status report: " + e.getMessage());
            this.acknowledgeSmsReport(token, messageRef, 2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSmsStatusReportReceived(int token, String format, byte[] pdu) throws RuntimeException {
        IImsSmsListener listener = null;
        Object object = this.mLock;
        synchronized (object) {
            listener = this.mListener;
        }
        if (listener == null) {
            throw new RuntimeException("Feature not ready.");
        }
        try {
            listener.onSmsStatusReportReceived(token, format, pdu);
        }
        catch (RemoteException e) {
            Log.e(LOG_TAG, "Can not process sms status report: " + e.getMessage());
            SmsMessage message = SmsMessage.createFromPdu(pdu, format);
            if (message != null && message.mWrappedSmsMessage != null) {
                this.acknowledgeSmsReport(token, message.mWrappedSmsMessage.mMessageRef, 2);
            }
            Log.w(LOG_TAG, "onSmsStatusReportReceived: Invalid pdu entered.");
            this.acknowledgeSmsReport(token, 0, 2);
        }
    }

    public String getSmsFormat() {
        return "3gpp";
    }

    public void onReady() {
    }

    public void setDefaultExecutor(@NonNull Executor executor) {
        if (this.mExecutor == null) {
            this.mExecutor = executor;
        }
    }

    @NonNull
    public Executor getExecutor() {
        return this.mExecutor != null ? this.mExecutor : Runnable::run;
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface StatusReportResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeliverStatusResult {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SendStatusResult {
    }
}

