/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.feature;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Binder;
import android.os.Bundle;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.telephony.ims.ImsCallProfile;
import android.telephony.ims.ImsCallSessionListener;
import android.telephony.ims.ImsReasonInfo;
import android.telephony.ims.MediaQualityStatus;
import android.telephony.ims.MediaThreshold;
import android.telephony.ims.RtpHeaderExtensionType;
import android.telephony.ims.SrvccCall;
import android.telephony.ims.aidl.IImsCallSessionListener;
import android.telephony.ims.aidl.IImsCapabilityCallback;
import android.telephony.ims.aidl.IImsMmTelFeature;
import android.telephony.ims.aidl.IImsMmTelListener;
import android.telephony.ims.aidl.IImsSmsListener;
import android.telephony.ims.aidl.IImsTrafficSessionCallback;
import android.telephony.ims.aidl.ISrvccStartedCallback;
import android.telephony.ims.feature.CapabilityChangeRequest;
import android.telephony.ims.feature.ConnectionFailureInfo;
import android.telephony.ims.feature.ImsFeature;
import android.telephony.ims.feature.ImsTrafficSessionCallback;
import android.telephony.ims.stub.ImsCallSessionImplBase;
import android.telephony.ims.stub.ImsEcbmImplBase;
import android.telephony.ims.stub.ImsMultiEndpointImplBase;
import android.telephony.ims.stub.ImsSmsImplBase;
import android.telephony.ims.stub.ImsUtImplBase;
import android.util.ArraySet;
import android.util.Log;
import com.android.ims.internal.IImsCallSession;
import com.android.ims.internal.IImsEcbm;
import com.android.ims.internal.IImsMultiEndpoint;
import com.android.ims.internal.IImsUt;
import com.android.internal.telephony.util.TelephonyUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class MmTelFeature
extends ImsFeature {
    private static final String LOG_TAG = "MmTelFeature";
    private Executor mExecutor;
    private ImsSmsImplBase mSmsImpl;
    private HashMap<ImsTrafficSessionCallback, ImsTrafficSessionCallbackWrapper> mTrafficCallbacks = new HashMap();
    private final IImsMmTelFeature mImsMMTelBinder = new IImsMmTelFeature.Stub(){

        @Override
        public void setListener(IImsMmTelListener l) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.setListener(l), "setListener");
        }

        @Override
        public int getFeatureState() throws RemoteException {
            return this.executeMethodAsyncForResult(() -> MmTelFeature.this.getFeatureState(), "getFeatureState");
        }

        @Override
        public ImsCallProfile createCallProfile(int callSessionType, int callType) throws RemoteException {
            return this.executeMethodAsyncForResult(() -> MmTelFeature.this.createCallProfile(callSessionType, callType), "createCallProfile");
        }

        @Override
        public void changeOfferedRtpHeaderExtensionTypes(List<RtpHeaderExtensionType> types) throws RemoteException {
            this.executeMethodAsync(() -> MmTelFeature.this.changeOfferedRtpHeaderExtensionTypes(new ArraySet<RtpHeaderExtensionType>(types)), "changeOfferedRtpHeaderExtensionTypes");
        }

        @Override
        public IImsCallSession createCallSession(ImsCallProfile profile) throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            IImsCallSession result = this.executeMethodAsyncForResult(() -> {
                try {
                    return MmTelFeature.this.createCallSessionInterface(profile);
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                    return null;
                }
            }, "createCallSession");
            if (exceptionRef.get() != null) {
                throw (RemoteException)exceptionRef.get();
            }
            return result;
        }

        @Override
        public int shouldProcessCall(String[] numbers) {
            Integer result = this.executeMethodAsyncForResultNoException(() -> MmTelFeature.this.shouldProcessCall(numbers), "shouldProcessCall");
            if (result != null) {
                return result;
            }
            return 1;
        }

        @Override
        public IImsUt getUtInterface() throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            IImsUt result = this.executeMethodAsyncForResult(() -> {
                try {
                    return MmTelFeature.this.getUtInterface();
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                    return null;
                }
            }, "getUtInterface");
            if (exceptionRef.get() != null) {
                throw (RemoteException)exceptionRef.get();
            }
            return result;
        }

        @Override
        public IImsEcbm getEcbmInterface() throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            IImsEcbm result = this.executeMethodAsyncForResult(() -> {
                try {
                    return MmTelFeature.this.getEcbmInterface();
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                    return null;
                }
            }, "getEcbmInterface");
            if (exceptionRef.get() != null) {
                throw (RemoteException)exceptionRef.get();
            }
            return result;
        }

        @Override
        public void setUiTtyMode(int uiTtyMode, Message onCompleteMessage) throws RemoteException {
            this.executeMethodAsync(() -> MmTelFeature.this.setUiTtyMode(uiTtyMode, onCompleteMessage), "setUiTtyMode");
        }

        @Override
        public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
            AtomicReference exceptionRef = new AtomicReference();
            IImsMultiEndpoint result = this.executeMethodAsyncForResult(() -> {
                try {
                    return MmTelFeature.this.getMultiEndpointInterface();
                }
                catch (RemoteException e) {
                    exceptionRef.set(e);
                    return null;
                }
            }, "getMultiEndpointInterface");
            if (exceptionRef.get() != null) {
                throw (RemoteException)exceptionRef.get();
            }
            return result;
        }

        @Override
        public int queryCapabilityStatus() {
            Integer result = this.executeMethodAsyncForResultNoException(() -> MmTelFeature.this.queryCapabilityStatus().mCapabilities, "queryCapabilityStatus");
            if (result != null) {
                return result;
            }
            return 0;
        }

        @Override
        public void addCapabilityCallback(IImsCapabilityCallback c) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.addCapabilityCallback(c), "addCapabilityCallback");
        }

        @Override
        public void removeCapabilityCallback(IImsCapabilityCallback c) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.removeCapabilityCallback(c), "removeCapabilityCallback");
        }

        @Override
        public void changeCapabilitiesConfiguration(CapabilityChangeRequest request, IImsCapabilityCallback c) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.requestChangeEnabledCapabilities(request, c), "changeCapabilitiesConfiguration");
        }

        @Override
        public void queryCapabilityConfiguration(int capability, int radioTech, IImsCapabilityCallback c) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.queryCapabilityConfigurationInternal(capability, radioTech, c), "queryCapabilityConfiguration");
        }

        @Override
        public void setMediaQualityThreshold(int sessionType, MediaThreshold mediaThreshold) {
            if (mediaThreshold != null) {
                this.executeMethodAsyncNoException(() -> MmTelFeature.this.setMediaThreshold(sessionType, mediaThreshold), "setMediaQualityThreshold");
            } else {
                this.executeMethodAsyncNoException(() -> MmTelFeature.this.clearMediaThreshold(sessionType), "clearMediaQualityThreshold");
            }
        }

        @Override
        public MediaQualityStatus queryMediaQualityStatus(int sessionType) throws RemoteException {
            return this.executeMethodAsyncForResult(() -> MmTelFeature.this.queryMediaQualityStatus(sessionType), "queryMediaQualityStatus");
        }

        @Override
        public void setSmsListener(IImsSmsListener l) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.setSmsListener(l), "setSmsListener", MmTelFeature.this.getImsSmsImpl().getExecutor());
        }

        @Override
        public void sendSms(int token, int messageRef, String format, String smsc, boolean retry, byte[] pdu) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.sendSms(token, messageRef, format, smsc, retry, pdu), "sendSms", MmTelFeature.this.getImsSmsImpl().getExecutor());
        }

        @Override
        public void onMemoryAvailable(int token) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.onMemoryAvailable(token), "onMemoryAvailable", MmTelFeature.this.getImsSmsImpl().getExecutor());
        }

        @Override
        public void acknowledgeSms(int token, int messageRef, int result) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.acknowledgeSms(token, messageRef, result), "acknowledgeSms", MmTelFeature.this.getImsSmsImpl().getExecutor());
        }

        @Override
        public void acknowledgeSmsWithPdu(int token, int messageRef, int result, byte[] pdu) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.acknowledgeSms(token, messageRef, result, pdu), "acknowledgeSms", MmTelFeature.this.getImsSmsImpl().getExecutor());
        }

        @Override
        public void acknowledgeSmsReport(int token, int messageRef, int result) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.acknowledgeSmsReport(token, messageRef, result), "acknowledgeSmsReport", MmTelFeature.this.getImsSmsImpl().getExecutor());
        }

        @Override
        public String getSmsFormat() {
            return this.executeMethodAsyncForResultNoException(() -> MmTelFeature.this.getSmsFormat(), "getSmsFormat", MmTelFeature.this.getImsSmsImpl().getExecutor());
        }

        @Override
        public void onSmsReady() {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.onSmsReady(), "onSmsReady", MmTelFeature.this.getImsSmsImpl().getExecutor());
        }

        @Override
        public void notifySrvccStarted(ISrvccStartedCallback cb) {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.notifySrvccStarted((List<SrvccCall> profiles) -> {
                try {
                    cb.onSrvccCallNotified((List<SrvccCall>)profiles);
                }
                catch (Exception e) {
                    Log.e(MmTelFeature.LOG_TAG, "onSrvccCallNotified e=" + e);
                }
            }), "notifySrvccStarted");
        }

        @Override
        public void notifySrvccCompleted() {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.notifySrvccCompleted(), "notifySrvccCompleted");
        }

        @Override
        public void notifySrvccFailed() {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.notifySrvccFailed(), "notifySrvccFailed");
        }

        @Override
        public void notifySrvccCanceled() {
            this.executeMethodAsyncNoException(() -> MmTelFeature.this.notifySrvccCanceled(), "notifySrvccCanceled");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setTerminalBasedCallWaitingStatus(boolean enabled) throws RemoteException {
            Object object = MmTelFeature.this.mLock;
            synchronized (object) {
                try {
                    MmTelFeature.this.setTerminalBasedCallWaitingStatus(enabled);
                }
                catch (ServiceSpecificException se) {
                    throw new ServiceSpecificException(se.errorCode, se.getMessage());
                }
                catch (Exception e) {
                    throw new RemoteException(e.getMessage());
                }
            }
        }

        private void executeMethodAsync(Runnable r, String errorLogName) throws RemoteException {
            try {
                CompletableFuture.runAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), MmTelFeature.this.mExecutor).join();
            }
            catch (CancellationException | CompletionException e) {
                Log.w(MmTelFeature.LOG_TAG, "MmTelFeature Binder - " + errorLogName + " exception: " + e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }

        private void executeMethodAsyncNoException(Runnable r, String errorLogName) {
            try {
                CompletableFuture.runAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), MmTelFeature.this.mExecutor).join();
            }
            catch (CancellationException | CompletionException e) {
                Log.w(MmTelFeature.LOG_TAG, "MmTelFeature Binder - " + errorLogName + " exception: " + e.getMessage());
            }
        }

        private void executeMethodAsyncNoException(Runnable r, String errorLogName, Executor executor) {
            try {
                CompletableFuture.runAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), executor).join();
            }
            catch (CancellationException | CompletionException e) {
                Log.w(MmTelFeature.LOG_TAG, "MmTelFeature Binder - " + errorLogName + " exception: " + e.getMessage());
            }
        }

        private <T> T executeMethodAsyncForResult(Supplier<T> r, String errorLogName) throws RemoteException {
            CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), MmTelFeature.this.mExecutor);
            try {
                return (T)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Log.w(MmTelFeature.LOG_TAG, "MmTelFeature Binder - " + errorLogName + " exception: " + e.getMessage());
                throw new RemoteException(e.getMessage());
            }
        }

        private <T> T executeMethodAsyncForResultNoException(Supplier<T> r, String errorLogName) {
            CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), MmTelFeature.this.mExecutor);
            try {
                return (T)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Log.w(MmTelFeature.LOG_TAG, "MmTelFeature Binder - " + errorLogName + " exception: " + e.getMessage());
                return null;
            }
        }

        private <T> T executeMethodAsyncForResultNoException(Supplier<T> r, String errorLogName, Executor executor) {
            CompletableFuture<Object> future = CompletableFuture.supplyAsync(() -> TelephonyUtils.runWithCleanCallingIdentity(r), executor);
            try {
                return (T)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                Log.w(MmTelFeature.LOG_TAG, "MmTelFeature Binder - " + errorLogName + " exception: " + e.getMessage());
                return null;
            }
        }
    };
    @SystemApi
    public static final int PROCESS_CALL_IMS = 0;
    @SystemApi
    public static final int PROCESS_CALL_CSFB = 1;
    @SystemApi
    public static final String EXTRA_IS_USSD = "android.telephony.ims.feature.extra.IS_USSD";
    @SystemApi
    public static final String EXTRA_IS_UNKNOWN_CALL = "android.telephony.ims.feature.extra.IS_UNKNOWN_CALL";
    @SystemApi
    public static final int AUDIO_HANDLER_ANDROID = 0;
    @SystemApi
    public static final int AUDIO_HANDLER_BASEBAND = 1;
    public static final int EPS_FALLBACK_REASON_INVALID = -1;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.support_ims_mmtel_interface")
    public static final int EPS_FALLBACK_REASON_NO_NETWORK_TRIGGER = 1;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.support_ims_mmtel_interface")
    public static final int EPS_FALLBACK_REASON_NO_NETWORK_RESPONSE = 2;
    public static final int IMS_TRAFFIC_TYPE_NONE = -1;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.support_ims_mmtel_interface")
    public static final int IMS_TRAFFIC_TYPE_EMERGENCY = 0;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.support_ims_mmtel_interface")
    public static final int IMS_TRAFFIC_TYPE_EMERGENCY_SMS = 1;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.support_ims_mmtel_interface")
    public static final int IMS_TRAFFIC_TYPE_VOICE = 2;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.support_ims_mmtel_interface")
    public static final int IMS_TRAFFIC_TYPE_VIDEO = 3;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.support_ims_mmtel_interface")
    public static final int IMS_TRAFFIC_TYPE_SMS = 4;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.support_ims_mmtel_interface")
    public static final int IMS_TRAFFIC_TYPE_REGISTRATION = 5;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.support_ims_mmtel_interface")
    public static final int IMS_TRAFFIC_TYPE_UT_XCAP = 6;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.support_ims_mmtel_interface")
    public static final int IMS_TRAFFIC_DIRECTION_INCOMING = 0;
    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.support_ims_mmtel_interface")
    public static final int IMS_TRAFFIC_DIRECTION_OUTGOING = 1;
    private IImsMmTelListener mListener;

    @SystemApi
    public MmTelFeature() {
    }

    @SystemApi
    public MmTelFeature(@NonNull Executor executor) {
        this.mExecutor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setListener(IImsMmTelListener listener) {
        Object object = this.mLock;
        synchronized (object) {
            this.mListener = listener;
            if (this.mListener != null) {
                this.onFeatureReady();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IImsMmTelListener getListener() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mListener;
        }
    }

    @Override
    @SystemApi
    @NonNull
    public MmTelCapabilities queryCapabilityStatus() {
        return new MmTelCapabilities(super.queryCapabilityStatus());
    }

    @SystemApi
    public void notifyCapabilitiesStatusChanged(@NonNull MmTelCapabilities c) {
        if (c == null) {
            throw new IllegalArgumentException("MmTelCapabilities must be non-null!");
        }
        super.notifyCapabilitiesStatusChanged(c);
    }

    @SystemApi
    public void notifyMediaQualityStatusChanged(@NonNull MediaQualityStatus status) {
        if (status == null) {
            throw new IllegalArgumentException("MediaQualityStatus must be non-null!");
        }
        Log.i(LOG_TAG, "notifyMediaQualityStatusChanged " + status);
        IImsMmTelListener listener = this.getListener();
        if (listener == null) {
            throw new IllegalStateException("Session is not available.");
        }
        try {
            listener.onMediaQualityStatusChanged(status);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    @SystemApi
    public void notifyIncomingCall(@NonNull ImsCallSessionImplBase c, @NonNull Bundle extras) {
        if (c == null || extras == null) {
            throw new IllegalArgumentException("ImsCallSessionImplBase and Bundle can not be null.");
        }
        IImsMmTelListener listener = this.getListener();
        if (listener == null) {
            throw new IllegalStateException("Session is not available.");
        }
        try {
            c.setDefaultExecutor(this.mExecutor);
            listener.onIncomingCall(c.getServiceImpl(), null, extras);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @SystemApi
    @Nullable
    public ImsCallSessionListener notifyIncomingCall(@NonNull ImsCallSessionImplBase c, @NonNull String callId, @NonNull Bundle extras) {
        if (c == null || callId == null || extras == null) {
            throw new IllegalArgumentException("ImsCallSessionImplBase, callId, and Bundle can not be null.");
        }
        IImsMmTelListener listener = this.getListener();
        if (listener == null) {
            throw new IllegalStateException("Session is not available.");
        }
        try {
            c.setDefaultExecutor(this.mExecutor);
            IImsCallSessionListener isl = listener.onIncomingCall(c.getServiceImpl(), callId, extras);
            if (isl != null) {
                ImsCallSessionListener iCSL = new ImsCallSessionListener(isl);
                iCSL.setDefaultExecutor(this.mExecutor);
                return iCSL;
            }
            return null;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @SystemApi
    public void notifyRejectedCall(@NonNull ImsCallProfile callProfile, @NonNull ImsReasonInfo reason) {
        if (callProfile == null || reason == null) {
            throw new IllegalArgumentException("ImsCallProfile and ImsReasonInfo must not be null.");
        }
        IImsMmTelListener listener = this.getListener();
        if (listener == null) {
            throw new IllegalStateException("Session is not available.");
        }
        try {
            listener.onRejectedCall(callProfile, reason);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    public void notifyIncomingCallSession(IImsCallSession c, Bundle extras) {
        IImsMmTelListener listener = this.getListener();
        if (listener == null) {
            throw new IllegalStateException("Session is not available.");
        }
        try {
            listener.onIncomingCall(c, null, extras);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @SystemApi
    public void notifyVoiceMessageCountUpdate(int count) {
        IImsMmTelListener listener = this.getListener();
        if (listener == null) {
            throw new IllegalStateException("Session is not available.");
        }
        try {
            listener.onVoiceMessageCountUpdate(count);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @SystemApi
    public void setCallAudioHandler(int imsAudioHandler) {
        IImsMmTelListener listener = this.getListener();
        if (listener == null) {
            throw new IllegalStateException("Session is not available.");
        }
        try {
            listener.onAudioModeIsVoipChanged(imsAudioHandler);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.support_ims_mmtel_interface")
    public void triggerEpsFallback(int reason) {
        IImsMmTelListener listener = this.getListener();
        if (listener == null) {
            throw new IllegalStateException("Session is not available.");
        }
        try {
            listener.onTriggerEpsFallback(reason);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.support_ims_mmtel_interface")
    public void startImsTrafficSession(int trafficType, int accessNetworkType, int trafficDirection, @NonNull Executor executor, @NonNull ImsTrafficSessionCallback callback) {
        IImsMmTelListener listener = this.getListener();
        if (listener == null) {
            throw new IllegalStateException("Session is not available.");
        }
        ImsTrafficSessionCallbackWrapper callbackWrapper = this.mTrafficCallbacks.get(callback);
        if (callbackWrapper == null) {
            callbackWrapper = new ImsTrafficSessionCallbackWrapper(callback);
            this.mTrafficCallbacks.put(callback, callbackWrapper);
        }
        try {
            callbackWrapper.update(executor);
            listener.onStartImsTrafficSession(callbackWrapper.getToken(), trafficType, accessNetworkType, trafficDirection, callbackWrapper.getCallbackBinder());
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.support_ims_mmtel_interface")
    public void modifyImsTrafficSession(int accessNetworkType, @NonNull ImsTrafficSessionCallback callback) {
        IImsMmTelListener listener = this.getListener();
        if (listener == null) {
            throw new IllegalStateException("Session is not available.");
        }
        ImsTrafficSessionCallbackWrapper callbackWrapper = this.mTrafficCallbacks.get(callback);
        if (callbackWrapper == null) {
            throw new IllegalStateException("Unknown ImsTrafficSessionCallback instance.");
        }
        try {
            listener.onModifyImsTrafficSession(callbackWrapper.getToken(), accessNetworkType);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @SystemApi
    @FlaggedApi(value="com.android.internal.telephony.flags.support_ims_mmtel_interface")
    public void stopImsTrafficSession(@NonNull ImsTrafficSessionCallback callback) {
        IImsMmTelListener listener = this.getListener();
        if (listener == null) {
            throw new IllegalStateException("Session is not available.");
        }
        ImsTrafficSessionCallbackWrapper callbackWrapper = this.mTrafficCallbacks.get(callback);
        if (callbackWrapper == null) {
            throw new IllegalStateException("Unknown ImsTrafficSessionCallback instance.");
        }
        try {
            listener.onStopImsTrafficSession(callbackWrapper.getToken());
            callbackWrapper.reset();
            this.mTrafficCallbacks.remove(callback);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @SystemApi
    public boolean queryCapabilityConfiguration(int capability, int radioTech) {
        return false;
    }

    @Override
    @SystemApi
    public void changeEnabledCapabilities(@NonNull CapabilityChangeRequest request, @NonNull ImsFeature.CapabilityCallbackProxy c) {
    }

    @SystemApi
    public void setMediaThreshold(int mediaSessionType, @NonNull MediaThreshold mediaThreshold) {
        Log.d(LOG_TAG, "setMediaThreshold is not supported." + mediaThreshold);
    }

    @SystemApi
    public void clearMediaThreshold(int mediaSessionType) {
        Log.d(LOG_TAG, "clearMediaThreshold is not supported." + mediaSessionType);
    }

    @SystemApi
    @Nullable
    public MediaQualityStatus queryMediaQualityStatus(int mediaSessionType) {
        Log.d(LOG_TAG, "queryMediaQualityStatus is not supported." + mediaSessionType);
        return null;
    }

    @SystemApi
    @Nullable
    public ImsCallProfile createCallProfile(int callSessionType, int callType) {
        return null;
    }

    @SystemApi
    public void changeOfferedRtpHeaderExtensionTypes(@NonNull Set<RtpHeaderExtensionType> extensionTypes) {
    }

    public IImsCallSession createCallSessionInterface(ImsCallProfile profile) throws RemoteException {
        ImsCallSessionImplBase s = this.createCallSession(profile);
        if (s != null) {
            s.setDefaultExecutor(this.mExecutor);
            return s.getServiceImpl();
        }
        return null;
    }

    @SystemApi
    @Nullable
    public ImsCallSessionImplBase createCallSession(@NonNull ImsCallProfile profile) {
        return null;
    }

    @SystemApi
    public int shouldProcessCall(@NonNull String[] numbers) {
        return 0;
    }

    protected IImsUt getUtInterface() throws RemoteException {
        ImsUtImplBase utImpl = this.getUt();
        if (utImpl != null) {
            utImpl.setDefaultExecutor(this.mExecutor);
            return utImpl.getInterface();
        }
        return null;
    }

    protected IImsEcbm getEcbmInterface() throws RemoteException {
        ImsEcbmImplBase ecbmImpl = this.getEcbm();
        if (ecbmImpl != null) {
            ecbmImpl.setDefaultExecutor(this.mExecutor);
            return ecbmImpl.getImsEcbm();
        }
        return null;
    }

    public IImsMultiEndpoint getMultiEndpointInterface() throws RemoteException {
        ImsMultiEndpointImplBase multiendpointImpl = this.getMultiEndpoint();
        if (multiendpointImpl != null) {
            multiendpointImpl.setDefaultExecutor(this.mExecutor);
            return multiendpointImpl.getIImsMultiEndpoint();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public ImsSmsImplBase getImsSmsImpl() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mSmsImpl == null) {
                this.mSmsImpl = this.getSmsImplementation();
                this.mSmsImpl.setDefaultExecutor(this.mExecutor);
            }
            return this.mSmsImpl;
        }
    }

    @SystemApi
    @NonNull
    public ImsUtImplBase getUt() {
        return new ImsUtImplBase();
    }

    @SystemApi
    @NonNull
    public ImsEcbmImplBase getEcbm() {
        return new ImsEcbmImplBase();
    }

    @SystemApi
    @NonNull
    public ImsMultiEndpointImplBase getMultiEndpoint() {
        return new ImsMultiEndpointImplBase();
    }

    @SystemApi
    public void setUiTtyMode(int mode, @Nullable Message onCompleteMessage) {
    }

    @SystemApi
    public void setTerminalBasedCallWaitingStatus(boolean enabled) {
        throw new ServiceSpecificException(2, "Not implemented on device.");
    }

    @SystemApi
    public void notifySrvccStarted(@NonNull Consumer<List<SrvccCall>> consumer) {
    }

    @SystemApi
    public void notifySrvccCompleted() {
    }

    @SystemApi
    public void notifySrvccFailed() {
    }

    @SystemApi
    public void notifySrvccCanceled() {
    }

    private void setSmsListener(IImsSmsListener listener) {
        this.getImsSmsImpl().registerSmsListener(listener);
    }

    private void sendSms(int token, int messageRef, String format, String smsc, boolean isRetry, byte[] pdu) {
        this.getImsSmsImpl().sendSms(token, messageRef, format, smsc, isRetry, pdu);
    }

    private void onMemoryAvailable(int token) {
        this.getImsSmsImpl().onMemoryAvailable(token);
    }

    private void acknowledgeSms(int token, int messageRef, int result) {
        this.getImsSmsImpl().acknowledgeSms(token, messageRef, result);
    }

    private void acknowledgeSms(int token, int messageRef, int result, byte[] pdu) {
        this.getImsSmsImpl().acknowledgeSms(token, messageRef, result, pdu);
    }

    private void acknowledgeSmsReport(int token, int messageRef, int result) {
        this.getImsSmsImpl().acknowledgeSmsReport(token, messageRef, result);
    }

    private void onSmsReady() {
        this.getImsSmsImpl().onReady();
    }

    @SystemApi
    @NonNull
    public ImsSmsImplBase getSmsImplementation() {
        return new ImsSmsImplBase();
    }

    private String getSmsFormat() {
        return this.getImsSmsImpl().getSmsFormat();
    }

    @Override
    @SystemApi
    public void onFeatureRemoved() {
    }

    @Override
    @SystemApi
    public void onFeatureReady() {
    }

    @Override
    public IImsMmTelFeature getBinder() {
        return this.mImsMMTelBinder;
    }

    public void setDefaultExecutor(@NonNull Executor executor) {
        if (this.mExecutor == null) {
            this.mExecutor = executor;
        }
    }

    public static class MmTelCapabilities
    extends ImsFeature.Capabilities {
        public static final int CAPABILITY_TYPE_NONE = 0;
        public static final int CAPABILITY_TYPE_VOICE = 1;
        public static final int CAPABILITY_TYPE_VIDEO = 2;
        public static final int CAPABILITY_TYPE_UT = 4;
        public static final int CAPABILITY_TYPE_SMS = 8;
        public static final int CAPABILITY_TYPE_CALL_COMPOSER = 16;
        @FlaggedApi(value="com.android.server.telecom.flags.business_call_composer")
        public static final int CAPABILITY_TYPE_CALL_COMPOSER_BUSINESS_ONLY = 32;
        public static final int CAPABILITY_TYPE_MAX = 33;

        @SystemApi
        public MmTelCapabilities() {
        }

        @Deprecated
        @SystemApi
        public MmTelCapabilities(ImsFeature.Capabilities c) {
            this.mCapabilities = c.mCapabilities;
        }

        @SystemApi
        public MmTelCapabilities(int capabilities) {
            super(capabilities);
        }

        @Override
        @SystemApi
        public void addCapabilities(int capabilities) {
            super.addCapabilities(capabilities);
        }

        @Override
        @SystemApi
        public void removeCapabilities(int capability) {
            super.removeCapabilities(capability);
        }

        @Override
        public boolean isCapable(int capabilities) {
            return super.isCapable(capabilities);
        }

        @Override
        @NonNull
        public String toString() {
            StringBuilder builder = new StringBuilder("MmTel Capabilities - [");
            builder.append("Voice: ");
            builder.append(this.isCapable(1));
            builder.append(" Video: ");
            builder.append(this.isCapable(2));
            builder.append(" UT: ");
            builder.append(this.isCapable(4));
            builder.append(" SMS: ");
            builder.append(this.isCapable(8));
            builder.append(" CALL_COMPOSER: ");
            builder.append(this.isCapable(16));
            builder.append(" BUSINESS_COMPOSER_ONLY: ");
            builder.append(this.isCapable(32));
            builder.append("]");
            return builder.toString();
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface MmTelCapability {
        }
    }

    public static class ImsTrafficSessionCallbackWrapper {
        public static final int INVALID_TOKEN = -1;
        private static final int MAX_TOKEN = 65536;
        private static final AtomicInteger sTokenGenerator = new AtomicInteger();
        private IImsTrafficSessionCallbackStub mCallback = null;
        private int mToken = -1;
        private ImsTrafficSessionCallback mImsTrafficSessionCallback;

        private ImsTrafficSessionCallbackWrapper(ImsTrafficSessionCallback callback) {
            this.mImsTrafficSessionCallback = callback;
        }

        void update(@NonNull Executor executor) {
            if (executor == null) {
                throw new IllegalArgumentException("ImsTrafficSessionCallback Executor must be non-null");
            }
            if (this.mCallback == null) {
                this.mCallback = new IImsTrafficSessionCallbackStub(this.mImsTrafficSessionCallback, executor);
                this.mToken = ImsTrafficSessionCallbackWrapper.generateToken();
            } else {
                this.mCallback.update(executor);
            }
        }

        IImsTrafficSessionCallbackStub getCallbackBinder() {
            return this.mCallback;
        }

        int getToken() {
            return this.mToken;
        }

        void reset() {
            this.mCallback = null;
            this.mToken = -1;
        }

        private static int generateToken() {
            int token = sTokenGenerator.incrementAndGet();
            if (token == 65536) {
                sTokenGenerator.set(0);
            }
            return token;
        }

        private static class IImsTrafficSessionCallbackStub
        extends IImsTrafficSessionCallback.Stub {
            private WeakReference<ImsTrafficSessionCallback> mImsTrafficSessionCallbackWeakRef;
            private Executor mExecutor;

            IImsTrafficSessionCallbackStub(ImsTrafficSessionCallback imsTrafficCallback, Executor executor) {
                this.mImsTrafficSessionCallbackWeakRef = new WeakReference<ImsTrafficSessionCallback>(imsTrafficCallback);
                this.mExecutor = executor;
            }

            void update(Executor executor) {
                this.mExecutor = executor;
            }

            @Override
            public void onReady() {
                ImsTrafficSessionCallback callback = (ImsTrafficSessionCallback)this.mImsTrafficSessionCallbackWeakRef.get();
                if (callback == null) {
                    return;
                }
                Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> callback.onReady()));
            }

            @Override
            public void onError(ConnectionFailureInfo info) {
                ImsTrafficSessionCallback callback = (ImsTrafficSessionCallback)this.mImsTrafficSessionCallbackWeakRef.get();
                if (callback == null) {
                    return;
                }
                Binder.withCleanCallingIdentity(() -> this.mExecutor.execute(() -> callback.onError(info)));
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsTrafficDirection {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsTrafficType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EpsFallbackReason {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ImsAudioHandler {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProcessCallResult {
    }

    public static class Listener
    extends IImsMmTelListener.Stub {
        @Override
        @Nullable
        public IImsCallSessionListener onIncomingCall(IImsCallSession c, String callId, Bundle extras) {
            return null;
        }

        @Override
        public void onRejectedCall(ImsCallProfile callProfile, ImsReasonInfo reason) {
        }

        @Override
        public void onVoiceMessageCountUpdate(int count) {
        }

        @Override
        public void onAudioModeIsVoipChanged(int imsAudioHandler) {
        }

        @Override
        public void onTriggerEpsFallback(int reason) {
        }

        @Override
        public void onStartImsTrafficSession(int token, int trafficType, int accessNetworkType, int trafficDirection, IImsTrafficSessionCallback callback) {
        }

        @Override
        public void onModifyImsTrafficSession(int token, int accessNetworkType) {
        }

        @Override
        public void onStopImsTrafficSession(int token) {
        }

        @Override
        public void onMediaQualityStatusChanged(MediaQualityStatus status) {
        }
    }
}

