/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims.aidl;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface IRcsConfigCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.telephony.ims.aidl.IRcsConfigCallback";

    public void onConfigurationChanged(byte[] var1) throws RemoteException;

    public void onAutoConfigurationErrorReceived(int var1, String var2) throws RemoteException;

    public void onConfigurationReset() throws RemoteException;

    public void onRemoved() throws RemoteException;

    public void onPreProvisioningReceived(byte[] var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IRcsConfigCallback {
        static final int TRANSACTION_onConfigurationChanged = 1;
        static final int TRANSACTION_onAutoConfigurationErrorReceived = 2;
        static final int TRANSACTION_onConfigurationReset = 3;
        static final int TRANSACTION_onRemoved = 4;
        static final int TRANSACTION_onPreProvisioningReceived = 5;

        public Stub() {
            this.attachInterface(this, IRcsConfigCallback.DESCRIPTOR);
        }

        public static IRcsConfigCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IRcsConfigCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IRcsConfigCallback) {
                return (IRcsConfigCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onConfigurationChanged";
                }
                case 2: {
                    return "onAutoConfigurationErrorReceived";
                }
                case 3: {
                    return "onConfigurationReset";
                }
                case 4: {
                    return "onRemoved";
                }
                case 5: {
                    return "onPreProvisioningReceived";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IRcsConfigCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    byte[] _arg0 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onConfigurationChanged(_arg0);
                    break;
                }
                case 2: {
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    data.enforceNoDataAvail();
                    this.onAutoConfigurationErrorReceived(_arg0, _arg1);
                    break;
                }
                case 3: {
                    this.onConfigurationReset();
                    break;
                }
                case 4: {
                    this.onRemoved();
                    break;
                }
                case 5: {
                    byte[] _arg0 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.onPreProvisioningReceived(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 4;
        }

        private static class Proxy
        implements IRcsConfigCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IRcsConfigCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onConfigurationChanged(byte[] config) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRcsConfigCallback.DESCRIPTOR);
                    _data.writeByteArray(config);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAutoConfigurationErrorReceived(int errorCode, String errorString) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRcsConfigCallback.DESCRIPTOR);
                    _data.writeInt(errorCode);
                    _data.writeString(errorString);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onConfigurationReset() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRcsConfigCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onRemoved() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRcsConfigCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onPreProvisioningReceived(byte[] config) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IRcsConfigCallback.DESCRIPTOR);
                    _data.writeByteArray(config);
                    boolean bl = this.mRemote.transact(5, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IRcsConfigCallback {
        @Override
        public void onConfigurationChanged(byte[] config) throws RemoteException {
        }

        @Override
        public void onAutoConfigurationErrorReceived(int errorCode, String errorString) throws RemoteException {
        }

        @Override
        public void onConfigurationReset() throws RemoteException {
        }

        @Override
        public void onRemoved() throws RemoteException {
        }

        @Override
        public void onPreProvisioningReceived(byte[] config) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

