/*
 * Decompiled with CFR 0.152.
 */
package android.telephony.ims;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@SystemApi
public class RtpHeaderExtensionType
implements Parcelable {
    private int mLocalIdentifier;
    private Uri mUri;
    @NonNull
    public static final Parcelable.Creator<RtpHeaderExtensionType> CREATOR = new Parcelable.Creator<RtpHeaderExtensionType>(){

        @Override
        public RtpHeaderExtensionType createFromParcel(@NonNull Parcel in) {
            return new RtpHeaderExtensionType(in);
        }

        @NonNull
        public RtpHeaderExtensionType[] newArray(int size) {
            return new RtpHeaderExtensionType[size];
        }
    };

    public RtpHeaderExtensionType(int localIdentifier, @NonNull Uri uri) {
        if (localIdentifier < 1 || localIdentifier > 13) {
            throw new IllegalArgumentException("localIdentifier must be in range 1-14");
        }
        if (uri == null) {
            throw new NullPointerException("uri is required.");
        }
        this.mLocalIdentifier = localIdentifier;
        this.mUri = uri;
    }

    private RtpHeaderExtensionType(Parcel in) {
        this.mLocalIdentifier = in.readInt();
        this.mUri = in.readParcelable(Uri.class.getClassLoader(), Uri.class);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mLocalIdentifier);
        dest.writeParcelable(this.mUri, flags);
    }

    public int getLocalIdentifier() {
        return this.mLocalIdentifier;
    }

    @NonNull
    public Uri getUri() {
        return this.mUri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RtpHeaderExtensionType that = (RtpHeaderExtensionType)o;
        return this.mLocalIdentifier == that.mLocalIdentifier && this.mUri.equals(that.mUri);
    }

    public int hashCode() {
        return Objects.hash(this.mLocalIdentifier, this.mUri);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RtpHeaderExtensionType{mLocalIdentifier=");
        sb.append(this.mLocalIdentifier);
        sb.append(", mUri=");
        sb.append(this.mUri);
        sb.append("}");
        return sb.toString();
    }
}

