/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.LteVopsSupportInfo;
import android.telephony.VopsSupportInfo;
import com.android.internal.annotations.VisibleForTesting;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class DataSpecificRegistrationInfo
implements Parcelable {
    public static final int LTE_ATTACH_TYPE_UNKNOWN = 0;
    public static final int LTE_ATTACH_TYPE_EPS_ONLY = 1;
    public static final int LTE_ATTACH_TYPE_COMBINED = 2;
    public static final int LTE_ATTACH_EXTRA_INFO_NONE = 0;
    public static final int LTE_ATTACH_EXTRA_INFO_CSFB_NOT_PREFERRED = 1;
    public static final int LTE_ATTACH_EXTRA_INFO_SMS_ONLY = 2;
    public final int maxDataCalls;
    public final boolean isDcNrRestricted;
    public final boolean isNrAvailable;
    public final boolean isEnDcAvailable;
    @Nullable
    private final VopsSupportInfo mVopsSupportInfo;
    private final int mLteAttachResultType;
    private final int mLteAttachExtraInfo;
    @NonNull
    public static final Parcelable.Creator<DataSpecificRegistrationInfo> CREATOR = new Parcelable.Creator<DataSpecificRegistrationInfo>(){

        @Override
        public DataSpecificRegistrationInfo createFromParcel(Parcel source) {
            return new DataSpecificRegistrationInfo(source);
        }

        public DataSpecificRegistrationInfo[] newArray(int size) {
            return new DataSpecificRegistrationInfo[size];
        }
    };

    private DataSpecificRegistrationInfo(Builder builder) {
        this.maxDataCalls = builder.mMaxDataCalls;
        this.isDcNrRestricted = builder.mIsDcNrRestricted;
        this.isNrAvailable = builder.mIsNrAvailable;
        this.isEnDcAvailable = builder.mIsEnDcAvailable;
        this.mVopsSupportInfo = builder.mVopsSupportInfo;
        this.mLteAttachResultType = builder.mLteAttachResultType;
        this.mLteAttachExtraInfo = builder.mLteAttachExtraInfo;
    }

    @VisibleForTesting
    public DataSpecificRegistrationInfo(int maxDataCalls, boolean isDcNrRestricted, boolean isNrAvailable, boolean isEnDcAvailable, @Nullable VopsSupportInfo vops) {
        this.maxDataCalls = maxDataCalls;
        this.isDcNrRestricted = isDcNrRestricted;
        this.isNrAvailable = isNrAvailable;
        this.isEnDcAvailable = isEnDcAvailable;
        this.mVopsSupportInfo = vops;
        this.mLteAttachResultType = 0;
        this.mLteAttachExtraInfo = 0;
    }

    DataSpecificRegistrationInfo(@NonNull DataSpecificRegistrationInfo dsri) {
        this.maxDataCalls = dsri.maxDataCalls;
        this.isDcNrRestricted = dsri.isDcNrRestricted;
        this.isNrAvailable = dsri.isNrAvailable;
        this.isEnDcAvailable = dsri.isEnDcAvailable;
        this.mVopsSupportInfo = dsri.mVopsSupportInfo;
        this.mLteAttachResultType = dsri.mLteAttachResultType;
        this.mLteAttachExtraInfo = dsri.mLteAttachExtraInfo;
    }

    private DataSpecificRegistrationInfo(Parcel source) {
        this.maxDataCalls = source.readInt();
        this.isDcNrRestricted = source.readBoolean();
        this.isNrAvailable = source.readBoolean();
        this.isEnDcAvailable = source.readBoolean();
        this.mVopsSupportInfo = source.readParcelable(VopsSupportInfo.class.getClassLoader(), VopsSupportInfo.class);
        this.mLteAttachResultType = source.readInt();
        this.mLteAttachExtraInfo = source.readInt();
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.maxDataCalls);
        dest.writeBoolean(this.isDcNrRestricted);
        dest.writeBoolean(this.isNrAvailable);
        dest.writeBoolean(this.isEnDcAvailable);
        dest.writeParcelable(this.mVopsSupportInfo, flags);
        dest.writeInt(this.mLteAttachResultType);
        dest.writeInt(this.mLteAttachExtraInfo);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public String toString() {
        return this.getClass().getName() + " :{" + (" maxDataCalls = " + this.maxDataCalls) + (" isDcNrRestricted = " + this.isDcNrRestricted) + (" isNrAvailable = " + this.isNrAvailable) + (" isEnDcAvailable = " + this.isEnDcAvailable) + (" mLteAttachResultType = " + this.mLteAttachResultType) + (" mLteAttachExtraInfo = " + this.mLteAttachExtraInfo) + (" " + this.mVopsSupportInfo) + " }";
    }

    public int hashCode() {
        return Objects.hash(this.maxDataCalls, this.isDcNrRestricted, this.isNrAvailable, this.isEnDcAvailable, this.mVopsSupportInfo, this.mLteAttachResultType, this.mLteAttachExtraInfo);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataSpecificRegistrationInfo)) {
            return false;
        }
        DataSpecificRegistrationInfo other = (DataSpecificRegistrationInfo)o;
        return this.maxDataCalls == other.maxDataCalls && this.isDcNrRestricted == other.isDcNrRestricted && this.isNrAvailable == other.isNrAvailable && this.isEnDcAvailable == other.isEnDcAvailable && Objects.equals(this.mVopsSupportInfo, other.mVopsSupportInfo) && this.mLteAttachResultType == other.mLteAttachResultType && this.mLteAttachExtraInfo == other.mLteAttachExtraInfo;
    }

    @Deprecated
    @NonNull
    public LteVopsSupportInfo getLteVopsSupportInfo() {
        return this.mVopsSupportInfo instanceof LteVopsSupportInfo ? (LteVopsSupportInfo)this.mVopsSupportInfo : new LteVopsSupportInfo(1, 1);
    }

    @Nullable
    public VopsSupportInfo getVopsSupportInfo() {
        return this.mVopsSupportInfo;
    }

    public int getLteAttachResultType() {
        return this.mLteAttachResultType;
    }

    public int getLteAttachExtraInfo() {
        return this.mLteAttachExtraInfo;
    }

    public static class Builder {
        private final int mMaxDataCalls;
        private boolean mIsDcNrRestricted;
        private boolean mIsNrAvailable;
        private boolean mIsEnDcAvailable;
        @Nullable
        private VopsSupportInfo mVopsSupportInfo;
        private int mLteAttachResultType = 0;
        private int mLteAttachExtraInfo = 0;

        public Builder(int maxDataCalls) {
            this.mMaxDataCalls = maxDataCalls;
        }

        @NonNull
        public Builder setDcNrRestricted(boolean isDcNrRestricted) {
            this.mIsDcNrRestricted = isDcNrRestricted;
            return this;
        }

        @NonNull
        public Builder setNrAvailable(boolean isNrAvailable) {
            this.mIsNrAvailable = isNrAvailable;
            return this;
        }

        @NonNull
        public Builder setEnDcAvailable(boolean isEnDcAvailable) {
            this.mIsEnDcAvailable = isEnDcAvailable;
            return this;
        }

        @Nullable
        @NonNull
        public Builder setVopsSupportInfo(VopsSupportInfo vops) {
            this.mVopsSupportInfo = vops;
            return this;
        }

        @NonNull
        public Builder setLteAttachResultType(int lteAttachResultType) {
            this.mLteAttachResultType = lteAttachResultType;
            return this;
        }

        @NonNull
        public Builder setLteAttachExtraInfo(int lteAttachExtraInfo) {
            this.mLteAttachExtraInfo = lteAttachExtraInfo;
            return this;
        }

        @NonNull
        public DataSpecificRegistrationInfo build() {
            return new DataSpecificRegistrationInfo(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LteAttachExtraInfo {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LteAttachResultType {
    }
}

