/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellIdentity;
import android.telephony.ClosedSubscriberGroupInfo;
import android.telephony.gsm.GsmCellLocation;
import android.text.TextUtils;
import android.util.ArraySet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;

public class CellIdentityLte
extends CellIdentity {
    private static final String TAG = CellIdentityLte.class.getSimpleName();
    private static final boolean DBG = false;
    private static final int MAX_CI = 0xFFFFFFF;
    private static final int MAX_PCI = 503;
    private static final int MAX_TAC = 65535;
    private static final int MAX_EARFCN = 262143;
    private static final int MAX_BANDWIDTH = 20000;
    private final int mCi;
    private final int mPci;
    private final int mTac;
    private final int mEarfcn;
    private final int mBandwidth;
    private final int[] mBands;
    private final ArraySet<String> mAdditionalPlmns;
    private ClosedSubscriberGroupInfo mCsgInfo;
    @NonNull
    public static final Parcelable.Creator<CellIdentityLte> CREATOR = new Parcelable.Creator<CellIdentityLte>(){

        @Override
        public CellIdentityLte createFromParcel(Parcel in) {
            in.readInt();
            return CellIdentityLte.createFromParcelBody(in);
        }

        public CellIdentityLte[] newArray(int size) {
            return new CellIdentityLte[size];
        }
    };

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    public CellIdentityLte() {
        super(TAG, 3, null, null, null, null);
        this.mCi = Integer.MAX_VALUE;
        this.mPci = Integer.MAX_VALUE;
        this.mTac = Integer.MAX_VALUE;
        this.mEarfcn = Integer.MAX_VALUE;
        this.mBands = new int[0];
        this.mBandwidth = Integer.MAX_VALUE;
        this.mAdditionalPlmns = new ArraySet();
        this.mCsgInfo = null;
        this.mGlobalCellId = null;
    }

    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public CellIdentityLte(int mcc, int mnc, int ci, int pci, int tac) {
        this(ci, pci, tac, Integer.MAX_VALUE, new int[0], Integer.MAX_VALUE, String.valueOf(mcc), String.valueOf(mnc), null, null, new ArraySet<String>(), null);
    }

    public CellIdentityLte(int ci, int pci, int tac, int earfcn, @NonNull int[] bands, int bandwidth, @Nullable String mccStr, @Nullable String mncStr, @Nullable String alphal, @Nullable String alphas, @NonNull Collection<String> additionalPlmns, @Nullable ClosedSubscriberGroupInfo csgInfo) {
        super(TAG, 3, mccStr, mncStr, alphal, alphas);
        this.mCi = CellIdentityLte.inRangeOrUnavailable(ci, 0, 0xFFFFFFF);
        this.mPci = CellIdentityLte.inRangeOrUnavailable(pci, 0, 503);
        this.mTac = CellIdentityLte.inRangeOrUnavailable(tac, 0, 65535);
        this.mEarfcn = CellIdentityLte.inRangeOrUnavailable(earfcn, 0, 262143);
        this.mBands = bands;
        this.mBandwidth = CellIdentityLte.inRangeOrUnavailable(bandwidth, 0, 20000);
        this.mAdditionalPlmns = new ArraySet(additionalPlmns.size());
        for (String plmn : additionalPlmns) {
            if (!CellIdentityLte.isValidPlmn(plmn)) continue;
            this.mAdditionalPlmns.add(plmn);
        }
        this.mCsgInfo = csgInfo;
        this.updateGlobalCellId();
    }

    private CellIdentityLte(@NonNull CellIdentityLte cid) {
        this(cid.mCi, cid.mPci, cid.mTac, cid.mEarfcn, cid.mBands, cid.mBandwidth, cid.mMccStr, cid.mMncStr, cid.mAlphaLong, cid.mAlphaShort, cid.mAdditionalPlmns, cid.mCsgInfo);
    }

    @Override
    @NonNull
    public CellIdentityLte sanitizeLocationInfo() {
        return new CellIdentityLte(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, this.mBands, Integer.MAX_VALUE, this.mMccStr, this.mMncStr, this.mAlphaLong, this.mAlphaShort, this.mAdditionalPlmns, null);
    }

    @NonNull
    CellIdentityLte copy() {
        return new CellIdentityLte(this);
    }

    @Override
    protected void updateGlobalCellId() {
        this.mGlobalCellId = null;
        String plmn = this.getPlmn();
        if (plmn == null) {
            return;
        }
        if (this.mCi == Integer.MAX_VALUE) {
            return;
        }
        this.mGlobalCellId = plmn + TextUtils.formatSimple("%07x", this.mCi);
    }

    @Deprecated
    public int getMcc() {
        return this.mMccStr != null ? Integer.valueOf(this.mMccStr) : Integer.MAX_VALUE;
    }

    @Deprecated
    public int getMnc() {
        return this.mMncStr != null ? Integer.valueOf(this.mMncStr) : Integer.MAX_VALUE;
    }

    public int getCi() {
        return this.mCi;
    }

    public int getPci() {
        return this.mPci;
    }

    public int getTac() {
        return this.mTac;
    }

    public int getEarfcn() {
        return this.mEarfcn;
    }

    @NonNull
    public int[] getBands() {
        return Arrays.copyOf(this.mBands, this.mBands.length);
    }

    public int getBandwidth() {
        return this.mBandwidth;
    }

    @Override
    @Nullable
    public String getMccString() {
        return this.mMccStr;
    }

    @Override
    @Nullable
    public String getMncString() {
        return this.mMncStr;
    }

    @Nullable
    public String getMobileNetworkOperator() {
        return this.mMccStr == null || this.mMncStr == null ? null : this.mMccStr + this.mMncStr;
    }

    @Override
    public int getChannelNumber() {
        return this.mEarfcn;
    }

    @NonNull
    public Set<String> getAdditionalPlmns() {
        return Collections.unmodifiableSet(this.mAdditionalPlmns);
    }

    @Nullable
    public ClosedSubscriberGroupInfo getClosedSubscriberGroupInfo() {
        return this.mCsgInfo;
    }

    @Override
    @NonNull
    public GsmCellLocation asCellLocation() {
        GsmCellLocation cl = new GsmCellLocation();
        int tac = this.mTac != Integer.MAX_VALUE ? this.mTac : -1;
        int cid = this.mCi != Integer.MAX_VALUE ? this.mCi : -1;
        cl.setLacAndCid(tac, cid);
        cl.setPsc(0);
        return cl;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.mCi, this.mPci, this.mTac, this.mEarfcn, Arrays.hashCode(this.mBands), this.mBandwidth, this.mAdditionalPlmns.hashCode(), this.mCsgInfo, super.hashCode());
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof CellIdentityLte)) {
            return false;
        }
        CellIdentityLte o = (CellIdentityLte)other;
        return this.mCi == o.mCi && this.mPci == o.mPci && this.mTac == o.mTac && this.mEarfcn == o.mEarfcn && Arrays.equals(this.mBands, o.mBands) && this.mBandwidth == o.mBandwidth && TextUtils.equals(this.mMccStr, o.mMccStr) && TextUtils.equals(this.mMncStr, o.mMncStr) && this.mAdditionalPlmns.equals(o.mAdditionalPlmns) && Objects.equals(this.mCsgInfo, o.mCsgInfo) && super.equals(other);
    }

    public String toString() {
        return TAG + ":{ mCi=" + this.mCi + " mPci=" + this.mPci + " mTac=" + this.mTac + " mEarfcn=" + this.mEarfcn + " mBands=" + Arrays.toString(this.mBands) + " mBandwidth=" + this.mBandwidth + " mMcc=" + this.mMccStr + " mMnc=" + this.mMncStr + " mAlphaLong=" + this.mAlphaLong + " mAlphaShort=" + this.mAlphaShort + " mAdditionalPlmns=" + this.mAdditionalPlmns + " mCsgInfo=" + this.mCsgInfo + "}";
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, 3);
        dest.writeInt(this.mCi);
        dest.writeInt(this.mPci);
        dest.writeInt(this.mTac);
        dest.writeInt(this.mEarfcn);
        dest.writeIntArray(this.mBands);
        dest.writeInt(this.mBandwidth);
        dest.writeArraySet(this.mAdditionalPlmns);
        dest.writeParcelable(this.mCsgInfo, flags);
    }

    private CellIdentityLte(Parcel in) {
        super(TAG, 3, in);
        this.mCi = in.readInt();
        this.mPci = in.readInt();
        this.mTac = in.readInt();
        this.mEarfcn = in.readInt();
        this.mBands = in.createIntArray();
        this.mBandwidth = in.readInt();
        this.mAdditionalPlmns = in.readArraySet(null);
        this.mCsgInfo = in.readParcelable(null, ClosedSubscriberGroupInfo.class);
        this.updateGlobalCellId();
    }

    protected static CellIdentityLte createFromParcelBody(Parcel in) {
        return new CellIdentityLte(in);
    }
}

