/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.SubscriptionInfo;
import com.android.layoutlib.androidx.annotation.NonNull;
import com.android.telephony.Rlog;
import java.util.ArrayList;
import java.util.List;

public class CarrierInfo
implements Parcelable {
    @android.annotation.NonNull
    public static final Parcelable.Creator<CarrierInfo> CREATOR = new Parcelable.Creator<CarrierInfo>(){

        @Override
        public CarrierInfo createFromParcel(Parcel source) {
            return new CarrierInfo(source);
        }

        public CarrierInfo[] newArray(int size) {
            return new CarrierInfo[size];
        }
    };
    @NonNull
    private String mMcc;
    @NonNull
    private String mMnc;
    @Nullable
    private String mSpn;
    @Nullable
    private String mGid1;
    @Nullable
    private String mGid2;
    @Nullable
    private String mImsiPrefix;
    @Nullable
    private List<String> mEhplmn;
    @Nullable
    private String mIccid;
    @Nullable
    private String mImpi;

    @NonNull
    public String getMcc() {
        return this.mMcc;
    }

    @NonNull
    public String getMnc() {
        return this.mMnc;
    }

    @Nullable
    public String getSpn() {
        return this.mSpn;
    }

    @Nullable
    public String getGid1() {
        return this.mGid1;
    }

    @Nullable
    public String getGid2() {
        return this.mGid2;
    }

    @Nullable
    public String getImsiPrefix() {
        return this.mImsiPrefix;
    }

    @Nullable
    public String getIccid() {
        return this.mIccid;
    }

    @Nullable
    public String getImpi() {
        return this.mImpi;
    }

    @NonNull
    public List<String> getEhplmn() {
        return this.mEhplmn;
    }

    public CarrierInfo(@NonNull String mcc, @NonNull String mnc, @Nullable String spn, @Nullable String gid1, @Nullable String gid2, @Nullable String imsi, @Nullable String iccid, @Nullable String impi, @Nullable List<String> plmnArrayList) {
        this.mMcc = mcc;
        this.mMnc = mnc;
        this.mSpn = spn;
        this.mGid1 = gid1;
        this.mGid2 = gid2;
        this.mImsiPrefix = imsi;
        this.mIccid = iccid;
        this.mImpi = impi;
        this.mEhplmn = plmnArrayList;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString8(this.mMcc);
        dest.writeString8(this.mMnc);
        dest.writeString8(this.mSpn);
        dest.writeString8(this.mGid1);
        dest.writeString8(this.mGid2);
        dest.writeString8(this.mImsiPrefix);
        dest.writeString8(this.mIccid);
        dest.writeString8(this.mImpi);
        dest.writeStringList(this.mEhplmn);
    }

    public CarrierInfo(Parcel in) {
        this.mEhplmn = new ArrayList<String>();
        this.mMcc = in.readString8();
        this.mMnc = in.readString8();
        this.mSpn = in.readString8();
        this.mGid1 = in.readString8();
        this.mGid2 = in.readString8();
        this.mImsiPrefix = in.readString8();
        this.mIccid = in.readString8();
        this.mImpi = in.readString8();
        in.readStringList(this.mEhplmn);
    }

    @android.annotation.NonNull
    public String toString() {
        return "CarrierInfo MCC = " + this.mMcc + "   MNC = " + this.mMnc + "  SPN = " + this.mSpn + "   GID1 = " + this.mGid1 + "   GID2 = " + this.mGid2 + "   IMSI = " + this.getPrintableImsi() + "   ICCID = " + SubscriptionInfo.getPrintableId(this.mIccid) + "  IMPI = " + this.mImpi + "  EHPLMN = [ " + this.getEhplmn_toString() + " ]";
    }

    private String getEhplmn_toString() {
        return String.join((CharSequence)"  ", this.mEhplmn);
    }

    private String getPrintableImsi() {
        boolean enablePiiLog = Rlog.isLoggable("CarrierInfo", 2);
        return this.mImsiPrefix != null && this.mImsiPrefix.length() > 6 ? this.mImsiPrefix.substring(0, 6) + Rlog.pii(enablePiiLog, (Object)this.mImsiPrefix.substring(6)) : this.mImsiPrefix;
    }
}

