/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CallQuality;
import java.util.Objects;

@SystemApi
public class CallState
implements Parcelable {
    public static final int CALL_CLASSIFICATION_UNKNOWN = -1;
    public static final int CALL_CLASSIFICATION_RINGING = 0;
    public static final int CALL_CLASSIFICATION_FOREGROUND = 1;
    public static final int CALL_CLASSIFICATION_BACKGROUND = 2;
    public static final int CALL_CLASSIFICATION_MAX = 3;
    private final int mPreciseCallState;
    private final int mNetworkType;
    private final CallQuality mCallQuality;
    private final int mCallClassification;
    @Nullable
    private String mImsCallId;
    private int mImsCallServiceType;
    private int mImsCallType;
    @NonNull
    public static final Parcelable.Creator<CallState> CREATOR = new Parcelable.Creator(){

        public CallState createFromParcel(Parcel in) {
            return new CallState(in);
        }

        public CallState[] newArray(int size) {
            return new CallState[size];
        }
    };

    private CallState(int callState, int networkType, @NonNull CallQuality callQuality, int callClassification, @Nullable String imsCallId, int imsCallServiceType, int imsCallType) {
        this.mPreciseCallState = callState;
        this.mNetworkType = networkType;
        this.mCallQuality = callQuality;
        this.mCallClassification = callClassification;
        this.mImsCallId = imsCallId;
        this.mImsCallServiceType = imsCallServiceType;
        this.mImsCallType = imsCallType;
    }

    @NonNull
    public String toString() {
        return "mPreciseCallState=" + this.mPreciseCallState + " mNetworkType=" + this.mNetworkType + " mCallQuality=" + this.mCallQuality + " mCallClassification" + this.mCallClassification + " mImsCallId=" + this.mImsCallId + " mImsCallServiceType=" + this.mImsCallServiceType + " mImsCallType=" + this.mImsCallType;
    }

    private CallState(Parcel in) {
        this.mPreciseCallState = in.readInt();
        this.mNetworkType = in.readInt();
        this.mCallQuality = in.readParcelable(CallQuality.class.getClassLoader(), CallQuality.class);
        this.mCallClassification = in.readInt();
        this.mImsCallId = in.readString();
        this.mImsCallServiceType = in.readInt();
        this.mImsCallType = in.readInt();
    }

    public int getCallState() {
        return this.mPreciseCallState;
    }

    public int getNetworkType() {
        return this.mNetworkType;
    }

    @Nullable
    public CallQuality getCallQuality() {
        return this.mCallQuality;
    }

    public int getCallClassification() {
        return this.mCallClassification;
    }

    @Nullable
    public String getImsCallSessionId() {
        return this.mImsCallId;
    }

    public int getImsCallServiceType() {
        return this.mImsCallServiceType;
    }

    public int getImsCallType() {
        return this.mImsCallType;
    }

    public int hashCode() {
        return Objects.hash(this.mPreciseCallState, this.mNetworkType, this.mCallQuality, this.mCallClassification, this.mImsCallId, this.mImsCallServiceType, this.mImsCallType);
    }

    public boolean equals(@Nullable Object o) {
        if (o == null || !(o instanceof CallState) || this.hashCode() != o.hashCode()) {
            return false;
        }
        if (this == o) {
            return true;
        }
        CallState s = (CallState)o;
        return this.mPreciseCallState == s.mPreciseCallState && this.mNetworkType == s.mNetworkType && Objects.equals(this.mCallQuality, s.mCallQuality) && this.mCallClassification == s.mCallClassification && Objects.equals(this.mImsCallId, s.mImsCallId) && this.mImsCallType == s.mImsCallType && this.mImsCallServiceType == s.mImsCallServiceType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@Nullable Parcel dest, int flags) {
        dest.writeInt(this.mPreciseCallState);
        dest.writeInt(this.mNetworkType);
        dest.writeParcelable(this.mCallQuality, flags);
        dest.writeInt(this.mCallClassification);
        dest.writeString(this.mImsCallId);
        dest.writeInt(this.mImsCallServiceType);
        dest.writeInt(this.mImsCallType);
    }

    public static class Builder {
        private int mPreciseCallState;
        private int mNetworkType = 0;
        private CallQuality mCallQuality = null;
        private int mCallClassification = -1;
        private String mImsCallId;
        private int mImsCallServiceType = 0;
        private int mImsCallType = 0;

        public Builder(int preciseCallState) {
            this.mPreciseCallState = preciseCallState;
        }

        @NonNull
        public Builder setNetworkType(int networkType) {
            this.mNetworkType = networkType;
            return this;
        }

        @NonNull
        public Builder setCallQuality(@Nullable CallQuality callQuality) {
            this.mCallQuality = callQuality;
            return this;
        }

        @NonNull
        public Builder setCallClassification(int classification) {
            this.mCallClassification = classification;
            return this;
        }

        @NonNull
        public Builder setImsCallSessionId(@Nullable String imsCallId) {
            this.mImsCallId = imsCallId;
            return this;
        }

        @NonNull
        public Builder setImsCallServiceType(int serviceType) {
            this.mImsCallServiceType = serviceType;
            return this;
        }

        @NonNull
        public Builder setImsCallType(int callType) {
            this.mImsCallType = callType;
            return this;
        }

        @NonNull
        public CallState build() {
            return new CallState(this.mPreciseCallState, this.mNetworkType, this.mCallQuality, this.mCallClassification, this.mImsCallId, this.mImsCallServiceType, this.mImsCallType);
        }
    }
}

