/*
 * Decompiled with CFR 0.152.
 */
package android.system.virtualmachine;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.os.RemoteException;
import android.system.virtualmachine.BuildFlags;
import android.system.virtualmachine.VirtualMachine;
import android.system.virtualmachine.VirtualMachineConfig;
import android.system.virtualmachine.VirtualMachineDescriptor;
import android.system.virtualmachine.VirtualMachineException;
import android.system.virtualmachine.VirtualizationService;
import android.util.ArrayMap;
import com.android.internal.annotations.GuardedBy;
import com.android.system.virtualmachine.sysprop.HypervisorProperties;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@SystemApi
public class VirtualMachineManager {
    private static final Object sCreateLock = new Object();
    @NonNull
    private final Context mContext;
    @GuardedBy(value={"sCreateLock"})
    private final Map<String, WeakReference<VirtualMachine>> mVmsByName = new ArrayMap<String, WeakReference<VirtualMachine>>();
    public static final int CAPABILITY_PROTECTED_VM = 1;
    public static final int CAPABILITY_NON_PROTECTED_VM = 2;
    public static final String FEATURE_DICE_CHANGES = "com.android.kvm.DICE_CHANGES";
    public static final String FEATURE_MULTI_TENANT = "com.android.kvm.MULTI_TENANT";
    public static final String FEATURE_NETWORK = "com.android.kvm.NETWORK";
    public static final String FEATURE_REMOTE_ATTESTATION = "com.android.kvm.REMOTE_ATTESTATION";
    public static final String FEATURE_VENDOR_MODULES = "com.android.kvm.VENDOR_MODULES";
    public static final String FEATURE_LLPVM_CHANGES = "com.android.kvm.LLPVM_CHANGES";
    private static final String JSON_SUFFIX = ".json";
    private static final List<String> SUPPORTED_OS_LIST_FROM_CFG = VirtualMachineManager.extractSupportedOSListFromConfig();

    public VirtualMachineManager(@NonNull Context context) {
        this.mContext = Objects.requireNonNull(context);
    }

    @SystemApi
    public int getCapabilities() {
        int result = 0;
        if (HypervisorProperties.hypervisor_protected_vm_supported().orElse(false).booleanValue()) {
            result |= 1;
        }
        if (HypervisorProperties.hypervisor_vm_supported().orElse(false).booleanValue()) {
            result |= 2;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @NonNull
    @RequiresPermission(value="android.permission.MANAGE_VIRTUAL_MACHINE")
    public VirtualMachine create(@NonNull String name, @NonNull VirtualMachineConfig config) throws VirtualMachineException {
        Object object = sCreateLock;
        synchronized (object) {
            return this.createLocked(name, config);
        }
    }

    @NonNull
    @GuardedBy(value={"sCreateLock"})
    private VirtualMachine createLocked(@NonNull String name, @NonNull VirtualMachineConfig config) throws VirtualMachineException {
        VirtualMachine vm = VirtualMachine.create(this.mContext, name, config);
        this.mVmsByName.put(name, new WeakReference<VirtualMachine>(vm));
        return vm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @Nullable
    public VirtualMachine get(@NonNull String name) throws VirtualMachineException {
        Object object = sCreateLock;
        synchronized (object) {
            return this.getLocked(name);
        }
    }

    @Nullable
    @GuardedBy(value={"sCreateLock"})
    private VirtualMachine getLocked(@NonNull String name) throws VirtualMachineException {
        VirtualMachine vm = this.getVmByName(name);
        if (vm != null) {
            return vm;
        }
        vm = VirtualMachine.load(this.mContext, name);
        if (vm != null) {
            this.mVmsByName.put(name, new WeakReference<VirtualMachine>(vm));
        }
        return vm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @NonNull
    public VirtualMachine importFromDescriptor(@NonNull String name, @NonNull VirtualMachineDescriptor vmDescriptor) throws VirtualMachineException {
        VirtualMachine vm;
        Object object = sCreateLock;
        synchronized (object) {
            vm = VirtualMachine.fromDescriptor(this.mContext, name, vmDescriptor);
            this.mVmsByName.put(name, new WeakReference<VirtualMachine>(vm));
        }
        return vm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @NonNull
    public VirtualMachine getOrCreate(@NonNull String name, @NonNull VirtualMachineConfig config) throws VirtualMachineException {
        Object object = sCreateLock;
        synchronized (object) {
            VirtualMachine vm = this.getLocked(name);
            if (vm != null) {
                return vm;
            }
            return this.createLocked(name, config);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void delete(@NonNull String name) throws VirtualMachineException {
        Object object = sCreateLock;
        synchronized (object) {
            VirtualMachine vm = this.getVmByName(name);
            if (vm == null) {
                VirtualMachine.vmInstanceCleanup(this.mContext, name);
            } else {
                vm.delete(this.mContext, name);
            }
            this.mVmsByName.remove(name);
        }
    }

    @Nullable
    @GuardedBy(value={"sCreateLock"})
    private VirtualMachine getVmByName(@NonNull String name) {
        VirtualMachine vm;
        Objects.requireNonNull(name);
        WeakReference<VirtualMachine> weakReference = this.mVmsByName.get(name);
        if (weakReference != null && (vm = (VirtualMachine)weakReference.get()) != null && vm.getStatus() != 2) {
            return vm;
        }
        return null;
    }

    private static List<String> extractSupportedOSListFromConfig() {
        ArrayList<String> supportedOsList = new ArrayList<String>();
        File directory = new File("/apex/com.android.virt/etc");
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                String fileName = file.getName();
                if (!fileName.endsWith(JSON_SUFFIX)) continue;
                supportedOsList.add(fileName.substring(0, fileName.length() - JSON_SUFFIX.length()));
            }
        }
        return supportedOsList;
    }

    @NonNull
    public List<String> getSupportedOSList() throws VirtualMachineException {
        if (BuildFlags.VENDOR_MODULES_ENABLED) {
            return SUPPORTED_OS_LIST_FROM_CFG;
        }
        return Arrays.asList("microdroid");
    }

    @RequiresPermission(value="android.permission.MANAGE_VIRTUAL_MACHINE")
    public boolean isFeatureEnabled(String featureName) throws VirtualMachineException {
        Object object = sCreateLock;
        synchronized (object) {
            VirtualizationService service = VirtualizationService.getInstance();
            try {
                return service.getBinder().isFeatureEnabled(featureName);
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_VIRTUAL_MACHINE")
    public boolean isRemoteAttestationSupported() throws VirtualMachineException {
        Object object = sCreateLock;
        synchronized (object) {
            VirtualizationService service = VirtualizationService.getInstance();
            try {
                return service.getBinder().isRemoteAttestationSupported();
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_VIRTUAL_MACHINE")
    public boolean isUpdatableVmSupported() throws VirtualMachineException {
        Object object = sCreateLock;
        synchronized (object) {
            VirtualizationService service = VirtualizationService.getInstance();
            try {
                return service.getBinder().isUpdatableVmSupported();
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Features {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Capability {
    }
}

