/*
 * Decompiled with CFR 0.152.
 */
package android.system.virtualmachine;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.os.Binder;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceSpecificException;
import android.system.ErrnoException;
import android.system.OsConstants;
import android.system.virtualizationcommon.IEncryptedStoreKEK;
import android.system.virtualizationservice.IVirtualMachine;
import android.system.virtualizationservice.IVirtualMachineCallback;
import android.system.virtualizationservice.IVirtualizationService;
import android.system.virtualizationservice.InputDevice;
import android.system.virtualizationservice.VirtualMachineAppConfig;
import android.system.virtualizationservice.VirtualMachineRawConfig;
import android.system.virtualizationservice.VirtualMachineState;
import android.system.virtualmachine.VirtualMachineCallback;
import android.system.virtualmachine.VirtualMachineConfig;
import android.system.virtualmachine.VirtualMachineCustomImageConfig;
import android.system.virtualmachine.VirtualMachineDescriptor;
import android.system.virtualmachine.VirtualMachineException;
import android.system.virtualmachine.VirtualizationService;
import android.util.JsonReader;
import android.util.Log;
import android.util.Pair;
import android.view.KeyEvent;
import android.view.MotionEvent;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.lang.System_Delegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.invoke.MethodHandle;
import java.lang.ref.WeakReference;
import java.lang.runtime.ObjectMethods;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.zip.ZipFile;
import libcore.io.IoBridge;
import libcore.io.IoUtils;

@SystemApi
public class VirtualMachine
implements AutoCloseable {
    public static final String MANAGE_VIRTUAL_MACHINE_PERMISSION = "android.permission.MANAGE_VIRTUAL_MACHINE";
    public static final String USE_CUSTOM_VIRTUAL_MACHINE_PERMISSION = "android.permission.USE_CUSTOM_VIRTUAL_MACHINE";
    @SuppressLint(value={"MinMaxConstant"})
    public static final long MIN_VSOCK_PORT = 1024L;
    @SuppressLint(value={"MinMaxConstant"})
    public static final long MAX_VSOCK_PORT = 0xFFFFFFFFL;
    private ParcelFileDescriptor mTouchSock;
    private ParcelFileDescriptor mKeySock;
    private ParcelFileDescriptor mMouseSock;
    private ParcelFileDescriptor mSwitchesSock;
    private ParcelFileDescriptor mTrackpadSock;
    private BlockingQueue<Pair<InputEventType, MotionEvent>> mInputEventQueue = new LinkedBlockingQueue<Pair<InputEventType, MotionEvent>>();
    public static final int STATUS_STOPPED = 0;
    public static final int STATUS_RUNNING = 1;
    public static final int STATUS_DELETED = 2;
    private static final String TAG = "VirtualMachine";
    private static final String VM_DIR = "vm";
    private static final String CONFIG_FILE = "config.xml";
    private static final String INSTANCE_IMAGE_FILE = "instance.img";
    private static final String INSTANCE_ID_FILE = "instance_id";
    private static final String IDSIG_FILE = "idsig";
    private static final String EXTRA_IDSIG_FILE_PREFIX = "extra_idsig_";
    private static final long INSTANCE_FILE_SIZE = 0xA00000L;
    private static final String ENCRYPTED_STORE_FILE = "storage.img";
    private static final String ENCRYPTED_STORE_KEK_FILE = "encrypted_store_kek.bin";
    @NonNull
    private final String mPackageName;
    @NonNull
    private final String mName;
    @NonNull
    private final File mVmRootPath;
    @NonNull
    private final File mConfigFilePath;
    @NonNull
    private final File mInstanceFilePath;
    @NonNull
    private final File mIdsigFilePath;
    @Nullable
    private final File mEncryptedStoreFilePath;
    @Nullable
    private final EncryptedStoreKEK mEncryptedStoreKEK;
    @Nullable
    private final File mInstanceIdPath;
    @NonNull
    private final List<ExtraApkSpec> mExtraApks;
    @NonNull
    private final Executor mMemoryCallbackExecutor = Executors.newSingleThreadExecutor();
    @NonNull
    private final VirtualizationService mVirtualizationService;
    private final MemoryManagementCallbacks mMemoryManagementCallbacks;
    @NonNull
    private final Context mContext;
    private final Object mLock = new Object();
    private final Object mCallbackLock = new Object();
    private final boolean mVmOutputCaptured;
    private final boolean mVmConsoleInputSupported;
    private final boolean mConnectVmConsole;
    private final Executor mConsoleExecutor = Executors.newSingleThreadExecutor();
    private ExecutorService mInputEventExecutor;
    @GuardedBy(value={"mLock"})
    @NonNull
    private VirtualMachineConfig mConfig;
    @GuardedBy(value={"mLock"})
    @Nullable
    private IVirtualMachine mVirtualMachine;
    @GuardedBy(value={"mLock"})
    @Nullable
    private ParcelFileDescriptor mConsoleOutReader;
    @GuardedBy(value={"mLock"})
    @Nullable
    private ParcelFileDescriptor mConsoleOutWriter;
    @GuardedBy(value={"mLock"})
    @Nullable
    private ParcelFileDescriptor mConsoleInReader;
    @GuardedBy(value={"mLock"})
    @Nullable
    private ParcelFileDescriptor mConsoleInWriter;
    @GuardedBy(value={"mLock"})
    @Nullable
    private ParcelFileDescriptor mTeeConsoleOutReader;
    @GuardedBy(value={"mLock"})
    @Nullable
    private ParcelFileDescriptor mTeeConsoleOutWriter;
    @GuardedBy(value={"mLock"})
    @Nullable
    private ParcelFileDescriptor mPtyFd;
    @GuardedBy(value={"mLock"})
    @Nullable
    private ParcelFileDescriptor mPtsFd;
    @GuardedBy(value={"mLock"})
    @Nullable
    private String mPtsName;
    @GuardedBy(value={"mLock"})
    @Nullable
    private ParcelFileDescriptor mLogReader;
    @GuardedBy(value={"mLock"})
    @Nullable
    private ParcelFileDescriptor mLogWriter;
    @GuardedBy(value={"mLock"})
    private boolean mWasDeleted = false;
    @GuardedBy(value={"mCallbackLock"})
    @Nullable
    private VirtualMachineCallback mCallback;
    @GuardedBy(value={"mCallbackLock"})
    @Nullable
    private Executor mCallbackExecutor;

    private VirtualMachine(@NonNull Context context, @NonNull String name, @NonNull VirtualMachineConfig config, @NonNull VirtualizationService service) throws VirtualMachineException {
        File thisVmDir;
        this.mPackageName = context.getPackageName();
        this.mName = Objects.requireNonNull(name, "Name must not be null");
        this.mConfig = Objects.requireNonNull(config, "Config must not be null");
        this.mVirtualizationService = service;
        this.mVmRootPath = thisVmDir = VirtualMachine.getVmDir(context, this.mName);
        this.mConfigFilePath = new File(thisVmDir, CONFIG_FILE);
        try {
            this.mInstanceIdPath = this.mVirtualizationService.getBinder().isFeatureEnabled("com.android.kvm.LLPVM_CHANGES") ? new File(thisVmDir, INSTANCE_ID_FILE) : null;
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
        this.mInstanceFilePath = new File(thisVmDir, INSTANCE_IMAGE_FILE);
        this.mIdsigFilePath = new File(thisVmDir, IDSIG_FILE);
        this.mExtraApks = VirtualMachine.setupExtraApks(context, config, thisVmDir);
        this.mContext = context;
        this.mEncryptedStoreFilePath = config.isEncryptedStorageEnabled() ? new File(thisVmDir, ENCRYPTED_STORE_FILE) : null;
        this.mEncryptedStoreKEK = config.getEncryptedStoreMode() == 1 ? new EncryptedStoreKEK(context, this.mName) : null;
        this.mVmOutputCaptured = config.isVmOutputCaptured();
        this.mVmConsoleInputSupported = config.isVmConsoleInputSupported();
        this.mConnectVmConsole = config.isConnectVmConsole();
        VirtualMachineCustomImageConfig customImageConfig = config.getCustomImageConfig();
        this.mMemoryManagementCallbacks = customImageConfig == null || customImageConfig.useAutoMemoryBalloon() ? new MemoryManagementCallbacks() : null;
    }

    @GuardedBy(value={"VirtualMachineManager.sCreateLock"})
    @NonNull
    static VirtualMachine fromDescriptor(@NonNull Context context, @NonNull String name, @NonNull VirtualMachineDescriptor vmDescriptor) throws VirtualMachineException {
        File vmDir = VirtualMachine.createVmDir(context, name);
        try {
            VirtualMachine vm;
            try (VirtualMachineDescriptor virtualMachineDescriptor = vmDescriptor;){
                VirtualMachineConfig config = VirtualMachineConfig.from(vmDescriptor.getConfigFd());
                vm = new VirtualMachine(context, name, config, VirtualizationService.getInstance());
                config.serialize(vm.mConfigFilePath);
                try {
                    vm.mInstanceFilePath.createNewFile();
                }
                catch (IOException e) {
                    throw new VirtualMachineException("failed to create instance image", e);
                }
                vm.importInstanceFrom(vmDescriptor.getInstanceImgFd());
                if (vmDescriptor.getEncryptedStoreFd() != null) {
                    try {
                        vm.mEncryptedStoreFilePath.createNewFile();
                    }
                    catch (IOException e) {
                        throw new VirtualMachineException("failed to create encrypted storage image", e);
                    }
                    vm.importEncryptedStoreFrom(vmDescriptor.getEncryptedStoreFd());
                }
                if (vm.mInstanceIdPath != null) {
                    vm.importInstanceIdFrom(vmDescriptor.getInstanceIdFd());
                    vm.claimInstance();
                }
            }
            return vm;
        }
        catch (VirtualMachineException | RuntimeException e) {
            try {
                VirtualMachine.deleteRecursively(vmDir);
            }
            catch (Exception innerException) {
                e.addSuppressed(innerException);
            }
            throw e;
        }
    }

    @GuardedBy(value={"VirtualMachineManager.sCreateLock"})
    @NonNull
    static VirtualMachine create(@NonNull Context context, @NonNull String name, @NonNull VirtualMachineConfig config) throws VirtualMachineException {
        File vmDir = VirtualMachine.createVmDir(context, name);
        try {
            VirtualMachine vm = new VirtualMachine(context, name, config, VirtualizationService.getInstance());
            config.serialize(vm.mConfigFilePath);
            try {
                vm.mInstanceFilePath.createNewFile();
            }
            catch (IOException e) {
                throw new VirtualMachineException("failed to create instance image", e);
            }
            if (config.isEncryptedStorageEnabled()) {
                try {
                    vm.mEncryptedStoreFilePath.createNewFile();
                }
                catch (IOException e) {
                    throw new VirtualMachineException("failed to create encrypted storage image", e);
                }
            }
            IVirtualizationService service = vm.mVirtualizationService.getBinder();
            if (vm.mInstanceIdPath != null) {
                try (FileOutputStream stream = new FileOutputStream(vm.mInstanceIdPath);){
                    byte[] id2 = service.allocateInstanceId();
                    stream.write(id2);
                }
                catch (FileNotFoundException e) {
                    throw new VirtualMachineException("instance_id file missing", e);
                }
                catch (IOException e) {
                    throw new VirtualMachineException("failed to persist instance_id", e);
                }
                catch (RemoteException e) {
                    throw e.rethrowAsRuntimeException();
                }
                catch (ServiceSpecificException | IllegalArgumentException e) {
                    throw new VirtualMachineException("failed to create instance_id", e);
                }
            }
            try {
                service.initializeWritablePartition(ParcelFileDescriptor.open(vm.mInstanceFilePath, 0x30000000), 0xA00000L, 1);
            }
            catch (FileNotFoundException e) {
                throw new VirtualMachineException("instance image missing", e);
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            catch (ServiceSpecificException | IllegalArgumentException e) {
                throw new VirtualMachineException("failed to create instance partition", e);
            }
            if (config.isEncryptedStorageEnabled()) {
                try {
                    service.initializeWritablePartition(ParcelFileDescriptor.open(vm.mEncryptedStoreFilePath, 0x30000000), config.getEncryptedStorageBytes(), 2);
                }
                catch (FileNotFoundException e) {
                    throw new VirtualMachineException("encrypted storage image missing", e);
                }
                catch (RemoteException e) {
                    throw e.rethrowAsRuntimeException();
                }
                catch (ServiceSpecificException | IllegalArgumentException e) {
                    throw new VirtualMachineException("failed to create encrypted storage partition", e);
                }
            }
            return vm;
        }
        catch (VirtualMachineException | RuntimeException e) {
            try {
                VirtualMachine.vmInstanceCleanup(context, name);
            }
            catch (Exception innerException) {
                e.addSuppressed(innerException);
            }
            throw e;
        }
    }

    @GuardedBy(value={"VirtualMachineManager.sCreateLock"})
    @Nullable
    static VirtualMachine load(@NonNull Context context, @NonNull String name) throws VirtualMachineException {
        File thisVmDir = VirtualMachine.getVmDir(context, name);
        if (!thisVmDir.exists()) {
            return null;
        }
        File configFilePath = new File(thisVmDir, CONFIG_FILE);
        VirtualMachineConfig config = VirtualMachineConfig.from(configFilePath);
        VirtualMachine vm = new VirtualMachine(context, name, config, VirtualizationService.getInstance());
        if (vm.mInstanceIdPath != null && !vm.mInstanceIdPath.exists()) {
            throw new VirtualMachineException("instance_id file missing");
        }
        if (!vm.mInstanceFilePath.exists()) {
            throw new VirtualMachineException("instance image missing");
        }
        if (config.isEncryptedStorageEnabled() && !vm.mEncryptedStoreFilePath.exists()) {
            throw new VirtualMachineException("Storage image missing");
        }
        return vm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value={"VirtualMachineManager.sCreateLock"})
    void delete(Context context, String name) throws VirtualMachineException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkStopped();
            this.mWasDeleted = true;
        }
        VirtualMachine.vmInstanceCleanup(context, name);
    }

    @GuardedBy(value={"VirtualMachineManager.sCreateLock"})
    static void vmInstanceCleanup(Context context, String name) throws VirtualMachineException {
        File vmDir = VirtualMachine.getVmDir(context, name);
        File ceVmDir = VirtualMachine.getVmDir(context.createCredentialProtectedStorageContext(), name);
        VirtualMachine.notifyInstanceRemoval(vmDir, VirtualizationService.getInstance());
        try {
            VirtualMachine.deleteRecursively(vmDir);
            if (ceVmDir.exists() && !vmDir.getCanonicalPath().equals(ceVmDir.getCanonicalPath())) {
                VirtualMachine.deleteRecursively(ceVmDir);
            }
        }
        catch (IOException e) {
            throw new VirtualMachineException(e);
        }
    }

    private static void notifyInstanceRemoval(File vmDirectory, @NonNull VirtualizationService service) {
        File instanceIdFile = new File(vmDirectory, INSTANCE_ID_FILE);
        try {
            byte[] instanceId = Files.readAllBytes(instanceIdFile.toPath());
            service.getBinder().removeVmInstance(instanceId);
        }
        catch (Exception e) {
            Log.w(TAG, "Failed to notify VS to remove the VM instance", e);
        }
    }

    void claimInstance() throws VirtualMachineException {
        if (this.mInstanceIdPath != null) {
            IVirtualizationService service = this.mVirtualizationService.getBinder();
            try {
                byte[] instanceId = Files.readAllBytes(this.mInstanceIdPath.toPath());
                service.claimVmInstance(instanceId);
            }
            catch (IOException e) {
                throw new VirtualMachineException("failed to read instance_id", e);
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    @GuardedBy(value={"VirtualMachineManager.sCreateLock"})
    @NonNull
    private static File createVmDir(@NonNull Context context, @NonNull String name) throws VirtualMachineException {
        File vmDir = VirtualMachine.getVmDir(context, name);
        try {
            Files.createDirectories(vmDir.getParentFile().toPath(), new FileAttribute[0]);
            Files.createDirectory(vmDir.toPath(), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            throw new VirtualMachineException("virtual machine already exists", e);
        }
        catch (IOException e) {
            throw new VirtualMachineException("failed to create directory for VM", e);
        }
        return vmDir;
    }

    @NonNull
    private static File getVmDir(@NonNull Context context, @NonNull String name) {
        if (name.contains(File.separator) || name.equals(".") || name.equals("..")) {
            throw new IllegalArgumentException("Invalid VM name: " + name);
        }
        File vmRoot = new File(context.getDataDir(), VM_DIR);
        return new File(vmRoot, name);
    }

    @SystemApi
    @NonNull
    public String getName() {
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @NonNull
    public VirtualMachineConfig getConfig() {
        Object object = this.mLock;
        synchronized (object) {
            return this.mConfig;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public int getStatus() {
        int status;
        IVirtualMachine virtualMachine;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mWasDeleted) {
                return 2;
            }
            virtualMachine = this.mVirtualMachine;
        }
        if (virtualMachine == null) {
            status = 0;
        } else {
            try {
                status = this.stateToStatus(virtualMachine.getState());
            }
            catch (RemoteException e) {
                status = 0;
            }
        }
        if (status == 0 && !this.mVmRootPath.exists()) {
            Object object2 = this.mLock;
            synchronized (object2) {
                this.dropVm();
            }
            return 2;
        }
        return status;
    }

    private int stateToStatus(@VirtualMachineState int state) {
        switch (state) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return 1;
            }
        }
        return 0;
    }

    @GuardedBy(value={"mLock"})
    private void checkStopped() throws VirtualMachineException {
        if (this.mWasDeleted || !this.mVmRootPath.exists()) {
            throw new VirtualMachineException("VM has been deleted");
        }
        if (this.mVirtualMachine == null) {
            return;
        }
        try {
            if (this.stateToStatus(this.mVirtualMachine.getState()) != 0) {
                throw new VirtualMachineException("VM is not in stopped state");
            }
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
        this.dropVm();
    }

    @GuardedBy(value={"mLock"})
    private void dropVm() {
        if (this.mInputEventExecutor != null) {
            this.mInputEventExecutor.shutdownNow();
            this.mInputEventExecutor = null;
        }
        if (this.mMemoryManagementCallbacks != null) {
            this.mContext.unregisterComponentCallbacks(this.mMemoryManagementCallbacks);
        }
        this.mVirtualMachine = null;
    }

    @GuardedBy(value={"mLock"})
    private IVirtualMachine getRunningVm() throws VirtualMachineException {
        try {
            if (this.mVirtualMachine != null && this.stateToStatus(this.mVirtualMachine.getState()) == 1) {
                return this.mVirtualMachine;
            }
            if (this.mWasDeleted || !this.mVmRootPath.exists()) {
                throw new VirtualMachineException("VM has been deleted");
            }
            throw new VirtualMachineException("VM is not in running state");
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void setCallback(@NonNull Executor executor, @NonNull VirtualMachineCallback callback) {
        Object object = this.mCallbackLock;
        synchronized (object) {
            this.mCallback = callback;
            this.mCallbackExecutor = executor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void clearCallback() {
        Object object = this.mCallbackLock;
        synchronized (object) {
            this.mCallback = null;
            this.mCallbackExecutor = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeCallback(Consumer<VirtualMachineCallback> fn) {
        Executor executor;
        VirtualMachineCallback callback;
        Object object = this.mCallbackLock;
        synchronized (object) {
            callback = this.mCallback;
            executor = this.mCallbackExecutor;
        }
        if (callback == null || executor == null) {
            return;
        }
        long restoreToken = Binder.clearCallingIdentity();
        try {
            executor.execute(() -> fn.accept(callback));
        }
        finally {
            Binder.restoreCallingIdentity(restoreToken);
        }
    }

    private android.system.virtualizationservice.VirtualMachineConfig createVirtualMachineConfigForRawFrom(VirtualMachineConfig vmConfig) throws IllegalStateException, IOException {
        VirtualMachineRawConfig rawConfig = vmConfig.toVsRawConfig();
        ArrayList<InputDevice> inputDevices = new ArrayList<InputDevice>();
        if (vmConfig.getCustomImageConfig() != null && rawConfig.displayConfig != null) {
            Parcelable t;
            ParcelFileDescriptor[] pfds;
            if (vmConfig.getCustomImageConfig().useTouch()) {
                pfds = ParcelFileDescriptor.createSocketPair();
                this.mTouchSock = pfds[0];
                t = new InputDevice.MultiTouch();
                t.width = rawConfig.displayConfig.width;
                t.height = rawConfig.displayConfig.height;
                t.pfd = pfds[1];
                inputDevices.add(InputDevice.multiTouch(t));
            }
            if (vmConfig.getCustomImageConfig().useKeyboard()) {
                pfds = ParcelFileDescriptor.createSocketPair();
                this.mKeySock = pfds[0];
                InputDevice.Keyboard k = new InputDevice.Keyboard();
                k.pfd = pfds[1];
                inputDevices.add(InputDevice.keyboard(k));
            }
            if (vmConfig.getCustomImageConfig().useMouse()) {
                pfds = ParcelFileDescriptor.createSocketPair();
                this.mMouseSock = pfds[0];
                InputDevice.Mouse m = new InputDevice.Mouse();
                m.pfd = pfds[1];
                inputDevices.add(InputDevice.mouse(m));
            }
            if (vmConfig.getCustomImageConfig().useSwitches()) {
                pfds = ParcelFileDescriptor.createSocketPair();
                this.mSwitchesSock = pfds[0];
                InputDevice.Switches s = new InputDevice.Switches();
                s.pfd = pfds[1];
                inputDevices.add(InputDevice.switches(s));
            }
            if (vmConfig.getCustomImageConfig().useTrackpad()) {
                pfds = ParcelFileDescriptor.createSocketPair();
                this.mTrackpadSock = pfds[0];
                t = new InputDevice.Trackpad();
                ((InputDevice.Trackpad)t).width = 2380;
                ((InputDevice.Trackpad)t).height = 1369;
                ((InputDevice.Trackpad)t).pfd = pfds[1];
                inputDevices.add(InputDevice.trackpad((InputDevice.Trackpad)t));
            }
        }
        rawConfig.inputDevices = inputDevices.toArray(new InputDevice[0]);
        if (vmConfig.getCustomImageConfig() != null) {
            rawConfig.networkSupported = vmConfig.getCustomImageConfig().useNetwork();
        }
        return android.system.virtualizationservice.VirtualMachineConfig.rawConfig(rawConfig);
    }

    public boolean sendKeyEvent(KeyEvent event) {
        if (this.mKeySock == null) {
            Log.d(TAG, "mKeySock == null");
            return false;
        }
        short EV_SYN = 0;
        short EV_KEY = 1;
        short SYN_REPORT = 0;
        boolean down = event.getAction() != 1;
        return this.writeEventsToSock(this.mKeySock, Arrays.asList(new InputEvent(EV_KEY, (short)event.getScanCode(), down ? 1 : 0), new InputEvent(EV_SYN, SYN_REPORT, 0)));
    }

    public boolean sendMouseEvent(MotionEvent event) {
        try {
            this.mInputEventQueue.add(Pair.create(InputEventType.MOUSE, MotionEvent.obtainNoHistory(event)));
            return true;
        }
        catch (Exception e) {
            Log.e(TAG, ((Object)e).toString());
            return false;
        }
    }

    private boolean sendMouseEventInternal(MotionEvent event) {
        if (this.mMouseSock == null) {
            Log.d(TAG, "mMouseSock == null");
            return false;
        }
        short EV_SYN = 0;
        short EV_REL = 2;
        short EV_KEY = 1;
        short REL_X = 0;
        short REL_Y = 1;
        short SYN_REPORT = 0;
        switch (event.getAction()) {
            case 2: {
                int x = (int)event.getX();
                int y = (int)event.getY();
                return this.writeEventsToSock(this.mMouseSock, Arrays.asList(new InputEvent(EV_REL, REL_X, x), new InputEvent(EV_REL, REL_Y, y), new InputEvent(EV_SYN, SYN_REPORT, 0)));
            }
            case 11: 
            case 12: {
                short keyCode;
                short BTN_LEFT = 272;
                short BTN_RIGHT = 273;
                short BTN_MIDDLE = 274;
                switch (event.getActionButton()) {
                    case 1: {
                        keyCode = BTN_LEFT;
                        break;
                    }
                    case 2: {
                        keyCode = BTN_RIGHT;
                        break;
                    }
                    case 4: {
                        keyCode = BTN_MIDDLE;
                        break;
                    }
                    default: {
                        Log.d(TAG, event.toString());
                        return false;
                    }
                }
                return this.writeEventsToSock(this.mMouseSock, Arrays.asList(new InputEvent(EV_KEY, keyCode, event.getAction() == 11 ? 1 : 0), new InputEvent(EV_SYN, SYN_REPORT, 0)));
            }
            case 8: {
                short REL_HWHEEL = 6;
                short REL_WHEEL = 8;
                int scrollX = (int)event.getAxisValue(10);
                int scrollY = (int)event.getAxisValue(9);
                boolean status = true;
                if (scrollX != 0) {
                    status &= this.writeEventsToSock(this.mMouseSock, Arrays.asList(new InputEvent(EV_REL, REL_HWHEEL, scrollX), new InputEvent(EV_SYN, SYN_REPORT, 0)));
                } else if (scrollY != 0) {
                    status &= this.writeEventsToSock(this.mMouseSock, Arrays.asList(new InputEvent(EV_REL, REL_WHEEL, scrollY), new InputEvent(EV_SYN, SYN_REPORT, 0)));
                } else {
                    Log.d(TAG, event.toString());
                    return false;
                }
                return status;
            }
            case 0: 
            case 1: {
                return true;
            }
        }
        Log.d(TAG, event.toString());
        return false;
    }

    public boolean sendMultiTouchEvent(MotionEvent event) {
        try {
            this.mInputEventQueue.add(Pair.create(InputEventType.TOUCH, MotionEvent.obtainNoHistory(event)));
            return true;
        }
        catch (Exception e) {
            Log.e(TAG, ((Object)e).toString());
            return false;
        }
    }

    private boolean sendMultiTouchEventInternal(MotionEvent event) {
        if (this.mTouchSock == null) {
            Log.d(TAG, "mTouchSock == null");
            return false;
        }
        short EV_SYN = 0;
        short EV_ABS = 3;
        short EV_KEY = 1;
        short BTN_TOUCH = 330;
        short ABS_X = 0;
        short ABS_Y = 1;
        short SYN_REPORT = 0;
        short ABS_MT_SLOT = 47;
        short ABS_MT_POSITION_X = 53;
        short ABS_MT_POSITION_Y = 54;
        short ABS_MT_TRACKING_ID = 57;
        switch (event.getActionMasked()) {
            case 2: {
                ArrayList<InputEvent> events = new ArrayList<InputEvent>(event.getPointerCount() * 6 + 1);
                for (int actionIdx = 0; actionIdx < event.getPointerCount(); ++actionIdx) {
                    int pointerId = event.getPointerId(actionIdx);
                    int x = (int)event.getRawX(actionIdx);
                    int y = (int)event.getRawY(actionIdx);
                    events.add(new InputEvent(EV_ABS, ABS_MT_SLOT, pointerId));
                    events.add(new InputEvent(EV_ABS, ABS_MT_TRACKING_ID, pointerId));
                    events.add(new InputEvent(EV_ABS, ABS_MT_POSITION_X, x));
                    events.add(new InputEvent(EV_ABS, ABS_MT_POSITION_Y, y));
                    events.add(new InputEvent(EV_ABS, ABS_X, x));
                    events.add(new InputEvent(EV_ABS, ABS_Y, y));
                }
                events.add(new InputEvent(EV_SYN, SYN_REPORT, 0));
                return this.writeEventsToSock(this.mTouchSock, events);
            }
            case 0: 
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                return false;
            }
        }
        boolean down = event.getActionMasked() == 0 || event.getActionMasked() == 5;
        int actionIdx = event.getActionIndex();
        int pointerId = event.getPointerId(actionIdx);
        int x = (int)event.getRawX(actionIdx);
        int y = (int)event.getRawY(actionIdx);
        return this.writeEventsToSock(this.mTouchSock, Arrays.asList(new InputEvent(EV_KEY, BTN_TOUCH, down ? 1 : 0), new InputEvent(EV_ABS, ABS_MT_SLOT, pointerId), new InputEvent(EV_ABS, ABS_MT_TRACKING_ID, down ? pointerId : -1), new InputEvent(EV_ABS, ABS_MT_POSITION_X, x), new InputEvent(EV_ABS, ABS_MT_POSITION_Y, y), new InputEvent(EV_ABS, ABS_X, x), new InputEvent(EV_ABS, ABS_Y, y), new InputEvent(EV_SYN, SYN_REPORT, 0)));
    }

    public boolean sendLidEvent(boolean close) {
        if (this.mSwitchesSock == null) {
            Log.d(TAG, "mSwitcheSock == null");
            return false;
        }
        short EV_SYN = 0;
        short EV_SW = 5;
        short SW_LID = 0;
        short SYN_REPORT = 0;
        return this.writeEventsToSock(this.mSwitchesSock, Arrays.asList(new InputEvent(EV_SW, SW_LID, close ? 1 : 0), new InputEvent(EV_SYN, SYN_REPORT, 0)));
    }

    public boolean sendTabletModeEvent(boolean tabletMode) {
        if (this.mSwitchesSock == null) {
            Log.d(TAG, "mSwitcheSock == null");
            return false;
        }
        short EV_SYN = 0;
        short EV_SW = 5;
        short SW_TABLET_MODE = 1;
        short SYN_REPORT = 0;
        return this.writeEventsToSock(this.mSwitchesSock, Arrays.asList(new InputEvent(EV_SW, SW_TABLET_MODE, tabletMode ? 1 : 0), new InputEvent(EV_SYN, SYN_REPORT, 0)));
    }

    public boolean sendTrackpadEvent(MotionEvent event) {
        try {
            this.mInputEventQueue.add(Pair.create(InputEventType.TRACKPAD, MotionEvent.obtainNoHistory(event)));
            return true;
        }
        catch (Exception e) {
            Log.e(TAG, ((Object)e).toString());
            return false;
        }
    }

    private boolean sendTrackpadEventInternal(MotionEvent event) {
        if (this.mTrackpadSock == null) {
            Log.d(TAG, "mTrackpadSock == null");
            return false;
        }
        short EV_SYN = 0;
        short EV_ABS = 3;
        short EV_KEY = 1;
        short BTN_TOUCH = 330;
        short BTN_TOOL_FINGER = 325;
        short BTN_TOOL_DOUBLETAP = 333;
        short BTN_TOOL_TRIPLETAP = 334;
        short BTN_TOOL_QUADTAP = 335;
        short ABS_X = 0;
        short ABS_Y = 1;
        short SYN_REPORT = 0;
        short ABS_MT_SLOT = 47;
        short ABS_MT_TOUCH_MAJOR = 48;
        short ABS_MT_TOUCH_MINOR = 49;
        int ABS_MT_WIDTH_MAJOR = 50;
        int ABS_MT_WIDTH_MINOR = 51;
        int ABS_MT_ORIENTATION = 52;
        short ABS_MT_POSITION_X = 53;
        short ABS_MT_POSITION_Y = 54;
        short ABS_MT_TOOL_TYPE = 55;
        int ABS_MT_BLOB_ID = 56;
        short ABS_MT_TRACKING_ID = 57;
        short ABS_MT_PRESSURE = 58;
        int ABS_MT_DISTANCE = 59;
        int ABS_MT_TOOL_X = 60;
        int ABS_MT_TOOL_Y = 61;
        short ABS_PRESSURE = 24;
        int ABS_TOOL_WIDTH = 28;
        switch (event.getActionMasked()) {
            case 11: 
            case 12: {
                short keyCode;
                short BTN_LEFT = 272;
                switch (event.getActionButton()) {
                    case 1: {
                        keyCode = BTN_LEFT;
                        break;
                    }
                    default: {
                        Log.d(TAG, event.toString());
                        return false;
                    }
                }
                return this.writeEventsToSock(this.mMouseSock, Arrays.asList(new InputEvent(EV_KEY, keyCode, event.getAction() == 11 ? 1 : 0), new InputEvent(EV_SYN, SYN_REPORT, 0)));
            }
            case 2: {
                ArrayList<InputEvent> events = new ArrayList<InputEvent>(event.getPointerCount() * 10 + 1);
                for (int actionIdx = 0; actionIdx < event.getPointerCount(); ++actionIdx) {
                    int pointerId = event.getPointerId(actionIdx);
                    int x = (int)event.getRawX(actionIdx);
                    int y = (int)event.getRawY(actionIdx);
                    events.add(new InputEvent(EV_ABS, ABS_MT_SLOT, pointerId));
                    events.add(new InputEvent(EV_ABS, ABS_MT_TRACKING_ID, pointerId));
                    events.add(new InputEvent(EV_ABS, ABS_MT_POSITION_X, x));
                    events.add(new InputEvent(EV_ABS, ABS_MT_POSITION_Y, y));
                    events.add(new InputEvent(EV_ABS, ABS_MT_TOUCH_MAJOR, (short)event.getTouchMajor(actionIdx)));
                    events.add(new InputEvent(EV_ABS, ABS_MT_TOUCH_MINOR, (short)event.getTouchMinor(actionIdx)));
                    events.add(new InputEvent(EV_ABS, ABS_X, x));
                    events.add(new InputEvent(EV_ABS, ABS_Y, y));
                    events.add(new InputEvent(EV_ABS, ABS_PRESSURE, (short)(255.0f * event.getPressure(actionIdx))));
                    events.add(new InputEvent(EV_ABS, ABS_MT_PRESSURE, (short)(255.0f * event.getPressure(actionIdx))));
                }
                events.add(new InputEvent(EV_SYN, SYN_REPORT, 0));
                return this.writeEventsToSock(this.mTrackpadSock, events);
            }
            case 0: 
            case 1: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                return false;
            }
        }
        boolean down = event.getActionMasked() == 0 || event.getActionMasked() == 5;
        int actionIdx = event.getActionIndex();
        int pointerId = event.getPointerId(actionIdx);
        int x = (int)event.getRawX(actionIdx);
        int y = (int)event.getRawY(actionIdx);
        return this.writeEventsToSock(this.mTrackpadSock, Arrays.asList(new InputEvent(EV_KEY, BTN_TOUCH, down ? 1 : 0), new InputEvent(EV_KEY, BTN_TOOL_FINGER, down && event.getPointerCount() == 1 ? 1 : 0), new InputEvent(EV_KEY, BTN_TOOL_DOUBLETAP, event.getPointerCount() == 2 ? 1 : 0), new InputEvent(EV_KEY, BTN_TOOL_TRIPLETAP, event.getPointerCount() == 3 ? 1 : 0), new InputEvent(EV_KEY, BTN_TOOL_QUADTAP, event.getPointerCount() > 4 ? 1 : 0), new InputEvent(EV_ABS, ABS_MT_SLOT, pointerId), new InputEvent(EV_ABS, ABS_MT_TRACKING_ID, down ? pointerId : -1), new InputEvent(EV_ABS, ABS_MT_TOOL_TYPE, 0), new InputEvent(EV_ABS, ABS_MT_POSITION_X, x), new InputEvent(EV_ABS, ABS_MT_POSITION_Y, y), new InputEvent(EV_ABS, ABS_MT_TOUCH_MAJOR, (short)event.getTouchMajor(actionIdx)), new InputEvent(EV_ABS, ABS_MT_TOUCH_MINOR, (short)event.getTouchMinor(actionIdx)), new InputEvent(EV_ABS, ABS_X, x), new InputEvent(EV_ABS, ABS_Y, y), new InputEvent(EV_ABS, ABS_PRESSURE, (short)(255.0f * event.getPressure(actionIdx))), new InputEvent(EV_ABS, ABS_MT_PRESSURE, (short)(255.0f * event.getPressure(actionIdx))), new InputEvent(EV_SYN, SYN_REPORT, 0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getActualMemoryBalloonBytes() {
        long bytes = 0L;
        if (this.mMemoryManagementCallbacks != null) {
            Log.d(TAG, "Auto balloon enabled in getActualMemoryBalloonBytes");
            return bytes;
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.mVirtualMachine != null) {
                    bytes = this.mVirtualMachine.getActualMemoryBalloonBytes();
                }
            }
            catch (RemoteException e) {
                Log.w(TAG, "Cannot getActualMemoryBalloonBytes", e);
            }
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemoryBalloon(long bytes) {
        if (this.mMemoryManagementCallbacks != null) {
            Log.d(TAG, "Auto balloon enabled in setMemoryBalloon");
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.mVirtualMachine != null) {
                    this.mVirtualMachine.setMemoryBalloon(bytes);
                }
            }
            catch (RemoteException e) {
                Log.w(TAG, "Cannot setMemoryBalloon", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMemoryBalloonByPercent(int percent) {
        if (percent < 0 || percent > 100) {
            Log.e(TAG, String.format("Invalid percent value: %d", percent));
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                if (this.mVirtualMachine != null && this.mVirtualMachine.isMemoryBalloonEnabled()) {
                    long bytes = this.mConfig.getMemoryBytes();
                    this.mVirtualMachine.setMemoryBalloon(bytes * (long)percent / 100L);
                }
            }
            catch (RemoteException | ServiceSpecificException e) {
                Log.w(TAG, "Cannot setMemoryBalloon", e);
            }
        }
    }

    private boolean writeEventsToSock(ParcelFileDescriptor sock, List<InputEvent> evtList) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8 * evtList.size());
        byteBuffer.clear();
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        for (InputEvent e : evtList) {
            byteBuffer.putShort(e.type);
            byteBuffer.putShort(e.code);
            byteBuffer.putInt(e.value);
        }
        try {
            IoBridge.write(sock.getFileDescriptor(), byteBuffer.array(), 0, byteBuffer.array().length);
        }
        catch (IOException e) {
            Log.d(TAG, "cannot send event", e);
            return false;
        }
        return true;
    }

    private android.system.virtualizationservice.VirtualMachineConfig createVirtualMachineConfigForAppFrom(VirtualMachineConfig vmConfig, IVirtualizationService service) throws RemoteException, IOException, VirtualMachineException {
        VirtualMachineAppConfig appConfig = vmConfig.toVsConfig(this.mContext.getPackageManager());
        appConfig.instanceImage = ParcelFileDescriptor.open(this.mInstanceFilePath, 0x30000000);
        appConfig.name = this.mName;
        appConfig.instanceId = this.mInstanceIdPath != null ? Files.readAllBytes(this.mInstanceIdPath.toPath()) : new byte[64];
        if (this.mEncryptedStoreFilePath != null) {
            appConfig.encryptedStorageImage = ParcelFileDescriptor.open(this.mEncryptedStoreFilePath, 0x30000000);
        }
        if (!vmConfig.getExtraApks().isEmpty()) {
            ArrayList<ParcelFileDescriptor> extraApkFiles = new ArrayList<ParcelFileDescriptor>(this.mExtraApks.size());
            for (ExtraApkSpec extraApk : this.mExtraApks) {
                try {
                    extraApkFiles.add(ParcelFileDescriptor.open(extraApk.apk, 0x10000000));
                }
                catch (FileNotFoundException e) {
                    throw new VirtualMachineException("Failed to open extra APK", e);
                }
            }
            appConfig.payload.getPayloadConfig().extraApks = extraApkFiles;
        }
        appConfig.encryptedStoreKEK = this.mEncryptedStoreKEK;
        try {
            this.createIdSigsAndUpdateConfig(service, appConfig);
        }
        catch (FileNotFoundException e) {
            throw new VirtualMachineException("Failed to generate APK signature", e);
        }
        return android.system.virtualizationservice.VirtualMachineConfig.appConfig(appConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @RequiresPermission(value="android.permission.MANAGE_VIRTUAL_MACHINE")
    public void run() throws VirtualMachineException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkStopped();
            try {
                this.mIdsigFilePath.createNewFile();
                for (ExtraApkSpec extraApk : this.mExtraApks) {
                    extraApk.idsig.createNewFile();
                }
            }
            catch (IOException e) {
                throw new VirtualMachineException("Failed to create APK signature file", e);
            }
            IVirtualizationService service = this.mVirtualizationService.getBinder();
            try {
                android.system.virtualizationservice.VirtualMachineConfig vmConfigParcel;
                if (this.mConnectVmConsole) {
                    this.createPtyConsole();
                }
                if (this.mVmOutputCaptured) {
                    this.createVmOutputPipes();
                }
                if (this.mVmConsoleInputSupported) {
                    this.createVmInputPipes();
                }
                ParcelFileDescriptor consoleOutFd = null;
                if (this.mConnectVmConsole && this.mVmOutputCaptured) {
                    ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createPipe();
                    this.mTeeConsoleOutReader = pipe[0];
                    consoleOutFd = this.mTeeConsoleOutWriter = pipe[1];
                    TeeWorker tee = new TeeWorker(this.mName + " console", new FileInputStream(this.mTeeConsoleOutReader.getFileDescriptor()), List.of(new FileOutputStream(this.mPtyFd.getFileDescriptor()), new FileOutputStream(this.mConsoleOutWriter.getFileDescriptor())));
                    this.mConsoleExecutor.execute(tee);
                } else if (this.mConnectVmConsole) {
                    consoleOutFd = this.mPtyFd;
                } else if (this.mVmOutputCaptured) {
                    consoleOutFd = this.mConsoleOutWriter;
                }
                this.mInputEventExecutor = Executors.newSingleThreadExecutor();
                this.mInputEventExecutor.execute(() -> {
                    while (true) {
                        try {
                            while (true) {
                                Pair<InputEventType, MotionEvent> event = this.mInputEventQueue.take();
                                switch (((InputEventType)((Object)((Object)event.first))).ordinal()) {
                                    case 0: {
                                        this.sendMultiTouchEventInternal((MotionEvent)event.second);
                                        break;
                                    }
                                    case 2: {
                                        this.sendTrackpadEventInternal((MotionEvent)event.second);
                                        break;
                                    }
                                    case 1: {
                                        this.sendMouseEventInternal((MotionEvent)event.second);
                                    }
                                }
                                ((MotionEvent)event.second).recycle();
                            }
                        }
                        catch (Exception e) {
                            Log.e(TAG, ((Object)e).toString());
                            continue;
                        }
                        break;
                    }
                });
                ParcelFileDescriptor consoleInFd = null;
                if (this.mConnectVmConsole) {
                    consoleInFd = this.mPtyFd;
                } else if (this.mVmConsoleInputSupported) {
                    consoleInFd = this.mConsoleInReader;
                }
                VirtualMachineConfig vmConfig = this.getConfig();
                android.system.virtualizationservice.VirtualMachineConfig virtualMachineConfig = vmConfigParcel = vmConfig.getCustomImageConfig() != null ? this.createVirtualMachineConfigForRawFrom(vmConfig) : this.createVirtualMachineConfigForAppFrom(vmConfig, service);
                if (vmConfig.isEncryptedStorageEnabled()) {
                    service.setEncryptedStorageSize(ParcelFileDescriptor.open(this.mEncryptedStoreFilePath, 0x30000000), vmConfig.getEncryptedStorageBytes());
                }
                this.mVirtualMachine = service.createVm(vmConfigParcel, consoleOutFd, consoleInFd, this.mLogWriter, null);
                this.mVirtualMachine.registerCallback(new CallbackTranslator(this, service));
                if (this.mMemoryManagementCallbacks != null) {
                    this.mContext.registerComponentCallbacks(this.mMemoryManagementCallbacks);
                }
                if (this.mConnectVmConsole) {
                    this.mVirtualMachine.setHostConsoleName(this.getHostConsoleName());
                }
                this.mVirtualMachine.start();
            }
            catch (IOException e) {
                throw new VirtualMachineException("failed to persist files", e);
            }
            catch (ServiceSpecificException | IllegalStateException e) {
                throw new VirtualMachineException(e);
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    private void createIdSigsAndUpdateConfig(IVirtualizationService service, VirtualMachineAppConfig appConfig) throws RemoteException, FileNotFoundException {
        service.createOrUpdateIdsigFile(appConfig.apk, ParcelFileDescriptor.open(this.mIdsigFilePath, 0x30000000));
        for (ExtraApkSpec extraApk : this.mExtraApks) {
            service.createOrUpdateIdsigFile(ParcelFileDescriptor.open(extraApk.apk, 0x10000000), ParcelFileDescriptor.open(extraApk.idsig, 0x30000000));
        }
        appConfig.idsig = ParcelFileDescriptor.open(this.mIdsigFilePath, 0x10000000);
        ArrayList<ParcelFileDescriptor> extraIdsigs = new ArrayList<ParcelFileDescriptor>();
        for (ExtraApkSpec extraApk : this.mExtraApks) {
            extraIdsigs.add(ParcelFileDescriptor.open(extraApk.idsig, 0x10000000));
        }
        appConfig.extraIdsigs = extraIdsigs;
    }

    @GuardedBy(value={"mLock"})
    private void createVmOutputPipes() throws VirtualMachineException {
        try {
            ParcelFileDescriptor[] pipe;
            if (this.mConsoleOutReader == null || this.mConsoleOutWriter == null) {
                pipe = ParcelFileDescriptor.createPipe();
                this.mConsoleOutReader = pipe[0];
                this.mConsoleOutWriter = pipe[1];
            }
            if (this.mLogReader == null || this.mLogWriter == null) {
                pipe = ParcelFileDescriptor.createPipe();
                this.mLogReader = pipe[0];
                this.mLogWriter = pipe[1];
            }
        }
        catch (IOException e) {
            throw new VirtualMachineException("Failed to create output stream for VM", e);
        }
    }

    @GuardedBy(value={"mLock"})
    private void createVmInputPipes() throws VirtualMachineException {
        try {
            if (this.mConsoleInReader == null || this.mConsoleInWriter == null) {
                if (this.mConnectVmConsole) {
                    this.createPtyConsole();
                    this.mConsoleInReader = this.mPtyFd.dup();
                    this.mConsoleInWriter = this.mPtsFd.dup();
                } else {
                    ParcelFileDescriptor[] pipe = ParcelFileDescriptor.createPipe();
                    this.mConsoleInReader = pipe[0];
                    this.mConsoleInWriter = pipe[1];
                }
            }
        }
        catch (IOException e) {
            throw new VirtualMachineException("Failed to create input stream for VM", e);
        }
    }

    private static void nativeOpenPtyRawNonblock(OpenPtyCallback openPtyCallback) throws IOException {
        OverrideMethod.invokeV("android.system.virtualmachine.VirtualMachine#nativeOpenPtyRawNonblock(Landroid/system/virtualmachine/VirtualMachine$OpenPtyCallback;)V", true, null);
    }

    @GuardedBy(value={"mLock"})
    private void createPtyConsole() throws VirtualMachineException {
        if (this.mPtyFd != null && this.mPtsFd != null) {
            return;
        }
        ArrayList fd = new ArrayList(2);
        StringBuilder nameBuilder = new StringBuilder();
        try {
            try {
                VirtualMachine.nativeOpenPtyRawNonblock((mfd, sfd, ptsName) -> {
                    fd.add(mfd);
                    fd.add(sfd);
                    nameBuilder.append(new String(ptsName, StandardCharsets.UTF_8));
                });
            }
            catch (Exception e) {
                fd.forEach(IoUtils::closeQuietly);
                throw e;
            }
        }
        catch (IOException e) {
            throw new VirtualMachineException("Failed to create host console to connect to the VM console", e);
        }
        this.mPtyFd = new ParcelFileDescriptor((FileDescriptor)fd.get(0));
        this.mPtsFd = new ParcelFileDescriptor((FileDescriptor)fd.get(1));
        this.mPtsName = nameBuilder.toString();
        Log.d(TAG, "Serial console device: " + this.mPtsName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    private String getHostConsoleName() throws VirtualMachineException {
        if (!this.mConnectVmConsole) {
            throw new VirtualMachineException("Host console is not enabled");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.createPtyConsole();
            return this.mPtsName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @NonNull
    public InputStream getConsoleOutput() throws VirtualMachineException {
        if (!this.mVmOutputCaptured) {
            throw new VirtualMachineException("Capturing vm outputs is turned off");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.createVmOutputPipes();
            return new FileInputStream(this.mConsoleOutReader.getFileDescriptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public OutputStream getConsoleInput() throws VirtualMachineException {
        if (!this.mVmConsoleInputSupported) {
            throw new VirtualMachineException("VM console input is not supported");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.createVmInputPipes();
            return new FileOutputStream(this.mConsoleInWriter.getFileDescriptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @NonNull
    public InputStream getLogOutput() throws VirtualMachineException {
        if (!this.mVmOutputCaptured) {
            throw new VirtualMachineException("Capturing vm outputs is turned off");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.createVmOutputPipes();
            return new FileInputStream(this.mLogReader.getFileDescriptor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    public void stop() throws VirtualMachineException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVirtualMachine == null) {
                throw new VirtualMachineException("VM is not running");
            }
            try {
                this.mVirtualMachine.stop();
                this.dropVm();
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            catch (ServiceSpecificException e) {
                throw new VirtualMachineException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws VirtualMachineException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVirtualMachine == null) {
                throw new VirtualMachineException("VM is not running");
            }
            try {
                this.mVirtualMachine.suspend();
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            catch (ServiceSpecificException e) {
                throw new VirtualMachineException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws VirtualMachineException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVirtualMachine == null) {
                throw new VirtualMachineException("VM is not running");
            }
            try {
                this.mVirtualMachine.resume();
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            catch (ServiceSpecificException e) {
                throw new VirtualMachineException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @SystemApi
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mVirtualMachine == null) {
                return;
            }
            try {
                if (this.stateToStatus(this.mVirtualMachine.getState()) == 1) {
                    this.mVirtualMachine.stop();
                    this.dropVm();
                }
            }
            catch (RemoteException | ServiceSpecificException e) {
                Log.i(TAG, "Ignoring error on close()", e);
            }
        }
    }

    private static void deleteRecursively(File dir) throws IOException {
        Files.walkFileTree(dir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException e) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SystemApi
    @NonNull
    public VirtualMachineConfig setConfig(@NonNull VirtualMachineConfig newConfig) throws VirtualMachineException {
        Object object = this.mLock;
        synchronized (object) {
            VirtualMachineConfig oldConfig = this.mConfig;
            if (!oldConfig.isCompatibleWith(newConfig) || oldConfig.getEncryptedStorageBytes() > newConfig.getEncryptedStorageBytes()) {
                throw new VirtualMachineException("incompatible config");
            }
            this.checkStopped();
            if (oldConfig != newConfig) {
                this.mConfigFilePath.delete();
                newConfig.serialize(this.mConfigFilePath);
                this.mConfig = newConfig;
            }
            return oldConfig;
        }
    }

    @SystemApi
    @NonNull
    public IBinder connectToVsockServer(final long port) throws VirtualMachineException {
        VsockConnectionProvider provider = new VsockConnectionProvider(){

            @Override
            public ParcelFileDescriptor addConnection() throws VirtualMachineException {
                return VirtualMachine.this.connectVsock(port);
            }
        };
        return VirtualMachine.binderFromPreconnectedClient(provider);
    }

    @Nullable
    private static IBinder nativeBinderFromPreconnectedClient(NativeProviderWrapper nativeProviderWrapper) {
        return (IBinder)OverrideMethod.invokeA("android.system.virtualmachine.VirtualMachine#nativeBinderFromPreconnectedClient(Landroid/system/virtualmachine/VirtualMachine$NativeProviderWrapper;)Landroid/os/IBinder;", true, null);
    }

    @SystemApi
    @SuppressLint(value={"UnflaggedApi"})
    @NonNull
    public static IBinder binderFromPreconnectedClient(@NonNull VsockConnectionProvider provider) throws VirtualMachineException {
        IBinder binder = VirtualMachine.nativeBinderFromPreconnectedClient(new NativeProviderWrapper(provider));
        if (binder == null) {
            throw new VirtualMachineException("Failed to connect to vsock server");
        }
        Binder.allowBlocking(binder);
        return binder;
    }

    @SystemApi
    @NonNull
    public ParcelFileDescriptor connectVsock(long port) throws VirtualMachineException {
        Object object = this.mLock;
        synchronized (object) {
            try {
                return this.getRunningVm().connectVsock(this.validatePort(port));
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
            catch (ServiceSpecificException e) {
                throw new VirtualMachineException(e);
            }
        }
    }

    private int validatePort(long port) {
        if (port < 1024L || port > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Bad port " + port);
        }
        return (int)port;
    }

    @NonNull
    public File getRootDir() {
        return this.mVmRootPath;
    }

    @RequiresPermission(value="android.permission.USE_CUSTOM_VIRTUAL_MACHINE")
    public void enableTestAttestation() throws VirtualMachineException {
        try {
            this.mVirtualizationService.getBinder().enableTestAttestation();
        }
        catch (RemoteException e) {
            throw e.rethrowAsRuntimeException();
        }
    }

    @SystemApi
    @NonNull
    public VirtualMachineDescriptor toDescriptor() throws VirtualMachineException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkStopped();
            try {
                return new VirtualMachineDescriptor(ParcelFileDescriptor.open(this.mConfigFilePath, 0x10000000), this.mInstanceIdPath != null ? ParcelFileDescriptor.open(this.mInstanceIdPath, 0x10000000) : null, ParcelFileDescriptor.open(this.mInstanceFilePath, 0x10000000), this.mEncryptedStoreFilePath != null ? ParcelFileDescriptor.open(this.mEncryptedStoreFilePath, 0x10000000) : null);
            }
            catch (IOException e) {
                throw new VirtualMachineException(e);
            }
        }
    }

    public String toString() {
        VirtualMachineConfig config = this.getConfig();
        String payloadConfigPath = config.getPayloadConfigPath();
        String payloadBinaryName = config.getPayloadBinaryName();
        StringBuilder result = new StringBuilder();
        result.append("VirtualMachine(").append("name:").append(this.getName()).append(", ");
        if (payloadBinaryName != null) {
            result.append("payload:").append(payloadBinaryName).append(", ");
        }
        if (payloadConfigPath != null) {
            result.append("config:").append(payloadConfigPath).append(", ");
        }
        result.append("package: ").append(this.mPackageName).append(")");
        return result.toString();
    }

    private static List<ExtraApkSpec> setupExtraApks(@NonNull Context context, @NonNull VirtualMachineConfig config, @NonNull File vmDir) throws VirtualMachineException {
        String configPath = config.getPayloadConfigPath();
        List<String> extraApks = config.getExtraApks();
        if (configPath != null) {
            return VirtualMachine.setupExtraApksFromConfigFile(context, vmDir, configPath);
        }
        if (!extraApks.isEmpty()) {
            return VirtualMachine.setupExtraApksFromList(context, vmDir, extraApks);
        }
        return Collections.emptyList();
    }

    private static List<ExtraApkSpec> setupExtraApksFromConfigFile(Context context, File vmDir, String configPath) throws VirtualMachineException {
        ArrayList<ExtraApkSpec> arrayList;
        ZipFile zipFile = new ZipFile(context.getPackageCodePath());
        try {
            InputStream inputStream = zipFile.getInputStream(zipFile.getEntry(configPath));
            List<String> apkList = VirtualMachine.parseExtraApkListFromPayloadConfig(new JsonReader(new InputStreamReader(inputStream)));
            ArrayList<ExtraApkSpec> extraApks = new ArrayList<ExtraApkSpec>(apkList.size());
            for (int i = 0; i < apkList.size(); ++i) {
                extraApks.add(new ExtraApkSpec(new File(apkList.get(i)), new File(vmDir, EXTRA_IDSIG_FILE_PREFIX + i)));
            }
            arrayList = extraApks;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new VirtualMachineException("Couldn't parse extra apks from the vm config", e);
            }
        }
        zipFile.close();
        return arrayList;
    }

    private static List<String> parseExtraApkListFromPayloadConfig(JsonReader reader) throws VirtualMachineException {
        try {
            ArrayList<String> apks = new ArrayList<String>();
            reader.beginObject();
            while (reader.hasNext()) {
                if (reader.nextName().equals("extra_apks")) {
                    reader.beginArray();
                    while (reader.hasNext()) {
                        reader.beginObject();
                        String name = reader.nextName();
                        if (name.equals("path")) {
                            apks.add(reader.nextString());
                        } else {
                            reader.skipValue();
                        }
                        reader.endObject();
                    }
                    reader.endArray();
                    continue;
                }
                reader.skipValue();
            }
            reader.endObject();
            return apks;
        }
        catch (IOException e) {
            throw new VirtualMachineException(e);
        }
    }

    private static List<ExtraApkSpec> setupExtraApksFromList(Context context, File vmDir, List<String> extraApkInfo) throws VirtualMachineException {
        int count = extraApkInfo.size();
        ArrayList<ExtraApkSpec> extraApks = new ArrayList<ExtraApkSpec>(count);
        for (int i = 0; i < count; ++i) {
            ApplicationInfo appInfo;
            String packageName = extraApkInfo.get(i);
            try {
                appInfo = context.getPackageManager().getApplicationInfo(packageName, PackageManager.ApplicationInfoFlags.of(0L));
            }
            catch (PackageManager.NameNotFoundException e) {
                throw new VirtualMachineException("Extra APK package not found", e);
            }
            extraApks.add(new ExtraApkSpec(new File(appInfo.sourceDir), new File(vmDir, EXTRA_IDSIG_FILE_PREFIX + i)));
        }
        return extraApks;
    }

    private void importInstanceIdFrom(@NonNull ParcelFileDescriptor instanceIdFd) throws VirtualMachineException {
        try (FileChannel idOutput = new FileOutputStream(this.mInstanceIdPath).getChannel();
             FileChannel idInput = new ParcelFileDescriptor.AutoCloseInputStream(instanceIdFd).getChannel();){
            idOutput.transferFrom(idInput, 0L, idInput.size());
        }
        catch (IOException e) {
            throw new VirtualMachineException("failed to copy instance_id", e);
        }
    }

    private void importInstanceFrom(@NonNull ParcelFileDescriptor instanceFd) throws VirtualMachineException {
        try (FileChannel instance = new FileOutputStream(this.mInstanceFilePath).getChannel();
             FileChannel instanceInput = new ParcelFileDescriptor.AutoCloseInputStream(instanceFd).getChannel();){
            instance.transferFrom(instanceInput, 0L, instanceInput.size());
        }
        catch (IOException e) {
            throw new VirtualMachineException("failed to transfer instance image", e);
        }
    }

    private void importEncryptedStoreFrom(@NonNull ParcelFileDescriptor encryptedStoreFd) throws VirtualMachineException {
        try (FileChannel storeOutput = new FileOutputStream(this.mEncryptedStoreFilePath).getChannel();
             FileChannel storeInput = new ParcelFileDescriptor.AutoCloseInputStream(encryptedStoreFd).getChannel();){
            storeOutput.transferFrom(storeInput, 0L, storeInput.size());
        }
        catch (IOException e) {
            throw new VirtualMachineException("failed to transfer encryptedstore image", e);
        }
    }

    static {
        System_Delegate.loadLibrary("virtualmachine_jni");
    }

    private static class EncryptedStoreKEK
    extends IEncryptedStoreKEK.Stub {
        private final File mKEKFile;

        private EncryptedStoreKEK(Context context, String name) {
            File vmDir = VirtualMachine.getVmDir(context.createCredentialProtectedStorageContext(), name);
            this.mKEKFile = new File(vmDir, VirtualMachine.ENCRYPTED_STORE_KEK_FILE);
        }

        @Override
        public byte[] getKEK() {
            if (!this.mKEKFile.exists()) {
                return null;
            }
            try {
                return Files.readAllBytes(this.mKEKFile.toPath());
            }
            catch (IOException e) {
                Log.e(VirtualMachine.TAG, "Failed to read " + this.mKEKFile.getAbsolutePath(), e);
                return null;
            }
        }

        @Override
        public void onKEKCreated(byte[] kekBlob) {
            try {
                this.mKEKFile.getParentFile().mkdirs();
                this.mKEKFile.createNewFile();
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to create " + this.mKEKFile.getAbsolutePath(), e);
            }
            try (FileOutputStream fos = new FileOutputStream(this.mKEKFile.getAbsolutePath());){
                fos.write(kekBlob);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to write to " + this.mKEKFile.getAbsolutePath(), e);
            }
        }
    }

    private class MemoryManagementCallbacks
    implements ComponentCallbacks2 {
        private MemoryManagementCallbacks() {
        }

        @Override
        public void onConfigurationChanged(@NonNull Configuration newConfig) {
        }

        @Override
        public void onLowMemory() {
        }

        @Override
        public void onTrimMemory(int level) {
            int currentLevel = level;
            VirtualMachine.this.mMemoryCallbackExecutor.execute(() -> {
                int percent = 10;
                if (currentLevel >= 20) {
                    percent = 30;
                }
                if (currentLevel >= 40) {
                    percent = 50;
                }
                VirtualMachine.this.setMemoryBalloonByPercent(percent);
                Log.d(VirtualMachine.TAG, "onTrimMemory: Completed setMemoryBalloonByPercent on thread: " + Thread.currentThread().getName());
            });
        }
    }

    private static class InputEvent
    extends Record {
        private final short type;
        private final short code;
        private final int value;

        private InputEvent(short type, short code, int value) {
            this.type = type;
            this.code = code;
            this.value = value;
        }

        @Override
        public String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{InputEvent.class, "type;code;value", "type", "code", "value"}, this);
        }

        @Override
        public int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{InputEvent.class, "type;code;value", "type", "code", "value"}, this);
        }

        @Override
        public boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{InputEvent.class, "type;code;value", "type", "code", "value"}, this, o);
        }

        public short type() {
            return this.type;
        }

        public short code() {
            return this.code;
        }

        public int value() {
            return this.value;
        }
    }

    private static enum InputEventType {
        TOUCH,
        MOUSE,
        TRACKPAD;

    }

    private static class ExtraApkSpec {
        public final File apk;
        public final File idsig;

        ExtraApkSpec(File apk, File idsig) {
            this.apk = apk;
            this.idsig = idsig;
        }
    }

    private static class TeeWorker
    implements Runnable {
        private final String mName;
        private final InputStream mIn;
        private final List<OutputStream> mOuts;

        TeeWorker(String name, InputStream in, Collection<OutputStream> outs) {
            this.mName = name;
            this.mIn = in;
            this.mOuts = new ArrayList<OutputStream>(outs);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            byte[] buffer = new byte[2048];
            try {
                int len;
                while (!Thread.interrupted() && (len = this.mIn.read(buffer)) >= 0) {
                    for (OutputStream out : this.mOuts) {
                        try {
                            out.write(buffer, 0, len);
                        }
                        catch (IOException e) {
                            if (TeeWorker.isErrnoError(e, OsConstants.EAGAIN)) continue;
                            throw e;
                        }
                    }
                    continue;
                    return;
                }
            }
            catch (Exception e) {
                Log.e(VirtualMachine.TAG, "Tee " + this.mName, e);
            }
        }

        private static ErrnoException asErrnoException(Throwable e) {
            if (e instanceof ErrnoException) {
                return (ErrnoException)e;
            }
            if (e instanceof IOException) {
                return TeeWorker.asErrnoException(e.getCause());
            }
            return null;
        }

        private static boolean isErrnoError(Exception e, int expectedValue) {
            ErrnoException errno = TeeWorker.asErrnoException(e);
            return errno != null && errno.errno == expectedValue;
        }
    }

    private static class CallbackTranslator
    extends IVirtualMachineCallback.Stub {
        private final WeakReference<VirtualMachine> mVirtualMachine;
        private final WeakReference<IVirtualizationService> mService;
        private final IBinder.DeathRecipient mDeathRecipient;
        private final AtomicBoolean mOnDiedCalled = new AtomicBoolean(false);

        public CallbackTranslator(VirtualMachine virtualMachine, IVirtualizationService service) throws RemoteException {
            this.mVirtualMachine = new WeakReference<VirtualMachine>(virtualMachine);
            this.mService = new WeakReference<IVirtualizationService>(service);
            this.mDeathRecipient = () -> this.reportStopped(-1);
            service.asBinder().linkToDeath(this.mDeathRecipient, 0);
        }

        @Override
        public void onPayloadStarted(int cid) {
            VirtualMachine vm = (VirtualMachine)this.mVirtualMachine.get();
            if (vm != null) {
                vm.executeCallback(cb -> cb.onPayloadStarted(vm));
            }
        }

        @Override
        public void onPayloadReady(int cid) {
            VirtualMachine vm = (VirtualMachine)this.mVirtualMachine.get();
            if (vm != null) {
                vm.executeCallback(cb -> cb.onPayloadReady(vm));
            }
        }

        @Override
        public void onPayloadFinished(int cid, int exitCode) {
            VirtualMachine vm = (VirtualMachine)this.mVirtualMachine.get();
            if (vm != null) {
                vm.executeCallback(cb -> cb.onPayloadFinished(vm, exitCode));
            }
        }

        @Override
        public void onError(int cid, int errorCode, String message) {
            int translatedError = this.getTranslatedError(errorCode);
            VirtualMachine vm = (VirtualMachine)this.mVirtualMachine.get();
            if (vm != null) {
                vm.executeCallback(cb -> cb.onError(vm, translatedError, message));
            }
        }

        @Override
        public void onDied(int cid, int reason) {
            int translatedReason = this.getTranslatedReason(reason);
            this.reportStopped(translatedReason);
            IVirtualizationService service = (IVirtualizationService)this.mService.get();
            if (service != null) {
                service.asBinder().unlinkToDeath(this.mDeathRecipient, 0);
            }
        }

        private void reportStopped(int reason) {
            VirtualMachine vm;
            if (this.mOnDiedCalled.compareAndSet(false, true) && (vm = (VirtualMachine)this.mVirtualMachine.get()) != null) {
                vm.executeCallback(cb -> cb.onStopped(vm, reason));
            }
        }

        private int getTranslatedError(int reason) {
            switch (reason) {
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
                case 3: {
                    return 3;
                }
            }
            return 0;
        }

        private int getTranslatedReason(int reason) {
            switch (reason) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 3: {
                    return 3;
                }
                case 4: {
                    return 4;
                }
                case 5: {
                    return 5;
                }
                case 6: {
                    return 6;
                }
                case 7: {
                    return 7;
                }
                case 8: {
                    return 8;
                }
                case 11: {
                    return 11;
                }
                case 12: {
                    return 12;
                }
                case 13: {
                    return 13;
                }
                case 14: {
                    return 14;
                }
                case 15: {
                    return 15;
                }
                case 16: {
                    return 16;
                }
            }
            return 2;
        }
    }

    @FunctionalInterface
    private static interface OpenPtyCallback {
        public void apply(FileDescriptor var1, FileDescriptor var2, byte[] var3);
    }

    @SystemApi
    @SuppressLint(value={"UnflaggedApi"})
    public static interface VsockConnectionProvider {
        @NonNull
        @SuppressLint(value={"UnflaggedApi"})
        public ParcelFileDescriptor addConnection() throws VirtualMachineException;
    }

    private static class NativeProviderWrapper {
        private VsockConnectionProvider mProvider = null;
        private ParcelFileDescriptor mMoreLifetime = null;

        public NativeProviderWrapper(VsockConnectionProvider provider) {
            this.mProvider = provider;
        }

        int connect() throws VirtualMachineException {
            this.mMoreLifetime = this.mProvider.addConnection();
            return this.mMoreLifetime.getFileDescriptor().getInt$();
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }
}

