/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Preconditions;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
@SuppressLint(value={"UnflaggedApi"})
public class VisualQueryDetectedResult
implements Parcelable {
    @NonNull
    private final String mPartialQuery;
    private final int mSpeakerId;
    @Nullable
    private final byte[] mAccessibilityDetectionData;
    @SuppressLint(value={"UnflaggedApi"})
    @NonNull
    public static final Parcelable.Creator<VisualQueryDetectedResult> CREATOR = new Parcelable.Creator<VisualQueryDetectedResult>(){

        public VisualQueryDetectedResult[] newArray(int size) {
            return new VisualQueryDetectedResult[size];
        }

        @Override
        public VisualQueryDetectedResult createFromParcel(@NonNull Parcel in) {
            return new VisualQueryDetectedResult(in);
        }
    };

    private static String defaultPartialQuery() {
        return "";
    }

    private static int defaultSpeakerId() {
        return 0;
    }

    @SuppressLint(value={"UnflaggedApi"})
    public static int getMaxSpeakerId() {
        return 15;
    }

    private static byte[] defaultAccessibilityDetectionData() {
        return null;
    }

    private void onConstructed() {
        Preconditions.checkArgumentInRange(this.mSpeakerId, 0, VisualQueryDetectedResult.getMaxSpeakerId(), "speakerId");
    }

    public Builder buildUpon() {
        return new Builder().setPartialQuery(this.mPartialQuery).setSpeakerId(this.mSpeakerId).setAccessibilityDetectionData(this.mAccessibilityDetectionData);
    }

    VisualQueryDetectedResult(@NonNull String partialQuery, int speakerId, @Nullable byte[] accessibilityDetectionData) {
        this.mPartialQuery = partialQuery;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPartialQuery);
        this.mSpeakerId = speakerId;
        this.mAccessibilityDetectionData = accessibilityDetectionData;
        this.onConstructed();
    }

    @SuppressLint(value={"UnflaggedApi"})
    @NonNull
    public String getPartialQuery() {
        return this.mPartialQuery;
    }

    @SuppressLint(value={"UnflaggedApi"})
    public int getSpeakerId() {
        return this.mSpeakerId;
    }

    @SuppressLint(value={"UnflaggedApi"})
    @Nullable
    public byte[] getAccessibilityDetectionData() {
        return this.mAccessibilityDetectionData;
    }

    public String toString() {
        return "VisualQueryDetectedResult { partialQuery = " + this.mPartialQuery + ", speakerId = " + this.mSpeakerId + ", accessibilityDetectionData = " + Arrays.toString(this.mAccessibilityDetectionData) + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VisualQueryDetectedResult that = (VisualQueryDetectedResult)o;
        return Objects.equals(this.mPartialQuery, that.mPartialQuery) && this.mSpeakerId == that.mSpeakerId && Arrays.equals(this.mAccessibilityDetectionData, that.mAccessibilityDetectionData);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mPartialQuery);
        _hash = 31 * _hash + this.mSpeakerId;
        _hash = 31 * _hash + Arrays.hashCode(this.mAccessibilityDetectionData);
        return _hash;
    }

    @Override
    @SuppressLint(value={"UnflaggedApi"})
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mPartialQuery);
        dest.writeInt(this.mSpeakerId);
        dest.writeByteArray(this.mAccessibilityDetectionData);
    }

    @Override
    @SuppressLint(value={"UnflaggedApi"})
    public int describeContents() {
        return 0;
    }

    VisualQueryDetectedResult(@NonNull Parcel in) {
        String partialQuery = in.readString();
        int speakerId = in.readInt();
        byte[] accessibilityDetectionData = in.createByteArray();
        this.mPartialQuery = partialQuery;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mPartialQuery);
        this.mSpeakerId = speakerId;
        this.mAccessibilityDetectionData = accessibilityDetectionData;
        this.onConstructed();
    }

    @Deprecated
    private void __metadata() {
    }

    @SuppressLint(value={"UnflaggedApi"})
    public static class Builder {
        @NonNull
        private String mPartialQuery;
        private int mSpeakerId;
        @Nullable
        private byte[] mAccessibilityDetectionData;
        private long mBuilderFieldsSet = 0L;

        @SuppressLint(value={"UnflaggedApi"})
        public Builder() {
        }

        @SuppressLint(value={"UnflaggedApi"})
        @NonNull
        public Builder setPartialQuery(@NonNull String value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mPartialQuery = value;
            return this;
        }

        @SuppressLint(value={"UnflaggedApi"})
        @NonNull
        public Builder setSpeakerId(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mSpeakerId = value;
            return this;
        }

        @SuppressLint(value={"UnflaggedApi"})
        @NonNull
        public Builder setAccessibilityDetectionData(byte ... value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mAccessibilityDetectionData = value;
            return this;
        }

        @SuppressLint(value={"UnflaggedApi"})
        @NonNull
        public VisualQueryDetectedResult build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            if ((this.mBuilderFieldsSet & 1L) == 0L) {
                this.mPartialQuery = VisualQueryDetectedResult.defaultPartialQuery();
            }
            if ((this.mBuilderFieldsSet & 2L) == 0L) {
                this.mSpeakerId = VisualQueryDetectedResult.defaultSpeakerId();
            }
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mAccessibilityDetectionData = VisualQueryDetectedResult.defaultAccessibilityDetectionData();
            }
            VisualQueryDetectedResult o = new VisualQueryDetectedResult(this.mPartialQuery, this.mSpeakerId, this.mAccessibilityDetectionData);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 8L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

