/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.media.AudioFormat;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.service.voice.HotwordDetectedResult;
import android.service.voice.HotwordDetectionServiceFailure;
import android.service.voice.HotwordRejectedResult;

public interface IMicrophoneHotwordDetectionVoiceInteractionCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.service.voice.IMicrophoneHotwordDetectionVoiceInteractionCallback";

    public void onDetected(HotwordDetectedResult var1, AudioFormat var2, ParcelFileDescriptor var3) throws RemoteException;

    public void onHotwordDetectionServiceFailure(HotwordDetectionServiceFailure var1) throws RemoteException;

    public void onRejected(HotwordRejectedResult var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IMicrophoneHotwordDetectionVoiceInteractionCallback {
        static final int TRANSACTION_onDetected = 1;
        static final int TRANSACTION_onHotwordDetectionServiceFailure = 2;
        static final int TRANSACTION_onRejected = 3;

        public Stub() {
            this.attachInterface(this, IMicrophoneHotwordDetectionVoiceInteractionCallback.DESCRIPTOR);
        }

        public static IMicrophoneHotwordDetectionVoiceInteractionCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IMicrophoneHotwordDetectionVoiceInteractionCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IMicrophoneHotwordDetectionVoiceInteractionCallback) {
                return (IMicrophoneHotwordDetectionVoiceInteractionCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onDetected";
                }
                case 2: {
                    return "onHotwordDetectionServiceFailure";
                }
                case 3: {
                    return "onRejected";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IMicrophoneHotwordDetectionVoiceInteractionCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    HotwordDetectedResult _arg0 = data.readTypedObject(HotwordDetectedResult.CREATOR);
                    AudioFormat _arg1 = data.readTypedObject(AudioFormat.CREATOR);
                    ParcelFileDescriptor _arg2 = data.readTypedObject(ParcelFileDescriptor.CREATOR);
                    data.enforceNoDataAvail();
                    this.onDetected(_arg0, _arg1, _arg2);
                    break;
                }
                case 2: {
                    HotwordDetectionServiceFailure _arg0 = data.readTypedObject(HotwordDetectionServiceFailure.CREATOR);
                    data.enforceNoDataAvail();
                    this.onHotwordDetectionServiceFailure(_arg0);
                    break;
                }
                case 3: {
                    HotwordRejectedResult _arg0 = data.readTypedObject(HotwordRejectedResult.CREATOR);
                    data.enforceNoDataAvail();
                    this.onRejected(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IMicrophoneHotwordDetectionVoiceInteractionCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IMicrophoneHotwordDetectionVoiceInteractionCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDetected(HotwordDetectedResult hotwordDetectedResult, AudioFormat audioFormat, ParcelFileDescriptor audioStream) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMicrophoneHotwordDetectionVoiceInteractionCallback.DESCRIPTOR);
                    _data.writeTypedObject(hotwordDetectedResult, 0);
                    _data.writeTypedObject(audioFormat, 0);
                    _data.writeTypedObject(audioStream, 0);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onHotwordDetectionServiceFailure(HotwordDetectionServiceFailure hotwordDetectionServiceFailure) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMicrophoneHotwordDetectionVoiceInteractionCallback.DESCRIPTOR);
                    _data.writeTypedObject(hotwordDetectionServiceFailure, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRejected(HotwordRejectedResult hotwordRejectedResult) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IMicrophoneHotwordDetectionVoiceInteractionCallback.DESCRIPTOR);
                    _data.writeTypedObject(hotwordRejectedResult, 0);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IMicrophoneHotwordDetectionVoiceInteractionCallback {
        @Override
        public void onDetected(HotwordDetectedResult hotwordDetectedResult, AudioFormat audioFormat, ParcelFileDescriptor audioStream) throws RemoteException {
        }

        @Override
        public void onHotwordDetectionServiceFailure(HotwordDetectionServiceFailure hotwordDetectionServiceFailure) throws RemoteException {
        }

        @Override
        public void onRejected(HotwordRejectedResult hotwordRejectedResult) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

