/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

@SystemApi
public class HotwordDetectionServiceFailure
implements Parcelable {
    public static final int ERROR_CODE_UNKNOWN = 0;
    public static final int ERROR_CODE_BIND_FAILURE = 1;
    public static final int ERROR_CODE_BINDING_DIED = 2;
    public static final int ERROR_CODE_COPY_AUDIO_DATA_FAILURE = 3;
    public static final int ERROR_CODE_DETECT_TIMEOUT = 4;
    public static final int ERROR_CODE_ON_DETECTED_SECURITY_EXCEPTION = 5;
    public static final int ERROR_CODE_ON_DETECTED_STREAM_COPY_FAILURE = 6;
    public static final int ERROR_CODE_REMOTE_EXCEPTION = 7;
    @FlaggedApi(value="android.service.voice.flags.allow_training_data_egress_from_hds")
    public static final int ERROR_CODE_SHUTDOWN_HDS_ON_VOICE_ACTIVATION_OP_DISABLED = 10;
    private int mErrorCode = 0;
    private String mErrorMessage = "Unknown";
    @NonNull
    public static final Parcelable.Creator<HotwordDetectionServiceFailure> CREATOR = new Parcelable.Creator<HotwordDetectionServiceFailure>(){

        public HotwordDetectionServiceFailure[] newArray(int size) {
            return new HotwordDetectionServiceFailure[size];
        }

        @Override
        public HotwordDetectionServiceFailure createFromParcel(@NonNull Parcel in) {
            return new HotwordDetectionServiceFailure(in.readInt(), in.readString8());
        }
    };

    public HotwordDetectionServiceFailure(int errorCode, @NonNull String errorMessage) {
        if (TextUtils.isEmpty(errorMessage)) {
            throw new IllegalArgumentException("errorMessage is empty or null.");
        }
        this.mErrorCode = errorCode;
        this.mErrorMessage = errorMessage;
    }

    public int getErrorCode() {
        return this.mErrorCode;
    }

    @NonNull
    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public int getSuggestedAction() {
        switch (this.mErrorCode) {
            case 1: 
            case 2: 
            case 7: {
                return 3;
            }
            case 4: 
            case 5: 
            case 6: {
                return 4;
            }
        }
        return 1;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mErrorCode);
        dest.writeString8(this.mErrorMessage);
    }

    public String toString() {
        return "HotwordDetectionServiceFailure { errorCode = " + this.mErrorCode + ", errorMessage = " + this.mErrorMessage + " }";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface HotwordDetectionServiceErrorCode {
    }
}

