/*
 * Decompiled with CFR 0.152.
 */
package android.service.voice;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.media.AudioFormat;
import android.media.AudioTimestamp;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.PersistableBundle;
import com.android.internal.util.AnnotationValidations;
import java.util.Arrays;
import java.util.Objects;

@SystemApi
public class HotwordAudioStream
implements Parcelable {
    public static final String KEY_AUDIO_STREAM_COPY_BUFFER_LENGTH_BYTES = "android.service.voice.key.AUDIO_STREAM_COPY_BUFFER_LENGTH_BYTES";
    @NonNull
    private final AudioFormat mAudioFormat;
    @NonNull
    private final ParcelFileDescriptor mAudioStreamParcelFileDescriptor;
    @Nullable
    private final AudioTimestamp mTimestamp;
    @NonNull
    private final PersistableBundle mMetadata;
    @NonNull
    private final byte[] mInitialAudio;
    private static final byte[] DEFAULT_INITIAL_EMPTY_AUDIO = new byte[0];
    @NonNull
    public static final Parcelable.Creator<HotwordAudioStream> CREATOR = new Parcelable.Creator<HotwordAudioStream>(){

        public HotwordAudioStream[] newArray(int size) {
            return new HotwordAudioStream[size];
        }

        @Override
        public HotwordAudioStream createFromParcel(@NonNull Parcel in) {
            return new HotwordAudioStream(in);
        }
    };

    private static AudioTimestamp defaultTimestamp() {
        return null;
    }

    private static PersistableBundle defaultMetadata() {
        return new PersistableBundle();
    }

    private static byte[] defaultInitialAudio() {
        return DEFAULT_INITIAL_EMPTY_AUDIO;
    }

    private String initialAudioToString() {
        return "length=" + this.mInitialAudio.length;
    }

    public Builder buildUpon() {
        return new Builder(this.mAudioFormat, this.mAudioStreamParcelFileDescriptor).setTimestamp(this.mTimestamp).setMetadata(this.mMetadata).setInitialAudio(this.mInitialAudio);
    }

    HotwordAudioStream(@NonNull AudioFormat audioFormat, @NonNull ParcelFileDescriptor audioStreamParcelFileDescriptor, @Nullable AudioTimestamp timestamp, @NonNull PersistableBundle metadata, @NonNull byte[] initialAudio) {
        this.mAudioFormat = audioFormat;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mAudioFormat);
        this.mAudioStreamParcelFileDescriptor = audioStreamParcelFileDescriptor;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mAudioStreamParcelFileDescriptor);
        this.mTimestamp = timestamp;
        this.mMetadata = metadata;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mMetadata);
        this.mInitialAudio = initialAudio;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mInitialAudio);
    }

    @NonNull
    public AudioFormat getAudioFormat() {
        return this.mAudioFormat;
    }

    @NonNull
    public ParcelFileDescriptor getAudioStreamParcelFileDescriptor() {
        return this.mAudioStreamParcelFileDescriptor;
    }

    @Nullable
    public AudioTimestamp getTimestamp() {
        return this.mTimestamp;
    }

    @NonNull
    public PersistableBundle getMetadata() {
        return this.mMetadata;
    }

    @NonNull
    public byte[] getInitialAudio() {
        return this.mInitialAudio;
    }

    public String toString() {
        return "HotwordAudioStream { audioFormat = " + this.mAudioFormat + ", audioStreamParcelFileDescriptor = " + this.mAudioStreamParcelFileDescriptor + ", timestamp = " + this.mTimestamp + ", metadata = " + this.mMetadata + ", initialAudio = " + this.initialAudioToString() + " }";
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HotwordAudioStream that = (HotwordAudioStream)o;
        return Objects.equals(this.mAudioFormat, that.mAudioFormat) && Objects.equals(this.mAudioStreamParcelFileDescriptor, that.mAudioStreamParcelFileDescriptor) && Objects.equals(this.mTimestamp, that.mTimestamp) && Objects.equals(this.mMetadata, that.mMetadata) && Arrays.equals(this.mInitialAudio, that.mInitialAudio);
    }

    public int hashCode() {
        int _hash = 1;
        _hash = 31 * _hash + Objects.hashCode(this.mAudioFormat);
        _hash = 31 * _hash + Objects.hashCode(this.mAudioStreamParcelFileDescriptor);
        _hash = 31 * _hash + Objects.hashCode(this.mTimestamp);
        _hash = 31 * _hash + Objects.hashCode(this.mMetadata);
        _hash = 31 * _hash + Arrays.hashCode(this.mInitialAudio);
        return _hash;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        byte flg = 0;
        if (this.mTimestamp != null) {
            flg = (byte)(flg | 4);
        }
        dest.writeByte(flg);
        dest.writeTypedObject(this.mAudioFormat, flags);
        dest.writeTypedObject(this.mAudioStreamParcelFileDescriptor, flags);
        if (this.mTimestamp != null) {
            dest.writeTypedObject(this.mTimestamp, flags);
        }
        dest.writeTypedObject(this.mMetadata, flags);
        dest.writeByteArray(this.mInitialAudio);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    HotwordAudioStream(@NonNull Parcel in) {
        byte flg = in.readByte();
        AudioFormat audioFormat = in.readTypedObject(AudioFormat.CREATOR);
        ParcelFileDescriptor audioStreamParcelFileDescriptor = in.readTypedObject(ParcelFileDescriptor.CREATOR);
        AudioTimestamp timestamp = (flg & 4) == 0 ? null : in.readTypedObject(AudioTimestamp.CREATOR);
        PersistableBundle metadata = in.readTypedObject(PersistableBundle.CREATOR);
        byte[] initialAudio = in.createByteArray();
        this.mAudioFormat = audioFormat;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mAudioFormat);
        this.mAudioStreamParcelFileDescriptor = audioStreamParcelFileDescriptor;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mAudioStreamParcelFileDescriptor);
        this.mTimestamp = timestamp;
        this.mMetadata = metadata;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mMetadata);
        this.mInitialAudio = initialAudio;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mInitialAudio);
    }

    @Deprecated
    private void __metadata() {
    }

    public static class Builder
    extends BaseBuilder {
        @NonNull
        private AudioFormat mAudioFormat;
        @NonNull
        private ParcelFileDescriptor mAudioStreamParcelFileDescriptor;
        @Nullable
        private AudioTimestamp mTimestamp;
        @NonNull
        private PersistableBundle mMetadata;
        @NonNull
        private byte[] mInitialAudio;
        private long mBuilderFieldsSet = 0L;

        public Builder(@NonNull AudioFormat audioFormat, @NonNull ParcelFileDescriptor audioStreamParcelFileDescriptor) {
            this.mAudioFormat = audioFormat;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mAudioFormat);
            this.mAudioStreamParcelFileDescriptor = audioStreamParcelFileDescriptor;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mAudioStreamParcelFileDescriptor);
        }

        @NonNull
        public Builder setAudioFormat(@NonNull AudioFormat value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mAudioFormat = value;
            return this;
        }

        @NonNull
        public Builder setAudioStreamParcelFileDescriptor(@NonNull ParcelFileDescriptor value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mAudioStreamParcelFileDescriptor = value;
            return this;
        }

        @NonNull
        public Builder setTimestamp(@NonNull AudioTimestamp value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mTimestamp = value;
            return this;
        }

        @NonNull
        public Builder setMetadata(@NonNull PersistableBundle value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mMetadata = value;
            return this;
        }

        @NonNull
        public HotwordAudioStream build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            if ((this.mBuilderFieldsSet & 4L) == 0L) {
                this.mTimestamp = HotwordAudioStream.defaultTimestamp();
            }
            if ((this.mBuilderFieldsSet & 8L) == 0L) {
                this.mMetadata = HotwordAudioStream.defaultMetadata();
            }
            if ((this.mBuilderFieldsSet & 0x10L) == 0L) {
                this.mInitialAudio = HotwordAudioStream.defaultInitialAudio();
            }
            HotwordAudioStream o = new HotwordAudioStream(this.mAudioFormat, this.mAudioStreamParcelFileDescriptor, this.mTimestamp, this.mMetadata, this.mInitialAudio);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x20L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }

    static abstract class BaseBuilder {
        BaseBuilder() {
        }

        @NonNull
        public Builder setInitialAudio(@NonNull byte[] value) {
            Objects.requireNonNull(value, "value should not be null");
            Builder builder = (Builder)this;
            builder.mBuilderFieldsSet |= 0x10L;
            builder.mInitialAudio = value;
            return builder;
        }
    }
}

