/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.app.ActivityManager;
import android.app.AlarmManager;
import android.app.AutomaticZenRule;
import android.app.NotificationManager;
import android.app.backup.BackupRestoreEventLogger;
import android.compat.annotation.UnsupportedAppUsage;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ParceledListSlice;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.service.notification.Condition;
import android.service.notification.ScheduleCalendar;
import android.service.notification.ZenAdapters;
import android.service.notification.ZenDeviceEffects;
import android.service.notification.ZenPolicy;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.ArrayMap;
import android.util.PluralsMessageFormatter;
import android.util.Slog;
import android.util.proto.ProtoOutputStream;
import com.android.internal.hidden_from_bootclasspath.android.service.notification.Flags;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.XmlUtils;
import com.android.layoutlib.androidx.annotation.VisibleForTesting;
import com.android.layoutlib.bridge.android.AndroidLocale;
import com.android.modules.utils.TypedXmlPullParser;
import com.android.modules.utils.TypedXmlSerializer;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParserException;

public class ZenModeConfig
implements Parcelable {
    private static final String TAG = "ZenModeConfig";
    public static final int ORIGIN_UNKNOWN = 0;
    public static final int ORIGIN_INIT = 1;
    public static final int ORIGIN_INIT_USER = 2;
    public static final int ORIGIN_USER_IN_SYSTEMUI = 3;
    public static final int ORIGIN_APP = 4;
    public static final int ORIGIN_SYSTEM = 5;
    public static final int ORIGIN_RESTORE_BACKUP = 6;
    public static final int ORIGIN_USER_IN_APP = 7;
    private static final String IMPLICIT_RULE_ID_PREFIX = "implicit_";
    public static final int SOURCE_ANYONE = 0;
    public static final int SOURCE_CONTACT = 1;
    public static final int SOURCE_STAR = 2;
    private static final int MAX_SOURCE = 2;
    private static final int DEFAULT_SOURCE = 2;
    private static final int DEFAULT_CALLS_SOURCE = 2;
    public static final String MANUAL_RULE_ID = "MANUAL_RULE";
    public static final String EVENTS_OBSOLETE_RULE_ID = "EVENTS_DEFAULT_RULE";
    public static final String EVERY_NIGHT_DEFAULT_RULE_ID = "EVERY_NIGHT_DEFAULT_RULE";
    public static final int[] ALL_DAYS = new int[]{1, 2, 3, 4, 5, 6, 7};
    public static final int[] MINUTE_BUCKETS = ZenModeConfig.generateMinuteBuckets();
    private static final int SECONDS_MS = 1000;
    private static final int MINUTES_MS = 60000;
    private static final int DAY_MINUTES = 1440;
    private static final int ZERO_VALUE_MS = 10000;
    private static final boolean DEFAULT_ALLOW_ALARMS = true;
    private static final boolean DEFAULT_ALLOW_MEDIA = true;
    private static final boolean DEFAULT_ALLOW_SYSTEM = false;
    private static final boolean DEFAULT_ALLOW_CALLS = true;
    private static final boolean DEFAULT_ALLOW_MESSAGES = true;
    private static final boolean DEFAULT_ALLOW_REMINDERS = false;
    private static final boolean DEFAULT_ALLOW_EVENTS = false;
    private static final boolean DEFAULT_ALLOW_REPEAT_CALLERS = true;
    private static final boolean DEFAULT_ALLOW_CONV = true;
    private static final int DEFAULT_ALLOW_CONV_FROM = 2;
    private static final boolean DEFAULT_ALLOW_PRIORITY_CHANNELS = true;
    private static final boolean DEFAULT_HAS_PRIORITY_CHANNELS = false;
    private static final int DEFAULT_SUPPRESSED_VISUAL_EFFECTS = 157;
    private static final int LEGACY_SUPPRESSED_EFFECTS = 3;
    public static final int XML_VERSION_ZEN_UPGRADE = 8;
    public static final int XML_VERSION_MODES_API = 11;
    public static final int XML_VERSION_MODES_UI = 12;
    public static final String ZEN_TAG = "zen";
    private static final String ZEN_ATT_VERSION = "version";
    private static final String ZEN_ATT_USER = "user";
    private static final String ALLOW_TAG = "allow";
    private static final String ALLOW_ATT_ALARMS = "alarms";
    private static final String ALLOW_ATT_MEDIA = "media";
    private static final String ALLOW_ATT_SYSTEM = "system";
    private static final String ALLOW_ATT_CALLS = "calls";
    private static final String ALLOW_ATT_REPEAT_CALLERS = "repeatCallers";
    private static final String ALLOW_ATT_MESSAGES = "messages";
    private static final String ALLOW_ATT_FROM = "from";
    private static final String ALLOW_ATT_CALLS_FROM = "callsFrom";
    private static final String ALLOW_ATT_MESSAGES_FROM = "messagesFrom";
    private static final String ALLOW_ATT_REMINDERS = "reminders";
    private static final String ALLOW_ATT_EVENTS = "events";
    private static final String ALLOW_ATT_SCREEN_OFF = "visualScreenOff";
    private static final String ALLOW_ATT_SCREEN_ON = "visualScreenOn";
    private static final String ALLOW_ATT_CONV = "convos";
    private static final String ALLOW_ATT_CONV_FROM = "convosFrom";
    private static final String ALLOW_ATT_CHANNELS = "priorityChannelsAllowed";
    private static final String POLICY_USER_MODIFIED_FIELDS = "policyUserModifiedFields";
    private static final String DISALLOW_TAG = "disallow";
    private static final String DISALLOW_ATT_VISUAL_EFFECTS = "visualEffects";
    private static final String STATE_TAG = "state";
    private static final String STATE_HAS_PRIORITY_CHANNELS = "areChannelsBypassingDnd";
    private static final String SHOW_ATT_FULL_SCREEN_INTENT = "showFullScreenIntent";
    private static final String SHOW_ATT_LIGHTS = "showLights";
    private static final String SHOW_ATT_PEEK = "shoePeek";
    private static final String SHOW_ATT_STATUS_BAR_ICONS = "showStatusBarIcons";
    private static final String SHOW_ATT_BADGES = "showBadges";
    private static final String SHOW_ATT_AMBIENT = "showAmbient";
    private static final String SHOW_ATT_NOTIFICATION_LIST = "showNotificationList";
    private static final String CONDITION_ATT_ID = "id";
    private static final String CONDITION_ATT_SUMMARY = "summary";
    private static final String CONDITION_ATT_LINE1 = "line1";
    private static final String CONDITION_ATT_LINE2 = "line2";
    private static final String CONDITION_ATT_ICON = "icon";
    private static final String CONDITION_ATT_STATE = "state";
    private static final String CONDITION_ATT_SOURCE = "source";
    private static final String CONDITION_ATT_FLAGS = "flags";
    private static final String MANUAL_TAG = "manual";
    private static final String AUTOMATIC_TAG = "automatic";
    private static final String AUTOMATIC_DELETED_TAG = "deleted";
    private static final String RULE_ATT_ID = "ruleId";
    private static final String RULE_ATT_ENABLED = "enabled";
    private static final String RULE_ATT_NAME = "name";
    private static final String RULE_ATT_PKG = "pkg";
    private static final String RULE_ATT_COMPONENT = "component";
    private static final String RULE_ATT_CONFIG_ACTIVITY = "configActivity";
    private static final String RULE_ATT_ZEN = "zen";
    private static final String RULE_ATT_CONDITION_ID = "conditionId";
    private static final String RULE_ATT_CREATION_TIME = "creationTime";
    private static final String RULE_ATT_ENABLER = "enabler";
    private static final String RULE_ATT_ALLOW_MANUAL = "userInvokable";
    private static final String RULE_ATT_TYPE = "type";
    private static final String RULE_ATT_USER_MODIFIED_FIELDS = "userModifiedFields";
    private static final String RULE_ATT_ICON = "rule_icon";
    private static final String RULE_ATT_TRIGGER_DESC = "triggerDesc";
    private static final String RULE_ATT_DELETION_INSTANT = "deletionInstant";
    private static final String RULE_ATT_DISABLED_ORIGIN = "disabledOrigin";
    private static final String RULE_ATT_LEGACY_SUPPRESSED_EFFECTS = "legacySuppressedEffects";
    private static final String RULE_ATT_CONDITION_OVERRIDE = "conditionOverride";
    private static final String RULE_ATT_LAST_ACTIVATION = "lastActivation";
    private static final String RULE_ATT_LAST_MANUAL_ACTIVATION = "lastManualActivation";
    private static final String RULE_ATT_LAST_DEACTIVATION = "lastDeactivation";
    private static final String RULE_ATT_LAST_MANUAL_DEACTIVATION = "lastManualDeactivation";
    private static final String DEVICE_EFFECT_DISPLAY_GRAYSCALE = "zdeDisplayGrayscale";
    private static final String DEVICE_EFFECT_SUPPRESS_AMBIENT_DISPLAY = "zdeSuppressAmbientDisplay";
    private static final String DEVICE_EFFECT_DIM_WALLPAPER = "zdeDimWallpaper";
    private static final String DEVICE_EFFECT_USE_NIGHT_MODE = "zdeUseNightMode";
    private static final String DEVICE_EFFECT_DISABLE_AUTO_BRIGHTNESS = "zdeDisableAutoBrightness";
    private static final String DEVICE_EFFECT_DISABLE_TAP_TO_WAKE = "zdeDisableTapToWake";
    private static final String DEVICE_EFFECT_DISABLE_TILT_TO_WAKE = "zdeDisableTiltToWake";
    private static final String DEVICE_EFFECT_DISABLE_TOUCH = "zdeDisableTouch";
    private static final String DEVICE_EFFECT_MINIMIZE_RADIO_USAGE = "zdeMinimizeRadioUsage";
    private static final String DEVICE_EFFECT_MAXIMIZE_DOZE = "zdeMaximizeDoze";
    private static final String DEVICE_EFFECT_USE_NIGHT_LIGHT = "zdeUseNightLight";
    private static final String DEVICE_EFFECT_CAP_BRIGHTNESS = "zdeCapBrightness";
    private static final String DEVICE_EFFECT_EXTRAS = "zdeExtraEffects";
    private static final String DEVICE_EFFECT_USER_MODIFIED_FIELDS = "zdeUserModifiedFields";
    private static final String ITEM_SEPARATOR = ",";
    private static final String ITEM_SEPARATOR_ESCAPE = "\\";
    private static final Pattern ITEM_SPLITTER_REGEX = Pattern.compile("(?<!\\\\),");
    private boolean allowAlarms = true;
    private boolean allowMedia = true;
    private boolean allowSystem = false;
    private boolean allowCalls = true;
    private boolean allowRepeatCallers = true;
    private boolean allowMessages = true;
    private boolean allowReminders = false;
    private boolean allowEvents = false;
    private int allowCallsFrom = 2;
    private int allowMessagesFrom = 2;
    private boolean allowConversations = true;
    private int allowConversationsFrom = 2;
    private int suppressedVisualEffects = 157;
    public int user = 0;
    public boolean hasPriorityChannels = false;
    public boolean allowPriorityChannels = true;
    public int version;
    public ZenRule manualRule;
    @UnsupportedAppUsage
    public ArrayMap<String, ZenRule> automaticRules = new ArrayMap();
    public final ArrayMap<String, ZenRule> deletedRules = new ArrayMap();
    @NonNull
    public static final Parcelable.Creator<ZenModeConfig> CREATOR = new Parcelable.Creator<ZenModeConfig>(){

        @Override
        public ZenModeConfig createFromParcel(Parcel source) {
            return new ZenModeConfig(source);
        }

        public ZenModeConfig[] newArray(int size) {
            return new ZenModeConfig[size];
        }
    };
    public static final String SYSTEM_AUTHORITY = "android";
    public static final String COUNTDOWN_PATH = "countdown";
    public static final String IS_ALARM_PATH = "alarm";
    public static final String SCHEDULE_PATH = "schedule";
    public static final String EVENT_PATH = "event";
    public static final String CUSTOM_MANUAL_PATH = "custom_manual";
    private static final Uri CUSTOM_MANUAL_CONDITION_ID = new Uri.Builder().scheme("condition").authority("android").appendPath("custom_manual").build();

    @UnsupportedAppUsage
    public ZenModeConfig() {
        this.ensureManualZenRule();
    }

    public ZenModeConfig(Parcel source) {
        this.user = source.readInt();
        this.manualRule = source.readParcelable(null, ZenRule.class);
        ZenModeConfig.readRulesFromParcel(this.automaticRules, source);
        ZenModeConfig.readRulesFromParcel(this.deletedRules, source);
        this.hasPriorityChannels = source.readInt() == 1;
    }

    public static ZenPolicy getDefaultZenPolicy() {
        ZenPolicy policy = new ZenPolicy.Builder().allowAlarms(true).allowMedia(true).allowSystem(false).allowCalls(3).allowMessages(3).allowReminders(false).allowEvents(false).allowRepeatCallers(true).allowConversations(2).showAllVisualEffects().showVisualEffect(0, false).showVisualEffect(1, false).showVisualEffect(2, false).showVisualEffect(5, false).allowPriorityChannels(true).build();
        return policy;
    }

    public static ZenModeConfig getDefaultConfig() {
        ZenModeConfig config = new ZenModeConfig();
        ScheduleInfo scheduleInfo = new ScheduleInfo();
        scheduleInfo.days = new int[]{1, 2, 3, 4, 5, 6, 7};
        scheduleInfo.startHour = 22;
        scheduleInfo.endHour = 7;
        scheduleInfo.exitAtAlarm = true;
        ZenRule sleeping = new ZenRule();
        sleeping.id = EVERY_NIGHT_DEFAULT_RULE_ID;
        sleeping.conditionId = ZenModeConfig.toScheduleConditionId(scheduleInfo);
        sleeping.component = ComponentName.unflattenFromString("android/com.android.server.notification.ScheduleConditionProvider");
        sleeping.enabled = false;
        sleeping.zenMode = 1;
        sleeping.pkg = SYSTEM_AUTHORITY;
        config.automaticRules.put(EVERY_NIGHT_DEFAULT_RULE_ID, sleeping);
        return config;
    }

    public static List<String> getDefaultRuleIds() {
        return List.of(EVERY_NIGHT_DEFAULT_RULE_ID);
    }

    void ensureManualZenRule() {
        if (this.manualRule == null) {
            ZenRule newRule = new ZenRule();
            newRule.type = 0;
            newRule.enabled = true;
            newRule.conditionId = Uri.EMPTY;
            newRule.allowManualInvocation = true;
            newRule.zenPolicy = ZenModeConfig.getDefaultZenPolicy();
            newRule.pkg = SYSTEM_AUTHORITY;
            this.manualRule = newRule;
        }
    }

    private static void readRulesFromParcel(ArrayMap<String, ZenRule> ruleMap, Parcel source) {
        int len = source.readInt();
        if (len > 0) {
            List rules;
            String[] ids = new String[len];
            source.readString8Array(ids);
            ParceledListSlice parceledRules = source.readParcelable(ZenRule.class.getClassLoader(), ParceledListSlice.class);
            List list = rules = parceledRules != null ? parceledRules.getList() : new ArrayList();
            if (rules.size() != len) {
                Slog.wtf(TAG, String.format("Unexpected parceled rules count (%s != %s), throwing them out", rules.size(), len));
                len = 0;
            }
            for (int i = 0; i < len; ++i) {
                ruleMap.put(ids[i], (ZenRule)rules.get(i));
            }
        }
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.user);
        dest.writeParcelable(this.manualRule, 0);
        ZenModeConfig.writeRulesToParcel(this.automaticRules, dest, flags);
        ZenModeConfig.writeRulesToParcel(this.deletedRules, dest, flags);
        dest.writeInt(this.hasPriorityChannels ? 1 : 0);
    }

    private static void writeRulesToParcel(ArrayMap<String, ZenRule> ruleMap, Parcel dest, int flags) {
        if (!ruleMap.isEmpty()) {
            int len = ruleMap.size();
            String[] ids = new String[len];
            ArrayList<ZenRule> rules = new ArrayList<ZenRule>();
            for (int i = 0; i < len; ++i) {
                ids[i] = ruleMap.keyAt(i);
                rules.add(ruleMap.valueAt(i));
            }
            dest.writeInt(len);
            dest.writeString8Array(ids);
            dest.writeParcelable(new ParceledListSlice(rules), flags);
        } else {
            dest.writeInt(0);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(ZenModeConfig.class.getSimpleName()).append('[').append("user=").append(this.user);
        sb.append("\nhasPriorityChannels=").append(this.hasPriorityChannels);
        sb.append(",allowPriorityChannels=").append(this.allowPriorityChannels);
        sb.append(",\nautomaticRules=").append(ZenModeConfig.rulesToString(this.automaticRules));
        sb.append(",\nmanualRule=").append(this.manualRule);
        sb.append(",\ndeletedRules=").append(ZenModeConfig.rulesToString(this.deletedRules));
        return sb.append(']').toString();
    }

    public int getAllowConversationsFrom() {
        return this.manualRule.zenPolicy.getPriorityConversationSenders();
    }

    public int getAllowCallsFrom() {
        return ZenAdapters.peopleTypeToPrioritySenders(this.manualRule.zenPolicy.getPriorityCallSenders(), 2);
    }

    public void setAllowCallsFrom(int allowCallsFrom) {
        this.manualRule.zenPolicy = new ZenPolicy.Builder(this.manualRule.zenPolicy).allowCalls(ZenAdapters.prioritySendersToPeopleType(allowCallsFrom)).build();
    }

    public boolean isAllowEvents() {
        return this.manualRule.zenPolicy.isCategoryAllowed(1, false);
    }

    private static String rulesToString(ArrayMap<String, ZenRule> ruleList) {
        if (ruleList.isEmpty()) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(ruleList.size() * 28);
        buffer.append("{\n");
        for (int i = 0; i < ruleList.size(); ++i) {
            if (i > 0) {
                buffer.append(",\n");
            }
            ZenRule value = ruleList.valueAt(i);
            buffer.append(value);
        }
        buffer.append('}');
        return buffer.toString();
    }

    public boolean isValid() {
        if (!ZenModeConfig.isValidManualRule(this.manualRule)) {
            return false;
        }
        int N2 = this.automaticRules.size();
        for (int i = 0; i < N2; ++i) {
            if (ZenModeConfig.isValidAutomaticRule(this.automaticRules.valueAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidManualRule(ZenRule rule) {
        return rule == null || Settings.Global.isValidZenMode(rule.zenMode) && ZenModeConfig.sameCondition(rule);
    }

    private static boolean isValidAutomaticRule(ZenRule rule) {
        return rule != null && !TextUtils.isEmpty(rule.name) && Settings.Global.isValidZenMode(rule.zenMode) && rule.conditionId != null && ZenModeConfig.sameCondition(rule);
    }

    private static boolean sameCondition(ZenRule rule) {
        if (rule == null) {
            return false;
        }
        if (rule.conditionId == null) {
            return rule.condition == null;
        }
        return rule.condition == null || rule.conditionId.equals(rule.condition.id);
    }

    private static int[] generateMinuteBuckets() {
        int maxHrs = 12;
        int[] buckets = new int[15];
        buckets[0] = 15;
        buckets[1] = 30;
        buckets[2] = 45;
        for (int i = 1; i <= 12; ++i) {
            buckets[2 + i] = 60 * i;
        }
        return buckets;
    }

    public static String sourceToString(int source) {
        switch (source) {
            case 0: {
                return "anyone";
            }
            case 1: {
                return "contacts";
            }
            case 2: {
                return "stars";
            }
        }
        return "UNKNOWN";
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof ZenModeConfig)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        ZenModeConfig other = (ZenModeConfig)o;
        return other.allowAlarms == this.allowAlarms && other.allowMedia == this.allowMedia && other.allowSystem == this.allowSystem && other.allowCalls == this.allowCalls && other.allowRepeatCallers == this.allowRepeatCallers && other.allowMessages == this.allowMessages && other.allowCallsFrom == this.allowCallsFrom && other.allowMessagesFrom == this.allowMessagesFrom && other.allowReminders == this.allowReminders && other.allowEvents == this.allowEvents && other.user == this.user && Objects.equals(other.automaticRules, this.automaticRules) && Objects.equals(other.manualRule, this.manualRule) && other.suppressedVisualEffects == this.suppressedVisualEffects && other.hasPriorityChannels == this.hasPriorityChannels && other.allowConversations == this.allowConversations && other.allowConversationsFrom == this.allowConversationsFrom && Objects.equals(other.deletedRules, this.deletedRules) && other.allowPriorityChannels == this.allowPriorityChannels;
    }

    public int hashCode() {
        return Objects.hash(this.allowAlarms, this.allowMedia, this.allowSystem, this.allowCalls, this.allowRepeatCallers, this.allowMessages, this.allowCallsFrom, this.allowMessagesFrom, this.allowReminders, this.allowEvents, this.user, this.automaticRules, this.manualRule, this.suppressedVisualEffects, this.hasPriorityChannels, this.allowConversations, this.allowConversationsFrom, this.allowPriorityChannels);
    }

    private static String toDayList(int[] days) {
        if (days == null || days.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < days.length; ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(days[i]);
        }
        return sb.toString();
    }

    private static int[] tryParseDayList(String dayList, String sep) {
        if (dayList == null) {
            return null;
        }
        String[] tokens = dayList.split(sep);
        if (tokens.length == 0) {
            return null;
        }
        int[] rt = new int[tokens.length];
        for (int i = 0; i < tokens.length; ++i) {
            int day = ZenModeConfig.tryParseInt(tokens[i], -1);
            if (day == -1) {
                return null;
            }
            rt[i] = day;
        }
        return rt;
    }

    private static int tryParseInt(String value, int defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private static long tryParseLong(String value, long defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private static Long tryParseLong(String value, Long defValue) {
        if (TextUtils.isEmpty(value)) {
            return defValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    public static int getCurrentXmlVersion() {
        return 12;
    }

    public static ZenModeConfig readXml(TypedXmlPullParser parser, @Nullable BackupRestoreEventLogger logger) throws XmlPullParserException, IOException {
        int readRuleCount = 0;
        int type = parser.getEventType();
        if (type != 2) {
            return null;
        }
        String tag = parser.getName();
        if (!"zen".equals(tag)) {
            return null;
        }
        ZenModeConfig rt = new ZenModeConfig();
        rt.version = ZenModeConfig.safeInt(parser, ZEN_ATT_VERSION, ZenModeConfig.getCurrentXmlVersion());
        rt.user = ZenModeConfig.safeInt(parser, ZEN_ATT_USER, rt.user);
        boolean readSuppressedEffects = false;
        boolean readManualRule = false;
        boolean readManualRuleWithoutPolicy = false;
        while ((type = parser.next()) != 1) {
            tag = parser.getName();
            if (type == 2) {
                if (ALLOW_TAG.equals(tag)) {
                    rt.allowCalls = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_CALLS, true);
                    rt.allowRepeatCallers = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_REPEAT_CALLERS, true);
                    rt.allowMessages = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_MESSAGES, true);
                    rt.allowReminders = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_REMINDERS, false);
                    rt.allowConversations = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_CONV, true);
                    rt.allowEvents = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_EVENTS, false);
                    int from = ZenModeConfig.safeInt(parser, ALLOW_ATT_FROM, -1);
                    int callsFrom = ZenModeConfig.safeInt(parser, ALLOW_ATT_CALLS_FROM, -1);
                    int messagesFrom = ZenModeConfig.safeInt(parser, ALLOW_ATT_MESSAGES_FROM, -1);
                    rt.allowConversationsFrom = ZenModeConfig.safeInt(parser, ALLOW_ATT_CONV_FROM, 2);
                    if (ZenModeConfig.isValidSource(callsFrom) && ZenModeConfig.isValidSource(messagesFrom)) {
                        rt.allowCallsFrom = callsFrom;
                        rt.allowMessagesFrom = messagesFrom;
                    } else if (ZenModeConfig.isValidSource(from)) {
                        Slog.i(TAG, "Migrating existing shared 'from': " + ZenModeConfig.sourceToString(from));
                        rt.allowCallsFrom = from;
                        rt.allowMessagesFrom = from;
                    } else {
                        rt.allowCallsFrom = 2;
                        rt.allowMessagesFrom = 2;
                    }
                    rt.allowAlarms = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_ALARMS, true);
                    rt.allowMedia = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_MEDIA, true);
                    rt.allowSystem = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_SYSTEM, false);
                    rt.allowPriorityChannels = ZenModeConfig.safeBoolean(parser, ALLOW_ATT_CHANNELS, true);
                    Boolean allowWhenScreenOff = ZenModeConfig.unsafeBoolean(parser, ALLOW_ATT_SCREEN_OFF);
                    Boolean allowWhenScreenOn = ZenModeConfig.unsafeBoolean(parser, ALLOW_ATT_SCREEN_ON);
                    if (allowWhenScreenOff != null || allowWhenScreenOn != null) {
                        readSuppressedEffects = true;
                        rt.suppressedVisualEffects = 0;
                    }
                    if (allowWhenScreenOff != null && !allowWhenScreenOff.booleanValue()) {
                        rt.suppressedVisualEffects |= 0x8C;
                    }
                    if (allowWhenScreenOn != null && !allowWhenScreenOn.booleanValue()) {
                        rt.suppressedVisualEffects |= 0x10;
                    }
                    if (readSuppressedEffects) {
                        Slog.d(TAG, "Migrated visual effects to " + rt.suppressedVisualEffects);
                    }
                } else if (DISALLOW_TAG.equals(tag) && !readSuppressedEffects) {
                    rt.suppressedVisualEffects = ZenModeConfig.safeInt(parser, DISALLOW_ATT_VISUAL_EFFECTS, 157);
                } else if (MANUAL_TAG.equals(tag)) {
                    rt.manualRule = ZenModeConfig.readRuleXml(parser);
                    rt.manualRule.enabled = true;
                    readManualRule = true;
                    if (rt.manualRule.zenPolicy == null) {
                        readManualRuleWithoutPolicy = true;
                    } else {
                        ++readRuleCount;
                    }
                } else if (AUTOMATIC_TAG.equals(tag) || AUTOMATIC_DELETED_TAG.equals(tag)) {
                    String id2 = parser.getAttributeValue(null, RULE_ATT_ID);
                    if (id2 != null) {
                        ZenRule automaticRule = ZenModeConfig.readRuleXml(parser);
                        automaticRule.id = id2;
                        if (AUTOMATIC_DELETED_TAG.equals(tag)) {
                            String deletedRuleKey = ZenModeConfig.deletedRuleKey(automaticRule);
                            if (deletedRuleKey != null) {
                                rt.deletedRules.put(deletedRuleKey, automaticRule);
                            }
                        } else if (AUTOMATIC_TAG.equals(tag)) {
                            rt.automaticRules.put(id2, automaticRule);
                            ++readRuleCount;
                        }
                    }
                } else if ("state".equals(tag)) {
                    rt.hasPriorityChannels = ZenModeConfig.safeBoolean(parser, STATE_HAS_PRIORITY_CHANNELS, false);
                }
            }
            if (type != 3 || !"zen".equals(tag)) continue;
            if (!readManualRule || readManualRuleWithoutPolicy) {
                rt.manualRule.zenPolicy = rt.toZenPolicyForXmlUpgrade();
                if (readManualRuleWithoutPolicy) {
                    rt.manualRule.pkg = SYSTEM_AUTHORITY;
                    rt.manualRule.type = 0;
                    if (rt.manualRule.conditionId == null) {
                        rt.manualRule.conditionId = Uri.EMPTY;
                    }
                    rt.manualRule.condition = new Condition(rt.manualRule.conditionId, "", 1);
                    ++readRuleCount;
                }
            }
            if (logger != null) {
                logger.logItemsRestored("notifications:zen_rules", readRuleCount);
            }
            return rt;
        }
        throw new IllegalStateException("Failed to reach END_DOCUMENT");
    }

    @Nullable
    public static String deletedRuleKey(ZenRule rule) {
        if (rule.pkg != null && rule.conditionId != null) {
            return rule.pkg + "|" + rule.conditionId.toString();
        }
        return null;
    }

    public void writeXml(TypedXmlSerializer out, Integer version, boolean forBackup, @Nullable BackupRestoreEventLogger logger) throws IOException {
        int i;
        int writtenRuleCount = 0;
        int xmlVersion = ZenModeConfig.getCurrentXmlVersion();
        out.startTag(null, "zen");
        out.attribute(null, ZEN_ATT_VERSION, version == null ? Integer.toString(xmlVersion) : Integer.toString(version));
        out.attributeInt(null, ZEN_ATT_USER, this.user);
        out.startTag(null, ALLOW_TAG);
        out.attributeBoolean(null, ALLOW_ATT_CALLS, this.allowCalls);
        out.attributeBoolean(null, ALLOW_ATT_REPEAT_CALLERS, this.allowRepeatCallers);
        out.attributeBoolean(null, ALLOW_ATT_MESSAGES, this.allowMessages);
        out.attributeBoolean(null, ALLOW_ATT_REMINDERS, this.allowReminders);
        out.attributeBoolean(null, ALLOW_ATT_EVENTS, this.allowEvents);
        out.attributeInt(null, ALLOW_ATT_CALLS_FROM, this.allowCallsFrom);
        out.attributeInt(null, ALLOW_ATT_MESSAGES_FROM, this.allowMessagesFrom);
        out.attributeBoolean(null, ALLOW_ATT_ALARMS, this.allowAlarms);
        out.attributeBoolean(null, ALLOW_ATT_MEDIA, this.allowMedia);
        out.attributeBoolean(null, ALLOW_ATT_SYSTEM, this.allowSystem);
        out.attributeBoolean(null, ALLOW_ATT_CONV, this.allowConversations);
        out.attributeInt(null, ALLOW_ATT_CONV_FROM, this.allowConversationsFrom);
        out.attributeBoolean(null, ALLOW_ATT_CHANNELS, this.allowPriorityChannels);
        out.endTag(null, ALLOW_TAG);
        out.startTag(null, DISALLOW_TAG);
        out.attributeInt(null, DISALLOW_ATT_VISUAL_EFFECTS, this.suppressedVisualEffects);
        out.endTag(null, DISALLOW_TAG);
        if (this.manualRule != null) {
            out.startTag(null, MANUAL_TAG);
            ZenModeConfig.writeRuleXml(this.manualRule, out, forBackup);
            out.endTag(null, MANUAL_TAG);
        }
        ++writtenRuleCount;
        int N2 = this.automaticRules.size();
        for (i = 0; i < N2; ++i) {
            String id2 = this.automaticRules.keyAt(i);
            ZenRule automaticRule = this.automaticRules.valueAt(i);
            out.startTag(null, AUTOMATIC_TAG);
            out.attribute(null, RULE_ATT_ID, id2);
            ZenModeConfig.writeRuleXml(automaticRule, out, forBackup);
            out.endTag(null, AUTOMATIC_TAG);
            ++writtenRuleCount;
        }
        if (!forBackup) {
            for (i = 0; i < this.deletedRules.size(); ++i) {
                ZenRule deletedRule = this.deletedRules.valueAt(i);
                out.startTag(null, AUTOMATIC_DELETED_TAG);
                out.attribute(null, RULE_ATT_ID, deletedRule.id);
                ZenModeConfig.writeRuleXml(deletedRule, out, forBackup);
                out.endTag(null, AUTOMATIC_DELETED_TAG);
            }
        }
        out.startTag(null, "state");
        out.attributeBoolean(null, STATE_HAS_PRIORITY_CHANNELS, this.hasPriorityChannels);
        out.endTag(null, "state");
        out.endTag(null, "zen");
        if (logger != null) {
            logger.logItemsBackedUp("notifications:zen_rules", writtenRuleCount);
        }
    }

    @NonNull
    public static ZenRule readRuleXml(TypedXmlPullParser parser) {
        ZenRule rt = new ZenRule();
        rt.enabled = ZenModeConfig.safeBoolean(parser, RULE_ATT_ENABLED, true);
        rt.name = parser.getAttributeValue(null, RULE_ATT_NAME);
        String zen = parser.getAttributeValue(null, "zen");
        rt.zenMode = ZenModeConfig.tryParseZenMode(zen, 1);
        rt.conditionId = ZenModeConfig.safeUri(parser, RULE_ATT_CONDITION_ID);
        rt.component = ZenModeConfig.safeComponentName(parser, RULE_ATT_COMPONENT);
        rt.configurationActivity = ZenModeConfig.safeComponentName(parser, RULE_ATT_CONFIG_ACTIVITY);
        rt.pkg = XmlUtils.readStringAttribute(parser, RULE_ATT_PKG);
        if (rt.pkg == null) {
            rt.pkg = rt.component != null ? rt.component.getPackageName() : null;
        }
        rt.creationTime = ZenModeConfig.safeLong(parser, RULE_ATT_CREATION_TIME, 0L);
        rt.enabler = parser.getAttributeValue(null, RULE_ATT_ENABLER);
        rt.condition = ZenModeConfig.readConditionXml(parser);
        rt.zenPolicy = ZenModeConfig.readZenPolicyXml(parser);
        rt.zenDeviceEffects = ZenModeConfig.readZenDeviceEffectsXml(parser);
        rt.allowManualInvocation = ZenModeConfig.safeBoolean(parser, RULE_ATT_ALLOW_MANUAL, false);
        rt.iconResName = parser.getAttributeValue(null, RULE_ATT_ICON);
        rt.triggerDescription = parser.getAttributeValue(null, RULE_ATT_TRIGGER_DESC);
        rt.type = ZenModeConfig.safeInt(parser, RULE_ATT_TYPE, -1);
        rt.userModifiedFields = ZenModeConfig.safeInt(parser, RULE_ATT_USER_MODIFIED_FIELDS, 0);
        rt.zenPolicyUserModifiedFields = ZenModeConfig.safeInt(parser, POLICY_USER_MODIFIED_FIELDS, 0);
        rt.zenDeviceEffectsUserModifiedFields = ZenModeConfig.safeInt(parser, DEVICE_EFFECT_USER_MODIFIED_FIELDS, 0);
        rt.deletionInstant = ZenModeConfig.safeInstant(parser, RULE_ATT_DELETION_INSTANT, null);
        rt.disabledOrigin = ZenModeConfig.safeInt(parser, RULE_ATT_DISABLED_ORIGIN, 0);
        rt.legacySuppressedEffects = ZenModeConfig.safeInt(parser, RULE_ATT_LEGACY_SUPPRESSED_EFFECTS, 0);
        rt.conditionOverride = ZenModeConfig.safeInt(parser, RULE_ATT_CONDITION_OVERRIDE, 0);
        rt.lastActivation = ZenModeConfig.safeInstant(parser, RULE_ATT_LAST_ACTIVATION, null);
        if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.modesUiTileReactivatesLast()) {
            rt.lastManualActivation = ZenModeConfig.safeInstant(parser, RULE_ATT_LAST_MANUAL_ACTIVATION, null);
            rt.lastDeactivation = ZenModeConfig.safeInstant(parser, RULE_ATT_LAST_DEACTIVATION, null);
            rt.lastManualDeactivation = ZenModeConfig.safeInstant(parser, RULE_ATT_LAST_MANUAL_DEACTIVATION, null);
        }
        return rt;
    }

    public static void writeRuleXml(ZenRule rule, TypedXmlSerializer out, boolean forBackup) throws IOException {
        out.attributeBoolean(null, RULE_ATT_ENABLED, rule.enabled);
        if (rule.name != null) {
            out.attribute(null, RULE_ATT_NAME, rule.name);
        }
        out.attributeInt(null, "zen", rule.zenMode);
        if (rule.pkg != null) {
            out.attribute(null, RULE_ATT_PKG, rule.pkg);
        }
        if (rule.component != null) {
            out.attribute(null, RULE_ATT_COMPONENT, rule.component.flattenToString());
        }
        if (rule.configurationActivity != null) {
            out.attribute(null, RULE_ATT_CONFIG_ACTIVITY, rule.configurationActivity.flattenToString());
        }
        if (rule.conditionId != null) {
            out.attribute(null, RULE_ATT_CONDITION_ID, rule.conditionId.toString());
        }
        out.attributeLong(null, RULE_ATT_CREATION_TIME, rule.creationTime);
        if (rule.enabler != null) {
            out.attribute(null, RULE_ATT_ENABLER, rule.enabler);
        }
        if (rule.condition != null) {
            ZenModeConfig.writeConditionXml(rule.condition, out);
        }
        if (rule.zenPolicy != null) {
            ZenModeConfig.writeZenPolicyXml(rule.zenPolicy, out);
        }
        if (rule.zenDeviceEffects != null) {
            ZenModeConfig.writeZenDeviceEffectsXml(rule.zenDeviceEffects, out);
        }
        out.attributeBoolean(null, RULE_ATT_ALLOW_MANUAL, rule.allowManualInvocation);
        if (rule.iconResName != null) {
            out.attribute(null, RULE_ATT_ICON, rule.iconResName);
        }
        if (rule.triggerDescription != null) {
            out.attribute(null, RULE_ATT_TRIGGER_DESC, rule.triggerDescription);
        }
        out.attributeInt(null, RULE_ATT_TYPE, rule.type);
        out.attributeInt(null, RULE_ATT_USER_MODIFIED_FIELDS, rule.userModifiedFields);
        out.attributeInt(null, POLICY_USER_MODIFIED_FIELDS, rule.zenPolicyUserModifiedFields);
        out.attributeInt(null, DEVICE_EFFECT_USER_MODIFIED_FIELDS, rule.zenDeviceEffectsUserModifiedFields);
        ZenModeConfig.writeXmlAttributeInstant(out, RULE_ATT_DELETION_INSTANT, rule.deletionInstant);
        out.attributeInt(null, RULE_ATT_DISABLED_ORIGIN, rule.disabledOrigin);
        out.attributeInt(null, RULE_ATT_LEGACY_SUPPRESSED_EFFECTS, rule.legacySuppressedEffects);
        if (rule.conditionOverride == 1 && !forBackup) {
            out.attributeInt(null, RULE_ATT_CONDITION_OVERRIDE, rule.conditionOverride);
        }
        ZenModeConfig.writeXmlAttributeInstant(out, RULE_ATT_LAST_ACTIVATION, rule.lastActivation);
        if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.modesUiTileReactivatesLast()) {
            ZenModeConfig.writeXmlAttributeInstant(out, RULE_ATT_LAST_MANUAL_ACTIVATION, rule.lastManualActivation);
            ZenModeConfig.writeXmlAttributeInstant(out, RULE_ATT_LAST_DEACTIVATION, rule.lastDeactivation);
            ZenModeConfig.writeXmlAttributeInstant(out, RULE_ATT_LAST_MANUAL_DEACTIVATION, rule.lastManualDeactivation);
        }
    }

    private static void writeXmlAttributeInstant(TypedXmlSerializer out, String att, @Nullable Instant instant) throws IOException {
        if (instant != null) {
            out.attributeLong(null, att, instant.toEpochMilli());
        }
    }

    public static Condition readConditionXml(TypedXmlPullParser parser) {
        Uri id2 = ZenModeConfig.safeUri(parser, CONDITION_ATT_ID);
        if (id2 == null) {
            return null;
        }
        String summary = parser.getAttributeValue(null, CONDITION_ATT_SUMMARY);
        String line1 = parser.getAttributeValue(null, CONDITION_ATT_LINE1);
        String line2 = parser.getAttributeValue(null, CONDITION_ATT_LINE2);
        int icon = ZenModeConfig.safeInt(parser, CONDITION_ATT_ICON, -1);
        int state = ZenModeConfig.safeInt(parser, "state", -1);
        int flags = ZenModeConfig.safeInt(parser, CONDITION_ATT_FLAGS, -1);
        try {
            int source = ZenModeConfig.safeInt(parser, CONDITION_ATT_SOURCE, 0);
            return new Condition(id2, summary, line1, line2, icon, state, source, flags);
        }
        catch (IllegalArgumentException e) {
            Slog.w(TAG, "Unable to read condition xml", e);
            return null;
        }
    }

    public static void writeConditionXml(Condition c, TypedXmlSerializer out) throws IOException {
        out.attribute(null, CONDITION_ATT_ID, c.id.toString());
        out.attribute(null, CONDITION_ATT_SUMMARY, c.summary);
        out.attribute(null, CONDITION_ATT_LINE1, c.line1);
        out.attribute(null, CONDITION_ATT_LINE2, c.line2);
        out.attributeInt(null, CONDITION_ATT_ICON, c.icon);
        out.attributeInt(null, "state", c.state);
        out.attributeInt(null, CONDITION_ATT_SOURCE, c.source);
        out.attributeInt(null, CONDITION_ATT_FLAGS, c.flags);
    }

    public static ZenPolicy readZenPolicyXml(TypedXmlPullParser parser) {
        boolean policySet = false;
        ZenPolicy.Builder builder = new ZenPolicy.Builder();
        int calls = ZenModeConfig.safeInt(parser, ALLOW_ATT_CALLS_FROM, 0);
        int messages = ZenModeConfig.safeInt(parser, ALLOW_ATT_MESSAGES_FROM, 0);
        int repeatCallers = ZenModeConfig.safeInt(parser, ALLOW_ATT_REPEAT_CALLERS, 0);
        int conversations = ZenModeConfig.safeInt(parser, ALLOW_ATT_CONV_FROM, 0);
        int alarms = ZenModeConfig.safeInt(parser, ALLOW_ATT_ALARMS, 0);
        int media = ZenModeConfig.safeInt(parser, ALLOW_ATT_MEDIA, 0);
        int system = ZenModeConfig.safeInt(parser, ALLOW_ATT_SYSTEM, 0);
        int events = ZenModeConfig.safeInt(parser, ALLOW_ATT_EVENTS, 0);
        int reminders = ZenModeConfig.safeInt(parser, ALLOW_ATT_REMINDERS, 0);
        int channels = ZenModeConfig.safeInt(parser, ALLOW_ATT_CHANNELS, 0);
        if (channels != 0) {
            builder.allowPriorityChannels(channels == 1);
            policySet = true;
        }
        if (calls != 0) {
            builder.allowCalls(calls);
            policySet = true;
        }
        if (messages != 0) {
            builder.allowMessages(messages);
            policySet = true;
        }
        if (repeatCallers != 0) {
            builder.allowRepeatCallers(repeatCallers == 1);
            policySet = true;
        }
        if (conversations != 0) {
            builder.allowConversations(conversations);
            policySet = true;
        }
        if (alarms != 0) {
            builder.allowAlarms(alarms == 1);
            policySet = true;
        }
        if (media != 0) {
            builder.allowMedia(media == 1);
            policySet = true;
        }
        if (system != 0) {
            builder.allowSystem(system == 1);
            policySet = true;
        }
        if (events != 0) {
            builder.allowEvents(events == 1);
            policySet = true;
        }
        if (reminders != 0) {
            builder.allowReminders(reminders == 1);
            policySet = true;
        }
        int fullScreenIntent = ZenModeConfig.safeInt(parser, SHOW_ATT_FULL_SCREEN_INTENT, 0);
        int lights = ZenModeConfig.safeInt(parser, SHOW_ATT_LIGHTS, 0);
        int peek = ZenModeConfig.safeInt(parser, SHOW_ATT_PEEK, 0);
        int statusBar = ZenModeConfig.safeInt(parser, SHOW_ATT_STATUS_BAR_ICONS, 0);
        int badges = ZenModeConfig.safeInt(parser, SHOW_ATT_BADGES, 0);
        int ambient = ZenModeConfig.safeInt(parser, SHOW_ATT_AMBIENT, 0);
        int notificationList = ZenModeConfig.safeInt(parser, SHOW_ATT_NOTIFICATION_LIST, 0);
        if (fullScreenIntent != 0) {
            builder.showFullScreenIntent(fullScreenIntent == 1);
            policySet = true;
        }
        if (lights != 0) {
            builder.showLights(lights == 1);
            policySet = true;
        }
        if (peek != 0) {
            builder.showPeeking(peek == 1);
            policySet = true;
        }
        if (statusBar != 0) {
            builder.showStatusBarIcons(statusBar == 1);
            policySet = true;
        }
        if (badges != 0) {
            builder.showBadges(badges == 1);
            policySet = true;
        }
        if (ambient != 0) {
            builder.showInAmbientDisplay(ambient == 1);
            policySet = true;
        }
        if (notificationList != 0) {
            builder.showInNotificationList(notificationList == 1);
            policySet = true;
        }
        if (policySet) {
            return builder.build();
        }
        return null;
    }

    public static void writeZenPolicyXml(ZenPolicy policy, TypedXmlSerializer out) throws IOException {
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_CALLS_FROM, policy.getPriorityCallSenders(), out);
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_MESSAGES_FROM, policy.getPriorityMessageSenders(), out);
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_REPEAT_CALLERS, policy.getPriorityCategoryRepeatCallers(), out);
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_CONV_FROM, policy.getPriorityConversationSenders(), out);
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_ALARMS, policy.getPriorityCategoryAlarms(), out);
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_MEDIA, policy.getPriorityCategoryMedia(), out);
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_SYSTEM, policy.getPriorityCategorySystem(), out);
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_REMINDERS, policy.getPriorityCategoryReminders(), out);
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_EVENTS, policy.getPriorityCategoryEvents(), out);
        ZenModeConfig.writeZenPolicyState(SHOW_ATT_FULL_SCREEN_INTENT, policy.getVisualEffectFullScreenIntent(), out);
        ZenModeConfig.writeZenPolicyState(SHOW_ATT_LIGHTS, policy.getVisualEffectLights(), out);
        ZenModeConfig.writeZenPolicyState(SHOW_ATT_PEEK, policy.getVisualEffectPeek(), out);
        ZenModeConfig.writeZenPolicyState(SHOW_ATT_STATUS_BAR_ICONS, policy.getVisualEffectStatusBar(), out);
        ZenModeConfig.writeZenPolicyState(SHOW_ATT_BADGES, policy.getVisualEffectBadge(), out);
        ZenModeConfig.writeZenPolicyState(SHOW_ATT_AMBIENT, policy.getVisualEffectAmbient(), out);
        ZenModeConfig.writeZenPolicyState(SHOW_ATT_NOTIFICATION_LIST, policy.getVisualEffectNotificationList(), out);
        ZenModeConfig.writeZenPolicyState(ALLOW_ATT_CHANNELS, policy.getPriorityChannelsAllowed(), out);
    }

    private static void writeZenPolicyState(String attr2, int val, TypedXmlSerializer out) throws IOException {
        if (Objects.equals(attr2, ALLOW_ATT_CALLS_FROM) || Objects.equals(attr2, ALLOW_ATT_MESSAGES_FROM)) {
            if (val != 0) {
                out.attributeInt(null, attr2, val);
            }
        } else if (Objects.equals(attr2, ALLOW_ATT_CONV_FROM)) {
            if (val != 0) {
                out.attributeInt(null, attr2, val);
            }
        } else if (Objects.equals(attr2, ALLOW_ATT_CHANNELS)) {
            if (val != 0) {
                out.attributeInt(null, attr2, val);
            }
        } else if (val != 0) {
            out.attributeInt(null, attr2, val);
        }
    }

    @Nullable
    private static ZenDeviceEffects readZenDeviceEffectsXml(TypedXmlPullParser parser) {
        ZenDeviceEffects deviceEffects;
        ZenDeviceEffects.Builder builder = new ZenDeviceEffects.Builder().setShouldDisplayGrayscale(ZenModeConfig.safeBoolean(parser, DEVICE_EFFECT_DISPLAY_GRAYSCALE, false)).setShouldSuppressAmbientDisplay(ZenModeConfig.safeBoolean(parser, DEVICE_EFFECT_SUPPRESS_AMBIENT_DISPLAY, false)).setShouldDimWallpaper(ZenModeConfig.safeBoolean(parser, DEVICE_EFFECT_DIM_WALLPAPER, false)).setShouldUseNightMode(ZenModeConfig.safeBoolean(parser, DEVICE_EFFECT_USE_NIGHT_MODE, false)).setShouldDisableAutoBrightness(ZenModeConfig.safeBoolean(parser, DEVICE_EFFECT_DISABLE_AUTO_BRIGHTNESS, false)).setShouldDisableTapToWake(ZenModeConfig.safeBoolean(parser, DEVICE_EFFECT_DISABLE_TAP_TO_WAKE, false)).setShouldDisableTiltToWake(ZenModeConfig.safeBoolean(parser, DEVICE_EFFECT_DISABLE_TILT_TO_WAKE, false)).setShouldDisableTouch(ZenModeConfig.safeBoolean(parser, DEVICE_EFFECT_DISABLE_TOUCH, false)).setShouldMinimizeRadioUsage(ZenModeConfig.safeBoolean(parser, DEVICE_EFFECT_MINIMIZE_RADIO_USAGE, false)).setShouldMaximizeDoze(ZenModeConfig.safeBoolean(parser, DEVICE_EFFECT_MAXIMIZE_DOZE, false)).setShouldUseNightLight(ZenModeConfig.safeBoolean(parser, DEVICE_EFFECT_USE_NIGHT_LIGHT, false)).setExtraEffects(ZenModeConfig.safeStringSet(parser, DEVICE_EFFECT_EXTRAS));
        if (Flags.applyBrightnessClampingForModes()) {
            builder.setBrightnessPercentageCap(ZenModeConfig.unsafeFloat(parser, DEVICE_EFFECT_CAP_BRIGHTNESS));
        }
        return (deviceEffects = builder.build()).hasEffects() ? deviceEffects : null;
    }

    private static void writeZenDeviceEffectsXml(ZenDeviceEffects deviceEffects, TypedXmlSerializer out) throws IOException {
        ZenModeConfig.writeBooleanIfTrue(out, DEVICE_EFFECT_DISPLAY_GRAYSCALE, deviceEffects.shouldDisplayGrayscale());
        ZenModeConfig.writeBooleanIfTrue(out, DEVICE_EFFECT_SUPPRESS_AMBIENT_DISPLAY, deviceEffects.shouldSuppressAmbientDisplay());
        ZenModeConfig.writeBooleanIfTrue(out, DEVICE_EFFECT_DIM_WALLPAPER, deviceEffects.shouldDimWallpaper());
        ZenModeConfig.writeBooleanIfTrue(out, DEVICE_EFFECT_USE_NIGHT_MODE, deviceEffects.shouldUseNightMode());
        ZenModeConfig.writeBooleanIfTrue(out, DEVICE_EFFECT_DISABLE_AUTO_BRIGHTNESS, deviceEffects.shouldDisableAutoBrightness());
        ZenModeConfig.writeBooleanIfTrue(out, DEVICE_EFFECT_DISABLE_TAP_TO_WAKE, deviceEffects.shouldDisableTapToWake());
        ZenModeConfig.writeBooleanIfTrue(out, DEVICE_EFFECT_DISABLE_TILT_TO_WAKE, deviceEffects.shouldDisableTiltToWake());
        ZenModeConfig.writeBooleanIfTrue(out, DEVICE_EFFECT_DISABLE_TOUCH, deviceEffects.shouldDisableTouch());
        ZenModeConfig.writeBooleanIfTrue(out, DEVICE_EFFECT_MINIMIZE_RADIO_USAGE, deviceEffects.shouldMinimizeRadioUsage());
        ZenModeConfig.writeBooleanIfTrue(out, DEVICE_EFFECT_MAXIMIZE_DOZE, deviceEffects.shouldMaximizeDoze());
        ZenModeConfig.writeBooleanIfTrue(out, DEVICE_EFFECT_USE_NIGHT_LIGHT, deviceEffects.shouldUseNightLight());
        if (Flags.applyBrightnessClampingForModes()) {
            ZenModeConfig.writeFloatIfNotNull(out, DEVICE_EFFECT_CAP_BRIGHTNESS, deviceEffects.getBrightnessPercentageCap());
        }
        ZenModeConfig.writeStringSet(out, DEVICE_EFFECT_EXTRAS, deviceEffects.getExtraEffects());
    }

    private static void writeBooleanIfTrue(TypedXmlSerializer out, String att, boolean value) throws IOException {
        if (value) {
            out.attributeBoolean(null, att, true);
        }
    }

    private static void writeFloatIfNotNull(TypedXmlSerializer out, String att, @Nullable Float value) throws IOException {
        if (value != null) {
            out.attributeFloat(null, att, value.floatValue());
        }
    }

    private static void writeStringSet(TypedXmlSerializer out, String att, Set<String> values) throws IOException {
        if (values.isEmpty()) {
            return;
        }
        ArrayList<String> escapedItems = new ArrayList<String>();
        for (String item : values) {
            escapedItems.add(item.replace(ITEM_SEPARATOR_ESCAPE, "\\\\").replace(ITEM_SEPARATOR, "\\,"));
        }
        String serialized = String.join((CharSequence)ITEM_SEPARATOR, escapedItems);
        out.attribute(null, att, serialized);
    }

    public static boolean isValidHour(int val) {
        return val >= 0 && val < 24;
    }

    public static boolean isValidMinute(int val) {
        return val >= 0 && val < 60;
    }

    private static boolean isValidSource(int source) {
        return source >= 0 && source <= 2;
    }

    private static Boolean unsafeBoolean(TypedXmlPullParser parser, String att) {
        try {
            return parser.getAttributeBoolean(null, att);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static boolean safeBoolean(TypedXmlPullParser parser, String att, boolean defValue) {
        return parser.getAttributeBoolean(null, att, defValue);
    }

    private static boolean safeBoolean(String val, boolean defValue) {
        if (TextUtils.isEmpty(val)) {
            return defValue;
        }
        return Boolean.parseBoolean(val);
    }

    private static int safeInt(TypedXmlPullParser parser, String att, int defValue) {
        return parser.getAttributeInt(null, att, defValue);
    }

    @Nullable
    private static Float unsafeFloat(TypedXmlPullParser parser, String att) {
        try {
            return Float.valueOf(parser.getAttributeFloat(null, att));
        }
        catch (Exception e) {
            return null;
        }
    }

    private static ComponentName safeComponentName(TypedXmlPullParser parser, String att) {
        String val = parser.getAttributeValue(null, att);
        if (TextUtils.isEmpty(val)) {
            return null;
        }
        return ComponentName.unflattenFromString(val);
    }

    private static Uri safeUri(TypedXmlPullParser parser, String att) {
        String val = parser.getAttributeValue(null, att);
        if (val == null) {
            return null;
        }
        return Uri.parse(val);
    }

    private static long safeLong(TypedXmlPullParser parser, String att, long defValue) {
        String val = parser.getAttributeValue(null, att);
        return ZenModeConfig.tryParseLong(val, defValue);
    }

    @NonNull
    private static Set<String> safeStringSet(TypedXmlPullParser parser, String att) {
        HashSet<String> values = new HashSet<String>();
        String serialized = parser.getAttributeValue(null, att);
        if (!TextUtils.isEmpty(serialized)) {
            String[] escapedItems;
            for (String escapedItem : escapedItems = ITEM_SPLITTER_REGEX.split(serialized)) {
                values.add(escapedItem.replace("\\\\", ITEM_SEPARATOR_ESCAPE).replace("\\,", ITEM_SEPARATOR));
            }
        }
        return values;
    }

    @Nullable
    private static Instant safeInstant(TypedXmlPullParser parser, String att, @Nullable Instant defValue) {
        Long longValue;
        String strValue = parser.getAttributeValue(null, att);
        if (!TextUtils.isEmpty(strValue) && (longValue = ZenModeConfig.tryParseLong(strValue, null)) != null) {
            return Instant.ofEpochMilli(longValue);
        }
        return defValue;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public ZenModeConfig copy() {
        Parcel parcel = Parcel.obtain();
        try {
            this.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            ZenModeConfig zenModeConfig = new ZenModeConfig(parcel);
            return zenModeConfig;
        }
        finally {
            parcel.recycle();
        }
    }

    public ZenPolicy getZenPolicy() {
        return this.manualRule.zenPolicy;
    }

    private ZenPolicy toZenPolicyForXmlUpgrade() {
        ZenPolicy.Builder builder = new ZenPolicy.Builder().allowCalls(this.allowCalls ? ZenAdapters.prioritySendersToPeopleType(this.allowCallsFrom) : 4).allowRepeatCallers(this.allowRepeatCallers).allowMessages(this.allowMessages ? ZenAdapters.prioritySendersToPeopleType(this.allowMessagesFrom) : 4).allowReminders(this.allowReminders).allowEvents(this.allowEvents).allowAlarms(this.allowAlarms).allowMedia(this.allowMedia).allowSystem(this.allowSystem).allowConversations(this.allowConversations ? this.allowConversationsFrom : 3);
        if (this.suppressedVisualEffects == 0) {
            builder.showAllVisualEffects();
        } else {
            builder.showFullScreenIntent((this.suppressedVisualEffects & 4) == 0);
            builder.showLights((this.suppressedVisualEffects & 8) == 0);
            builder.showPeeking((this.suppressedVisualEffects & 0x10) == 0);
            builder.showStatusBarIcons((this.suppressedVisualEffects & 0x20) == 0);
            builder.showBadges((this.suppressedVisualEffects & 0x40) == 0);
            builder.showInAmbientDisplay((this.suppressedVisualEffects & 0x80) == 0);
            builder.showInNotificationList((this.suppressedVisualEffects & 0x100) == 0);
        }
        builder.allowPriorityChannels(this.allowPriorityChannels);
        return builder.build();
    }

    public NotificationManager.Policy toNotificationPolicy(ZenPolicy zenPolicy) {
        boolean suppressAmbient;
        NotificationManager.Policy defaultPolicy = this.toNotificationPolicy();
        int priorityCategories = 0;
        int suppressedVisualEffects = 0;
        int callSenders = defaultPolicy.priorityCallSenders;
        int messageSenders = defaultPolicy.priorityMessageSenders;
        int conversationSenders = defaultPolicy.priorityConversationSenders;
        if (zenPolicy.isCategoryAllowed(0, this.isPriorityCategoryEnabled(1, defaultPolicy))) {
            priorityCategories |= 1;
        }
        if (zenPolicy.isCategoryAllowed(1, this.isPriorityCategoryEnabled(2, defaultPolicy))) {
            priorityCategories |= 2;
        }
        if (zenPolicy.isCategoryAllowed(2, this.isPriorityCategoryEnabled(4, defaultPolicy))) {
            priorityCategories |= 4;
            messageSenders = ZenAdapters.peopleTypeToPrioritySenders(zenPolicy.getPriorityMessageSenders(), messageSenders);
        }
        if (zenPolicy.isCategoryAllowed(8, this.isPriorityCategoryEnabled(256, defaultPolicy))) {
            priorityCategories |= 0x100;
            conversationSenders = ZenAdapters.zenPolicyConversationSendersToNotificationPolicy(zenPolicy.getPriorityConversationSenders(), conversationSenders);
        } else {
            conversationSenders = 3;
        }
        if (zenPolicy.isCategoryAllowed(3, this.isPriorityCategoryEnabled(8, defaultPolicy))) {
            priorityCategories |= 8;
            callSenders = ZenAdapters.peopleTypeToPrioritySenders(zenPolicy.getPriorityCallSenders(), callSenders);
        }
        if (zenPolicy.isCategoryAllowed(4, this.isPriorityCategoryEnabled(16, defaultPolicy))) {
            priorityCategories |= 0x10;
        }
        if (zenPolicy.isCategoryAllowed(5, this.isPriorityCategoryEnabled(32, defaultPolicy))) {
            priorityCategories |= 0x20;
        }
        if (zenPolicy.isCategoryAllowed(6, this.isPriorityCategoryEnabled(64, defaultPolicy))) {
            priorityCategories |= 0x40;
        }
        if (zenPolicy.isCategoryAllowed(7, this.isPriorityCategoryEnabled(128, defaultPolicy))) {
            priorityCategories |= 0x80;
        }
        boolean suppressFullScreenIntent = !zenPolicy.isVisualEffectAllowed(0, this.isVisualEffectAllowed(4, defaultPolicy));
        boolean suppressLights = !zenPolicy.isVisualEffectAllowed(1, this.isVisualEffectAllowed(8, defaultPolicy));
        boolean bl = suppressAmbient = !zenPolicy.isVisualEffectAllowed(5, this.isVisualEffectAllowed(128, defaultPolicy));
        if (suppressFullScreenIntent && suppressLights && suppressAmbient) {
            suppressedVisualEffects |= 1;
        }
        if (suppressFullScreenIntent) {
            suppressedVisualEffects |= 4;
        }
        if (suppressLights) {
            suppressedVisualEffects |= 8;
        }
        if (!zenPolicy.isVisualEffectAllowed(2, this.isVisualEffectAllowed(16, defaultPolicy))) {
            suppressedVisualEffects |= 0x10;
            suppressedVisualEffects |= 2;
        }
        if (!zenPolicy.isVisualEffectAllowed(3, this.isVisualEffectAllowed(32, defaultPolicy))) {
            suppressedVisualEffects |= 0x20;
        }
        if (!zenPolicy.isVisualEffectAllowed(4, this.isVisualEffectAllowed(64, defaultPolicy))) {
            suppressedVisualEffects |= 0x40;
        }
        if (suppressAmbient) {
            suppressedVisualEffects |= 0x80;
        }
        if (!zenPolicy.isVisualEffectAllowed(6, this.isVisualEffectAllowed(256, defaultPolicy))) {
            suppressedVisualEffects |= 0x100;
        }
        int state = NotificationManager.Policy.policyState(defaultPolicy.hasPriorityChannels(), ZenPolicy.stateToBoolean(zenPolicy.getPriorityChannelsAllowed(), true));
        return new NotificationManager.Policy(priorityCategories, callSenders, messageSenders, suppressedVisualEffects, state, conversationSenders);
    }

    private boolean isPriorityCategoryEnabled(int categoryType, NotificationManager.Policy policy) {
        return (policy.priorityCategories & categoryType) != 0;
    }

    private boolean isVisualEffectAllowed(int visualEffect, NotificationManager.Policy policy) {
        return (policy.suppressedVisualEffects & visualEffect) == 0;
    }

    private boolean isVisualEffectAllowed(int suppressedVisualEffects, int visualEffect) {
        return (suppressedVisualEffects & visualEffect) == 0;
    }

    public NotificationManager.Policy toNotificationPolicy() {
        boolean suppressAmbient;
        int priorityCategories = 0;
        int priorityCallSenders = 1;
        int priorityMessageSenders = 1;
        int priorityConversationSenders = 2;
        int state = 0;
        int suppressedVisualEffects = 0;
        if (this.manualRule.zenPolicy.isCategoryAllowed(1, false)) {
            priorityCategories |= 2;
        }
        if (this.manualRule.zenPolicy.isCategoryAllowed(0, false)) {
            priorityCategories |= 1;
        }
        if (this.manualRule.zenPolicy.isCategoryAllowed(4, false)) {
            priorityCategories |= 0x10;
        }
        if (this.manualRule.zenPolicy.isCategoryAllowed(5, false)) {
            priorityCategories |= 0x20;
        }
        if (this.manualRule.zenPolicy.isCategoryAllowed(6, false)) {
            priorityCategories |= 0x40;
        }
        if (this.manualRule.zenPolicy.isCategoryAllowed(7, false)) {
            priorityCategories |= 0x80;
        }
        if (this.manualRule.zenPolicy.getPriorityCategoryConversations() == 1) {
            priorityCategories |= 0x100;
        }
        priorityConversationSenders = ZenAdapters.zenPolicyConversationSendersToNotificationPolicy(this.manualRule.zenPolicy.getPriorityConversationSenders(), 3);
        if (this.manualRule.zenPolicy.getPriorityCategoryCalls() == 1) {
            priorityCategories |= 8;
        }
        priorityCallSenders = ZenAdapters.peopleTypeToPrioritySenders(this.manualRule.zenPolicy.getPriorityCallSenders(), 2);
        if (this.manualRule.zenPolicy.getPriorityCategoryMessages() == 1) {
            priorityCategories |= 4;
        }
        priorityMessageSenders = ZenAdapters.peopleTypeToPrioritySenders(this.manualRule.zenPolicy.getPriorityMessageSenders(), 2);
        state = NotificationManager.Policy.policyState(this.hasPriorityChannels, this.manualRule.zenPolicy.getPriorityChannelsAllowed() != 2);
        boolean suppressFullScreenIntent = !this.manualRule.zenPolicy.isVisualEffectAllowed(0, this.isVisualEffectAllowed(157, 0));
        boolean suppressLights = !this.manualRule.zenPolicy.isVisualEffectAllowed(1, this.isVisualEffectAllowed(157, 1));
        boolean bl = suppressAmbient = !this.manualRule.zenPolicy.isVisualEffectAllowed(5, this.isVisualEffectAllowed(157, 5));
        if (suppressFullScreenIntent && suppressLights && suppressAmbient) {
            suppressedVisualEffects |= 1;
        }
        if (suppressFullScreenIntent) {
            suppressedVisualEffects |= 4;
        }
        if (suppressLights) {
            suppressedVisualEffects |= 8;
        }
        if (!this.manualRule.zenPolicy.isVisualEffectAllowed(2, this.isVisualEffectAllowed(157, 2))) {
            suppressedVisualEffects |= 0x10;
            suppressedVisualEffects |= 2;
        }
        if (!this.manualRule.zenPolicy.isVisualEffectAllowed(3, this.isVisualEffectAllowed(157, 3))) {
            suppressedVisualEffects |= 0x20;
        }
        if (!this.manualRule.zenPolicy.isVisualEffectAllowed(4, this.isVisualEffectAllowed(157, 4))) {
            suppressedVisualEffects |= 0x40;
        }
        if (suppressAmbient) {
            suppressedVisualEffects |= 0x80;
        }
        if (!this.manualRule.zenPolicy.isVisualEffectAllowed(6, this.isVisualEffectAllowed(157, 6))) {
            suppressedVisualEffects |= 0x100;
        }
        suppressedVisualEffects &= 0xFFFFFFFC;
        return new NotificationManager.Policy(priorityCategories, priorityCallSenders, priorityMessageSenders, suppressedVisualEffects |= 3 & this.manualRule.legacySuppressedEffects, state, priorityConversationSenders);
    }

    public static ScheduleCalendar toScheduleCalendar(Uri conditionId) {
        ScheduleInfo schedule = ZenModeConfig.tryParseScheduleConditionId(conditionId);
        if (schedule == null || schedule.days == null || schedule.days.length == 0) {
            return null;
        }
        ScheduleCalendar sc = new ScheduleCalendar();
        sc.setSchedule(schedule);
        sc.setTimeZone(TimeZone.getDefault());
        return sc;
    }

    private static int sourceToPrioritySenders(int source, int def) {
        switch (source) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return def;
    }

    private static int normalizePrioritySenders(int prioritySenders, int def) {
        if (prioritySenders != 1 && prioritySenders != 2 && prioritySenders != 0) {
            return def;
        }
        return prioritySenders;
    }

    private static int normalizeConversationSenders(boolean allowed, int senders, int def) {
        if (!allowed) {
            return 3;
        }
        if (senders != 1 && senders != 2 && senders != 3) {
            return def;
        }
        return senders;
    }

    public void applyNotificationPolicy(NotificationManager.Policy policy) {
        if (policy == null) {
            return;
        }
        this.manualRule.zenPolicy = ZenAdapters.notificationPolicyToZenPolicy(policy);
        this.manualRule.legacySuppressedEffects = 3 & policy.suppressedVisualEffects;
        if (policy.state != -1) {
            this.hasPriorityChannels = (policy.state & 1) != 0;
        }
    }

    public static Condition toTimeCondition(Context context, int minutesFromNow, int userHandle) {
        return ZenModeConfig.toTimeCondition(context, minutesFromNow, userHandle, false);
    }

    public static Condition toTimeCondition(Context context, int minutesFromNow, int userHandle, boolean shortVersion) {
        long now = System_Delegate.currentTimeMillis();
        long millis = minutesFromNow == 0 ? 10000L : (long)(minutesFromNow * 60000);
        return ZenModeConfig.toTimeCondition(context, now + millis, minutesFromNow, userHandle, shortVersion);
    }

    public static Condition toTimeCondition(Context context, long time, int minutes, int userHandle, boolean shortVersion) {
        String line2;
        String line1;
        String summary;
        int summaryResId;
        CharSequence formattedTime = ZenModeConfig.getFormattedTime(context, time, ZenModeConfig.isToday(time), userHandle);
        Resources res = context.getResources();
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        if (minutes < 60) {
            int num = minutes;
            summaryResId = shortVersion ? 17042188 : 17042187;
            arguments.put("count", num);
            arguments.put("formattedTime", formattedTime);
            summary = PluralsMessageFormatter.format(res, arguments, summaryResId);
            int line1ResId = shortVersion ? 17042186 : 17042185;
            line1 = PluralsMessageFormatter.format(res, arguments, line1ResId);
            line2 = res.getString(17042202, formattedTime);
        } else if (minutes < 1440) {
            int num = Math.round((float)minutes / 60.0f);
            summaryResId = shortVersion ? 17042184 : 17042183;
            arguments.put("count", num);
            arguments.put("formattedTime", formattedTime);
            summary = PluralsMessageFormatter.format(res, arguments, summaryResId);
            int line1ResId = shortVersion ? 17042182 : 17042181;
            line1 = PluralsMessageFormatter.format(res, arguments, line1ResId);
            line2 = res.getString(17042202, formattedTime);
        } else {
            line1 = line2 = res.getString(17042203, formattedTime);
            summary = line2;
        }
        Uri id2 = ZenModeConfig.toCountdownConditionId(time, false);
        return new Condition(id2, summary, line1, line2, 0, 1, 1);
    }

    public static Condition toNextAlarmCondition(Context context, long alarm, int userHandle) {
        boolean isSameDay = ZenModeConfig.isToday(alarm);
        CharSequence formattedTime = ZenModeConfig.getFormattedTime(context, alarm, isSameDay, userHandle);
        Resources res = context.getResources();
        String line1 = res.getString(17042202, formattedTime);
        Uri id2 = ZenModeConfig.toCountdownConditionId(alarm, true);
        return new Condition(id2, "", line1, "", 0, 1, 1);
    }

    public static CharSequence getFormattedTime(Context context, long time, boolean isSameDay, int userHandle) {
        String skeleton = (!isSameDay ? "EEE " : "") + (DateFormat.is24HourFormat(context, userHandle) ? "Hm" : "hma");
        String pattern = DateFormat.getBestDateTimePattern(AndroidLocale.getDefault(), skeleton);
        return DateFormat.format((CharSequence)pattern, time);
    }

    public static boolean isToday(long time) {
        GregorianCalendar now = new GregorianCalendar();
        GregorianCalendar endTime = new GregorianCalendar();
        endTime.setTimeInMillis(time);
        return now.get(1) == endTime.get(1) && now.get(2) == endTime.get(2) && now.get(5) == endTime.get(5);
    }

    public static Uri toCountdownConditionId(long time, boolean alarm) {
        return new Uri.Builder().scheme("condition").authority(SYSTEM_AUTHORITY).appendPath(COUNTDOWN_PATH).appendPath(Long.toString(time)).appendPath(IS_ALARM_PATH).appendPath(Boolean.toString(alarm)).build();
    }

    public static long tryParseCountdownConditionId(Uri conditionId) {
        if (!Condition.isValidId(conditionId, SYSTEM_AUTHORITY)) {
            return 0L;
        }
        if (conditionId.getPathSegments().size() < 2 || !COUNTDOWN_PATH.equals(conditionId.getPathSegments().get(0))) {
            return 0L;
        }
        try {
            return Long.parseLong(conditionId.getPathSegments().get(1));
        }
        catch (RuntimeException e) {
            Slog.w(TAG, "Error parsing countdown condition: " + conditionId, e);
            return 0L;
        }
    }

    public static boolean isValidCountdownConditionId(Uri conditionId) {
        return ZenModeConfig.tryParseCountdownConditionId(conditionId) != 0L;
    }

    public static boolean isValidCountdownToAlarmConditionId(Uri conditionId) {
        if (ZenModeConfig.tryParseCountdownConditionId(conditionId) != 0L) {
            if (conditionId.getPathSegments().size() < 4 || !IS_ALARM_PATH.equals(conditionId.getPathSegments().get(2))) {
                return false;
            }
            try {
                return Boolean.parseBoolean(conditionId.getPathSegments().get(3));
            }
            catch (RuntimeException e) {
                Slog.w(TAG, "Error parsing countdown alarm condition: " + conditionId, e);
                return false;
            }
        }
        return false;
    }

    public static Uri toScheduleConditionId(ScheduleInfo schedule) {
        return new Uri.Builder().scheme("condition").authority(SYSTEM_AUTHORITY).appendPath(SCHEDULE_PATH).appendQueryParameter("days", ZenModeConfig.toDayList(schedule.days)).appendQueryParameter("start", schedule.startHour + "." + schedule.startMinute).appendQueryParameter("end", schedule.endHour + "." + schedule.endMinute).appendQueryParameter("exitAtAlarm", String.valueOf(schedule.exitAtAlarm)).build();
    }

    public static boolean isValidScheduleConditionId(Uri conditionId) {
        ScheduleInfo info;
        try {
            info = ZenModeConfig.tryParseScheduleConditionId(conditionId);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            return false;
        }
        return info != null && info.days != null && info.days.length != 0;
    }

    public static boolean isValidScheduleConditionId(Uri conditionId, boolean allowNever) {
        ScheduleInfo info;
        try {
            info = ZenModeConfig.tryParseScheduleConditionId(conditionId);
        }
        catch (ArrayIndexOutOfBoundsException | NullPointerException e) {
            return false;
        }
        return info != null && (allowNever || info.days != null && info.days.length != 0);
    }

    @UnsupportedAppUsage
    @Nullable
    public static ScheduleInfo tryParseScheduleConditionId(Uri conditionId) {
        boolean isSchedule;
        boolean bl = isSchedule = conditionId != null && "condition".equals(conditionId.getScheme()) && SYSTEM_AUTHORITY.equals(conditionId.getAuthority()) && conditionId.getPathSegments().size() == 1 && SCHEDULE_PATH.equals(conditionId.getPathSegments().get(0));
        if (!isSchedule) {
            return null;
        }
        int[] start = ZenModeConfig.tryParseHourAndMinute(conditionId.getQueryParameter("start"));
        int[] end = ZenModeConfig.tryParseHourAndMinute(conditionId.getQueryParameter("end"));
        if (start == null || end == null) {
            return null;
        }
        ScheduleInfo rt = new ScheduleInfo();
        rt.days = ZenModeConfig.tryParseDayList(conditionId.getQueryParameter("days"), "\\.");
        rt.startHour = start[0];
        rt.startMinute = start[1];
        rt.endHour = end[0];
        rt.endMinute = end[1];
        rt.exitAtAlarm = ZenModeConfig.safeBoolean(conditionId.getQueryParameter("exitAtAlarm"), false);
        return rt;
    }

    public static ComponentName getScheduleConditionProvider() {
        return new ComponentName(SYSTEM_AUTHORITY, "ScheduleConditionProvider");
    }

    public static Uri toEventConditionId(EventInfo event) {
        return new Uri.Builder().scheme("condition").authority(SYSTEM_AUTHORITY).appendPath(EVENT_PATH).appendQueryParameter("userId", Long.toString(event.userId)).appendQueryParameter("calendar", event.calName != null ? event.calName : "").appendQueryParameter("calendarId", event.calendarId != null ? ((Object)event.calendarId).toString() : "").appendQueryParameter("reply", Integer.toString(event.reply)).build();
    }

    public static boolean isValidEventConditionId(Uri conditionId) {
        return ZenModeConfig.tryParseEventConditionId(conditionId) != null;
    }

    @Nullable
    public static EventInfo tryParseEventConditionId(Uri conditionId) {
        boolean isEvent;
        boolean bl = isEvent = conditionId != null && "condition".equals(conditionId.getScheme()) && SYSTEM_AUTHORITY.equals(conditionId.getAuthority()) && conditionId.getPathSegments().size() == 1 && EVENT_PATH.equals(conditionId.getPathSegments().get(0));
        if (!isEvent) {
            return null;
        }
        EventInfo rt = new EventInfo();
        rt.userId = ZenModeConfig.tryParseInt(conditionId.getQueryParameter("userId"), -10000);
        rt.calName = conditionId.getQueryParameter("calendar");
        if (TextUtils.isEmpty(rt.calName)) {
            rt.calName = null;
        }
        rt.calendarId = ZenModeConfig.tryParseLong(conditionId.getQueryParameter("calendarId"), null);
        rt.reply = ZenModeConfig.tryParseInt(conditionId.getQueryParameter("reply"), 0);
        return rt;
    }

    public static ComponentName getEventConditionProvider() {
        return new ComponentName(SYSTEM_AUTHORITY, "EventConditionProvider");
    }

    public static Uri toCustomManualConditionId() {
        return CUSTOM_MANUAL_CONDITION_ID;
    }

    public static boolean isValidCustomManualConditionId(Uri conditionId) {
        return CUSTOM_MANUAL_CONDITION_ID.equals(conditionId);
    }

    public static ComponentName getCustomManualConditionProvider() {
        return new ComponentName(SYSTEM_AUTHORITY, "CustomManualConditionProvider");
    }

    public static String implicitRuleId(String forPackage) {
        return IMPLICIT_RULE_ID_PREFIX + forPackage;
    }

    public static boolean isImplicitRuleId(@NonNull String ruleId) {
        return ruleId != null && ruleId.startsWith(IMPLICIT_RULE_ID_PREFIX);
    }

    private static int[] tryParseHourAndMinute(String value) {
        int[] nArray;
        if (TextUtils.isEmpty(value)) {
            return null;
        }
        int i = value.indexOf(46);
        if (i < 1 || i >= value.length() - 1) {
            return null;
        }
        int hour = ZenModeConfig.tryParseInt(value.substring(0, i), -1);
        int minute = ZenModeConfig.tryParseInt(value.substring(i + 1), -1);
        if (ZenModeConfig.isValidHour(hour) && ZenModeConfig.isValidMinute(minute)) {
            int[] nArray2 = new int[2];
            nArray2[0] = hour;
            nArray = nArray2;
            nArray2[1] = minute;
        } else {
            nArray = null;
        }
        return nArray;
    }

    private static int tryParseZenMode(String value, int defValue) {
        int rt = ZenModeConfig.tryParseInt(value, defValue);
        return Settings.Global.isValidZenMode(rt) ? rt : defValue;
    }

    public static String newRuleId() {
        return ((Object)UUID.randomUUID()).toString().replace("-", "");
    }

    public static String getOwnerCaption(Context context, String owner) {
        PackageManager pm = context.getPackageManager();
        try {
            String str;
            CharSequence seq;
            ApplicationInfo info = pm.getApplicationInfo(owner, 0);
            if (info != null && (seq = info.loadLabel(pm)) != null && (str = seq.toString().trim()).length() > 0) {
                return str;
            }
        }
        catch (Throwable e) {
            Slog.w(TAG, "Error loading owner caption", e);
        }
        return "";
    }

    public boolean isManualActive() {
        return this.manualRule != null && this.manualRule.isActive();
    }

    public static boolean areAllPriorityOnlyRingerSoundsMuted(NotificationManager.Policy policy) {
        boolean allowReminders = (policy.priorityCategories & 1) != 0;
        boolean allowCalls = (policy.priorityCategories & 8) != 0;
        boolean allowMessages = (policy.priorityCategories & 4) != 0;
        boolean allowEvents = (policy.priorityCategories & 2) != 0;
        boolean allowRepeatCallers = (policy.priorityCategories & 0x10) != 0;
        boolean allowConversations = (policy.priorityConversationSenders & 0x100) != 0;
        boolean areChannelsBypassingDnd = policy.hasPriorityChannels() && policy.allowPriorityChannels();
        boolean allowSystem = (policy.priorityCategories & 0x80) != 0;
        return !allowReminders && !allowCalls && !allowMessages && !allowEvents && !allowRepeatCallers && !areChannelsBypassingDnd && !allowSystem && !allowConversations;
    }

    public static boolean areAllZenBehaviorSoundsMuted(NotificationManager.Policy policy) {
        boolean allowAlarms = (policy.priorityCategories & 0x20) != 0;
        boolean allowMedia = (policy.priorityCategories & 0x40) != 0;
        return !allowAlarms && !allowMedia && ZenModeConfig.areAllPriorityOnlyRingerSoundsMuted(policy);
    }

    public static boolean isZenOverridingRinger(int zen, NotificationManager.Policy consolidatedPolicy) {
        return zen == 2 || zen == 3 || zen == 1 && ZenModeConfig.areAllPriorityOnlyRingerSoundsMuted(consolidatedPolicy);
    }

    public static boolean areAllPriorityOnlyRingerSoundsMuted(ZenModeConfig config) {
        ZenPolicy policy = config.manualRule.zenPolicy;
        return !policy.isCategoryAllowed(0, false) && !policy.isCategoryAllowed(3, false) && !policy.isCategoryAllowed(2, false) && !policy.isCategoryAllowed(1, false) && !policy.isCategoryAllowed(4, false) && !policy.isCategoryAllowed(7, false) && (!config.hasPriorityChannels || policy.getPriorityChannelsAllowed() != 1);
    }

    public static boolean areAllZenBehaviorSoundsMuted(ZenModeConfig config) {
        ZenPolicy policy = config.manualRule.zenPolicy;
        return !policy.isCategoryAllowed(5, false) && !policy.isCategoryAllowed(6, false) && ZenModeConfig.areAllPriorityOnlyRingerSoundsMuted(config);
    }

    private static long parseAutomaticRuleEndTime(Context context, Uri id2) {
        if (ZenModeConfig.isValidEventConditionId(id2)) {
            return Long.MAX_VALUE;
        }
        if (ZenModeConfig.isValidScheduleConditionId(id2)) {
            ScheduleCalendar schedule = ZenModeConfig.toScheduleCalendar(id2);
            long endTimeMs = schedule.getNextChangeTime(System_Delegate.currentTimeMillis());
            if (schedule.exitAtAlarm()) {
                long nextAlarm = ZenModeConfig.getNextAlarm(context);
                schedule.maybeSetNextAlarm(System_Delegate.currentTimeMillis(), nextAlarm);
                if (schedule.shouldExitForAlarm(endTimeMs)) {
                    return nextAlarm;
                }
            }
            return endTimeMs;
        }
        return -1L;
    }

    private static long getNextAlarm(Context context) {
        AlarmManager alarms = (AlarmManager)context.getSystemService(IS_ALARM_PATH);
        AlarmManager.AlarmClockInfo info = alarms.getNextAlarmClock(context.getUserId());
        return info != null ? info.getTriggerTime() : 0L;
    }

    public static class ZenRule
    implements Parcelable {
        public static final int OVERRIDE_NONE = 0;
        public static final int OVERRIDE_ACTIVATE = 1;
        public static final int OVERRIDE_DEACTIVATE = 2;
        @UnsupportedAppUsage
        public boolean enabled;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public String name;
        @UnsupportedAppUsage
        public int zenMode;
        @UnsupportedAppUsage
        public Uri conditionId;
        public Condition condition;
        public ComponentName component;
        public ComponentName configurationActivity;
        public String id;
        @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
        public long creationTime;
        public String enabler;
        public ZenPolicy zenPolicy;
        @Nullable
        public ZenDeviceEffects zenDeviceEffects;
        public String pkg;
        public int type = -1;
        public String triggerDescription;
        @Nullable
        public String iconResName;
        public boolean allowManualInvocation;
        public int userModifiedFields;
        public int zenPolicyUserModifiedFields;
        public int zenDeviceEffectsUserModifiedFields;
        @Nullable
        public Instant deletionInstant;
        public int disabledOrigin = 0;
        int legacySuppressedEffects;
        int conditionOverride = 0;
        @Nullable
        public Instant lastActivation;
        @Nullable
        public Instant lastManualActivation;
        @Nullable
        public Instant lastDeactivation;
        @Nullable
        public Instant lastManualDeactivation;
        @NonNull
        public static final Parcelable.Creator<ZenRule> CREATOR = new Parcelable.Creator<ZenRule>(){

            @Override
            public ZenRule createFromParcel(Parcel source) {
                return new ZenRule(source);
            }

            public ZenRule[] newArray(int size) {
                return new ZenRule[size];
            }
        };

        public ZenRule() {
        }

        public ZenRule(Parcel source) {
            boolean bl = this.enabled = source.readInt() == 1;
            if (source.readInt() == 1) {
                this.name = source.readString8();
            }
            this.zenMode = source.readInt();
            this.conditionId = source.readParcelable(null, Uri.class);
            this.condition = source.readParcelable(null, Condition.class);
            this.component = source.readParcelable(null, ComponentName.class);
            this.configurationActivity = source.readParcelable(null, ComponentName.class);
            if (source.readInt() == 1) {
                this.id = source.readString8();
            }
            this.creationTime = source.readLong();
            if (source.readInt() == 1) {
                this.enabler = source.readString8();
            }
            this.zenPolicy = source.readParcelable(null, ZenPolicy.class);
            this.zenDeviceEffects = source.readParcelable(null, ZenDeviceEffects.class);
            this.pkg = source.readString8();
            this.allowManualInvocation = source.readBoolean();
            this.iconResName = source.readString8();
            this.triggerDescription = source.readString8();
            this.type = source.readInt();
            this.userModifiedFields = source.readInt();
            this.zenPolicyUserModifiedFields = source.readInt();
            this.zenDeviceEffectsUserModifiedFields = source.readInt();
            if (source.readInt() == 1) {
                this.deletionInstant = Instant.ofEpochMilli(source.readLong());
            }
            this.disabledOrigin = source.readInt();
            this.legacySuppressedEffects = source.readInt();
            this.conditionOverride = source.readInt();
            if (source.readInt() == 1) {
                this.lastActivation = Instant.ofEpochMilli(source.readLong());
            }
            if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.modesUiTileReactivatesLast()) {
                if (source.readInt() == 1) {
                    this.lastManualActivation = Instant.ofEpochMilli(source.readLong());
                }
                if (source.readInt() == 1) {
                    this.lastDeactivation = Instant.ofEpochMilli(source.readLong());
                }
                if (source.readInt() == 1) {
                    this.lastManualDeactivation = Instant.ofEpochMilli(source.readLong());
                }
            }
        }

        public boolean isUserModified() {
            return this.userModifiedFields != 0 || this.zenPolicyUserModifiedFields != 0 || this.zenDeviceEffectsUserModifiedFields != 0;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(Parcel dest, int flags) {
            dest.writeInt(this.enabled ? 1 : 0);
            if (this.name != null) {
                dest.writeInt(1);
                dest.writeString8(this.name);
            } else {
                dest.writeInt(0);
            }
            dest.writeInt(this.zenMode);
            dest.writeParcelable(this.conditionId, 0);
            dest.writeParcelable(this.condition, 0);
            dest.writeParcelable(this.component, 0);
            dest.writeParcelable(this.configurationActivity, 0);
            if (this.id != null) {
                dest.writeInt(1);
                dest.writeString8(this.id);
            } else {
                dest.writeInt(0);
            }
            dest.writeLong(this.creationTime);
            if (this.enabler != null) {
                dest.writeInt(1);
                dest.writeString8(this.enabler);
            } else {
                dest.writeInt(0);
            }
            dest.writeParcelable(this.zenPolicy, 0);
            dest.writeParcelable(this.zenDeviceEffects, 0);
            dest.writeString8(this.pkg);
            dest.writeBoolean(this.allowManualInvocation);
            dest.writeString8(this.iconResName);
            dest.writeString8(this.triggerDescription);
            dest.writeInt(this.type);
            dest.writeInt(this.userModifiedFields);
            dest.writeInt(this.zenPolicyUserModifiedFields);
            dest.writeInt(this.zenDeviceEffectsUserModifiedFields);
            ZenRule.writeInstantToParcel(dest, this.deletionInstant);
            dest.writeInt(this.disabledOrigin);
            dest.writeInt(this.legacySuppressedEffects);
            dest.writeInt(this.conditionOverride);
            ZenRule.writeInstantToParcel(dest, this.lastActivation);
            if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.modesUiTileReactivatesLast()) {
                ZenRule.writeInstantToParcel(dest, this.lastManualActivation);
                ZenRule.writeInstantToParcel(dest, this.lastDeactivation);
                ZenRule.writeInstantToParcel(dest, this.lastManualDeactivation);
            }
        }

        private static void writeInstantToParcel(Parcel dest, @Nullable Instant instant) {
            if (instant != null) {
                dest.writeInt(1);
                dest.writeLong(instant.toEpochMilli());
            } else {
                dest.writeInt(0);
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(ZenRule.class.getSimpleName()).append('[').append("id=").append(this.id).append(",state=").append(this.condition == null ? "STATE_FALSE" : Condition.stateToString(this.condition.state)).append(",enabled=").append(String.valueOf(this.enabled).toUpperCase()).append(",conditionOverride=").append(ZenRule.conditionOverrideToString(this.conditionOverride)).append(",name=").append(this.name).append(",zenMode=").append(Settings.Global.zenModeToString(this.zenMode)).append(",conditionId=").append(this.conditionId).append(",pkg=").append(this.pkg).append(",component=").append(this.component).append(",configActivity=").append(this.configurationActivity).append(",creationTime=").append(this.creationTime).append(",enabler=").append(this.enabler).append(",zenPolicy=").append(this.zenPolicy).append(",condition=").append(this.condition).append(",deviceEffects=").append(this.zenDeviceEffects).append(",allowManualInvocation=").append(this.allowManualInvocation).append(",iconResName=").append(this.iconResName).append(",triggerDescription=").append(this.triggerDescription).append(",type=").append(this.type);
            if (this.userModifiedFields != 0) {
                sb.append(",userModifiedFields=").append(AutomaticZenRule.fieldsToString(this.userModifiedFields));
            }
            if (this.zenPolicyUserModifiedFields != 0) {
                sb.append(",zenPolicyUserModifiedFields=").append(ZenPolicy.fieldsToString(this.zenPolicyUserModifiedFields));
            }
            if (this.zenDeviceEffectsUserModifiedFields != 0) {
                sb.append(",zenDeviceEffectsUserModifiedFields=").append(ZenDeviceEffects.fieldsToString(this.zenDeviceEffectsUserModifiedFields));
            }
            if (this.deletionInstant != null) {
                sb.append(",deletionInstant=").append(this.deletionInstant);
            }
            sb.append(",disabledOrigin=").append(this.disabledOrigin);
            sb.append(",legacySuppressedEffects=").append(this.legacySuppressedEffects);
            sb.append(",lastActivation=").append(this.lastActivation);
            if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.modesUiTileReactivatesLast()) {
                sb.append(",lastManualActivation=").append(this.lastManualActivation);
                sb.append(",lastDeactivation=").append(this.lastDeactivation);
                sb.append(",lastManualDeactivation=").append(this.lastManualDeactivation);
            }
            return sb.append(']').toString();
        }

        private static String conditionOverrideToString(int value) {
            String string2;
            switch (value) {
                case 1: {
                    string2 = "OVERRIDE_ACTIVATE";
                    break;
                }
                case 2: {
                    string2 = "OVERRIDE_DEACTIVATE";
                    break;
                }
                case 0: {
                    string2 = "OVERRIDE_NONE";
                    break;
                }
                default: {
                    string2 = "UNKNOWN";
                }
            }
            return string2;
        }

        public void dumpDebug(ProtoOutputStream proto, long fieldId) {
            long token = proto.start(fieldId);
            proto.write(0x10900000001L, this.id);
            proto.write(1138166333442L, this.name);
            proto.write(0x10300000003L, this.creationTime);
            proto.write(1133871366148L, this.enabled);
            proto.write(1138166333445L, this.enabler);
            proto.write(1133871366150L, this.conditionOverride == 2);
            proto.write(1159641169927L, this.zenMode);
            if (this.conditionId != null) {
                proto.write(1138166333448L, this.conditionId.toString());
            }
            if (this.condition != null) {
                this.condition.dumpDebug(proto, 1146756268041L);
            }
            if (this.component != null) {
                this.component.dumpDebug(proto, 1146756268042L);
            }
            if (this.zenPolicy != null) {
                this.zenPolicy.dumpDebug(proto, 0x10B0000000BL);
            }
            proto.end(token);
        }

        public boolean equals(@Nullable Object o) {
            boolean finalEquals;
            if (!(o instanceof ZenRule)) {
                return false;
            }
            if (o == this) {
                return true;
            }
            ZenRule other = (ZenRule)o;
            boolean bl = finalEquals = other.enabled == this.enabled && Objects.equals(other.name, this.name) && other.zenMode == this.zenMode && Objects.equals(other.conditionId, this.conditionId) && Objects.equals(other.condition, this.condition) && Objects.equals(other.component, this.component) && Objects.equals(other.configurationActivity, this.configurationActivity) && Objects.equals(other.id, this.id) && Objects.equals(other.enabler, this.enabler) && Objects.equals(other.zenPolicy, this.zenPolicy) && Objects.equals(other.pkg, this.pkg) && Objects.equals(other.zenDeviceEffects, this.zenDeviceEffects) && other.allowManualInvocation == this.allowManualInvocation && Objects.equals(other.iconResName, this.iconResName) && Objects.equals(other.triggerDescription, this.triggerDescription) && other.type == this.type && other.userModifiedFields == this.userModifiedFields && other.zenPolicyUserModifiedFields == this.zenPolicyUserModifiedFields && other.zenDeviceEffectsUserModifiedFields == this.zenDeviceEffectsUserModifiedFields && Objects.equals(other.deletionInstant, this.deletionInstant) && other.disabledOrigin == this.disabledOrigin && other.legacySuppressedEffects == this.legacySuppressedEffects && other.conditionOverride == this.conditionOverride && Objects.equals(other.lastActivation, this.lastActivation);
            if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.modesUiTileReactivatesLast()) {
                finalEquals = finalEquals && Objects.equals(other.lastManualActivation, this.lastManualActivation) && Objects.equals(other.lastDeactivation, this.lastDeactivation) && Objects.equals(other.lastManualDeactivation, this.lastManualDeactivation);
            }
            return finalEquals;
        }

        public int hashCode() {
            if (com.android.internal.hidden_from_bootclasspath.android.app.Flags.modesUiTileReactivatesLast()) {
                return Objects.hash(this.enabled, this.name, this.zenMode, this.conditionId, this.condition, this.component, this.configurationActivity, this.pkg, this.id, this.enabler, this.zenPolicy, this.zenDeviceEffects, this.allowManualInvocation, this.iconResName, this.triggerDescription, this.type, this.userModifiedFields, this.zenPolicyUserModifiedFields, this.zenDeviceEffectsUserModifiedFields, this.deletionInstant, this.disabledOrigin, this.legacySuppressedEffects, this.conditionOverride, this.lastActivation, this.lastManualActivation, this.lastDeactivation, this.lastManualDeactivation);
            }
            return Objects.hash(this.enabled, this.name, this.zenMode, this.conditionId, this.condition, this.component, this.configurationActivity, this.pkg, this.id, this.enabler, this.zenPolicy, this.zenDeviceEffects, this.allowManualInvocation, this.iconResName, this.triggerDescription, this.type, this.userModifiedFields, this.zenPolicyUserModifiedFields, this.zenDeviceEffectsUserModifiedFields, this.deletionInstant, this.disabledOrigin, this.legacySuppressedEffects, this.conditionOverride, this.lastActivation);
        }

        public ZenRule copy() {
            Parcel parcel = Parcel.obtain();
            try {
                this.writeToParcel(parcel, 0);
                parcel.setDataPosition(0);
                ZenRule zenRule = new ZenRule(parcel);
                return zenRule;
            }
            finally {
                parcel.recycle();
            }
        }

        public boolean isActive() {
            if (!this.enabled || this.getPkg() == null) {
                return false;
            }
            if (this.conditionOverride == 1) {
                return true;
            }
            if (this.conditionOverride == 2) {
                return false;
            }
            return this.isTrueOrUnknown();
        }

        @VisibleForTesting(otherwise=5)
        public int getConditionOverride() {
            return this.conditionOverride;
        }

        public void setConditionOverride(int value) {
            this.conditionOverride = value;
        }

        public void resetConditionOverride() {
            this.setConditionOverride(0);
        }

        public void reconsiderConditionOverride() {
            if (this.conditionOverride == 1 && this.isTrueOrUnknown()) {
                this.resetConditionOverride();
            } else if (this.conditionOverride == 2 && !this.isTrueOrUnknown()) {
                this.resetConditionOverride();
            }
        }

        public String getPkg() {
            return !TextUtils.isEmpty(this.pkg) ? this.pkg : (this.component != null ? this.component.getPackageName() : (this.configurationActivity != null ? this.configurationActivity.getPackageName() : null));
        }

        public boolean isTrueOrUnknown() {
            return this.condition != null && (this.condition.state == 1 || this.condition.state == 2);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface ConditionOverride {
        }
    }

    public static class ScheduleInfo {
        @UnsupportedAppUsage
        public int[] days;
        @UnsupportedAppUsage
        public int startHour;
        @UnsupportedAppUsage
        public int startMinute;
        @UnsupportedAppUsage
        public int endHour;
        @UnsupportedAppUsage
        public int endMinute;
        public boolean exitAtAlarm;
        public long nextAlarm;

        public int hashCode() {
            return 0;
        }

        public boolean equals(@Nullable Object o) {
            if (!(o instanceof ScheduleInfo)) {
                return false;
            }
            ScheduleInfo other = (ScheduleInfo)o;
            return ZenModeConfig.toDayList(this.days).equals(ZenModeConfig.toDayList(other.days)) && this.startHour == other.startHour && this.startMinute == other.startMinute && this.endHour == other.endHour && this.endMinute == other.endMinute && this.exitAtAlarm == other.exitAtAlarm;
        }

        public ScheduleInfo copy() {
            ScheduleInfo rt = new ScheduleInfo();
            if (this.days != null) {
                rt.days = new int[this.days.length];
                System.arraycopy(this.days, 0, rt.days, 0, this.days.length);
            }
            rt.startHour = this.startHour;
            rt.startMinute = this.startMinute;
            rt.endHour = this.endHour;
            rt.endMinute = this.endMinute;
            rt.exitAtAlarm = this.exitAtAlarm;
            rt.nextAlarm = this.nextAlarm;
            return rt;
        }

        public String toString() {
            return "ScheduleInfo{days=" + Arrays.toString(this.days) + ", startHour=" + this.startHour + ", startMinute=" + this.startMinute + ", endHour=" + this.endHour + ", endMinute=" + this.endMinute + ", exitAtAlarm=" + this.exitAtAlarm + ", nextAlarm=" + ScheduleInfo.ts(this.nextAlarm) + '}';
        }

        protected static String ts(long time) {
            return new Date(time) + " (" + time + ")";
        }
    }

    public static class EventInfo {
        public static final int REPLY_ANY_EXCEPT_NO = 0;
        public static final int REPLY_YES_OR_MAYBE = 1;
        public static final int REPLY_YES = 2;
        public int userId = -10000;
        public String calName;
        @Nullable
        public Long calendarId;
        public int reply;

        public int hashCode() {
            return Objects.hash(this.userId, this.calName, this.calendarId, this.reply);
        }

        public boolean equals(@Nullable Object o) {
            if (!(o instanceof EventInfo)) {
                return false;
            }
            EventInfo other = (EventInfo)o;
            return this.userId == other.userId && Objects.equals(this.calName, other.calName) && this.reply == other.reply && Objects.equals(this.calendarId, other.calendarId);
        }

        public EventInfo copy() {
            EventInfo rt = new EventInfo();
            rt.userId = this.userId;
            rt.calName = this.calName;
            rt.reply = this.reply;
            rt.calendarId = this.calendarId;
            return rt;
        }

        public static int resolveUserId(int userId) {
            return userId == -10000 ? ActivityManager.getCurrentUser() : userId;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConfigOrigin {
    }
}

