/*
 * Decompiled with CFR 0.152.
 */
package android.service.notification;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.hidden_from_bootclasspath.android.service.notification.Flags;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ZenDeviceEffects
implements Parcelable {
    public static final int FIELD_GRAYSCALE = 1;
    public static final int FIELD_SUPPRESS_AMBIENT_DISPLAY = 2;
    public static final int FIELD_DIM_WALLPAPER = 4;
    public static final int FIELD_NIGHT_MODE = 8;
    public static final int FIELD_DISABLE_AUTO_BRIGHTNESS = 16;
    public static final int FIELD_DISABLE_TAP_TO_WAKE = 32;
    public static final int FIELD_DISABLE_TILT_TO_WAKE = 64;
    public static final int FIELD_DISABLE_TOUCH = 128;
    public static final int FIELD_MINIMIZE_RADIO_USAGE = 256;
    public static final int FIELD_MAXIMIZE_DOZE = 512;
    public static final int FIELD_EXTRA_EFFECTS = 1024;
    public static final int FIELD_NIGHT_LIGHT = 2048;
    public static final int FIELD_BRIGHTNESS_CAP = 4096;
    private static final int MAX_EFFECTS_LENGTH = 2000;
    private static final float BRIGHTNESS_CAP_MIN = 0.0f;
    private static final float BRIGHTNESS_CAP_MAX = 100.0f;
    private final boolean mGrayscale;
    private final boolean mSuppressAmbientDisplay;
    private final boolean mDimWallpaper;
    private final boolean mNightMode;
    private final boolean mDisableAutoBrightness;
    private final boolean mDisableTapToWake;
    private final boolean mDisableTiltToWake;
    private final boolean mDisableTouch;
    private final boolean mMinimizeRadioUsage;
    private final boolean mMaximizeDoze;
    private final boolean mNightLight;
    @Nullable
    private final Float mBrightnessCap;
    private final Set<String> mExtraEffects;
    @NonNull
    public static final Parcelable.Creator<ZenDeviceEffects> CREATOR = new Parcelable.Creator<ZenDeviceEffects>(){

        @Override
        public ZenDeviceEffects createFromParcel(Parcel in) {
            return new ZenDeviceEffects(in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean(), in.readBoolean() ? Float.valueOf(in.readFloat()) : null, Set.of(in.readArray(String.class.getClassLoader(), String.class)));
        }

        public ZenDeviceEffects[] newArray(int size) {
            return new ZenDeviceEffects[size];
        }
    };

    private ZenDeviceEffects(boolean grayscale, boolean suppressAmbientDisplay, boolean dimWallpaper, boolean nightMode, boolean disableAutoBrightness, boolean disableTapToWake, boolean disableTiltToWake, boolean disableTouch, boolean minimizeRadioUsage, boolean maximizeDoze, boolean nightLight, @Nullable Float brightnessCap, Set<String> extraEffects) {
        this.mGrayscale = grayscale;
        this.mSuppressAmbientDisplay = suppressAmbientDisplay;
        this.mDimWallpaper = dimWallpaper;
        this.mNightMode = nightMode;
        this.mDisableAutoBrightness = disableAutoBrightness;
        this.mDisableTapToWake = disableTapToWake;
        this.mDisableTiltToWake = disableTiltToWake;
        this.mDisableTouch = disableTouch;
        this.mMinimizeRadioUsage = minimizeRadioUsage;
        this.mMaximizeDoze = maximizeDoze;
        this.mNightLight = nightLight;
        this.mBrightnessCap = Flags.applyBrightnessClampingForModes() ? brightnessCap : null;
        this.mExtraEffects = Collections.unmodifiableSet(extraEffects);
    }

    public void validate() {
        int extraEffectsLength = 0;
        for (String extraEffect : this.mExtraEffects) {
            extraEffectsLength += extraEffect.length();
        }
        if (extraEffectsLength > 2000) {
            throw new IllegalArgumentException("Total size of extra effects must be at most 2000 characters");
        }
        if (this.mBrightnessCap != null && (this.mBrightnessCap.floatValue() < 0.0f || this.mBrightnessCap.floatValue() > 100.0f)) {
            throw new IllegalArgumentException("Brightness cap must be between 0f and 100f");
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ZenDeviceEffects)) {
            return false;
        }
        ZenDeviceEffects that = (ZenDeviceEffects)obj;
        if (obj == this) {
            return true;
        }
        return this.mGrayscale == that.mGrayscale && this.mSuppressAmbientDisplay == that.mSuppressAmbientDisplay && this.mDimWallpaper == that.mDimWallpaper && this.mNightMode == that.mNightMode && this.mDisableAutoBrightness == that.mDisableAutoBrightness && this.mDisableTapToWake == that.mDisableTapToWake && this.mDisableTiltToWake == that.mDisableTiltToWake && this.mDisableTouch == that.mDisableTouch && this.mMinimizeRadioUsage == that.mMinimizeRadioUsage && this.mMaximizeDoze == that.mMaximizeDoze && this.mNightLight == that.mNightLight && Objects.equals(this.mBrightnessCap, that.mBrightnessCap) && Objects.equals(this.mExtraEffects, that.mExtraEffects);
    }

    public int hashCode() {
        return Objects.hash(this.mGrayscale, this.mSuppressAmbientDisplay, this.mDimWallpaper, this.mNightMode, this.mDisableAutoBrightness, this.mDisableTapToWake, this.mDisableTiltToWake, this.mDisableTouch, this.mMinimizeRadioUsage, this.mMaximizeDoze, this.mNightLight, this.mBrightnessCap, this.mExtraEffects);
    }

    public String toString() {
        ArrayList<String> effects = new ArrayList<String>(11);
        if (this.mGrayscale) {
            effects.add("grayscale");
        }
        if (this.mSuppressAmbientDisplay) {
            effects.add("suppressAmbientDisplay");
        }
        if (this.mDimWallpaper) {
            effects.add("dimWallpaper");
        }
        if (this.mNightMode) {
            effects.add("nightMode");
        }
        if (this.mDisableAutoBrightness) {
            effects.add("disableAutoBrightness");
        }
        if (this.mDisableTapToWake) {
            effects.add("disableTapToWake");
        }
        if (this.mDisableTiltToWake) {
            effects.add("disableTiltToWake");
        }
        if (this.mDisableTouch) {
            effects.add("disableTouch");
        }
        if (this.mMinimizeRadioUsage) {
            effects.add("minimizeRadioUsage");
        }
        if (this.mMaximizeDoze) {
            effects.add("maximizeDoze");
        }
        if (this.mNightLight) {
            effects.add("nightLight");
        }
        if (this.mBrightnessCap != null) {
            effects.add("brightnessCap=" + this.mBrightnessCap + "%");
        }
        if (this.mExtraEffects.size() > 0) {
            effects.add("extraEffects=[" + String.join((CharSequence)",", this.mExtraEffects) + "]");
        }
        return "[" + String.join((CharSequence)", ", effects) + "]";
    }

    public static String fieldsToString(int bitmask) {
        ArrayList<String> modified = new ArrayList<String>();
        if ((bitmask & 1) != 0) {
            modified.add("FIELD_GRAYSCALE");
        }
        if ((bitmask & 2) != 0) {
            modified.add("FIELD_SUPPRESS_AMBIENT_DISPLAY");
        }
        if ((bitmask & 4) != 0) {
            modified.add("FIELD_DIM_WALLPAPER");
        }
        if ((bitmask & 8) != 0) {
            modified.add("FIELD_NIGHT_MODE");
        }
        if ((bitmask & 0x10) != 0) {
            modified.add("FIELD_DISABLE_AUTO_BRIGHTNESS");
        }
        if ((bitmask & 0x20) != 0) {
            modified.add("FIELD_DISABLE_TAP_TO_WAKE");
        }
        if ((bitmask & 0x40) != 0) {
            modified.add("FIELD_DISABLE_TILT_TO_WAKE");
        }
        if ((bitmask & 0x80) != 0) {
            modified.add("FIELD_DISABLE_TOUCH");
        }
        if ((bitmask & 0x100) != 0) {
            modified.add("FIELD_MINIMIZE_RADIO_USAGE");
        }
        if ((bitmask & 0x200) != 0) {
            modified.add("FIELD_MAXIMIZE_DOZE");
        }
        if ((bitmask & 0x800) != 0) {
            modified.add("FIELD_NIGHT_LIGHT");
        }
        if ((bitmask & 0x1000) != 0) {
            modified.add("FIELD_BRIGHTNESS_CAP");
        }
        if ((bitmask & 0x400) != 0) {
            modified.add("FIELD_EXTRA_EFFECTS");
        }
        return "{" + String.join((CharSequence)",", modified) + "}";
    }

    public boolean shouldDisplayGrayscale() {
        return this.mGrayscale;
    }

    public boolean shouldSuppressAmbientDisplay() {
        return this.mSuppressAmbientDisplay;
    }

    public boolean shouldDimWallpaper() {
        return this.mDimWallpaper;
    }

    public boolean shouldUseNightMode() {
        return this.mNightMode;
    }

    public boolean shouldDisableAutoBrightness() {
        return this.mDisableAutoBrightness;
    }

    public boolean shouldDisableTapToWake() {
        return this.mDisableTapToWake;
    }

    public boolean shouldDisableTiltToWake() {
        return this.mDisableTiltToWake;
    }

    public boolean shouldDisableTouch() {
        return this.mDisableTouch;
    }

    public boolean shouldMinimizeRadioUsage() {
        return this.mMinimizeRadioUsage;
    }

    public boolean shouldMaximizeDoze() {
        return this.mMaximizeDoze;
    }

    public boolean shouldUseNightLight() {
        return this.mNightLight;
    }

    @Nullable
    public Float getBrightnessPercentageCap() {
        return this.mBrightnessCap;
    }

    @NonNull
    public Set<String> getExtraEffects() {
        return this.mExtraEffects;
    }

    public boolean hasEffects() {
        return this.mGrayscale || this.mSuppressAmbientDisplay || this.mDimWallpaper || this.mNightMode || this.mDisableAutoBrightness || this.mDisableTapToWake || this.mDisableTiltToWake || this.mDisableTouch || this.mMinimizeRadioUsage || this.mMaximizeDoze || this.mNightLight || this.mBrightnessCap != null || this.mExtraEffects.size() > 0;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeBoolean(this.mGrayscale);
        dest.writeBoolean(this.mSuppressAmbientDisplay);
        dest.writeBoolean(this.mDimWallpaper);
        dest.writeBoolean(this.mNightMode);
        dest.writeBoolean(this.mDisableAutoBrightness);
        dest.writeBoolean(this.mDisableTapToWake);
        dest.writeBoolean(this.mDisableTiltToWake);
        dest.writeBoolean(this.mDisableTouch);
        dest.writeBoolean(this.mMinimizeRadioUsage);
        dest.writeBoolean(this.mMaximizeDoze);
        dest.writeBoolean(this.mNightLight);
        if (this.mBrightnessCap != null) {
            dest.writeBoolean(true);
            dest.writeFloat(this.mBrightnessCap.floatValue());
        } else {
            dest.writeBoolean(false);
        }
        dest.writeArray(this.mExtraEffects.toArray(new String[0]));
    }

    public static class Builder {
        private boolean mGrayscale;
        private boolean mSuppressAmbientDisplay;
        private boolean mDimWallpaper;
        private boolean mNightMode;
        private boolean mDisableAutoBrightness;
        private boolean mDisableTapToWake;
        private boolean mDisableTiltToWake;
        private boolean mDisableTouch;
        private boolean mMinimizeRadioUsage;
        private boolean mMaximizeDoze;
        private boolean mNightLight;
        @Nullable
        private Float mBrightnessCap = null;
        private final HashSet<String> mExtraEffects = new HashSet();

        public Builder() {
        }

        public Builder(@NonNull ZenDeviceEffects zenDeviceEffects) {
            this.mGrayscale = zenDeviceEffects.shouldDisplayGrayscale();
            this.mSuppressAmbientDisplay = zenDeviceEffects.shouldSuppressAmbientDisplay();
            this.mDimWallpaper = zenDeviceEffects.shouldDimWallpaper();
            this.mNightMode = zenDeviceEffects.shouldUseNightMode();
            this.mDisableAutoBrightness = zenDeviceEffects.shouldDisableAutoBrightness();
            this.mDisableTapToWake = zenDeviceEffects.shouldDisableTapToWake();
            this.mDisableTiltToWake = zenDeviceEffects.shouldDisableTiltToWake();
            this.mDisableTouch = zenDeviceEffects.shouldDisableTouch();
            this.mMinimizeRadioUsage = zenDeviceEffects.shouldMinimizeRadioUsage();
            this.mMaximizeDoze = zenDeviceEffects.shouldMaximizeDoze();
            this.mNightLight = zenDeviceEffects.shouldUseNightLight();
            this.mBrightnessCap = zenDeviceEffects.getBrightnessPercentageCap();
            this.mExtraEffects.addAll(zenDeviceEffects.getExtraEffects());
        }

        @NonNull
        public Builder setShouldDisplayGrayscale(boolean grayscale) {
            this.mGrayscale = grayscale;
            return this;
        }

        @NonNull
        public Builder setShouldSuppressAmbientDisplay(boolean suppressAmbientDisplay) {
            this.mSuppressAmbientDisplay = suppressAmbientDisplay;
            return this;
        }

        @NonNull
        public Builder setShouldDimWallpaper(boolean dimWallpaper) {
            this.mDimWallpaper = dimWallpaper;
            return this;
        }

        @NonNull
        public Builder setShouldUseNightMode(boolean nightMode) {
            this.mNightMode = nightMode;
            return this;
        }

        @NonNull
        public Builder setShouldDisableAutoBrightness(boolean disableAutoBrightness) {
            this.mDisableAutoBrightness = disableAutoBrightness;
            return this;
        }

        @NonNull
        public Builder setShouldDisableTapToWake(boolean disableTapToWake) {
            this.mDisableTapToWake = disableTapToWake;
            return this;
        }

        @NonNull
        public Builder setShouldDisableTiltToWake(boolean disableTiltToWake) {
            this.mDisableTiltToWake = disableTiltToWake;
            return this;
        }

        @NonNull
        public Builder setShouldDisableTouch(boolean disableTouch) {
            this.mDisableTouch = disableTouch;
            return this;
        }

        @NonNull
        public Builder setShouldMinimizeRadioUsage(boolean minimizeRadioUsage) {
            this.mMinimizeRadioUsage = minimizeRadioUsage;
            return this;
        }

        @NonNull
        public Builder setShouldMaximizeDoze(boolean maximizeDoze) {
            this.mMaximizeDoze = maximizeDoze;
            return this;
        }

        @NonNull
        public Builder setShouldUseNightLight(boolean nightLight) {
            this.mNightLight = nightLight;
            return this;
        }

        @NonNull
        public Builder setBrightnessPercentageCap(@Nullable Float brightnessCap) {
            this.mBrightnessCap = Flags.applyBrightnessClampingForModes() ? brightnessCap : null;
            return this;
        }

        @NonNull
        public Builder setExtraEffects(@NonNull Set<String> extraEffects) {
            Objects.requireNonNull(extraEffects);
            this.mExtraEffects.clear();
            this.mExtraEffects.addAll(extraEffects);
            return this;
        }

        @NonNull
        public Builder addExtraEffects(@NonNull Set<String> extraEffects) {
            this.mExtraEffects.addAll((Collection<String>)Objects.requireNonNull(extraEffects));
            return this;
        }

        @NonNull
        public Builder addExtraEffect(@NonNull String extraEffect) {
            this.mExtraEffects.add(Objects.requireNonNull(extraEffect));
            return this;
        }

        @NonNull
        public Builder add(@Nullable ZenDeviceEffects effects) {
            if (effects == null) {
                return this;
            }
            if (effects.shouldDisplayGrayscale()) {
                this.setShouldDisplayGrayscale(true);
            }
            if (effects.shouldSuppressAmbientDisplay()) {
                this.setShouldSuppressAmbientDisplay(true);
            }
            if (effects.shouldDimWallpaper()) {
                this.setShouldDimWallpaper(true);
            }
            if (effects.shouldUseNightMode()) {
                this.setShouldUseNightMode(true);
            }
            if (effects.shouldDisableAutoBrightness()) {
                this.setShouldDisableAutoBrightness(true);
            }
            if (effects.shouldDisableTapToWake()) {
                this.setShouldDisableTapToWake(true);
            }
            if (effects.shouldDisableTiltToWake()) {
                this.setShouldDisableTiltToWake(true);
            }
            if (effects.shouldDisableTouch()) {
                this.setShouldDisableTouch(true);
            }
            if (effects.shouldMinimizeRadioUsage()) {
                this.setShouldMinimizeRadioUsage(true);
            }
            if (effects.shouldMaximizeDoze()) {
                this.setShouldMaximizeDoze(true);
            }
            if (effects.shouldUseNightLight()) {
                this.setShouldUseNightLight(true);
            }
            if (this.mBrightnessCap == null) {
                this.setBrightnessPercentageCap(effects.getBrightnessPercentageCap());
            } else if (effects.getBrightnessPercentageCap() != null) {
                this.setBrightnessPercentageCap(Float.valueOf(Math.min(effects.getBrightnessPercentageCap().floatValue(), this.mBrightnessCap.floatValue())));
            }
            this.addExtraEffects(effects.getExtraEffects());
            return this;
        }

        @NonNull
        public ZenDeviceEffects build() {
            return new ZenDeviceEffects(this.mGrayscale, this.mSuppressAmbientDisplay, this.mDimWallpaper, this.mNightMode, this.mDisableAutoBrightness, this.mDisableTapToWake, this.mDisableTiltToWake, this.mDisableTouch, this.mMinimizeRadioUsage, this.mMaximizeDoze, this.mNightLight, this.mBrightnessCap, this.mExtraEffects);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ModifiableField {
    }
}

