/*
 * Decompiled with CFR 0.152.
 */
package android.service.chooser;

import android.graphics.Rect;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.service.chooser.IChooserController;

public interface IChooserControllerCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.service.chooser.IChooserControllerCallback";

    public void registerChooserController(IChooserController var1) throws RemoteException;

    public void onBoundsChanged(Rect var1) throws RemoteException;

    public void onClosed() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IChooserControllerCallback {
        static final int TRANSACTION_registerChooserController = 1;
        static final int TRANSACTION_onBoundsChanged = 2;
        static final int TRANSACTION_onClosed = 3;

        public Stub() {
            this.attachInterface(this, IChooserControllerCallback.DESCRIPTOR);
        }

        public static IChooserControllerCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IChooserControllerCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IChooserControllerCallback) {
                return (IChooserControllerCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "registerChooserController";
                }
                case 2: {
                    return "onBoundsChanged";
                }
                case 3: {
                    return "onClosed";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IChooserControllerCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IChooserController _arg0 = IChooserController.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.registerChooserController(_arg0);
                    break;
                }
                case 2: {
                    Rect _arg0 = data.readTypedObject(Rect.CREATOR);
                    data.enforceNoDataAvail();
                    this.onBoundsChanged(_arg0);
                    break;
                }
                case 3: {
                    this.onClosed();
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IChooserControllerCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IChooserControllerCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerChooserController(IChooserController updater) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IChooserControllerCallback.DESCRIPTOR);
                    _data.writeStrongInterface(updater);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onBoundsChanged(Rect size) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IChooserControllerCallback.DESCRIPTOR);
                    _data.writeTypedObject(size, 0);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onClosed() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IChooserControllerCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IChooserControllerCallback {
        @Override
        public void registerChooserController(IChooserController updater) throws RemoteException {
        }

        @Override
        public void onBoundsChanged(Rect size) throws RemoteException {
        }

        @Override
        public void onClosed() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

