/*
 * Decompiled with CFR 0.152.
 */
package android.service.chooser;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.content.Intent;
import android.graphics.Rect;
import android.os.Binder;
import android.os.DeadObjectException;
import android.os.IBinder;
import android.os.RemoteException;
import android.service.chooser.ChooserSessionToken;
import android.service.chooser.IChooserController;
import android.service.chooser.IChooserControllerCallback;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

@FlaggedApi(value="android.service.chooser.interactive_chooser")
@SuppressLint(value={"NotCloseable"})
public class ChooserSession {
    public static final String EXTRA_CHOOSER_SESSION = "com.android.extra.EXTRA_CHOOSER_INTERACTIVE_CALLBACK";
    private static final String TAG = "ChooserSession";
    public static final int STATE_INITIALIZED = 0;
    public static final int STATE_STARTED = 1;
    public static final int STATE_CLOSED = 2;
    private final ChooserSessionImpl mChooserSession = new ChooserSessionImpl();
    private final ChooserSessionToken mToken = new ChooserSessionToken(this.mChooserSession);

    ChooserSession() {
    }

    IBinder getBinder() {
        return this.mChooserSession;
    }

    @NonNull
    public ChooserSessionToken getToken() {
        return this.mToken;
    }

    public int getState() {
        return this.mChooserSession.getState();
    }

    public void close() {
        this.mChooserSession.close();
    }

    public void updateIntent(@NonNull Intent intent) {
        Objects.requireNonNull(intent, "intent should not be null");
        IChooserController controller = this.mChooserSession.getChooserController();
        if (controller != null) {
            try {
                controller.updateIntent(intent);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void collapse() {
        this.mChooserSession.collapse();
    }

    public void setTargetsEnabled(boolean isEnabled) {
        this.mChooserSession.setTargetsEnabled(isEnabled);
    }

    @Nullable
    public Rect getSize() {
        return this.mChooserSession.mSize.get();
    }

    public void addStateListener(@NonNull Executor executor, @NonNull StateListener listener) {
        Objects.requireNonNull(executor, "executor should not be null");
        Objects.requireNonNull(listener, "listener should not be null");
        this.mChooserSession.addStateListener(executor, listener);
    }

    public void removeStateListener(@NonNull StateListener listener) {
        Objects.requireNonNull(listener, "listener should not be null");
        this.mChooserSession.removeStateListener(listener);
    }

    static boolean isSessionBinder(IBinder binder) {
        return binder instanceof ChooserSessionImpl;
    }

    private static class ChooserSessionImpl
    extends IChooserControllerCallback.Stub {
        private final Object mListenerLock = new Object();
        @GuardedBy(value={"mListenerLock"})
        private Map<StateListener, UpdateListenerWrapper> mListenerMap = new HashMap<StateListener, UpdateListenerWrapper>();
        private final Object mStateLock = new Object();
        @GuardedBy(value={"mStateLock"})
        @Nullable
        private IChooserController mChooserController;
        @GuardedBy(value={"mStateLock"})
        @Nullable
        private IBinder.DeathRecipient mChooserControllerLinkToDeath;
        @GuardedBy(value={"mStateLock"})
        private int mState = 0;
        private final AtomicReference<Rect> mSize = new AtomicReference();

        private ChooserSessionImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void registerChooserController(@Nullable IChooserController chooserController) {
            int newState;
            if (chooserController == null) {
                Log.d(ChooserSession.TAG, "Received null controller, closing the session");
                this.onClosed();
                return;
            }
            Log.d(ChooserSession.TAG, "setIntentUpdater; state: " + this.mState + ", chooserController: " + chooserController);
            boolean updateState = false;
            Object object = this.mStateLock;
            synchronized (object) {
                if (this.mState == 2) {
                    ChooserSessionImpl.safeUpdateChooserIntent(chooserController, null);
                    return;
                }
                if (ChooserSessionImpl.areEqual(this.mChooserController, chooserController)) {
                    return;
                }
                this.disconnectCurrentController();
                this.connectController(chooserController);
                if (this.mChooserController == null) {
                    this.mState = 2;
                    updateState = true;
                } else if (this.mState == 0) {
                    this.mState = 1;
                    updateState = true;
                }
                newState = this.mState;
            }
            if (updateState) {
                this.notifyListeners(listener -> {
                    if (this.isActive()) {
                        listener.onStateChanged(newState);
                    }
                });
            }
        }

        @Override
        public void onBoundsChanged(Rect size) {
            this.mSize.set(size);
            this.notifyListeners(listener -> {
                if (this.isActive()) {
                    listener.onBoundsChanged(size);
                }
            });
        }

        @Override
        public void onClosed() {
            this.doClose(true);
        }

        public void close() {
            this.doClose(false);
        }

        public void collapse() {
            IChooserController controller = this.getChooserController();
            if (controller != null) {
                try {
                    controller.collapse();
                }
                catch (DeadObjectException e) {
                    this.doClose(true);
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        public void setTargetsEnabled(boolean isEnabled) {
            IChooserController controller = this.getChooserController();
            if (controller != null) {
                try {
                    controller.setTargetsEnabled(isEnabled);
                }
                catch (DeadObjectException e) {
                    this.doClose(true);
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getState() {
            Object object = this.mStateLock;
            synchronized (object) {
                return this.mState;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public IChooserController getChooserController() {
            Object object = this.mStateLock;
            synchronized (object) {
                return this.mChooserController;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addStateListener(Executor executor, StateListener listener) {
            Object object = this.mListenerLock;
            synchronized (object) {
                if (!this.mListenerMap.containsKey(listener)) {
                    this.mListenerMap = new HashMap<StateListener, UpdateListenerWrapper>(this.mListenerMap);
                    this.mListenerMap.put(listener, new UpdateListenerWrapper(listener, executor));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeStateListener(StateListener listener) {
            Object object = this.mListenerLock;
            synchronized (object) {
                if (this.mListenerMap.containsKey(listener)) {
                    this.mListenerMap = new HashMap<StateListener, UpdateListenerWrapper>(this.mListenerMap);
                    UpdateListenerWrapper lw = this.mListenerMap.remove(listener);
                    lw.isSubscribed.set(false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isActive() {
            Object object = this.mStateLock;
            synchronized (object) {
                return this.mState != 2;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyListeners(Consumer<StateListener> block) {
            Collection<UpdateListenerWrapper> listeners;
            Object object = this.mListenerLock;
            synchronized (object) {
                listeners = this.mListenerMap.values();
            }
            long token = Binder.clearCallingIdentity();
            try {
                for (UpdateListenerWrapper lw : listeners) {
                    lw.executor.execute(() -> {
                        if (lw.isSubscribed.get()) {
                            block.accept(lw.listener);
                        }
                    });
                }
            }
            finally {
                Binder.restoreCallingIdentity(token);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doClose(boolean isClosedByChooser) {
            boolean wasActive;
            Object object = this.mStateLock;
            synchronized (object) {
                wasActive = this.mState != 2;
                this.mState = 2;
                if (!isClosedByChooser && this.mChooserController != null) {
                    ChooserSessionImpl.safeUpdateChooserIntent(this.mChooserController, null);
                }
                this.disconnectCurrentController();
            }
            if (wasActive && isClosedByChooser) {
                this.notifyListeners(listener -> listener.onStateChanged(2));
            }
            object = this.mListenerLock;
            synchronized (object) {
                this.mListenerMap = Collections.emptyMap();
            }
        }

        @GuardedBy(value={"mStateLock"})
        private void disconnectCurrentController() {
            if (this.mChooserController != null && this.mChooserControllerLinkToDeath != null) {
                ChooserSessionImpl.safeUnlinkToDeath(this.mChooserController.asBinder(), this.mChooserControllerLinkToDeath);
            }
            this.mChooserController = null;
            this.mChooserControllerLinkToDeath = null;
        }

        @GuardedBy(value={"mStateLock"})
        private void connectController(IChooserController chooserController) {
            this.mChooserController = chooserController;
            this.mChooserControllerLinkToDeath = this.createDeathRecipient(chooserController);
            try {
                chooserController.asBinder().linkToDeath(this.mChooserControllerLinkToDeath, 0);
            }
            catch (RemoteException e) {
                this.mChooserController = null;
                this.mChooserControllerLinkToDeath = null;
            }
        }

        private IBinder.DeathRecipient createDeathRecipient(IChooserController chooserController) {
            return () -> {
                Log.d(ChooserSession.TAG, "chooser died");
                boolean shouldClose = false;
                Object object = this.mStateLock;
                synchronized (object) {
                    if (ChooserSessionImpl.areEqual(this.mChooserController, chooserController)) {
                        this.mChooserController = null;
                        this.mChooserControllerLinkToDeath = null;
                        shouldClose = true;
                    }
                }
                if (shouldClose) {
                    this.doClose(true);
                }
            };
        }

        private static void safeUpdateChooserIntent(IChooserController chooserController, @Nullable Intent chooserIntent) {
            try {
                chooserController.updateIntent(chooserIntent);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private static void safeUnlinkToDeath(IBinder binder, IBinder.DeathRecipient linkToDeath) {
            try {
                binder.unlinkToDeath(linkToDeath, 0);
            }
            catch (Exception e) {
                Log.w(ChooserSession.TAG, "Failed to unlink to death", e);
            }
        }

        private static boolean areEqual(@Nullable IChooserController left, @Nullable IChooserController right) {
            if (left == null && right == null) {
                return true;
            }
            if (left == null || right == null) {
                return false;
            }
            return left.asBinder().equals(right.asBinder());
        }
    }

    public static interface StateListener {
        public void onStateChanged(int var1);

        public void onBoundsChanged(@NonNull Rect var1);
    }

    private static class UpdateListenerWrapper {
        public final StateListener listener;
        public final Executor executor;
        public final AtomicBoolean isSubscribed = new AtomicBoolean(true);

        UpdateListenerWrapper(StateListener listener, Executor executor) {
            this.listener = listener;
            this.executor = executor;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface State {
    }
}

