/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore2;

import android.annotation.NonNull;
import android.security.KeyStoreSecurityLevel;
import android.security.keystore2.AndroidKeyStoreEdECPrivateKey;
import android.security.keystore2.AndroidKeyStorePrivateKey;
import android.security.keystore2.AndroidKeyStorePublicKey;
import android.system.keystore2.KeyDescriptor;
import android.system.keystore2.KeyMetadata;
import java.math.BigInteger;
import java.security.interfaces.EdECPublicKey;
import java.security.spec.EdECPoint;
import java.security.spec.NamedParameterSpec;
import java.util.Arrays;
import java.util.Objects;

public class AndroidKeyStoreEdECPublicKey
extends AndroidKeyStorePublicKey
implements EdECPublicKey {
    private static final byte[] DER_KEY_PREFIX = new byte[]{48, 42, 48, 5, 6, 3, 43, 101, 112, 3, 33, 0};
    private static final int ED25519_KEY_SIZE_BYTES = 32;
    private byte[] mEncodedKey;
    private EdECPoint mPoint;

    public AndroidKeyStoreEdECPublicKey(@NonNull KeyDescriptor descriptor, @NonNull KeyMetadata metadata, @NonNull String algorithm, @NonNull KeyStoreSecurityLevel iSecurityLevel, @NonNull byte[] encodedKey) {
        super(descriptor, metadata, encodedKey, algorithm, iSecurityLevel);
        this.mEncodedKey = encodedKey;
        int preambleLength = AndroidKeyStoreEdECPublicKey.matchesPreamble(DER_KEY_PREFIX, encodedKey);
        if (preambleLength == 0) {
            throw new IllegalArgumentException("Key size is not correct size");
        }
        this.mPoint = AndroidKeyStoreEdECPublicKey.pointFromKeyByteArray(Arrays.copyOfRange(encodedKey, preambleLength, encodedKey.length));
    }

    @Override
    AndroidKeyStorePrivateKey getPrivateKey() {
        return new AndroidKeyStoreEdECPrivateKey(this.getUserKeyDescriptor(), this.getKeyIdDescriptor().nspace, this.getAuthorizations(), "EdDSA", this.getSecurityLevel());
    }

    @Override
    public NamedParameterSpec getParams() {
        return NamedParameterSpec.ED25519;
    }

    @Override
    public EdECPoint getPoint() {
        return this.mPoint;
    }

    private static int matchesPreamble(byte[] preamble, byte[] encoded) {
        if (encoded.length != preamble.length + 32) {
            return 0;
        }
        if (Arrays.compare(preamble, Arrays.copyOf(encoded, preamble.length)) != 0) {
            return 0;
        }
        return preamble.length;
    }

    private static EdECPoint pointFromKeyByteArray(byte[] coordinates) {
        Objects.requireNonNull(coordinates);
        boolean isOdd = (0x80 & coordinates[coordinates.length - 1]) != 0;
        int n = coordinates.length - 1;
        coordinates[n] = (byte)(coordinates[n] & 0x7F);
        AndroidKeyStoreEdECPublicKey.reverse(coordinates);
        BigInteger y = new BigInteger(1, coordinates);
        return new EdECPoint(isOdd, y);
    }

    private static void reverse(byte[] coordinateArray) {
        int start = 0;
        for (int end = coordinateArray.length - 1; start < end; ++start, --end) {
            byte tmp = coordinateArray[start];
            coordinateArray[start] = coordinateArray[end];
            coordinateArray[end] = tmp;
        }
    }

    @Override
    public byte[] getEncoded() {
        return (byte[])this.mEncodedKey.clone();
    }
}

