/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore.recovery;

import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.io.ByteArrayInputStream;
import java.security.cert.CertPath;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.Objects;

public class RecoveryCertPath
implements Parcelable {
    private static final String CERT_PATH_ENCODING = "PkiPath";
    private final byte[] mEncodedCertPath;
    @NonNull
    public static final Parcelable.Creator<RecoveryCertPath> CREATOR = new Parcelable.Creator<RecoveryCertPath>(){

        @Override
        public RecoveryCertPath createFromParcel(Parcel in) {
            return new RecoveryCertPath(in);
        }

        public RecoveryCertPath[] newArray(int length) {
            return new RecoveryCertPath[length];
        }
    };

    @NonNull
    public static RecoveryCertPath createRecoveryCertPath(@NonNull CertPath certPath) throws CertificateException {
        try {
            return new RecoveryCertPath(RecoveryCertPath.encodeCertPath(certPath));
        }
        catch (CertificateEncodingException e) {
            throw new CertificateException("Failed to encode the given CertPath", e);
        }
    }

    @NonNull
    public CertPath getCertPath() throws CertificateException {
        return RecoveryCertPath.decodeCertPath(this.mEncodedCertPath);
    }

    private RecoveryCertPath(@NonNull byte[] encodedCertPath) {
        this.mEncodedCertPath = Objects.requireNonNull(encodedCertPath);
    }

    private RecoveryCertPath(Parcel in) {
        this.mEncodedCertPath = in.createByteArray();
    }

    @Override
    public void writeToParcel(Parcel out, int flags) {
        out.writeByteArray(this.mEncodedCertPath);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    private static byte[] encodeCertPath(@NonNull CertPath certPath) throws CertificateEncodingException {
        Objects.requireNonNull(certPath);
        return certPath.getEncoded(CERT_PATH_ENCODING);
    }

    @NonNull
    private static CertPath decodeCertPath(@NonNull byte[] bytes) throws CertificateException {
        CertificateFactory certFactory;
        Objects.requireNonNull(bytes);
        try {
            certFactory = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException e) {
            throw new RuntimeException(e);
        }
        return certFactory.generateCertPath(new ByteArrayInputStream(bytes), CERT_PATH_ENCODING);
    }
}

