/*
 * Decompiled with CFR 0.152.
 */
package android.security.intrusiondetection;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.os.RemoteException;
import android.security.intrusiondetection.IIntrusionDetectionService;
import android.security.intrusiondetection.IIntrusionDetectionServiceCommandCallback;
import android.security.intrusiondetection.IIntrusionDetectionServiceStateCallback;
import android.util.Log;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

@SystemApi
@FlaggedApi(value="android.security.afl_api")
public class IntrusionDetectionManager {
    private static final String TAG = "IntrusionDetectionManager";
    public static final int STATE_UNKNOWN = 0;
    public static final int STATE_DISABLED = 1;
    public static final int STATE_ENABLED = 2;
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_PERMISSION_DENIED = 1;
    public static final int ERROR_TRANSPORT_UNAVAILABLE = 3;
    public static final int ERROR_DATA_SOURCE_UNAVAILABLE = 4;
    private final IIntrusionDetectionService mService;
    private final ConcurrentHashMap<Consumer<Integer>, IIntrusionDetectionServiceStateCallback> mStateCallbacks = new ConcurrentHashMap();

    public IntrusionDetectionManager(IIntrusionDetectionService service) {
        this.mService = service;
    }

    @RequiresPermission(value="android.permission.READ_INTRUSION_DETECTION_STATE")
    public void addStateCallback(final @NonNull Executor executor, final @NonNull Consumer<Integer> callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        if (this.mStateCallbacks.get(callback) != null) {
            Log.d(TAG, "addStateCallback callback already present");
            return;
        }
        IIntrusionDetectionServiceStateCallback.Stub wrappedCallback = new IIntrusionDetectionServiceStateCallback.Stub(this){

            @Override
            public void onStateChange(int state) {
                executor.execute(() -> callback.accept(state));
            }
        };
        try {
            this.mService.addStateCallback(wrappedCallback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.mStateCallbacks.put(callback, wrappedCallback);
    }

    @RequiresPermission(value="android.permission.READ_INTRUSION_DETECTION_STATE")
    public void removeStateCallback(@NonNull Consumer<Integer> callback) {
        Objects.requireNonNull(callback);
        if (!this.mStateCallbacks.containsKey(callback)) {
            Log.d(TAG, "removeStateCallback callback not present");
            return;
        }
        IIntrusionDetectionServiceStateCallback wrappedCallback = this.mStateCallbacks.get(callback);
        try {
            this.mService.removeStateCallback(wrappedCallback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        this.mStateCallbacks.remove(callback);
    }

    @RequiresPermission(value="android.permission.MANAGE_INTRUSION_DETECTION_STATE")
    public void enable(final @NonNull Executor executor, final @NonNull CommandCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.enable(new IIntrusionDetectionServiceCommandCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(callback::onSuccess);
                }

                @Override
                public void onFailure(int error) {
                    executor.execute(() -> callback.onFailure(error));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_INTRUSION_DETECTION_STATE")
    public void disable(final @NonNull Executor executor, final @NonNull CommandCallback callback) {
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        try {
            this.mService.disable(new IIntrusionDetectionServiceCommandCallback.Stub(this){

                @Override
                public void onSuccess() {
                    executor.execute(callback::onSuccess);
                }

                @Override
                public void onFailure(int error) {
                    executor.execute(() -> callback.onFailure(error));
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public static interface CommandCallback {
        public void onSuccess();

        public void onFailure(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IntrusionDetectionError {
    }

    @Target(value={ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IntrusionDetectionState {
    }
}

