/*
 * Decompiled with CFR 0.152.
 */
package android.security.attestationverification;

import android.annotation.NonNull;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.security.attestationverification.AttestationProfile;
import android.security.attestationverification.AttestationVerificationManager;
import com.android.internal.util.AnnotationValidations;
import com.android.internal.util.Parcelling;
import java.time.Instant;

public class VerificationToken
implements Parcelable {
    @NonNull
    private final AttestationProfile mAttestationProfile;
    private final int mLocalBindingType;
    @NonNull
    private final Bundle mRequirements;
    private final int mVerificationResult;
    @NonNull
    private final Instant mVerificationTime;
    @NonNull
    private final byte[] mHmac;
    private int mUid;
    static Parcelling<Instant> sParcellingForVerificationTime = Parcelling.Cache.get(Parcelling.BuiltIn.ForInstant.class);
    @NonNull
    public static final Parcelable.Creator<VerificationToken> CREATOR;

    VerificationToken(@NonNull AttestationProfile attestationProfile, int localBindingType, @NonNull Bundle requirements, int verificationResult, @NonNull Instant verificationTime, @NonNull byte[] hmac) {
        this.mAttestationProfile = attestationProfile;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mAttestationProfile);
        this.mLocalBindingType = localBindingType;
        AnnotationValidations.validate(AttestationVerificationManager.LocalBindingType.class, null, this.mLocalBindingType);
        this.mRequirements = requirements;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mRequirements);
        this.mVerificationResult = verificationResult;
        AnnotationValidations.validate(AttestationVerificationManager.VerificationResultFlags.class, null, this.mVerificationResult);
        this.mVerificationTime = verificationTime;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mVerificationTime);
        this.mHmac = hmac;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHmac);
    }

    @NonNull
    public AttestationProfile getAttestationProfile() {
        return this.mAttestationProfile;
    }

    public int getLocalBindingType() {
        return this.mLocalBindingType;
    }

    @NonNull
    public Bundle getRequirements() {
        return this.mRequirements;
    }

    public int getVerificationResult() {
        return this.mVerificationResult;
    }

    @NonNull
    public Instant getVerificationTime() {
        return this.mVerificationTime;
    }

    @NonNull
    public byte[] getHmac() {
        return this.mHmac;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeTypedObject(this.mAttestationProfile, flags);
        dest.writeInt(this.mLocalBindingType);
        dest.writeBundle(this.mRequirements);
        dest.writeInt(this.mVerificationResult);
        sParcellingForVerificationTime.parcel(this.mVerificationTime, dest, flags);
        dest.writeByteArray(this.mHmac);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    VerificationToken(@NonNull Parcel in) {
        AttestationProfile attestationProfile = in.readTypedObject(AttestationProfile.CREATOR);
        int localBindingType = in.readInt();
        Bundle requirements = in.readBundle();
        int verificationResult = in.readInt();
        Instant verificationTime = sParcellingForVerificationTime.unparcel(in);
        byte[] hmac = in.createByteArray();
        this.mAttestationProfile = attestationProfile;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mAttestationProfile);
        this.mLocalBindingType = localBindingType;
        AnnotationValidations.validate(AttestationVerificationManager.LocalBindingType.class, null, this.mLocalBindingType);
        this.mRequirements = requirements;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mRequirements);
        this.mVerificationResult = verificationResult;
        AnnotationValidations.validate(AttestationVerificationManager.VerificationResultFlags.class, null, this.mVerificationResult);
        this.mVerificationTime = verificationTime;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mVerificationTime);
        this.mHmac = hmac;
        AnnotationValidations.validate(NonNull.class, null, (Object)this.mHmac);
    }

    static {
        if (sParcellingForVerificationTime == null) {
            sParcellingForVerificationTime = Parcelling.Cache.put(new Parcelling.BuiltIn.ForInstant());
        }
        CREATOR = new Parcelable.Creator<VerificationToken>(){

            public VerificationToken[] newArray(int size) {
                return new VerificationToken[size];
            }

            @Override
            public VerificationToken createFromParcel(@NonNull Parcel in) {
                return new VerificationToken(in);
            }
        };
    }

    public static class Builder {
        @NonNull
        private AttestationProfile mAttestationProfile;
        private int mLocalBindingType;
        @NonNull
        private Bundle mRequirements;
        private int mVerificationResult;
        @NonNull
        private Instant mVerificationTime;
        @NonNull
        private byte[] mHmac;
        private long mBuilderFieldsSet = 0L;

        public Builder(@NonNull AttestationProfile attestationProfile, int localBindingType, @NonNull Bundle requirements, int verificationResult, @NonNull Instant verificationTime, @NonNull byte[] hmac) {
            this.mAttestationProfile = attestationProfile;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mAttestationProfile);
            this.mLocalBindingType = localBindingType;
            AnnotationValidations.validate(AttestationVerificationManager.LocalBindingType.class, null, this.mLocalBindingType);
            this.mRequirements = requirements;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mRequirements);
            this.mVerificationResult = verificationResult;
            AnnotationValidations.validate(AttestationVerificationManager.VerificationResultFlags.class, null, this.mVerificationResult);
            this.mVerificationTime = verificationTime;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mVerificationTime);
            this.mHmac = hmac;
            AnnotationValidations.validate(NonNull.class, null, (Object)this.mHmac);
        }

        @NonNull
        public Builder setAttestationProfile(@NonNull AttestationProfile value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 1L;
            this.mAttestationProfile = value;
            return this;
        }

        @NonNull
        public Builder setLocalBindingType(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 2L;
            this.mLocalBindingType = value;
            return this;
        }

        @NonNull
        public Builder setRequirements(@NonNull Bundle value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 4L;
            this.mRequirements = value;
            return this;
        }

        @NonNull
        public Builder setVerificationResult(int value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 8L;
            this.mVerificationResult = value;
            return this;
        }

        @NonNull
        public Builder setVerificationTime(@NonNull Instant value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x10L;
            this.mVerificationTime = value;
            return this;
        }

        @NonNull
        public Builder setHmac(byte ... value) {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x20L;
            this.mHmac = value;
            return this;
        }

        @NonNull
        public VerificationToken build() {
            this.checkNotUsed();
            this.mBuilderFieldsSet |= 0x40L;
            VerificationToken o = new VerificationToken(this.mAttestationProfile, this.mLocalBindingType, this.mRequirements, this.mVerificationResult, this.mVerificationTime, this.mHmac);
            return o;
        }

        private void checkNotUsed() {
            if ((this.mBuilderFieldsSet & 0x40L) != 0L) {
                throw new IllegalStateException("This Builder should not be reused. Use a new Builder instance instead");
            }
        }
    }
}

