/*
 * Decompiled with CFR 0.152.
 */
package android.security.attestationverification;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.content.Context;
import android.os.Bundle;
import android.os.ParcelDuration;
import android.os.RemoteException;
import android.security.attestationverification.AttestationProfile;
import android.security.attestationverification.IAttestationVerificationManagerService;
import android.security.attestationverification.VerificationToken;
import android.util.Log;
import com.android.internal.infra.AndroidFuture;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Duration;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

public class AttestationVerificationManager {
    private static final String TAG = "AVF";
    private static final Duration MAX_TOKEN_AGE = Duration.ofHours(1L);
    private final Context mContext;
    private final IAttestationVerificationManagerService mService;
    public static final int PROFILE_UNKNOWN = 0;
    public static final int PROFILE_APP_DEFINED = 1;
    public static final int PROFILE_SELF_TRUSTED = 2;
    public static final int PROFILE_PEER_DEVICE = 3;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_APP_DEFINED = 1;
    public static final int TYPE_PUBLIC_KEY = 2;
    public static final int TYPE_CHALLENGE = 3;
    public static final int FLAG_FAILURE_UNKNOWN = 1;
    public static final int FLAG_FAILURE_UNSUPPORTED_PROFILE = 2;
    public static final int FLAG_FAILURE_CERTS = 4;
    public static final int FLAG_FAILURE_LOCAL_BINDING_REQUIREMENTS = 8;
    public static final int FLAG_FAILURE_KEYSTORE_REQUIREMENTS = 16;
    public static final int FLAG_FAILURE_BOOT_STATE = 32;
    public static final int FLAG_FAILURE_PATCH_LEVEL_DIFF = 64;
    public static final String PARAM_PUBLIC_KEY = "localbinding.public_key";
    public static final String PARAM_ID = "localbinding.id";
    public static final String PARAM_CHALLENGE = "localbinding.challenge";
    public static final String PARAM_MAX_PATCH_LEVEL_DIFF_MONTHS = "param_max_patch_level_diff_months";

    @RequiresPermission(value="android.permission.USE_ATTESTATION_VERIFICATION_SERVICE")
    public void verifyAttestation(@NonNull AttestationProfile profile, int localBindingType, @NonNull Bundle requirements, @NonNull byte[] attestation, @NonNull Executor executor, @NonNull BiConsumer<Integer, VerificationToken> callback) {
        try {
            AndroidFuture resultCallback = new AndroidFuture();
            resultCallback.thenAccept(result -> {
                Log.d(TAG, "verifyAttestation result: " + result.resultCode + " / " + result.token);
                executor.execute(() -> callback.accept(result.resultCode, result.token));
            });
            this.mService.verifyAttestation(profile, localBindingType, requirements, attestation, resultCallback);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.USE_ATTESTATION_VERIFICATION_SERVICE")
    public int verifyToken(@NonNull AttestationProfile profile, int localBindingType, @NonNull Bundle requirements, @NonNull VerificationToken token, @Nullable Duration maximumAge) {
        Duration usedMaximumAge;
        if (maximumAge == null) {
            usedMaximumAge = MAX_TOKEN_AGE;
        } else {
            if (maximumAge.compareTo(MAX_TOKEN_AGE) > 0) {
                throw new IllegalArgumentException("maximumAge cannot be greater than " + MAX_TOKEN_AGE + "; was " + maximumAge);
            }
            usedMaximumAge = maximumAge;
        }
        try {
            AndroidFuture resultCallback = new AndroidFuture();
            resultCallback.orTimeout(5L, TimeUnit.SECONDS);
            this.mService.verifyToken(token, new ParcelDuration(usedMaximumAge), resultCallback);
            return (Integer)resultCallback.get();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error verifying token.", t);
        }
    }

    public AttestationVerificationManager(@NonNull Context context, @NonNull IAttestationVerificationManagerService service) {
        this.mContext = context;
        this.mService = service;
    }

    public static String localBindingTypeToString(int localBindingType) {
        String text;
        switch (localBindingType) {
            case 0: {
                text = "UNKNOWN";
                break;
            }
            case 1: {
                text = "APP_DEFINED";
                break;
            }
            case 2: {
                text = "PUBLIC_KEY";
                break;
            }
            case 3: {
                text = "CHALLENGE";
                break;
            }
            default: {
                return Integer.toString(localBindingType);
            }
        }
        return text + "(" + localBindingType + ")";
    }

    @Target(value={ElementType.TYPE_PARAMETER, ElementType.TYPE_USE})
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VerificationResultFlags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface LocalBindingType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AttestationProfileId {
    }
}

