/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.content.Context;
import android.content.pm.PackageManager;
import android.security.OverlayNetworkSecurityPolicy;
import android.security.net.config.ApplicationConfig;
import android.security.net.config.ManifestConfigSource;

public class NetworkSecurityPolicy {
    private static final NetworkSecurityPolicy INSTANCE = new NetworkSecurityPolicy();

    private NetworkSecurityPolicy() {
    }

    public static NetworkSecurityPolicy getInstance() {
        return INSTANCE;
    }

    public boolean isCleartextTrafficPermitted() {
        return libcore.net.NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted();
    }

    public boolean isCleartextTrafficPermitted(String hostname) {
        return libcore.net.NetworkSecurityPolicy.getInstance().isCleartextTrafficPermitted(hostname);
    }

    public void setCleartextTrafficPermitted(boolean permitted) {
        libcore.net.NetworkSecurityPolicy currentPolicy = libcore.net.NetworkSecurityPolicy.getInstance();
        OverlayNetworkSecurityPolicy policy = new OverlayNetworkSecurityPolicy(currentPolicy, permitted);
        libcore.net.NetworkSecurityPolicy.setInstance(policy);
    }

    @FlaggedApi(value="android.security.certificate_transparency_configuration")
    public boolean isCertificateTransparencyVerificationRequired(@NonNull String hostname) {
        return libcore.net.NetworkSecurityPolicy.getInstance().isCertificateTransparencyVerificationRequired(hostname);
    }

    public void handleTrustStorageUpdate() {
        ApplicationConfig config = ApplicationConfig.getDefaultInstance();
        if (config != null) {
            config.handleTrustStorageUpdate();
        }
    }

    public static ApplicationConfig getApplicationConfigForPackage(Context context, String packageName) throws PackageManager.NameNotFoundException {
        Context appContext = context.createPackageContext(packageName, 0);
        ManifestConfigSource source = new ManifestConfigSource(appContext);
        return new ApplicationConfig(source);
    }
}

