/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.os.Parcel;
import android.os.Parcelable;
import android.permission.jarjar.com.android.internal.util.Preconditions;
import android.permission.jarjar.com.android.modules.utils.build.SdkLevel;
import android.text.TextUtils;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetySourceStatus
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<SafetySourceStatus> CREATOR = new Parcelable.Creator<SafetySourceStatus>(){

        @Override
        public SafetySourceStatus createFromParcel(Parcel in) {
            CharSequence title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            CharSequence summary = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            int severityLevel = in.readInt();
            return new Builder(title, summary, severityLevel).setPendingIntent(in.readTypedObject(PendingIntent.CREATOR)).setIconAction(in.readTypedObject(IconAction.CREATOR)).setEnabled(in.readBoolean()).build();
        }

        public SafetySourceStatus[] newArray(int size) {
            return new SafetySourceStatus[size];
        }
    };
    @NonNull
    private final CharSequence mTitle;
    @NonNull
    private final CharSequence mSummary;
    private final int mSeverityLevel;
    @Nullable
    private final PendingIntent mPendingIntent;
    @Nullable
    private final IconAction mIconAction;
    private final boolean mEnabled;

    private SafetySourceStatus(@NonNull CharSequence title, @NonNull CharSequence summary, int severityLevel, @Nullable PendingIntent pendingIntent, @Nullable IconAction iconAction, boolean enabled) {
        this.mTitle = title;
        this.mSummary = summary;
        this.mSeverityLevel = severityLevel;
        this.mPendingIntent = pendingIntent;
        this.mIconAction = iconAction;
        this.mEnabled = enabled;
    }

    @NonNull
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @NonNull
    public CharSequence getSummary() {
        return this.mSummary;
    }

    public int getSeverityLevel() {
        return this.mSeverityLevel;
    }

    @Nullable
    public PendingIntent getPendingIntent() {
        return this.mPendingIntent;
    }

    @Nullable
    public IconAction getIconAction() {
        return this.mIconAction;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        TextUtils.writeToParcel(this.mTitle, dest, flags);
        TextUtils.writeToParcel(this.mSummary, dest, flags);
        dest.writeInt(this.mSeverityLevel);
        dest.writeTypedObject(this.mPendingIntent, flags);
        dest.writeTypedObject(this.mIconAction, flags);
        dest.writeBoolean(this.mEnabled);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetySourceStatus)) {
            return false;
        }
        SafetySourceStatus that = (SafetySourceStatus)o;
        return this.mSeverityLevel == that.mSeverityLevel && this.mEnabled == that.mEnabled && TextUtils.equals(this.mTitle, that.mTitle) && TextUtils.equals(this.mSummary, that.mSummary) && Objects.equals(this.mPendingIntent, that.mPendingIntent) && Objects.equals(this.mIconAction, that.mIconAction);
    }

    public int hashCode() {
        return Objects.hash(this.mTitle, this.mSummary, this.mSeverityLevel, this.mPendingIntent, this.mIconAction, this.mEnabled);
    }

    public String toString() {
        return "SafetySourceStatus{mTitle=" + this.mTitle + ", mSummary=" + this.mSummary + ", mSeverityLevel=" + this.mSeverityLevel + ", mPendingIntent=" + this.mPendingIntent + ", mIconAction=" + this.mIconAction + ", mEnabled=" + this.mEnabled + '}';
    }

    private static int validateSeverityLevel(int value) {
        switch (value) {
            case 100: 
            case 200: 
            case 300: 
            case 400: {
                return value;
            }
        }
        throw new IllegalArgumentException("Unexpected SeverityLevel for SafetySourceStatus: " + value);
    }

    public static class IconAction
    implements Parcelable {
        @NonNull
        public static final Parcelable.Creator<IconAction> CREATOR = new Parcelable.Creator<IconAction>(){

            @Override
            public IconAction createFromParcel(Parcel in) {
                int iconType = in.readInt();
                PendingIntent pendingIntent = in.readTypedObject(PendingIntent.CREATOR);
                return new IconAction(iconType, pendingIntent);
            }

            public IconAction[] newArray(int size) {
                return new IconAction[size];
            }
        };
        public static final int ICON_TYPE_GEAR = 100;
        public static final int ICON_TYPE_INFO = 200;
        private final int mIconType;
        @NonNull
        private final PendingIntent mPendingIntent;

        public IconAction(int iconType, @NonNull PendingIntent pendingIntent) {
            this.mIconType = IconAction.validateIconType(iconType);
            this.mPendingIntent = Objects.requireNonNull(pendingIntent);
        }

        public int getIconType() {
            return this.mIconType;
        }

        @NonNull
        public PendingIntent getPendingIntent() {
            return this.mPendingIntent;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mIconType);
            dest.writeTypedObject(this.mPendingIntent, flags);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IconAction)) {
                return false;
            }
            IconAction that = (IconAction)o;
            return this.mIconType == that.mIconType && ((Object)this.mPendingIntent).equals(that.mPendingIntent);
        }

        public int hashCode() {
            return Objects.hash(this.mIconType, this.mPendingIntent);
        }

        public String toString() {
            return "IconAction{mIconType=" + this.mIconType + ", mPendingIntent=" + this.mPendingIntent + '}';
        }

        private static int validateIconType(int value) {
            switch (value) {
                case 100: 
                case 200: {
                    return value;
                }
            }
            throw new IllegalArgumentException("Unexpected IconType for IconAction: " + value);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface IconType {
        }
    }

    public static class Builder {
        @NonNull
        private final CharSequence mTitle;
        @NonNull
        private final CharSequence mSummary;
        private final int mSeverityLevel;
        @Nullable
        private PendingIntent mPendingIntent;
        @Nullable
        private IconAction mIconAction;
        private boolean mEnabled = true;

        public Builder(@NonNull CharSequence title, @NonNull CharSequence summary, int severityLevel) {
            this.mTitle = Objects.requireNonNull(title);
            this.mSummary = Objects.requireNonNull(summary);
            this.mSeverityLevel = SafetySourceStatus.validateSeverityLevel(severityLevel);
        }

        @RequiresApi(value=34)
        public Builder(@NonNull SafetySourceStatus safetySourceStatus) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            Objects.requireNonNull(safetySourceStatus);
            this.mTitle = safetySourceStatus.mTitle;
            this.mSummary = safetySourceStatus.mSummary;
            this.mSeverityLevel = safetySourceStatus.mSeverityLevel;
            this.mPendingIntent = safetySourceStatus.mPendingIntent;
            this.mIconAction = safetySourceStatus.mIconAction;
            this.mEnabled = safetySourceStatus.mEnabled;
        }

        @NonNull
        public Builder setPendingIntent(@Nullable PendingIntent pendingIntent) {
            Preconditions.checkArgument(pendingIntent == null || pendingIntent.isActivity(), "Safety source status pending intent must start an activity");
            this.mPendingIntent = pendingIntent;
            return this;
        }

        @NonNull
        public Builder setIconAction(@Nullable IconAction iconAction) {
            this.mIconAction = iconAction;
            return this;
        }

        @NonNull
        public Builder setEnabled(boolean enabled) {
            Preconditions.checkArgument(enabled || this.mSeverityLevel == 100, "Safety source status must have a severity level of SEVERITY_LEVEL_UNSPECIFIED when disabled");
            this.mEnabled = enabled;
            return this;
        }

        @NonNull
        public SafetySourceStatus build() {
            return new SafetySourceStatus(this.mTitle, this.mSummary, this.mSeverityLevel, this.mPendingIntent, this.mIconAction, this.mEnabled);
        }
    }
}

