/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.permission.jarjar.com.android.modules.utils.build.SdkLevel;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetyEvent
implements Parcelable {
    public static final int SAFETY_EVENT_TYPE_SOURCE_STATE_CHANGED = 100;
    public static final int SAFETY_EVENT_TYPE_REFRESH_REQUESTED = 200;
    public static final int SAFETY_EVENT_TYPE_RESOLVING_ACTION_SUCCEEDED = 300;
    public static final int SAFETY_EVENT_TYPE_RESOLVING_ACTION_FAILED = 400;
    public static final int SAFETY_EVENT_TYPE_DEVICE_LOCALE_CHANGED = 500;
    public static final int SAFETY_EVENT_TYPE_DEVICE_REBOOTED = 600;
    @NonNull
    public static final Parcelable.Creator<SafetyEvent> CREATOR = new Parcelable.Creator<SafetyEvent>(){

        @Override
        public SafetyEvent createFromParcel(Parcel in) {
            int type = in.readInt();
            return new Builder(type).setRefreshBroadcastId(in.readString()).setSafetySourceIssueId(in.readString()).setSafetySourceIssueActionId(in.readString()).build();
        }

        public SafetyEvent[] newArray(int size) {
            return new SafetyEvent[size];
        }
    };
    private final int mType;
    @Nullable
    private final String mRefreshBroadcastId;
    @Nullable
    private final String mSafetySourceIssueId;
    @Nullable
    private final String mSafetySourceIssueActionId;

    private SafetyEvent(int type, @Nullable String refreshBroadcastId, @Nullable String safetySourceIssueId, @Nullable String safetySourceIssueActionId) {
        this.mType = type;
        this.mRefreshBroadcastId = refreshBroadcastId;
        this.mSafetySourceIssueId = safetySourceIssueId;
        this.mSafetySourceIssueActionId = safetySourceIssueActionId;
    }

    public int getType() {
        return this.mType;
    }

    @Nullable
    public String getRefreshBroadcastId() {
        return this.mRefreshBroadcastId;
    }

    @Nullable
    public String getSafetySourceIssueId() {
        return this.mSafetySourceIssueId;
    }

    @Nullable
    public String getSafetySourceIssueActionId() {
        return this.mSafetySourceIssueActionId;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mType);
        dest.writeString(this.mRefreshBroadcastId);
        dest.writeString(this.mSafetySourceIssueId);
        dest.writeString(this.mSafetySourceIssueActionId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetyEvent)) {
            return false;
        }
        SafetyEvent that = (SafetyEvent)o;
        return this.mType == that.mType && Objects.equals(this.mRefreshBroadcastId, that.mRefreshBroadcastId) && Objects.equals(this.mSafetySourceIssueId, that.mSafetySourceIssueId) && Objects.equals(this.mSafetySourceIssueActionId, that.mSafetySourceIssueActionId);
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mRefreshBroadcastId, this.mSafetySourceIssueId, this.mSafetySourceIssueActionId);
    }

    public String toString() {
        return "SafetyEvent{mType=" + this.mType + ", mRefreshBroadcastId=" + this.mRefreshBroadcastId + ", mSafetySourceIssueId=" + this.mSafetySourceIssueId + ", mSafetySourceIssueActionId=" + this.mSafetySourceIssueActionId + '}';
    }

    private static int validateType(int value) {
        switch (value) {
            case 100: 
            case 200: 
            case 300: 
            case 400: 
            case 500: 
            case 600: {
                return value;
            }
        }
        throw new IllegalArgumentException("Unexpected Type for SafetyEvent: " + value);
    }

    public static class Builder {
        private final int mType;
        @Nullable
        private String mRefreshBroadcastId;
        @Nullable
        private String mSafetySourceIssueId;
        @Nullable
        private String mSafetySourceIssueActionId;

        public Builder(int type) {
            this.mType = SafetyEvent.validateType(type);
        }

        @RequiresApi(value=34)
        public Builder(@NonNull SafetyEvent safetyEvent) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            Objects.requireNonNull(safetyEvent);
            this.mType = safetyEvent.mType;
            this.mRefreshBroadcastId = safetyEvent.mRefreshBroadcastId;
            this.mSafetySourceIssueId = safetyEvent.mSafetySourceIssueId;
            this.mSafetySourceIssueActionId = safetyEvent.mSafetySourceIssueActionId;
        }

        @NonNull
        public Builder setRefreshBroadcastId(@Nullable String refreshBroadcastId) {
            this.mRefreshBroadcastId = refreshBroadcastId;
            return this;
        }

        @NonNull
        public Builder setSafetySourceIssueId(@Nullable String safetySourceIssueId) {
            this.mSafetySourceIssueId = safetySourceIssueId;
            return this;
        }

        @NonNull
        public Builder setSafetySourceIssueActionId(@Nullable String safetySourceIssueActionId) {
            this.mSafetySourceIssueActionId = safetySourceIssueActionId;
            return this;
        }

        @NonNull
        public SafetyEvent build() {
            switch (this.mType) {
                case 200: {
                    if (this.mRefreshBroadcastId != null) break;
                    throw new IllegalArgumentException("Missing refresh broadcast id for refresh requested safety event");
                }
                case 300: 
                case 400: {
                    if (this.mSafetySourceIssueId == null) {
                        throw new IllegalArgumentException("Missing issue id for resolving action safety event: " + this.mType);
                    }
                    if (this.mSafetySourceIssueActionId != null) break;
                    throw new IllegalArgumentException("Missing issue action id for resolving action safety event: " + this.mType);
                }
            }
            return new SafetyEvent(this.mType, this.mRefreshBroadcastId, this.mSafetySourceIssueId, this.mSafetySourceIssueActionId);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Type {
    }
}

