/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.os.Parcel;
import android.os.Parcelable;
import android.permission.jarjar.com.android.modules.utils.build.SdkLevel;
import android.text.TextUtils;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetyCenterIssue
implements Parcelable {
    public static final int ISSUE_SEVERITY_LEVEL_OK = 2100;
    public static final int ISSUE_SEVERITY_LEVEL_RECOMMENDATION = 2200;
    public static final int ISSUE_SEVERITY_LEVEL_CRITICAL_WARNING = 2300;
    @NonNull
    public static final Parcelable.Creator<SafetyCenterIssue> CREATOR = new Parcelable.Creator<SafetyCenterIssue>(){

        @Override
        public SafetyCenterIssue createFromParcel(Parcel in) {
            String id2 = in.readString();
            CharSequence title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            CharSequence subtitle = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            CharSequence summary = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            Builder builder = new Builder(id2, title, summary).setSubtitle(subtitle).setSeverityLevel(in.readInt()).setDismissible(in.readBoolean()).setShouldConfirmDismissal(in.readBoolean()).setActions(in.createTypedArrayList(Action.CREATOR));
            if (SdkLevel.isAtLeastU()) {
                builder.setAttributionTitle(TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in));
                builder.setGroupId(in.readString());
            }
            return builder.build();
        }

        public SafetyCenterIssue[] newArray(int size) {
            return new SafetyCenterIssue[size];
        }
    };
    @NonNull
    private final String mId;
    @NonNull
    private final CharSequence mTitle;
    @Nullable
    private final CharSequence mSubtitle;
    @NonNull
    private final CharSequence mSummary;
    private final int mSeverityLevel;
    private final boolean mDismissible;
    private final boolean mShouldConfirmDismissal;
    @NonNull
    private final List<Action> mActions;
    @Nullable
    private final CharSequence mAttributionTitle;
    @Nullable
    private final String mGroupId;

    private SafetyCenterIssue(@NonNull String id2, @NonNull CharSequence title, @Nullable CharSequence subtitle, @NonNull CharSequence summary, int severityLevel, boolean isDismissible, boolean shouldConfirmDismissal, @NonNull List<Action> actions, @Nullable CharSequence attributionTitle, @Nullable String groupId) {
        this.mId = id2;
        this.mTitle = title;
        this.mSubtitle = subtitle;
        this.mSummary = summary;
        this.mSeverityLevel = severityLevel;
        this.mDismissible = isDismissible;
        this.mShouldConfirmDismissal = shouldConfirmDismissal;
        this.mActions = actions;
        this.mAttributionTitle = attributionTitle;
        this.mGroupId = groupId;
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @NonNull
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @Nullable
    public CharSequence getSubtitle() {
        return this.mSubtitle;
    }

    @NonNull
    public CharSequence getSummary() {
        return this.mSummary;
    }

    @Nullable
    @RequiresApi(value=34)
    public CharSequence getAttributionTitle() {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
        }
        return this.mAttributionTitle;
    }

    public int getSeverityLevel() {
        return this.mSeverityLevel;
    }

    public boolean isDismissible() {
        return this.mDismissible;
    }

    public boolean shouldConfirmDismissal() {
        return this.mShouldConfirmDismissal;
    }

    @NonNull
    public List<Action> getActions() {
        return this.mActions;
    }

    @Nullable
    @RequiresApi(value=34)
    public String getGroupId() {
        if (!SdkLevel.isAtLeastU()) {
            throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
        }
        return this.mGroupId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetyCenterIssue)) {
            return false;
        }
        SafetyCenterIssue that = (SafetyCenterIssue)o;
        return this.mSeverityLevel == that.mSeverityLevel && this.mDismissible == that.mDismissible && this.mShouldConfirmDismissal == that.mShouldConfirmDismissal && Objects.equals(this.mId, that.mId) && TextUtils.equals(this.mTitle, that.mTitle) && TextUtils.equals(this.mSubtitle, that.mSubtitle) && TextUtils.equals(this.mSummary, that.mSummary) && Objects.equals(this.mActions, that.mActions) && TextUtils.equals(this.mAttributionTitle, that.mAttributionTitle) && Objects.equals(this.mGroupId, that.mGroupId);
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mTitle, this.mSubtitle, this.mSummary, this.mSeverityLevel, this.mDismissible, this.mShouldConfirmDismissal, this.mActions, this.mAttributionTitle, this.mGroupId);
    }

    public String toString() {
        return "SafetyCenterIssue{mId=" + this.mId + ", mTitle=" + this.mTitle + ", mSubtitle=" + this.mSubtitle + ", mSummary=" + this.mSummary + ", mSeverityLevel=" + this.mSeverityLevel + ", mDismissible=" + this.mDismissible + ", mConfirmDismissal=" + this.mShouldConfirmDismissal + ", mActions=" + this.mActions + ", mAttributionTitle=" + this.mAttributionTitle + ", mGroupId=" + this.mGroupId + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mId);
        TextUtils.writeToParcel(this.mTitle, dest, flags);
        TextUtils.writeToParcel(this.mSubtitle, dest, flags);
        TextUtils.writeToParcel(this.mSummary, dest, flags);
        dest.writeInt(this.mSeverityLevel);
        dest.writeBoolean(this.mDismissible);
        dest.writeBoolean(this.mShouldConfirmDismissal);
        dest.writeTypedList(this.mActions);
        if (SdkLevel.isAtLeastU()) {
            TextUtils.writeToParcel(this.mAttributionTitle, dest, flags);
            dest.writeString(this.mGroupId);
        }
    }

    private static int validateIssueSeverityLevel(int value) {
        switch (value) {
            case 2100: 
            case 2200: 
            case 2300: {
                return value;
            }
        }
        throw new IllegalArgumentException("Unexpected IssueSeverityLevel for SafetyCenterIssue: " + value);
    }

    public static class Action
    implements Parcelable {
        @NonNull
        public static final Parcelable.Creator<Action> CREATOR = new Parcelable.Creator<Action>(){

            @Override
            public Action createFromParcel(Parcel in) {
                String id2 = in.readString();
                CharSequence label = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                PendingIntent pendingIntent = in.readTypedObject(PendingIntent.CREATOR);
                Builder builder = new Builder(id2, label, pendingIntent).setWillResolve(in.readBoolean()).setIsInFlight(in.readBoolean()).setSuccessMessage(TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in));
                if (SdkLevel.isAtLeastU()) {
                    ConfirmationDialogDetails confirmationDialogDetails = in.readTypedObject(ConfirmationDialogDetails.CREATOR);
                    builder.setConfirmationDialogDetails(confirmationDialogDetails);
                }
                return builder.build();
            }

            public Action[] newArray(int size) {
                return new Action[size];
            }
        };
        @NonNull
        private final String mId;
        @NonNull
        private final CharSequence mLabel;
        @NonNull
        private final PendingIntent mPendingIntent;
        private final boolean mWillResolve;
        private final boolean mInFlight;
        @Nullable
        private final CharSequence mSuccessMessage;
        @Nullable
        private final ConfirmationDialogDetails mConfirmationDialogDetails;

        private Action(@NonNull String id2, @NonNull CharSequence label, @NonNull PendingIntent pendingIntent, boolean willResolve, boolean inFlight, @Nullable CharSequence successMessage, @Nullable ConfirmationDialogDetails confirmationDialogDetails) {
            this.mId = id2;
            this.mLabel = label;
            this.mPendingIntent = pendingIntent;
            this.mWillResolve = willResolve;
            this.mInFlight = inFlight;
            this.mSuccessMessage = successMessage;
            this.mConfirmationDialogDetails = confirmationDialogDetails;
        }

        @NonNull
        public String getId() {
            return this.mId;
        }

        @NonNull
        public CharSequence getLabel() {
            return this.mLabel;
        }

        @NonNull
        public PendingIntent getPendingIntent() {
            return this.mPendingIntent;
        }

        public boolean willResolve() {
            return this.mWillResolve;
        }

        public boolean isInFlight() {
            return this.mInFlight;
        }

        @Nullable
        public CharSequence getSuccessMessage() {
            return this.mSuccessMessage;
        }

        @Nullable
        @RequiresApi(value=34)
        public ConfirmationDialogDetails getConfirmationDialogDetails() {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            return this.mConfirmationDialogDetails;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Action)) {
                return false;
            }
            Action action = (Action)o;
            return Objects.equals(this.mId, action.mId) && TextUtils.equals(this.mLabel, action.mLabel) && Objects.equals(this.mPendingIntent, action.mPendingIntent) && this.mWillResolve == action.mWillResolve && this.mInFlight == action.mInFlight && TextUtils.equals(this.mSuccessMessage, action.mSuccessMessage) && Objects.equals(this.mConfirmationDialogDetails, action.mConfirmationDialogDetails);
        }

        public int hashCode() {
            return Objects.hash(this.mId, this.mLabel, this.mSuccessMessage, this.mWillResolve, this.mInFlight, this.mPendingIntent, this.mConfirmationDialogDetails);
        }

        public String toString() {
            return "Action{mId=" + this.mId + ", mLabel=" + this.mLabel + ", mPendingIntent=" + this.mPendingIntent + ", mWillResolve=" + this.mWillResolve + ", mInFlight=" + this.mInFlight + ", mSuccessMessage=" + this.mSuccessMessage + ", mConfirmationDialogDetails=" + this.mConfirmationDialogDetails + '}';
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeString(this.mId);
            TextUtils.writeToParcel(this.mLabel, dest, flags);
            dest.writeTypedObject(this.mPendingIntent, flags);
            dest.writeBoolean(this.mWillResolve);
            dest.writeBoolean(this.mInFlight);
            TextUtils.writeToParcel(this.mSuccessMessage, dest, flags);
            if (SdkLevel.isAtLeastU()) {
                dest.writeTypedObject(this.mConfirmationDialogDetails, flags);
            }
        }

        @RequiresApi(value=34)
        public static class ConfirmationDialogDetails
        implements Parcelable {
            @NonNull
            public static final Parcelable.Creator<ConfirmationDialogDetails> CREATOR = new Parcelable.Creator<ConfirmationDialogDetails>(){

                @Override
                public ConfirmationDialogDetails createFromParcel(Parcel in) {
                    CharSequence title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                    CharSequence text = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                    CharSequence acceptButtonText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                    CharSequence denyButtonText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
                    return new ConfirmationDialogDetails(title, text, acceptButtonText, denyButtonText);
                }

                public ConfirmationDialogDetails[] newArray(int size) {
                    return new ConfirmationDialogDetails[size];
                }
            };
            @NonNull
            private final CharSequence mTitle;
            @NonNull
            private final CharSequence mText;
            @NonNull
            private final CharSequence mAcceptButtonText;
            @NonNull
            private final CharSequence mDenyButtonText;

            public ConfirmationDialogDetails(@NonNull CharSequence title, @NonNull CharSequence text, @NonNull CharSequence acceptButtonText, @NonNull CharSequence denyButtonText) {
                this.mTitle = Objects.requireNonNull(title);
                this.mText = Objects.requireNonNull(text);
                this.mAcceptButtonText = Objects.requireNonNull(acceptButtonText);
                this.mDenyButtonText = Objects.requireNonNull(denyButtonText);
            }

            @NonNull
            public CharSequence getTitle() {
                return this.mTitle;
            }

            @NonNull
            public CharSequence getText() {
                return this.mText;
            }

            @NonNull
            public CharSequence getAcceptButtonText() {
                return this.mAcceptButtonText;
            }

            @NonNull
            public CharSequence getDenyButtonText() {
                return this.mDenyButtonText;
            }

            @Override
            public int describeContents() {
                return 0;
            }

            @Override
            public void writeToParcel(@NonNull Parcel dest, int flags) {
                TextUtils.writeToParcel(this.mTitle, dest, flags);
                TextUtils.writeToParcel(this.mText, dest, flags);
                TextUtils.writeToParcel(this.mAcceptButtonText, dest, flags);
                TextUtils.writeToParcel(this.mDenyButtonText, dest, flags);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof ConfirmationDialogDetails)) {
                    return false;
                }
                ConfirmationDialogDetails that = (ConfirmationDialogDetails)o;
                return TextUtils.equals(this.mTitle, that.mTitle) && TextUtils.equals(this.mText, that.mText) && TextUtils.equals(this.mAcceptButtonText, that.mAcceptButtonText) && TextUtils.equals(this.mDenyButtonText, that.mDenyButtonText);
            }

            public int hashCode() {
                return Objects.hash(this.mTitle, this.mText, this.mAcceptButtonText, this.mDenyButtonText);
            }

            public String toString() {
                return "ConfirmationDialogDetails{mTitle=" + this.mTitle + ", mText=" + this.mText + ", mAcceptButtonText=" + this.mAcceptButtonText + ", mDenyButtonText=" + this.mDenyButtonText + '}';
            }
        }

        public static class Builder {
            @NonNull
            private String mId;
            @NonNull
            private CharSequence mLabel;
            @NonNull
            private PendingIntent mPendingIntent;
            private boolean mWillResolve;
            private boolean mInFlight;
            @Nullable
            private CharSequence mSuccessMessage;
            @Nullable
            private ConfirmationDialogDetails mConfirmationDialogDetails;

            public Builder(@NonNull String id2, @NonNull CharSequence label, @NonNull PendingIntent pendingIntent) {
                this.mId = Objects.requireNonNull(id2);
                this.mLabel = Objects.requireNonNull(label);
                this.mPendingIntent = Objects.requireNonNull(pendingIntent);
            }

            @RequiresApi(value=34)
            public Builder(@NonNull Action action) {
                if (!SdkLevel.isAtLeastU()) {
                    throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
                }
                Objects.requireNonNull(action);
                this.mId = action.mId;
                this.mLabel = action.mLabel;
                this.mPendingIntent = action.mPendingIntent;
                this.mWillResolve = action.mWillResolve;
                this.mInFlight = action.mInFlight;
                this.mSuccessMessage = action.mSuccessMessage;
                this.mConfirmationDialogDetails = action.mConfirmationDialogDetails;
            }

            @NonNull
            public Builder setId(@NonNull String id2) {
                this.mId = Objects.requireNonNull(id2);
                return this;
            }

            @NonNull
            public Builder setLabel(@NonNull CharSequence label) {
                this.mLabel = Objects.requireNonNull(label);
                return this;
            }

            @NonNull
            public Builder setPendingIntent(@NonNull PendingIntent pendingIntent) {
                this.mPendingIntent = Objects.requireNonNull(pendingIntent);
                return this;
            }

            @SuppressLint(value={"MissingGetterMatchingBuilder"})
            @NonNull
            public Builder setWillResolve(boolean willResolve) {
                this.mWillResolve = willResolve;
                return this;
            }

            @SuppressLint(value={"MissingGetterMatchingBuilder"})
            @NonNull
            public Builder setIsInFlight(boolean inFlight) {
                this.mInFlight = inFlight;
                return this;
            }

            @NonNull
            public Builder setSuccessMessage(@Nullable CharSequence successMessage) {
                this.mSuccessMessage = successMessage;
                return this;
            }

            @NonNull
            @RequiresApi(value=34)
            public Builder setConfirmationDialogDetails(@Nullable ConfirmationDialogDetails confirmationDialogDetails) {
                if (!SdkLevel.isAtLeastU()) {
                    throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
                }
                this.mConfirmationDialogDetails = confirmationDialogDetails;
                return this;
            }

            @NonNull
            public Action build() {
                return new Action(this.mId, this.mLabel, this.mPendingIntent, this.mWillResolve, this.mInFlight, this.mSuccessMessage, this.mConfirmationDialogDetails);
            }
        }
    }

    public static class Builder {
        @NonNull
        private String mId;
        @NonNull
        private CharSequence mTitle;
        @NonNull
        private CharSequence mSummary;
        @Nullable
        private CharSequence mSubtitle;
        private int mSeverityLevel = 2100;
        private boolean mDismissible = true;
        private boolean mShouldConfirmDismissal = true;
        private List<Action> mActions = new ArrayList<Action>();
        @Nullable
        private CharSequence mAttributionTitle;
        @Nullable
        private String mGroupId;

        public Builder(@NonNull String id2, @NonNull CharSequence title, @NonNull CharSequence summary) {
            this.mId = Objects.requireNonNull(id2);
            this.mTitle = Objects.requireNonNull(title);
            this.mSummary = Objects.requireNonNull(summary);
        }

        public Builder(@NonNull SafetyCenterIssue issue) {
            this.mId = issue.mId;
            this.mTitle = issue.mTitle;
            this.mSubtitle = issue.mSubtitle;
            this.mSummary = issue.mSummary;
            this.mSeverityLevel = issue.mSeverityLevel;
            this.mDismissible = issue.mDismissible;
            this.mShouldConfirmDismissal = issue.mShouldConfirmDismissal;
            this.mActions = new ArrayList<Action>(issue.mActions);
            this.mAttributionTitle = issue.mAttributionTitle;
            this.mGroupId = issue.mGroupId;
        }

        @NonNull
        public Builder setId(@NonNull String id2) {
            this.mId = Objects.requireNonNull(id2);
            return this;
        }

        @NonNull
        public Builder setTitle(@NonNull CharSequence title) {
            this.mTitle = Objects.requireNonNull(title);
            return this;
        }

        @NonNull
        public Builder setSubtitle(@Nullable CharSequence subtitle) {
            this.mSubtitle = subtitle;
            return this;
        }

        @NonNull
        public Builder setSummary(@NonNull CharSequence summary) {
            this.mSummary = Objects.requireNonNull(summary);
            return this;
        }

        @NonNull
        @RequiresApi(value=34)
        public Builder setAttributionTitle(@Nullable CharSequence attributionTitle) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            this.mAttributionTitle = attributionTitle;
            return this;
        }

        @NonNull
        public Builder setSeverityLevel(int severityLevel) {
            this.mSeverityLevel = SafetyCenterIssue.validateIssueSeverityLevel(severityLevel);
            return this;
        }

        @NonNull
        public Builder setDismissible(boolean dismissible) {
            this.mDismissible = dismissible;
            return this;
        }

        @NonNull
        public Builder setShouldConfirmDismissal(boolean confirmDismissal) {
            this.mShouldConfirmDismissal = confirmDismissal;
            return this;
        }

        @NonNull
        public Builder setActions(@NonNull List<Action> actions) {
            this.mActions = Objects.requireNonNull(actions);
            return this;
        }

        @NonNull
        @RequiresApi(value=34)
        public Builder setGroupId(@Nullable String groupId) {
            if (!SdkLevel.isAtLeastU()) {
                throw new UnsupportedOperationException("Method not supported on versions lower than UPSIDE_DOWN_CAKE");
            }
            this.mGroupId = groupId;
            return this;
        }

        @NonNull
        public SafetyCenterIssue build() {
            return new SafetyCenterIssue(this.mId, this.mTitle, this.mSubtitle, this.mSummary, this.mSeverityLevel, this.mDismissible, this.mShouldConfirmDismissal, Collections.unmodifiableList(new ArrayList<Action>(this.mActions)), this.mAttributionTitle, this.mGroupId);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface IssueSeverityLevel {
    }
}

