/*
 * Decompiled with CFR 0.152.
 */
package android.safetycenter;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.app.PendingIntent;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.android.layoutlib.androidx.annotation.RequiresApi;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
@RequiresApi(value=33)
public class SafetyCenterEntry
implements Parcelable {
    public static final int ENTRY_SEVERITY_LEVEL_UNKNOWN = 3000;
    public static final int ENTRY_SEVERITY_LEVEL_UNSPECIFIED = 3100;
    public static final int ENTRY_SEVERITY_LEVEL_OK = 3200;
    public static final int ENTRY_SEVERITY_LEVEL_RECOMMENDATION = 3300;
    public static final int ENTRY_SEVERITY_LEVEL_CRITICAL_WARNING = 3400;
    public static final int SEVERITY_UNSPECIFIED_ICON_TYPE_NO_ICON = 0;
    public static final int SEVERITY_UNSPECIFIED_ICON_TYPE_PRIVACY = 1;
    public static final int SEVERITY_UNSPECIFIED_ICON_TYPE_NO_RECOMMENDATION = 2;
    @NonNull
    public static final Parcelable.Creator<SafetyCenterEntry> CREATOR = new Parcelable.Creator<SafetyCenterEntry>(){

        @Override
        public SafetyCenterEntry createFromParcel(Parcel in) {
            String id2 = in.readString();
            CharSequence title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in);
            return new Builder(id2, title).setSummary(TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(in)).setSeverityLevel(in.readInt()).setSeverityUnspecifiedIconType(in.readInt()).setEnabled(in.readBoolean()).setPendingIntent(in.readTypedObject(PendingIntent.CREATOR)).setIconAction(in.readTypedObject(IconAction.CREATOR)).build();
        }

        public SafetyCenterEntry[] newArray(int size) {
            return new SafetyCenterEntry[size];
        }
    };
    @NonNull
    private final String mId;
    @NonNull
    private final CharSequence mTitle;
    @Nullable
    private final CharSequence mSummary;
    private final int mSeverityLevel;
    private final int mSeverityUnspecifiedIconType;
    private final boolean mEnabled;
    @Nullable
    private final PendingIntent mPendingIntent;
    @Nullable
    private final IconAction mIconAction;

    private SafetyCenterEntry(@NonNull String id2, @NonNull CharSequence title, @Nullable CharSequence summary, int severityLevel, int severityUnspecifiedIconType, boolean enabled, @Nullable PendingIntent pendingIntent, @Nullable IconAction iconAction) {
        this.mId = id2;
        this.mTitle = title;
        this.mSummary = summary;
        this.mSeverityLevel = severityLevel;
        this.mSeverityUnspecifiedIconType = severityUnspecifiedIconType;
        this.mEnabled = enabled;
        this.mPendingIntent = pendingIntent;
        this.mIconAction = iconAction;
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @NonNull
    public CharSequence getTitle() {
        return this.mTitle;
    }

    @Nullable
    public CharSequence getSummary() {
        return this.mSummary;
    }

    public int getSeverityLevel() {
        return this.mSeverityLevel;
    }

    public int getSeverityUnspecifiedIconType() {
        return this.mSeverityUnspecifiedIconType;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    @Nullable
    public PendingIntent getPendingIntent() {
        return this.mPendingIntent;
    }

    @Nullable
    public IconAction getIconAction() {
        return this.mIconAction;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SafetyCenterEntry)) {
            return false;
        }
        SafetyCenterEntry that = (SafetyCenterEntry)o;
        return this.mSeverityLevel == that.mSeverityLevel && this.mSeverityUnspecifiedIconType == that.mSeverityUnspecifiedIconType && this.mEnabled == that.mEnabled && Objects.equals(this.mId, that.mId) && TextUtils.equals(this.mTitle, that.mTitle) && TextUtils.equals(this.mSummary, that.mSummary) && Objects.equals(this.mPendingIntent, that.mPendingIntent) && Objects.equals(this.mIconAction, that.mIconAction);
    }

    public int hashCode() {
        return Objects.hash(this.mId, this.mTitle, this.mSummary, this.mSeverityLevel, this.mSeverityUnspecifiedIconType, this.mEnabled, this.mPendingIntent, this.mIconAction);
    }

    public String toString() {
        return "SafetyCenterEntry{mId=" + this.mId + ", mTitle=" + this.mTitle + ", mSummary=" + this.mSummary + ", mSeverityLevel=" + this.mSeverityLevel + ", mSeverityUnspecifiedIconType=" + this.mSeverityUnspecifiedIconType + ", mEnabled=" + this.mEnabled + ", mPendingIntent=" + this.mPendingIntent + ", mIconAction=" + this.mIconAction + '}';
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mId);
        TextUtils.writeToParcel(this.mTitle, dest, flags);
        TextUtils.writeToParcel(this.mSummary, dest, flags);
        dest.writeInt(this.mSeverityLevel);
        dest.writeInt(this.mSeverityUnspecifiedIconType);
        dest.writeBoolean(this.mEnabled);
        dest.writeTypedObject(this.mPendingIntent, flags);
        dest.writeTypedObject(this.mIconAction, flags);
    }

    private static int validateEntrySeverityLevel(int value) {
        switch (value) {
            case 3000: 
            case 3100: 
            case 3200: 
            case 3300: 
            case 3400: {
                return value;
            }
        }
        throw new IllegalArgumentException("Unexpected EntrySeverityLevel for SafetyCenterEntry: " + value);
    }

    private static int validateSeverityUnspecifiedIconType(int value) {
        switch (value) {
            case 0: 
            case 1: 
            case 2: {
                return value;
            }
        }
        throw new IllegalArgumentException("Unexpected SeverityUnspecifiedIconType for SafetyCenterEntry: " + value);
    }

    public static class IconAction
    implements Parcelable {
        public static final int ICON_ACTION_TYPE_GEAR = 30100;
        public static final int ICON_ACTION_TYPE_INFO = 30200;
        @NonNull
        public static final Parcelable.Creator<IconAction> CREATOR = new Parcelable.Creator<IconAction>(){

            @Override
            public IconAction createFromParcel(Parcel in) {
                int type = in.readInt();
                PendingIntent pendingIntent = in.readTypedObject(PendingIntent.CREATOR);
                return new IconAction(type, pendingIntent);
            }

            public IconAction[] newArray(int size) {
                return new IconAction[size];
            }
        };
        private final int mType;
        @NonNull
        private final PendingIntent mPendingIntent;

        public IconAction(int type, @NonNull PendingIntent pendingIntent) {
            this.mType = IconAction.validateIconActionType(type);
            this.mPendingIntent = Objects.requireNonNull(pendingIntent);
        }

        public int getType() {
            return this.mType;
        }

        @NonNull
        public PendingIntent getPendingIntent() {
            return this.mPendingIntent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IconAction)) {
                return false;
            }
            IconAction that = (IconAction)o;
            return this.mType == that.mType && Objects.equals(this.mPendingIntent, that.mPendingIntent);
        }

        public int hashCode() {
            return Objects.hash(this.mType, this.mPendingIntent);
        }

        public String toString() {
            return "IconAction{mType=" + this.mType + ", mPendingIntent=" + this.mPendingIntent + '}';
        }

        @Override
        public int describeContents() {
            return 0;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.mType);
            dest.writeTypedObject(this.mPendingIntent, flags);
        }

        private static int validateIconActionType(int value) {
            switch (value) {
                case 30100: 
                case 30200: {
                    return value;
                }
            }
            throw new IllegalArgumentException("Unexpected IconActionType for IconAction: " + value);
        }

        @Retention(value=RetentionPolicy.SOURCE)
        public static @interface IconActionType {
        }
    }

    public static class Builder {
        @NonNull
        private String mId;
        @NonNull
        private CharSequence mTitle;
        @Nullable
        private CharSequence mSummary;
        private int mSeverityLevel = 3000;
        private int mSeverityUnspecifiedIconType = 0;
        private boolean mEnabled = true;
        @Nullable
        private PendingIntent mPendingIntent;
        @Nullable
        private IconAction mIconAction;

        public Builder(@NonNull String id2, @NonNull CharSequence title) {
            this.mId = Objects.requireNonNull(id2);
            this.mTitle = Objects.requireNonNull(title);
        }

        public Builder(@NonNull SafetyCenterEntry safetyCenterEntry) {
            this.mId = safetyCenterEntry.mId;
            this.mTitle = safetyCenterEntry.mTitle;
            this.mSummary = safetyCenterEntry.mSummary;
            this.mSeverityLevel = safetyCenterEntry.mSeverityLevel;
            this.mSeverityUnspecifiedIconType = safetyCenterEntry.mSeverityUnspecifiedIconType;
            this.mEnabled = safetyCenterEntry.mEnabled;
            this.mPendingIntent = safetyCenterEntry.mPendingIntent;
            this.mIconAction = safetyCenterEntry.mIconAction;
        }

        @NonNull
        public Builder setId(@NonNull String id2) {
            this.mId = Objects.requireNonNull(id2);
            return this;
        }

        @NonNull
        public Builder setTitle(@NonNull CharSequence title) {
            this.mTitle = Objects.requireNonNull(title);
            return this;
        }

        @NonNull
        public Builder setSummary(@Nullable CharSequence summary) {
            this.mSummary = summary;
            return this;
        }

        @NonNull
        public Builder setSeverityLevel(int severityLevel) {
            this.mSeverityLevel = SafetyCenterEntry.validateEntrySeverityLevel(severityLevel);
            return this;
        }

        @NonNull
        public Builder setSeverityUnspecifiedIconType(int severityUnspecifiedIconType) {
            this.mSeverityUnspecifiedIconType = SafetyCenterEntry.validateSeverityUnspecifiedIconType(severityUnspecifiedIconType);
            return this;
        }

        @NonNull
        public Builder setEnabled(boolean enabled) {
            this.mEnabled = enabled;
            return this;
        }

        @NonNull
        public Builder setPendingIntent(@Nullable PendingIntent pendingIntent) {
            this.mPendingIntent = pendingIntent;
            return this;
        }

        @NonNull
        public Builder setIconAction(@Nullable IconAction iconAction) {
            this.mIconAction = iconAction;
            return this;
        }

        @NonNull
        public Builder setIconAction(int type, @NonNull PendingIntent pendingIntent) {
            this.mIconAction = new IconAction(type, pendingIntent);
            return this;
        }

        @NonNull
        public SafetyCenterEntry build() {
            return new SafetyCenterEntry(this.mId, this.mTitle, this.mSummary, this.mSeverityLevel, this.mSeverityUnspecifiedIconType, this.mEnabled, this.mPendingIntent, this.mIconAction);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SeverityUnspecifiedIconType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface EntrySeverityLevel {
    }
}

