/*
 * Decompiled with CFR 0.152.
 */
package android.ranging.wifi.rtt;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.ranging.RangingCapabilities;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_rtt_enabled")
public class RttRangingCapabilities
implements Parcelable,
RangingCapabilities.TechnologyCapabilities {
    private final boolean mHasPeriodicRangingHardwareFeature;
    private final int mMaxSupportedBandwidth;
    private final int mMaxSupportedRxChain;
    @NonNull
    public static final Parcelable.Creator<RttRangingCapabilities> CREATOR = new Parcelable.Creator<RttRangingCapabilities>(){

        @Override
        public RttRangingCapabilities createFromParcel(Parcel in) {
            return new RttRangingCapabilities(in);
        }

        public RttRangingCapabilities[] newArray(int size) {
            return new RttRangingCapabilities[size];
        }
    };

    private RttRangingCapabilities(Builder builder) {
        this.mHasPeriodicRangingHardwareFeature = builder.mHasPeriodicRangingHardwareFeature;
        this.mMaxSupportedBandwidth = builder.mMaxSupportedBandwidth;
        this.mMaxSupportedRxChain = builder.mMaxSupportedRxChain;
    }

    private RttRangingCapabilities(Parcel in) {
        this.mHasPeriodicRangingHardwareFeature = in.readBoolean();
        this.mMaxSupportedBandwidth = in.readInt();
        this.mMaxSupportedRxChain = in.readInt();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeBoolean(this.mHasPeriodicRangingHardwareFeature);
        dest.writeInt(this.mMaxSupportedBandwidth);
        dest.writeInt(this.mMaxSupportedRxChain);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public int getTechnology() {
        return 2;
    }

    public boolean hasPeriodicRangingHardwareFeature() {
        return this.mHasPeriodicRangingHardwareFeature;
    }

    public int getMaxSupportedBandwidth() {
        return this.mMaxSupportedBandwidth;
    }

    public int getMaxSupportedRxChain() {
        return this.mMaxSupportedRxChain;
    }

    public String toString() {
        return "RttRangingCapabilities{ mHasPeriodicRangingHwFeature=" + this.mHasPeriodicRangingHardwareFeature + " }";
    }

    public static class Builder {
        private boolean mHasPeriodicRangingHardwareFeature = false;
        private int mMaxSupportedBandwidth = 0;
        private int mMaxSupportedRxChain = 0;

        @NonNull
        public Builder setMaxSupportedBandwidth(int maxSupportedBandwidth) {
            this.mMaxSupportedBandwidth = maxSupportedBandwidth;
            return this;
        }

        @NonNull
        public Builder setMaxSupportedRxChain(int maxSupportedRxChain) {
            this.mMaxSupportedRxChain = maxSupportedRxChain;
            return this;
        }

        @NonNull
        public Builder setPeriodicRangingHardwareFeature(boolean periodicRangingHwFeature) {
            this.mHasPeriodicRangingHardwareFeature = periodicRangingHwFeature;
            return this;
        }

        @NonNull
        public RttRangingCapabilities build() {
            return new RttRangingCapabilities(this);
        }
    }
}

