/*
 * Decompiled with CFR 0.152.
 */
package android.ranging.uwb;

import android.annotation.FlaggedApi;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.ranging.uwb.UwbAddress;
import android.ranging.uwb.UwbComplexChannel;
import com.android.layoutlib.androidx.annotation.NonNull;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.Objects;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class UwbRangingParams
implements Parcelable {
    private final int mSessionId;
    private final int mSubSessionId;
    @android.annotation.NonNull
    public static final Parcelable.Creator<UwbRangingParams> CREATOR = new Parcelable.Creator<UwbRangingParams>(){

        @Override
        public UwbRangingParams createFromParcel(Parcel in) {
            return new UwbRangingParams(in);
        }

        public UwbRangingParams[] newArray(int size) {
            return new UwbRangingParams[size];
        }
    };
    public static final int CONFIG_UNICAST_DS_TWR = 1;
    public static final int CONFIG_MULTICAST_DS_TWR = 2;
    public static final int CONFIG_PROVISIONED_UNICAST_DS_TWR = 3;
    public static final int CONFIG_PROVISIONED_MULTICAST_DS_TWR = 4;
    public static final int CONFIG_PROVISIONED_INDIVIDUAL_MULTICAST_DS_TWR = 5;
    public static final int CONFIG_PROVISIONED_UNICAST_DS_TWR_VERY_FAST = 6;
    public static final int SUB_SESSION_UNDEFINED = -1;
    private final int mConfigId;
    private final UwbAddress mDeviceAddress;
    private final byte[] mSessionKeyInfo;
    private final byte[] mSubSessionKeyInfo;
    private final UwbComplexChannel mComplexChannel;
    private final UwbAddress mPeerAddress;
    public static final int DURATION_1_MS = 1;
    public static final int DURATION_2_MS = 2;
    private final int mRangingUpdateRate;
    private final int mSlotDurationMillis;

    private UwbRangingParams(Parcel in) {
        this.mSessionId = in.readInt();
        this.mSubSessionId = in.readInt();
        this.mConfigId = in.readInt();
        this.mDeviceAddress = (UwbAddress)in.readParcelable(UwbAddress.class.getClassLoader());
        this.mSessionKeyInfo = in.readBlob();
        this.mSubSessionKeyInfo = in.readBlob();
        this.mComplexChannel = (UwbComplexChannel)in.readParcelable(UwbComplexChannel.class.getClassLoader());
        this.mRangingUpdateRate = in.readInt();
        this.mPeerAddress = (UwbAddress)in.readParcelable(UwbAddress.class.getClassLoader());
        this.mSlotDurationMillis = in.readInt();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mSessionId);
        dest.writeInt(this.mSubSessionId);
        dest.writeInt(this.mConfigId);
        dest.writeParcelable(this.mDeviceAddress, flags);
        dest.writeBlob(this.mSessionKeyInfo);
        dest.writeBlob(this.mSubSessionKeyInfo);
        dest.writeParcelable(this.mComplexChannel, flags);
        dest.writeInt(this.mRangingUpdateRate);
        dest.writeParcelable(this.mPeerAddress, flags);
        dest.writeInt(this.mSlotDurationMillis);
    }

    private UwbRangingParams(Builder builder) {
        this.mSessionId = builder.mSessionId;
        this.mSubSessionId = builder.mSubSessionId;
        this.mConfigId = builder.mConfigId;
        this.mDeviceAddress = builder.mDeviceAddress;
        this.mSessionKeyInfo = builder.mSessionKeyInfo;
        this.mSubSessionKeyInfo = builder.mSubSessionKeyInfo;
        this.mComplexChannel = builder.mComplexChannel;
        this.mPeerAddress = builder.mPeerAddress;
        this.mRangingUpdateRate = builder.mRangingUpdateRate;
        this.mSlotDurationMillis = builder.mSlotDuration;
    }

    public int getSessionId() {
        return this.mSessionId;
    }

    public int getSubSessionId() {
        return this.mSubSessionId;
    }

    public int getConfigId() {
        return this.mConfigId;
    }

    @android.annotation.NonNull
    public UwbAddress getDeviceAddress() {
        return this.mDeviceAddress;
    }

    @Nullable
    public byte[] getSessionKeyInfo() {
        return this.mSessionKeyInfo == null ? null : Arrays.copyOf(this.mSessionKeyInfo, this.mSessionKeyInfo.length);
    }

    @Nullable
    public byte[] getSubSessionKeyInfo() {
        return this.mSubSessionKeyInfo == null ? null : Arrays.copyOf(this.mSubSessionKeyInfo, this.mSubSessionKeyInfo.length);
    }

    @android.annotation.NonNull
    public UwbComplexChannel getComplexChannel() {
        return this.mComplexChannel;
    }

    @android.annotation.NonNull
    public UwbAddress getPeerAddress() {
        return this.mPeerAddress;
    }

    public int getRangingUpdateRate() {
        return this.mRangingUpdateRate;
    }

    public int getSlotDuration() {
        return this.mSlotDurationMillis;
    }

    public String toString() {
        return "UwbRangingParams{ mSessionId=" + this.mSessionId + ", mSubSessionId=" + this.mSubSessionId + ", mConfigId=" + this.mConfigId + ", mDeviceAddress=" + this.mDeviceAddress + ", mSessionKeyInfo=" + Arrays.toString(this.mSessionKeyInfo) + ", mSubSessionKeyInfo=" + Arrays.toString(this.mSubSessionKeyInfo) + ", mComplexChannel=" + this.mComplexChannel + ", mPeerAddress=" + this.mPeerAddress + ", mRangingUpdateRate=" + this.mRangingUpdateRate + ", mSlotDurationMillis=" + this.mSlotDurationMillis + " }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UwbRangingParams)) {
            return false;
        }
        UwbRangingParams that = (UwbRangingParams)o;
        return this.mSessionId == that.mSessionId && this.mSubSessionId == that.mSubSessionId && this.mConfigId == that.mConfigId && this.mRangingUpdateRate == that.mRangingUpdateRate && this.mSlotDurationMillis == that.mSlotDurationMillis && Objects.equals(this.mDeviceAddress, that.mDeviceAddress) && Objects.deepEquals(this.mSessionKeyInfo, that.mSessionKeyInfo) && Objects.deepEquals(this.mSubSessionKeyInfo, that.mSubSessionKeyInfo) && Objects.equals(this.mComplexChannel, that.mComplexChannel) && Objects.equals(this.mPeerAddress, that.mPeerAddress);
    }

    public int hashCode() {
        return Objects.hash(this.mSessionId, this.mSubSessionId, this.mConfigId, this.mDeviceAddress, Arrays.hashCode(this.mSessionKeyInfo), Arrays.hashCode(this.mSubSessionKeyInfo), this.mComplexChannel, this.mPeerAddress, this.mRangingUpdateRate, this.mSlotDurationMillis);
    }

    public static class Builder {
        private int mSessionId;
        private int mSubSessionId = -1;
        private int mConfigId;
        private UwbAddress mDeviceAddress = null;
        private byte[] mSessionKeyInfo = null;
        private byte[] mSubSessionKeyInfo = null;
        private UwbComplexChannel mComplexChannel = new UwbComplexChannel.Builder().build();
        private UwbAddress mPeerAddress = null;
        private int mRangingUpdateRate = 1;
        private int mSlotDuration = 2;

        public Builder(int sessionId, int configId, @android.annotation.NonNull UwbAddress deviceAddress, @android.annotation.NonNull UwbAddress peerAddress) {
            Objects.requireNonNull(deviceAddress);
            Objects.requireNonNull(peerAddress);
            this.mSessionId = sessionId;
            this.mConfigId = configId;
            this.mDeviceAddress = deviceAddress;
            this.mPeerAddress = peerAddress;
        }

        @android.annotation.NonNull
        public Builder setSubSessionId(int subSessionId) {
            this.mSubSessionId = subSessionId;
            return this;
        }

        @android.annotation.NonNull
        public Builder setSessionKeyInfo(@android.annotation.NonNull byte[] sessionKeyInfo) {
            Objects.requireNonNull(sessionKeyInfo);
            this.mSessionKeyInfo = Arrays.copyOf(sessionKeyInfo, sessionKeyInfo.length);
            return this;
        }

        @android.annotation.NonNull
        public Builder setSubSessionKeyInfo(@android.annotation.NonNull byte[] subSessionKeyInfo) {
            Objects.requireNonNull(subSessionKeyInfo);
            this.mSubSessionKeyInfo = Arrays.copyOf(subSessionKeyInfo, subSessionKeyInfo.length);
            return this;
        }

        @android.annotation.NonNull
        public Builder setComplexChannel(@android.annotation.NonNull UwbComplexChannel complexChannel) {
            this.mComplexChannel = complexChannel;
            return this;
        }

        @android.annotation.NonNull
        public Builder setRangingUpdateRate(int rate) {
            this.mRangingUpdateRate = rate;
            return this;
        }

        @android.annotation.NonNull
        public Builder setSlotDuration(int durationMs) {
            this.mSlotDuration = durationMs;
            return this;
        }

        @android.annotation.NonNull
        public UwbRangingParams build() {
            return new UwbRangingParams(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface SlotDuration {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface ConfigId {
    }
}

