/*
 * Decompiled with CFR 0.152.
 */
package android.ranging.uwb;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.ranging.RangingCapabilities;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class UwbRangingCapabilities
implements Parcelable,
RangingCapabilities.TechnologyCapabilities {
    private final boolean mSupportsDistance;
    private final boolean mSupportsAzimuthalAngle;
    private final boolean mSupportsElevationAngle;
    private final boolean mSupportsRangingIntervalReconfigure;
    private final Duration mMinRangingInterval;
    private final List<Integer> mSupportedChannels;
    private final List<Integer> mSupportedNtfConfigs;
    private final List<Integer> mSupportedConfigIds;
    private final List<Integer> mSupportedSlotDurations;
    private final List<Integer> mSupportedRangingUpdateRates;
    private final List<Integer> mSupportedPreambleIndexes;
    private final boolean mHasBackgroundRangingSupport;
    private final String mCountryCode;
    @NonNull
    public static final Parcelable.Creator<UwbRangingCapabilities> CREATOR = new Parcelable.Creator<UwbRangingCapabilities>(){

        @Override
        public UwbRangingCapabilities createFromParcel(Parcel in) {
            return new UwbRangingCapabilities(in);
        }

        public UwbRangingCapabilities[] newArray(int size) {
            return new UwbRangingCapabilities[size];
        }
    };

    private UwbRangingCapabilities(Builder builder) {
        this.mSupportsDistance = builder.mSupportsDistance;
        this.mSupportsAzimuthalAngle = builder.mSupportsAzimuthalAngle;
        this.mSupportsElevationAngle = builder.mSupportsElevationAngle;
        this.mSupportsRangingIntervalReconfigure = builder.mSupportsRangingIntervalReconfigure;
        this.mMinRangingInterval = builder.mMinRangingInterval;
        this.mSupportedChannels = builder.mSupportedChannels;
        this.mSupportedNtfConfigs = builder.mSupportedNtfConfigs;
        this.mSupportedConfigIds = builder.mSupportedConfigIds;
        this.mSupportedSlotDurations = builder.mSupportedSlotDurations;
        this.mSupportedRangingUpdateRates = builder.mSupportedRangingUpdateRates;
        this.mSupportedPreambleIndexes = builder.mSupportedPreambleIndexes;
        this.mHasBackgroundRangingSupport = builder.mHasBackgroundRangingSupport;
        this.mCountryCode = builder.mCountryCode;
    }

    private UwbRangingCapabilities(Parcel in) {
        this.mSupportsDistance = in.readByte() != 0;
        this.mSupportsAzimuthalAngle = in.readByte() != 0;
        this.mSupportsElevationAngle = in.readByte() != 0;
        this.mSupportsRangingIntervalReconfigure = in.readByte() != 0;
        this.mMinRangingInterval = Duration.ofMillis(in.readLong());
        this.mSupportedChannels = new ArrayList<Integer>();
        in.readList(this.mSupportedChannels, Integer.class.getClassLoader(), Integer.class);
        this.mSupportedNtfConfigs = new ArrayList<Integer>();
        in.readList(this.mSupportedNtfConfigs, Integer.class.getClassLoader(), Integer.class);
        this.mSupportedConfigIds = new ArrayList<Integer>();
        in.readList(this.mSupportedConfigIds, Integer.class.getClassLoader(), Integer.class);
        this.mSupportedSlotDurations = new ArrayList<Integer>();
        in.readList(this.mSupportedSlotDurations, Integer.class.getClassLoader(), Integer.class);
        this.mSupportedRangingUpdateRates = new ArrayList<Integer>();
        in.readList(this.mSupportedRangingUpdateRates, Integer.class.getClassLoader(), Integer.class);
        this.mSupportedPreambleIndexes = new ArrayList<Integer>();
        in.readList(this.mSupportedPreambleIndexes, Integer.class.getClassLoader(), Integer.class);
        this.mHasBackgroundRangingSupport = in.readByte() != 0;
        this.mCountryCode = in.readString();
    }

    @Override
    public int getTechnology() {
        return 0;
    }

    public boolean isDistanceMeasurementSupported() {
        return this.mSupportsDistance;
    }

    public boolean isAzimuthalAngleSupported() {
        return this.mSupportsAzimuthalAngle;
    }

    public boolean isElevationAngleSupported() {
        return this.mSupportsElevationAngle;
    }

    public boolean isRangingIntervalReconfigurationSupported() {
        return this.mSupportsRangingIntervalReconfigure;
    }

    @NonNull
    public Duration getMinimumRangingInterval() {
        return this.mMinRangingInterval;
    }

    @NonNull
    public List<Integer> getSupportedChannels() {
        return List.copyOf(this.mSupportedChannels);
    }

    @NonNull
    public List<Integer> getSupportedPreambleIndexes() {
        return List.copyOf(this.mSupportedPreambleIndexes);
    }

    @NonNull
    public List<Integer> getSupportedNotificationConfigurations() {
        return List.copyOf(this.mSupportedNtfConfigs);
    }

    @NonNull
    public List<Integer> getSupportedConfigIds() {
        return List.copyOf(this.mSupportedConfigIds);
    }

    @NonNull
    public List<Integer> getSupportedSlotDurations() {
        return List.copyOf(this.mSupportedSlotDurations);
    }

    @NonNull
    public List<Integer> getSupportedRangingUpdateRates() {
        return List.copyOf(this.mSupportedRangingUpdateRates);
    }

    public boolean isBackgroundRangingSupported() {
        return this.mHasBackgroundRangingSupport;
    }

    @NonNull
    public String getCountryCode() {
        return this.mCountryCode;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeByte((byte)(this.mSupportsDistance ? 1 : 0));
        dest.writeByte((byte)(this.mSupportsAzimuthalAngle ? 1 : 0));
        dest.writeByte((byte)(this.mSupportsElevationAngle ? 1 : 0));
        dest.writeByte((byte)(this.mSupportsRangingIntervalReconfigure ? 1 : 0));
        dest.writeLong(this.mMinRangingInterval.toMillis());
        dest.writeList(this.mSupportedChannels);
        dest.writeList(this.mSupportedNtfConfigs);
        dest.writeList(this.mSupportedConfigIds);
        dest.writeList(this.mSupportedSlotDurations);
        dest.writeList(this.mSupportedRangingUpdateRates);
        dest.writeList(this.mSupportedPreambleIndexes);
        dest.writeByte((byte)(this.mHasBackgroundRangingSupport ? 1 : 0));
        dest.writeString(this.mCountryCode);
    }

    public String toString() {
        return "UwbRangingCapabilities{ mSupportsDistance=" + this.mSupportsDistance + ", mSupportsAzimuthalAngle=" + this.mSupportsAzimuthalAngle + ", mSupportsElevationAngle=" + this.mSupportsElevationAngle + ", mSupportsRangingIntervalReconfigure=" + this.mSupportsRangingIntervalReconfigure + ", mMinRangingInterval=" + this.mMinRangingInterval + ", mSupportedChannels=" + this.mSupportedChannels + ", mSupportedNtfConfigs=" + this.mSupportedNtfConfigs + ", mSupportedConfigIds=" + this.mSupportedConfigIds + ", mSupportedSlotDurations=" + this.mSupportedSlotDurations + ", mSupportedRangingUpdateRates=" + this.mSupportedRangingUpdateRates + ", mSupportedPreambleIndexes=" + this.mSupportedPreambleIndexes + ", mHasBackgroundRangingSupport=" + this.mHasBackgroundRangingSupport + ", mCountryCode=" + this.mCountryCode + " }";
    }

    public static class Builder {
        private boolean mSupportsDistance;
        private boolean mSupportsAzimuthalAngle;
        private boolean mSupportsElevationAngle;
        private boolean mSupportsRangingIntervalReconfigure;
        private Duration mMinRangingInterval;
        private List<Integer> mSupportedChannels;
        private List<Integer> mSupportedNtfConfigs;
        private List<Integer> mSupportedConfigIds;
        private List<Integer> mSupportedSlotDurations;
        private List<Integer> mSupportedRangingUpdateRates;
        private List<Integer> mSupportedPreambleIndexes;
        private boolean mHasBackgroundRangingSupport;
        private String mCountryCode;

        @NonNull
        public Builder setSupportsDistance(boolean supportsDistance) {
            this.mSupportsDistance = supportsDistance;
            return this;
        }

        @NonNull
        public Builder setSupportsAzimuthalAngle(boolean supportsAzimuthalAngle) {
            this.mSupportsAzimuthalAngle = supportsAzimuthalAngle;
            return this;
        }

        @NonNull
        public Builder setSupportsElevationAngle(boolean supportsElevationAngle) {
            this.mSupportsElevationAngle = supportsElevationAngle;
            return this;
        }

        @NonNull
        public Builder setSupportsRangingIntervalReconfigure(boolean supportsRangingIntervalReconfigure) {
            this.mSupportsRangingIntervalReconfigure = supportsRangingIntervalReconfigure;
            return this;
        }

        @NonNull
        public Builder setMinRangingInterval(Duration minRangingInterval) {
            this.mMinRangingInterval = minRangingInterval;
            return this;
        }

        @NonNull
        public Builder setSupportedChannels(List<Integer> supportedChannels) {
            this.mSupportedChannels = supportedChannels;
            return this;
        }

        @NonNull
        public Builder setSupportedPreambleIndexes(List<Integer> supportedPreambleIndexes) {
            this.mSupportedPreambleIndexes = supportedPreambleIndexes;
            return this;
        }

        @NonNull
        public Builder setSupportedNtfConfigs(@NonNull List<Integer> supportedNtfConfigs) {
            this.mSupportedNtfConfigs = supportedNtfConfigs;
            return this;
        }

        @NonNull
        public Builder setSupportedConfigIds(@NonNull List<Integer> supportedConfigIds) {
            this.mSupportedConfigIds = supportedConfigIds;
            return this;
        }

        @NonNull
        public Builder setSupportedSlotDurations(@NonNull List<Integer> supportedSlotDurations) {
            this.mSupportedSlotDurations = supportedSlotDurations;
            return this;
        }

        @NonNull
        public Builder setSupportedRangingUpdateRates(@NonNull List<Integer> supportedRangingUpdateRates) {
            this.mSupportedRangingUpdateRates = supportedRangingUpdateRates;
            return this;
        }

        @NonNull
        public Builder setHasBackgroundRangingSupport(boolean hasBackgroundRangingSupport) {
            this.mHasBackgroundRangingSupport = hasBackgroundRangingSupport;
            return this;
        }

        @NonNull
        public Builder setCountryCode(String countryCode) {
            this.mCountryCode = countryCode;
            return this;
        }

        @NonNull
        public UwbRangingCapabilities build() {
            return new UwbRangingCapabilities(this);
        }
    }
}

