/*
 * Decompiled with CFR 0.152.
 */
package android.ranging.oob;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.ranging.oob.OobHandle;

public interface IOobSendDataListener
extends IInterface {
    public static final String DESCRIPTOR = "android.ranging.oob.IOobSendDataListener";

    public void sendOobData(OobHandle var1, byte[] var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IOobSendDataListener {
        static final int TRANSACTION_sendOobData = 1;

        public Stub() {
            this.attachInterface(this, IOobSendDataListener.DESCRIPTOR);
        }

        public static IOobSendDataListener asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IOobSendDataListener.DESCRIPTOR);
            if (iin != null && iin instanceof IOobSendDataListener) {
                return (IOobSendDataListener)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "sendOobData";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IOobSendDataListener.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    OobHandle _arg0 = data.readTypedObject(OobHandle.CREATOR);
                    byte[] _arg1 = data.createByteArray();
                    data.enforceNoDataAvail();
                    this.sendOobData(_arg0, _arg1);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 0;
        }

        private static class Proxy
        implements IOobSendDataListener {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IOobSendDataListener.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void sendOobData(OobHandle oobHandle, byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IOobSendDataListener.DESCRIPTOR);
                    _data.writeTypedObject(oobHandle, 0);
                    _data.writeByteArray(data);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IOobSendDataListener {
        @Override
        public void sendOobData(OobHandle oobHandle, byte[] data) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

