/*
 * Decompiled with CFR 0.152.
 */
package android.ranging.ble.rssi;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.bluetooth.BluetoothAdapter;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.Objects;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class BleRssiRangingParams
implements Parcelable {
    private final String mPeerBluetoothAddress;
    private final int mRangingUpdateRate;
    @NonNull
    public static final Parcelable.Creator<BleRssiRangingParams> CREATOR = new Parcelable.Creator<BleRssiRangingParams>(){

        @Override
        public BleRssiRangingParams createFromParcel(Parcel in) {
            return new BleRssiRangingParams(in);
        }

        public BleRssiRangingParams[] newArray(int size) {
            return new BleRssiRangingParams[size];
        }
    };

    private BleRssiRangingParams(Builder builder) {
        this.mPeerBluetoothAddress = builder.mPeerBluetoothAddress;
        this.mRangingUpdateRate = builder.mRangingUpdateRate;
    }

    private BleRssiRangingParams(Parcel in) {
        this.mPeerBluetoothAddress = in.readString();
        this.mRangingUpdateRate = in.readInt();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mPeerBluetoothAddress);
        dest.writeInt(this.mRangingUpdateRate);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public String getPeerBluetoothAddress() {
        return this.mPeerBluetoothAddress;
    }

    public int getRangingUpdateRate() {
        return this.mRangingUpdateRate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BleRssiRangingParams)) {
            return false;
        }
        BleRssiRangingParams that = (BleRssiRangingParams)o;
        return this.mRangingUpdateRate == that.mRangingUpdateRate && Objects.equals(this.mPeerBluetoothAddress, that.mPeerBluetoothAddress);
    }

    public int hashCode() {
        return Objects.hash(this.mPeerBluetoothAddress, this.mRangingUpdateRate);
    }

    public static class Builder {
        private String mPeerBluetoothAddress;
        private int mRangingUpdateRate = 1;

        public Builder(@NonNull String peerBluetoothAddress) {
            Objects.requireNonNull(peerBluetoothAddress);
            if (!BluetoothAdapter.checkBluetoothAddress(peerBluetoothAddress)) {
                throw new IllegalArgumentException("Bluetooth address is not in 00:11:22:33:AA:BB format");
            }
            this.mPeerBluetoothAddress = peerBluetoothAddress;
        }

        @NonNull
        public Builder setRangingUpdateRate(int updateRate) {
            this.mRangingUpdateRate = updateRate;
            return this;
        }

        @NonNull
        public BleRssiRangingParams build() {
            return new BleRssiRangingParams(this);
        }
    }
}

