/*
 * Decompiled with CFR 0.152.
 */
package android.ranging.ble.cs;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.bluetooth.BluetoothAdapter;
import android.os.Parcel;
import android.os.Parcelable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_cs_enabled")
public class BleCsRangingParams
implements Parcelable {
    public static final int SIGHT_TYPE_UNKNOWN = 0;
    public static final int SIGHT_TYPE_LINE_OF_SIGHT = 1;
    public static final int SIGHT_TYPE_NON_LINE_OF_SIGHT = 2;
    public static final int LOCATION_TYPE_UNKNOWN = 0;
    public static final int LOCATION_TYPE_INDOOR = 1;
    public static final int LOCATION_TYPE_OUTDOOR = 2;
    private final String mPeerBluetoothAddress;
    private final int mRangingUpdateRate;
    private final int mSightType;
    private final int mLocationType;
    private final int mSecurityLevel;
    @NonNull
    public static final Parcelable.Creator<BleCsRangingParams> CREATOR = new Parcelable.Creator<BleCsRangingParams>(){

        @Override
        public BleCsRangingParams createFromParcel(Parcel in) {
            return new BleCsRangingParams(in);
        }

        public BleCsRangingParams[] newArray(int size) {
            return new BleCsRangingParams[size];
        }
    };

    private BleCsRangingParams(Builder builder) {
        this.mPeerBluetoothAddress = builder.mPeerBluetoothAddress;
        this.mRangingUpdateRate = builder.mRangingUpdateRate;
        this.mSightType = builder.mSightType;
        this.mLocationType = builder.mLocationType;
        this.mSecurityLevel = builder.mSecurityLevel;
    }

    private BleCsRangingParams(Parcel in) {
        this.mPeerBluetoothAddress = in.readString();
        this.mRangingUpdateRate = in.readInt();
        this.mSightType = in.readInt();
        this.mLocationType = in.readInt();
        this.mSecurityLevel = in.readInt();
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mPeerBluetoothAddress);
        dest.writeInt(this.mRangingUpdateRate);
        dest.writeInt(this.mSightType);
        dest.writeInt(this.mLocationType);
        dest.writeInt(this.mSecurityLevel);
    }

    @NonNull
    public String getPeerBluetoothAddress() {
        return this.mPeerBluetoothAddress;
    }

    public int getRangingUpdateRate() {
        return this.mRangingUpdateRate;
    }

    public int getSightType() {
        return this.mSightType;
    }

    public int getLocationType() {
        return this.mLocationType;
    }

    public int getSecurityLevel() {
        return this.mSecurityLevel;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BleCsRangingParams)) {
            return false;
        }
        BleCsRangingParams that = (BleCsRangingParams)o;
        return this.mRangingUpdateRate == that.mRangingUpdateRate && this.mSightType == that.mSightType && this.mLocationType == that.mLocationType && this.mSecurityLevel == that.mSecurityLevel && Objects.equals(this.mPeerBluetoothAddress, that.mPeerBluetoothAddress);
    }

    public int hashCode() {
        return Objects.hash(this.mPeerBluetoothAddress, this.mRangingUpdateRate, this.mSightType, this.mLocationType, this.mSecurityLevel);
    }

    public static class Builder {
        private String mPeerBluetoothAddress;
        private int mRangingUpdateRate = 1;
        private int mSightType = 0;
        private int mLocationType = 0;
        private int mSecurityLevel = 1;

        public Builder(@NonNull String peerBluetoothAddress) {
            Objects.requireNonNull(peerBluetoothAddress);
            if (!BluetoothAdapter.checkBluetoothAddress(peerBluetoothAddress)) {
                throw new IllegalArgumentException("Bluetooth address is not in 00:11:22:33:AA:BB format");
            }
            this.mPeerBluetoothAddress = peerBluetoothAddress;
        }

        @NonNull
        public Builder setRangingUpdateRate(int updateRate) {
            this.mRangingUpdateRate = updateRate;
            return this;
        }

        @NonNull
        public Builder setSightType(int sightType) {
            this.mSightType = sightType;
            return this;
        }

        @NonNull
        public Builder setLocationType(int locationType) {
            this.mLocationType = locationType;
            return this;
        }

        @NonNull
        public Builder setSecurityLevel(int securityLevel) {
            this.mSecurityLevel = securityLevel;
            return this;
        }

        @NonNull
        public BleCsRangingParams build() {
            return new BleCsRangingParams(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface LocationType {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    static @interface SightType {
    }
}

