/*
 * Decompiled with CFR 0.152.
 */
package android.ranging.ble.cs;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.ranging.RangingCapabilities;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_cs_enabled")
public class BleCsRangingCapabilities
implements Parcelable,
RangingCapabilities.TechnologyCapabilities {
    public static final int CS_SECURITY_LEVEL_ONE = 1;
    public static final int CS_SECURITY_LEVEL_FOUR = 4;
    private final List<Integer> mSupportedSecurityLevels;
    private final String mBluetoothAddress;
    @NonNull
    public static final Parcelable.Creator<BleCsRangingCapabilities> CREATOR = new Parcelable.Creator<BleCsRangingCapabilities>(){

        @Override
        public BleCsRangingCapabilities createFromParcel(Parcel in) {
            return new BleCsRangingCapabilities(in);
        }

        public BleCsRangingCapabilities[] newArray(int size) {
            return new BleCsRangingCapabilities[size];
        }
    };

    @NonNull
    public Set<Integer> getSupportedSecurityLevels() {
        return new HashSet<Integer>(this.mSupportedSecurityLevels);
    }

    private BleCsRangingCapabilities(Builder builder) {
        this.mSupportedSecurityLevels = builder.mSupportedSecurityLevels;
        this.mBluetoothAddress = builder.mBluetoothAddress;
    }

    private BleCsRangingCapabilities(Parcel in) {
        this.mSupportedSecurityLevels = new ArrayList<Integer>();
        in.readList(this.mSupportedSecurityLevels, Integer.class.getClassLoader(), Integer.class);
        this.mBluetoothAddress = in.readString();
    }

    @NonNull
    public String getBluetoothAddress() {
        return this.mBluetoothAddress;
    }

    @Override
    public int getTechnology() {
        return 1;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeList(this.mSupportedSecurityLevels);
        dest.writeString(this.mBluetoothAddress);
    }

    public String toString() {
        return "BleCsRangingCapabilities{ mBluetoothAddress=" + this.mBluetoothAddress + ", mSupportedSecurityLevels=" + this.mSupportedSecurityLevels + " }";
    }

    public static class Builder {
        private List<Integer> mSupportedSecurityLevels;
        private String mBluetoothAddress;

        @NonNull
        public Builder setSupportedSecurityLevels(List<Integer> supportedSecurityLevels) {
            this.mSupportedSecurityLevels = supportedSecurityLevels;
            return this;
        }

        @NonNull
        public Builder setBluetoothAddress(String address) {
            this.mBluetoothAddress = address;
            return this;
        }

        @NonNull
        public BleCsRangingCapabilities build() {
            return new BleCsRangingCapabilities(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface SecurityLevel {
    }
}

