/*
 * Decompiled with CFR 0.152.
 */
package android.ranging;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.ranging.RangingConfig;
import android.ranging.SessionConfig;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class RangingPreference
implements Parcelable {
    public static final int DEVICE_ROLE_RESPONDER = 0;
    public static final int DEVICE_ROLE_INITIATOR = 1;
    private final int mDeviceRole;
    private final RangingConfig mRangingParams;
    private final SessionConfig mSessionConfig;
    @NonNull
    public static final Parcelable.Creator<RangingPreference> CREATOR = new Parcelable.Creator<RangingPreference>(){

        @Override
        public RangingPreference createFromParcel(Parcel in) {
            return new RangingPreference(in);
        }

        public RangingPreference[] newArray(int size) {
            return new RangingPreference[size];
        }
    };

    private RangingPreference(Builder builder) {
        this.mDeviceRole = builder.mDeviceRole;
        this.mRangingParams = builder.mRangingConfig;
        this.mSessionConfig = builder.mSessionConfig;
    }

    private RangingPreference(Parcel in) {
        this.mDeviceRole = in.readInt();
        this.mRangingParams = in.readParcelable(RangingConfig.class.getClassLoader(), RangingConfig.class);
        this.mSessionConfig = in.readParcelable(SessionConfig.class.getClassLoader(), SessionConfig.class);
    }

    public int getDeviceRole() {
        return this.mDeviceRole;
    }

    @Nullable
    public RangingConfig getRangingParams() {
        return this.mRangingParams;
    }

    @NonNull
    public SessionConfig getSessionConfig() {
        return this.mSessionConfig;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mDeviceRole);
        dest.writeParcelable(this.mRangingParams, flags);
        dest.writeParcelable(this.mSessionConfig, flags);
    }

    public String toString() {
        return "RangingPreference{ mDeviceRole=" + this.mDeviceRole + ", mRangingParameters=" + this.mRangingParams + ", mSessionConfig=" + this.mSessionConfig + " }";
    }

    public static class Builder {
        private final int mDeviceRole;
        private final RangingConfig mRangingConfig;
        private SessionConfig mSessionConfig = new SessionConfig.Builder().build();

        public Builder(int role, @NonNull RangingConfig rangingConfig) {
            Objects.requireNonNull(rangingConfig, "rangingConfig cannot be null");
            this.mDeviceRole = role;
            this.mRangingConfig = rangingConfig;
        }

        @NonNull
        public Builder setSessionConfig(@NonNull SessionConfig config) {
            Objects.requireNonNull(config, "config cannot be null");
            this.mSessionConfig = config;
            return this;
        }

        @NonNull
        public RangingPreference build() {
            return new RangingPreference(this);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface DeviceRole {
    }
}

