/*
 * Decompiled with CFR 0.152.
 */
package android.ranging;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import java.util.UUID;

@FlaggedApi(value="com.android.x.ranging.com.android.ranging.flags.ranging_stack_enabled")
public class RangingDevice
implements Parcelable {
    private final UUID mId;
    @NonNull
    public static final Parcelable.Creator<RangingDevice> CREATOR = new Parcelable.Creator<RangingDevice>(){

        @Override
        public RangingDevice createFromParcel(Parcel in) {
            return new RangingDevice(in);
        }

        public RangingDevice[] newArray(int size) {
            return new RangingDevice[size];
        }
    };

    private RangingDevice(Builder builder) {
        this.mId = builder.mId;
    }

    private RangingDevice(Parcel in) {
        long mostSigBits = in.readLong();
        long leastSigBits = in.readLong();
        this.mId = new UUID(mostSigBits, leastSigBits);
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeLong(this.mId.getMostSignificantBits());
        dest.writeLong(this.mId.getLeastSignificantBits());
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @NonNull
    public UUID getUuid() {
        return this.mId;
    }

    public int hashCode() {
        return ((Object)this.mId).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RangingDevice) {
            RangingDevice device = (RangingDevice)obj;
            return ((Object)this.mId).equals(device.getUuid());
        }
        return false;
    }

    public String toString() {
        return "RangingDevice{ " + this.mId + " }";
    }

    public static class Builder {
        private UUID mId = UUID.randomUUID();

        @NonNull
        public Builder setUuid(@NonNull UUID id2) {
            this.mId = id2;
            return this;
        }

        @NonNull
        public RangingDevice build() {
            return new RangingDevice(this);
        }
    }
}

