/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@FlaggedApi(value="android.provider.user_keys")
public class E2eeContactKeysManager {
    public static final String AUTHORITY = "com.android.contactkeys.contactkeysprovider";
    @NonNull
    public static final Uri AUTHORITY_URI = Uri.parse("content://com.android.contactkeys.contactkeysprovider");
    private static final int MAX_KEY_SIZE_BYTES = 5000;
    private static final int ARRAY_IS_NULL = -1;
    @NonNull
    private final ContentResolver mContentResolver;
    public static final int VERIFICATION_STATE_UNVERIFIED = 0;
    public static final int VERIFICATION_STATE_VERIFICATION_FAILED = 1;
    public static final int VERIFICATION_STATE_VERIFIED = 2;

    public E2eeContactKeysManager(@NonNull Context context) {
        Objects.requireNonNull(context);
        this.mContentResolver = context.getContentResolver();
    }

    @RequiresPermission(value="android.permission.WRITE_CONTACTS")
    public void updateOrInsertE2eeContactKey(@NonNull String lookupKey, @NonNull String deviceId, @NonNull String accountId, @NonNull byte[] keyValue) {
        E2eeContactKeysManager.validateKeyLength(keyValue);
        Bundle extras = new Bundle();
        extras.putString("lookup", Objects.requireNonNull(lookupKey));
        extras.putString("device_id", Objects.requireNonNull(deviceId));
        extras.putString("account_id", Objects.requireNonNull(accountId));
        extras.putByteArray("key_value", Objects.requireNonNull(keyValue));
        this.nullSafeCall(this.mContentResolver, "updateOrInsertContactKey", extras);
    }

    @RequiresPermission(value="android.permission.READ_CONTACTS")
    @Nullable
    public E2eeContactKey getE2eeContactKey(@NonNull String lookupKey, @NonNull String deviceId, @NonNull String accountId) {
        Bundle extras = new Bundle();
        extras.putString("lookup", Objects.requireNonNull(lookupKey));
        extras.putString("device_id", Objects.requireNonNull(deviceId));
        extras.putString("account_id", Objects.requireNonNull(accountId));
        Bundle response = this.nullSafeCall(this.mContentResolver, "getContactKey", extras);
        if (response == null) {
            return null;
        }
        return response.getParcelable("key_contact_key", E2eeContactKey.class);
    }

    @RequiresPermission(value="android.permission.READ_CONTACTS")
    @NonNull
    public List<E2eeContactKey> getAllE2eeContactKeys(@NonNull String lookupKey) {
        Bundle extras = new Bundle();
        extras.putString("lookup", Objects.requireNonNull(lookupKey));
        Bundle response = this.nullSafeCall(this.mContentResolver, "getAllContactKeys", extras);
        if (response == null) {
            return new ArrayList<E2eeContactKey>();
        }
        ArrayList<E2eeContactKey> value = response.getParcelableArrayList("key_contact_keys", E2eeContactKey.class);
        if (value == null) {
            return new ArrayList<E2eeContactKey>();
        }
        return value;
    }

    @RequiresPermission(value="android.permission.READ_CONTACTS")
    @NonNull
    public List<E2eeContactKey> getOwnerE2eeContactKeys(@NonNull String lookupKey) {
        Bundle extras = new Bundle();
        extras.putString("lookup", Objects.requireNonNull(lookupKey));
        Bundle response = this.nullSafeCall(this.mContentResolver, "getOwnerContactKeys", extras);
        if (response == null) {
            return new ArrayList<E2eeContactKey>();
        }
        ArrayList<E2eeContactKey> value = response.getParcelableArrayList("key_contact_keys", E2eeContactKey.class);
        if (value == null) {
            return new ArrayList<E2eeContactKey>();
        }
        return value;
    }

    @RequiresPermission(value="android.permission.WRITE_CONTACTS")
    public boolean updateE2eeContactKeyLocalVerificationState(@NonNull String lookupKey, @NonNull String deviceId, @NonNull String accountId, int localVerificationState) {
        E2eeContactKeysManager.validateVerificationState(localVerificationState);
        Bundle extras = new Bundle();
        extras.putString("lookup", Objects.requireNonNull(lookupKey));
        extras.putString("device_id", Objects.requireNonNull(deviceId));
        extras.putString("account_id", Objects.requireNonNull(accountId));
        extras.putInt("local_verification_state", localVerificationState);
        Bundle response = this.nullSafeCall(this.mContentResolver, "updateContactKeyLocalVerificationState", extras);
        return response != null && response.getBoolean("key_updated_rows");
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.WRITE_VERIFICATION_STATE_E2EE_CONTACT_KEYS", "android.permission.WRITE_CONTACTS"})
    public boolean updateE2eeContactKeyLocalVerificationState(@NonNull String lookupKey, @NonNull String deviceId, @NonNull String accountId, @NonNull String ownerPackageName, int localVerificationState) {
        E2eeContactKeysManager.validateVerificationState(localVerificationState);
        Bundle extras = new Bundle();
        extras.putString("lookup", Objects.requireNonNull(lookupKey));
        extras.putString("device_id", Objects.requireNonNull(deviceId));
        extras.putString("account_id", Objects.requireNonNull(accountId));
        extras.putString("owner_package_name", Objects.requireNonNull(ownerPackageName));
        extras.putInt("local_verification_state", localVerificationState);
        Bundle response = this.nullSafeCall(this.mContentResolver, "updateContactKeyLocalVerificationState", extras);
        return response != null && response.getBoolean("key_updated_rows");
    }

    @RequiresPermission(value="android.permission.WRITE_CONTACTS")
    public boolean updateE2eeContactKeyRemoteVerificationState(@NonNull String lookupKey, @NonNull String deviceId, @NonNull String accountId, int remoteVerificationState) {
        E2eeContactKeysManager.validateVerificationState(remoteVerificationState);
        Bundle extras = new Bundle();
        extras.putString("lookup", Objects.requireNonNull(lookupKey));
        extras.putString("device_id", Objects.requireNonNull(deviceId));
        extras.putString("account_id", Objects.requireNonNull(accountId));
        extras.putInt("remote_verification_state", remoteVerificationState);
        Bundle response = this.nullSafeCall(this.mContentResolver, "updateContactKeyRemoteVerificationState", extras);
        return response != null && response.getBoolean("key_updated_rows");
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.WRITE_VERIFICATION_STATE_E2EE_CONTACT_KEYS", "android.permission.WRITE_CONTACTS"})
    public boolean updateE2eeContactKeyRemoteVerificationState(@NonNull String lookupKey, @NonNull String deviceId, @NonNull String accountId, @NonNull String ownerPackageName, int remoteVerificationState) {
        E2eeContactKeysManager.validateVerificationState(remoteVerificationState);
        Bundle extras = new Bundle();
        extras.putString("lookup", Objects.requireNonNull(lookupKey));
        extras.putString("device_id", Objects.requireNonNull(deviceId));
        extras.putString("account_id", Objects.requireNonNull(accountId));
        extras.putString("owner_package_name", Objects.requireNonNull(ownerPackageName));
        extras.putInt("remote_verification_state", remoteVerificationState);
        Bundle response = this.nullSafeCall(this.mContentResolver, "updateContactKeyRemoteVerificationState", extras);
        return response != null && response.getBoolean("key_updated_rows");
    }

    private static void validateVerificationState(int verificationState) {
        if (verificationState != 0 && verificationState != 1 && verificationState != 2) {
            throw new IllegalArgumentException("Verification state value " + verificationState + " is not supported");
        }
    }

    @RequiresPermission(value="android.permission.WRITE_CONTACTS")
    public boolean removeE2eeContactKey(@NonNull String lookupKey, @NonNull String deviceId, @NonNull String accountId) {
        Bundle extras = new Bundle();
        extras.putString("lookup", Objects.requireNonNull(lookupKey));
        extras.putString("device_id", Objects.requireNonNull(deviceId));
        extras.putString("account_id", Objects.requireNonNull(accountId));
        Bundle response = this.nullSafeCall(this.mContentResolver, "removeContactKey", extras);
        return response != null && response.getBoolean("key_updated_rows");
    }

    @RequiresPermission(value="android.permission.WRITE_CONTACTS")
    public boolean updateOrInsertE2eeSelfKey(@NonNull String deviceId, @NonNull String accountId, @NonNull byte[] keyValue) {
        E2eeContactKeysManager.validateKeyLength(keyValue);
        Bundle extras = new Bundle();
        extras.putString("device_id", Objects.requireNonNull(deviceId));
        extras.putString("account_id", Objects.requireNonNull(accountId));
        extras.putByteArray("key_value", Objects.requireNonNull(keyValue));
        Bundle response = this.nullSafeCall(this.mContentResolver, "updateOrInsertSelfKey", extras);
        return response != null && response.getBoolean("key_updated_rows");
    }

    private static void validateKeyLength(byte[] keyValue) {
        Objects.requireNonNull(keyValue);
        if (keyValue.length == 0 || keyValue.length > E2eeContactKeysManager.getMaxKeySizeBytes()) {
            throw new IllegalArgumentException("Key value length is " + keyValue.length + ". Should be more than 0 and less than " + E2eeContactKeysManager.getMaxKeySizeBytes());
        }
    }

    @RequiresPermission(value="android.permission.WRITE_CONTACTS")
    public boolean updateE2eeSelfKeyRemoteVerificationState(@NonNull String deviceId, @NonNull String accountId, int remoteVerificationState) {
        E2eeContactKeysManager.validateVerificationState(remoteVerificationState);
        Bundle extras = new Bundle();
        extras.putString("device_id", Objects.requireNonNull(deviceId));
        extras.putString("account_id", Objects.requireNonNull(accountId));
        extras.putInt("remote_verification_state", remoteVerificationState);
        Bundle response = this.nullSafeCall(this.mContentResolver, "updateSelfKeyRemoteVerificationState", extras);
        return response != null && response.getBoolean("key_updated_rows");
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.WRITE_VERIFICATION_STATE_E2EE_CONTACT_KEYS", "android.permission.WRITE_CONTACTS"})
    public boolean updateE2eeSelfKeyRemoteVerificationState(@NonNull String deviceId, @NonNull String accountId, @NonNull String ownerPackageName, int remoteVerificationState) {
        E2eeContactKeysManager.validateVerificationState(remoteVerificationState);
        Bundle extras = new Bundle();
        extras.putString("device_id", Objects.requireNonNull(deviceId));
        extras.putString("account_id", Objects.requireNonNull(accountId));
        extras.putString("owner_package_name", Objects.requireNonNull(ownerPackageName));
        extras.putInt("remote_verification_state", remoteVerificationState);
        Bundle response = this.nullSafeCall(this.mContentResolver, "updateSelfKeyRemoteVerificationState", extras);
        return response != null && response.getBoolean("key_updated_rows");
    }

    public static int getMaxKeySizeBytes() {
        return 5000;
    }

    @RequiresPermission(value="android.permission.READ_CONTACTS")
    @Nullable
    public E2eeSelfKey getE2eeSelfKey(@NonNull String deviceId, @NonNull String accountId) {
        Bundle extras = new Bundle();
        extras.putString("device_id", Objects.requireNonNull(deviceId));
        extras.putString("account_id", Objects.requireNonNull(accountId));
        Bundle response = this.nullSafeCall(this.mContentResolver, "getSelfKey", extras);
        if (response == null) {
            return null;
        }
        return response.getParcelable("key_contact_key", E2eeSelfKey.class);
    }

    @RequiresPermission(value="android.permission.READ_CONTACTS")
    @NonNull
    public List<E2eeSelfKey> getAllE2eeSelfKeys() {
        Bundle extras = new Bundle();
        Bundle response = this.nullSafeCall(this.mContentResolver, "getAllSelfKeys", extras);
        if (response == null) {
            return new ArrayList<E2eeSelfKey>();
        }
        ArrayList<E2eeSelfKey> value = response.getParcelableArrayList("key_contact_keys", E2eeSelfKey.class);
        if (value == null) {
            return new ArrayList<E2eeSelfKey>();
        }
        return value;
    }

    @RequiresPermission(value="android.permission.READ_CONTACTS")
    @NonNull
    public List<E2eeSelfKey> getOwnerE2eeSelfKeys() {
        Bundle extras = new Bundle();
        Bundle response = this.nullSafeCall(this.mContentResolver, "getOwnerSelfKeys", extras);
        if (response == null) {
            return new ArrayList<E2eeSelfKey>();
        }
        ArrayList<E2eeSelfKey> value = response.getParcelableArrayList("key_contact_keys", E2eeSelfKey.class);
        if (value == null) {
            return new ArrayList<E2eeSelfKey>();
        }
        return value;
    }

    @RequiresPermission(value="android.permission.WRITE_CONTACTS")
    public boolean removeE2eeSelfKey(@NonNull String deviceId, @NonNull String accountId) {
        Bundle extras = new Bundle();
        extras.putString("device_id", Objects.requireNonNull(deviceId));
        extras.putString("account_id", Objects.requireNonNull(accountId));
        Bundle response = this.nullSafeCall(this.mContentResolver, "removeSelfKey", extras);
        return response != null && response.getBoolean("key_updated_rows");
    }

    private Bundle nullSafeCall(@NonNull ContentResolver resolver, @NonNull String method, @Nullable Bundle extras) {
        ContentProviderClient client = resolver.acquireContentProviderClient(AUTHORITY_URI);
        try {
            Bundle bundle = client.call(method, null, extras);
            if (client != null) {
                client.close();
            }
            return bundle;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (RemoteException e) {
                throw e.rethrowAsRuntimeException();
            }
        }
    }

    public static class E2eeContactKeys {
        public static final String LOOKUP_KEY = "lookup";
        public static final String DEVICE_ID = "device_id";
        public static final String ACCOUNT_ID = "account_id";
        public static final String DISPLAY_NAME = "display_name";
        public static final String PHONE_NUMBER = "number";
        public static final String EMAIL_ADDRESS = "address";
        public static final String TIME_UPDATED = "time_updated";
        public static final String KEY_VALUE = "key_value";
        public static final String OWNER_PACKAGE_NAME = "owner_package_name";
        public static final String LOCAL_VERIFICATION_STATE = "local_verification_state";
        public static final String REMOTE_VERIFICATION_STATE = "remote_verification_state";
        public static final String UPDATE_OR_INSERT_CONTACT_KEY_METHOD = "updateOrInsertContactKey";
        public static final String GET_CONTACT_KEY_METHOD = "getContactKey";
        public static final String GET_ALL_CONTACT_KEYS_METHOD = "getAllContactKeys";
        public static final String GET_OWNER_CONTACT_KEYS_METHOD = "getOwnerContactKeys";
        public static final String UPDATE_CONTACT_KEY_LOCAL_VERIFICATION_STATE_METHOD = "updateContactKeyLocalVerificationState";
        public static final String UPDATE_CONTACT_KEY_REMOTE_VERIFICATION_STATE_METHOD = "updateContactKeyRemoteVerificationState";
        public static final String REMOVE_CONTACT_KEY_METHOD = "removeContactKey";
        public static final String UPDATE_OR_INSERT_SELF_KEY_METHOD = "updateOrInsertSelfKey";
        public static final String UPDATE_SELF_KEY_REMOTE_VERIFICATION_STATE_METHOD = "updateSelfKeyRemoteVerificationState";
        public static final String GET_SELF_KEY_METHOD = "getSelfKey";
        public static final String GET_ALL_SELF_KEYS_METHOD = "getAllSelfKeys";
        public static final String GET_OWNER_SELF_KEYS_METHOD = "getOwnerSelfKeys";
        public static final String REMOVE_SELF_KEY_METHOD = "removeSelfKey";
        public static final String KEY_CONTACT_KEYS = "key_contact_keys";
        public static final String KEY_CONTACT_KEY = "key_contact_key";
        public static final String KEY_UPDATED_ROWS = "key_updated_rows";

        private E2eeContactKeys() {
        }
    }

    public static class E2eeContactKey
    extends E2eeBaseKey
    implements Parcelable {
        private final int mLocalVerificationState;
        private final String mDisplayName;
        private final String mPhoneNumber;
        private final String mEmailAddress;
        @NonNull
        public static final Parcelable.Creator<E2eeContactKey> CREATOR = new Parcelable.Creator<E2eeContactKey>(){

            @Override
            public E2eeContactKey createFromParcel(Parcel source) {
                byte[] keyValue;
                String deviceId = source.readString8();
                String accountId = source.readString8();
                String ownerPackageName = source.readString8();
                long timeUpdated = source.readLong();
                int keyValueLength = source.readInt();
                if (keyValueLength > 0) {
                    keyValue = new byte[keyValueLength];
                    source.readByteArray(keyValue);
                } else {
                    keyValue = null;
                }
                int localVerificationState = source.readInt();
                int remoteVerificationState = source.readInt();
                String displayName = source.readString8();
                String number = source.readString8();
                String address = source.readString8();
                return new E2eeContactKey(deviceId, accountId, ownerPackageName, timeUpdated, keyValue, localVerificationState, remoteVerificationState, displayName, number, address);
            }

            public E2eeContactKey[] newArray(int size) {
                return new E2eeContactKey[size];
            }
        };

        public E2eeContactKey(@Nullable String deviceId, @NonNull String accountId, @NonNull String ownerPackageName, long timeUpdated, @Nullable byte[] keyValue, int localVerificationState, int remoteVerificationState, @Nullable String displayName, @Nullable String phoneNumber, @Nullable String emailAddress) {
            super(deviceId, accountId, ownerPackageName, timeUpdated, keyValue, remoteVerificationState);
            this.mLocalVerificationState = localVerificationState;
            this.mDisplayName = displayName;
            this.mPhoneNumber = phoneNumber;
            this.mEmailAddress = emailAddress;
        }

        public int getLocalVerificationState() {
            return this.mLocalVerificationState;
        }

        @Nullable
        public String getDisplayName() {
            return this.mDisplayName;
        }

        @Nullable
        public String getPhoneNumber() {
            return this.mPhoneNumber;
        }

        @Nullable
        public String getEmailAddress() {
            return this.mEmailAddress;
        }

        public int hashCode() {
            return Objects.hash(this.mDeviceId, this.mAccountId, this.mOwnerPackageName, this.mTimeUpdated, Arrays.hashCode(this.mKeyValue), this.mLocalVerificationState, this.mRemoteVerificationState, this.mDisplayName, this.mPhoneNumber, this.mEmailAddress);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof E2eeContactKey)) {
                return false;
            }
            E2eeContactKey toCompare = (E2eeContactKey)obj;
            return Objects.equals(this.mDeviceId, toCompare.mDeviceId) && Objects.equals(this.mAccountId, toCompare.mAccountId) && Objects.equals(this.mOwnerPackageName, toCompare.mOwnerPackageName) && this.mTimeUpdated == toCompare.mTimeUpdated && Arrays.equals(this.mKeyValue, toCompare.mKeyValue) && this.mLocalVerificationState == toCompare.mLocalVerificationState && this.mRemoteVerificationState == toCompare.mRemoteVerificationState && Objects.equals(this.mDisplayName, toCompare.mDisplayName) && Objects.equals(this.mPhoneNumber, toCompare.mPhoneNumber) && Objects.equals(this.mEmailAddress, toCompare.mEmailAddress);
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeString8(this.mDeviceId);
            dest.writeString8(this.mAccountId);
            dest.writeString8(this.mOwnerPackageName);
            dest.writeLong(this.mTimeUpdated);
            dest.writeInt(this.mKeyValue != null ? this.mKeyValue.length : -1);
            if (this.mKeyValue != null) {
                dest.writeByteArray(this.mKeyValue);
            }
            dest.writeInt(this.mLocalVerificationState);
            dest.writeInt(this.mRemoteVerificationState);
            dest.writeString8(this.mDisplayName);
            dest.writeString8(this.mPhoneNumber);
            dest.writeString8(this.mEmailAddress);
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    public static class E2eeSelfKey
    extends E2eeBaseKey
    implements Parcelable {
        @NonNull
        public static final Parcelable.Creator<E2eeSelfKey> CREATOR = new Parcelable.Creator<E2eeSelfKey>(){

            @Override
            public E2eeSelfKey createFromParcel(Parcel source) {
                byte[] keyValue;
                String deviceId = source.readString8();
                String accountId = source.readString8();
                String ownerPackageName = source.readString8();
                long timeUpdated = source.readLong();
                int keyValueLength = source.readInt();
                if (keyValueLength > 0) {
                    keyValue = new byte[keyValueLength];
                    source.readByteArray(keyValue);
                } else {
                    keyValue = null;
                }
                int remoteVerificationState = source.readInt();
                return new E2eeSelfKey(deviceId, accountId, ownerPackageName, timeUpdated, keyValue, remoteVerificationState);
            }

            public E2eeSelfKey[] newArray(int size) {
                return new E2eeSelfKey[size];
            }
        };

        public E2eeSelfKey(@Nullable String deviceId, @NonNull String accountId, @NonNull String ownerPackageName, long timeUpdated, @Nullable byte[] keyValue, int remoteVerificationState) {
            super(deviceId, accountId, ownerPackageName, timeUpdated, keyValue, remoteVerificationState);
        }

        public int hashCode() {
            return Objects.hash(this.mDeviceId, this.mAccountId, this.mOwnerPackageName, this.mTimeUpdated, Arrays.hashCode(this.mKeyValue), this.mRemoteVerificationState);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof E2eeSelfKey)) {
                return false;
            }
            E2eeSelfKey toCompare = (E2eeSelfKey)obj;
            return Objects.equals(this.mDeviceId, toCompare.mDeviceId) && Objects.equals(this.mAccountId, toCompare.mAccountId) && Objects.equals(this.mOwnerPackageName, toCompare.mOwnerPackageName) && this.mTimeUpdated == toCompare.mTimeUpdated && Arrays.equals(this.mKeyValue, toCompare.mKeyValue) && this.mRemoteVerificationState == toCompare.mRemoteVerificationState;
        }

        @Override
        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeString8(this.mDeviceId);
            dest.writeString8(this.mAccountId);
            dest.writeString8(this.mOwnerPackageName);
            dest.writeLong(this.mTimeUpdated);
            dest.writeInt(this.mKeyValue != null ? this.mKeyValue.length : -1);
            if (this.mKeyValue != null) {
                dest.writeByteArray(this.mKeyValue);
            }
            dest.writeInt(this.mRemoteVerificationState);
        }

        @Override
        public int describeContents() {
            return 0;
        }
    }

    static abstract class E2eeBaseKey {
        protected final String mDeviceId;
        protected final String mAccountId;
        protected final String mOwnerPackageName;
        protected final long mTimeUpdated;
        protected final byte[] mKeyValue;
        protected final int mRemoteVerificationState;

        protected E2eeBaseKey(@Nullable String deviceId, @NonNull String accountId, @NonNull String ownerPackageName, long timeUpdated, @Nullable byte[] keyValue, int remoteVerificationState) {
            this.mDeviceId = deviceId;
            this.mAccountId = accountId;
            this.mOwnerPackageName = ownerPackageName;
            this.mTimeUpdated = timeUpdated;
            this.mKeyValue = keyValue == null ? null : Arrays.copyOf(keyValue, keyValue.length);
            this.mRemoteVerificationState = remoteVerificationState;
        }

        @Nullable
        public String getDeviceId() {
            return this.mDeviceId;
        }

        @NonNull
        public String getAccountId() {
            return this.mAccountId;
        }

        @NonNull
        public String getOwnerPackageName() {
            return this.mOwnerPackageName;
        }

        public long getTimeUpdated() {
            return this.mTimeUpdated;
        }

        @Nullable
        public byte[] getKeyValue() {
            return this.mKeyValue == null ? null : Arrays.copyOf(this.mKeyValue, this.mKeyValue.length);
        }

        public int getRemoteVerificationState() {
            return this.mRemoteVerificationState;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface VerificationState {
    }
}

