/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.os.Binder;
import android.os.IBinder;
import android.os.ICancellationSignal;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.print.PrintDocumentInfo;
import android.text.TextUtils;

public interface ILayoutResultCallback
extends IInterface {
    public void onLayoutStarted(ICancellationSignal var1, int var2) throws RemoteException;

    public void onLayoutFinished(PrintDocumentInfo var1, boolean var2, int var3) throws RemoteException;

    public void onLayoutFailed(CharSequence var1, int var2) throws RemoteException;

    public void onLayoutCanceled(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ILayoutResultCallback {
        public static final String DESCRIPTOR = "android.print.ILayoutResultCallback";
        static final int TRANSACTION_onLayoutStarted = 1;
        static final int TRANSACTION_onLayoutFinished = 2;
        static final int TRANSACTION_onLayoutFailed = 3;
        static final int TRANSACTION_onLayoutCanceled = 4;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static ILayoutResultCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof ILayoutResultCallback) {
                return (ILayoutResultCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onLayoutStarted";
                }
                case 2: {
                    return "onLayoutFinished";
                }
                case 3: {
                    return "onLayoutFailed";
                }
                case 4: {
                    return "onLayoutCanceled";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    ICancellationSignal _arg0 = ICancellationSignal.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onLayoutStarted(_arg0, _arg1);
                    break;
                }
                case 2: {
                    PrintDocumentInfo _arg0 = data.readTypedObject(PrintDocumentInfo.CREATOR);
                    boolean _arg1 = data.readBoolean();
                    int _arg2 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onLayoutFinished(_arg0, _arg1, _arg2);
                    break;
                }
                case 3: {
                    CharSequence _arg0 = data.readTypedObject(TextUtils.CHAR_SEQUENCE_CREATOR);
                    int _arg1 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onLayoutFailed(_arg0, _arg1);
                    break;
                }
                case 4: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onLayoutCanceled(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 3;
        }

        private static class Proxy
        implements ILayoutResultCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLayoutStarted(ICancellationSignal cancellation, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongInterface(cancellation);
                    _data.writeInt(sequence);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLayoutFinished(PrintDocumentInfo info, boolean changed, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedObject(info, 0);
                    _data.writeBoolean(changed);
                    _data.writeInt(sequence);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLayoutFailed(CharSequence error, int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (error != null) {
                        _data.writeInt(1);
                        TextUtils.writeToParcel(error, _data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(sequence);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLayoutCanceled(int sequence) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(sequence);
                    boolean bl = this.mRemote.transact(4, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ILayoutResultCallback {
        @Override
        public void onLayoutStarted(ICancellationSignal cancellation, int sequence) throws RemoteException {
        }

        @Override
        public void onLayoutFinished(PrintDocumentInfo info, boolean changed, int sequence) throws RemoteException {
        }

        @Override
        public void onLayoutFailed(CharSequence error, int sequence) throws RemoteException {
        }

        @Override
        public void onLayoutCanceled(int sequence) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

