/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.preference.Preference;
import android.preference.PreferenceInflater;
import android.preference.PreferenceManager;
import android.util.AttributeSet;
import android.view.InflateException;
import com.android.layoutlib.bridge.Bridge;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.android.BridgeXmlBlockParser;

public class BridgePreferenceInflater
extends PreferenceInflater {
    public BridgePreferenceInflater(Context context, PreferenceManager preferenceManager) {
        super(context, preferenceManager);
    }

    @Override
    public Preference createItem(String name, String prefix, AttributeSet attrs) throws ClassNotFoundException {
        Preference preference;
        Object viewKey = null;
        BridgeContext bc = null;
        Context context = this.getContext();
        if (context instanceof BridgeContext) {
            bc = (BridgeContext)context;
        }
        if (attrs instanceof BridgeXmlBlockParser) {
            viewKey = ((BridgeXmlBlockParser)attrs).getViewCookie();
        }
        try {
            preference = (Preference)super.createItem(name, prefix, attrs);
        }
        catch (InflateException | ClassNotFoundException exception) {
            if (("android.support.v7.preference".equals(prefix) || "androidx.preference".equals(prefix)) && "SwitchPreferenceCompat".equals(name)) {
                preference = (Preference)super.createItem("SwitchPreference", prefix, attrs);
            }
            Bridge.getLog().error("INFLATE", exception.getMessage(), null, null);
            throw exception;
        }
        if (viewKey != null && bc != null) {
            bc.addCookie(preference, viewKey);
        }
        return preference;
    }
}

