/*
 * Decompiled with CFR 0.152.
 */
package android.permission;

import android.annotation.NonNull;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import com.android.internal.util.Preconditions;

@SystemApi
public class AdminPermissionControlParams
implements Parcelable {
    @NonNull
    private final String mGranteePackageName;
    @NonNull
    private final String mPermission;
    private final int mGrantState;
    private final boolean mCanAdminGrantSensorsPermissions;
    @NonNull
    public static final Parcelable.Creator<AdminPermissionControlParams> CREATOR = new Parcelable.Creator<AdminPermissionControlParams>(){

        @Override
        public AdminPermissionControlParams createFromParcel(Parcel in) {
            String granteePackageName = in.readString();
            String permission2 = in.readString();
            int grantState = in.readInt();
            boolean mayAdminGrantSensorPermissions = in.readBoolean();
            return new AdminPermissionControlParams(granteePackageName, permission2, grantState, mayAdminGrantSensorPermissions);
        }

        public AdminPermissionControlParams[] newArray(int size) {
            return new AdminPermissionControlParams[size];
        }
    };

    public AdminPermissionControlParams(@NonNull String granteePackageName, @NonNull String permission2, int grantState, boolean canAdminGrantSensorsPermissions) {
        Preconditions.checkStringNotEmpty(granteePackageName, "Package name must not be empty.");
        Preconditions.checkStringNotEmpty(permission2, "Permission must not be empty.");
        Preconditions.checkArgument(grantState == 1 || grantState == 2 || grantState == 0);
        this.mGranteePackageName = granteePackageName;
        this.mPermission = permission2;
        this.mGrantState = grantState;
        this.mCanAdminGrantSensorsPermissions = canAdminGrantSensorsPermissions;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeString(this.mGranteePackageName);
        dest.writeString(this.mPermission);
        dest.writeInt(this.mGrantState);
        dest.writeBoolean(this.mCanAdminGrantSensorsPermissions);
    }

    @NonNull
    public String getGranteePackageName() {
        return this.mGranteePackageName;
    }

    @NonNull
    public String getPermission() {
        return this.mPermission;
    }

    public int getGrantState() {
        return this.mGrantState;
    }

    public boolean canAdminGrantSensorsPermissions() {
        return this.mCanAdminGrantSensorsPermissions;
    }

    public String toString() {
        return String.format("Grantee %s Permission %s state: %d admin grant of sensors permissions: %b", this.mGranteePackageName, this.mPermission, this.mGrantState, this.mCanAdminGrantSensorsPermissions);
    }
}

