/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator.persistence;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.annotation.Nullable;
import android.annotation.SystemApi;
import android.os.VibrationEffect;
import android.os.vibrator.persistence.ParsedVibration;
import android.util.Xml;
import com.android.internal.vibrator.persistence.VibrationEffectXmlParser;
import com.android.internal.vibrator.persistence.XmlParserException;
import com.android.internal.vibrator.persistence.XmlReader;
import com.android.internal.vibrator.persistence.XmlValidator;
import com.android.modules.utils.TypedXmlPullParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.xmlpull.v1.XmlPullParserException;

@SystemApi
@FlaggedApi(value="android.os.vibrator.vibration_xml_apis")
public class VibrationXmlParser {
    public static final String APPLICATION_VIBRATION_XML_MIME_TYPE = "application/vnd.android.haptics.vibration+xml";
    public static final int FLAG_ALLOW_HIDDEN_APIS = 1;

    public static boolean isSupportedMimeType(@Nullable String mimeType) {
        return APPLICATION_VIBRATION_XML_MIME_TYPE.equals(mimeType);
    }

    @SystemApi
    @FlaggedApi(value="android.os.vibrator.vibration_xml_apis")
    @NonNull
    public static ParsedVibration parse(@NonNull InputStream inputStream) throws IOException {
        return VibrationXmlParser.parseDocument(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    @SystemApi
    @FlaggedApi(value="android.os.vibrator.vibration_xml_apis")
    @NonNull
    public static VibrationEffect parseVibrationEffect(@NonNull InputStream inputStream) throws IOException {
        return VibrationXmlParser.parseVibrationEffect(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
    }

    @NonNull
    public static VibrationEffect parseVibrationEffect(@NonNull Reader reader) throws IOException {
        return VibrationXmlParser.parseVibrationEffect(reader, 0);
    }

    @NonNull
    public static VibrationEffect parseVibrationEffect(@NonNull Reader reader, int flags) throws IOException {
        return VibrationXmlParser.parseDocumentInternal(reader, flags, VibrationXmlParser::parseVibrationEffectInternal);
    }

    @NonNull
    public static ParsedVibration parseDocument(@NonNull Reader reader) throws IOException {
        return VibrationXmlParser.parseDocument(reader, 0);
    }

    @NonNull
    public static ParsedVibration parseDocument(@NonNull Reader reader, int flags) throws IOException {
        return VibrationXmlParser.parseDocumentInternal(reader, flags, VibrationXmlParser::parseElementInternal);
    }

    @NonNull
    public static ParsedVibration parseElement(@NonNull TypedXmlPullParser parser, int flags) throws IOException {
        try {
            return VibrationXmlParser.parseElementInternal(parser, flags);
        }
        catch (XmlParserException e) {
            throw new ParseFailedException(e);
        }
    }

    @NonNull
    private static ParsedVibration parseElementInternal(@NonNull TypedXmlPullParser parser, int flags) throws IOException, XmlParserException {
        String tagName;
        XmlValidator.checkStartTag(parser);
        switch (tagName = parser.getName()) {
            case "vibration-effect": {
                return new ParsedVibration(VibrationXmlParser.parseVibrationEffectInternal(parser, flags));
            }
            case "vibration-select": {
                return VibrationXmlParser.parseVibrationSelectInternal(parser, flags);
            }
        }
        throw new ParseFailedException("Unexpected tag " + tagName + " when parsing a vibration");
    }

    @NonNull
    private static ParsedVibration parseVibrationSelectInternal(@NonNull TypedXmlPullParser parser, int flags) throws IOException, XmlParserException {
        XmlValidator.checkStartTag(parser, "vibration-select");
        XmlValidator.checkTagHasNoUnexpectedAttributes(parser, new String[0]);
        int rootDepth = parser.getDepth();
        ArrayList<VibrationEffect> effects = new ArrayList<VibrationEffect>();
        while (XmlReader.readNextTagWithin(parser, rootDepth)) {
            effects.add(VibrationXmlParser.parseVibrationEffectInternal(parser, flags));
        }
        return new ParsedVibration(effects);
    }

    @NonNull
    private static VibrationEffect parseVibrationEffectInternal(@NonNull TypedXmlPullParser parser, int flags) throws IOException, XmlParserException {
        int parserFlags = 0;
        if ((flags & 1) != 0) {
            parserFlags |= 1;
        }
        return VibrationEffectXmlParser.parseTag(parser, parserFlags).deserialize();
    }

    @NonNull
    private static <T> T parseDocumentInternal(@NonNull Reader reader, int flags, ElementParser<T> parseLogic) throws IOException {
        try {
            TypedXmlPullParser parser = Xml.newFastPullParser();
            parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
            parser.setInput(reader);
            XmlReader.readDocumentStart(parser);
            T result = parseLogic.parse(parser, flags);
            XmlReader.readDocumentEndTag(parser);
            return result;
        }
        catch (XmlPullParserException e) {
            throw new ParseFailedException("Error initializing XMLPullParser", e);
        }
        catch (XmlParserException e) {
            throw new ParseFailedException(e);
        }
    }

    private VibrationXmlParser() {
    }

    private static interface ElementParser<T> {
        @NonNull
        public T parse(@NonNull TypedXmlPullParser var1, int var2) throws IOException, XmlParserException;
    }

    public static class ParseFailedException
    extends IOException {
        private ParseFailedException(String message) {
            super(message);
        }

        private ParseFailedException(XmlParserException parserException) {
            this(parserException.getMessage(), parserException);
        }

        private ParseFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Flags {
    }
}

