/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.annotation.FlaggedApi;
import android.annotation.NonNull;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.VibrationEffect;
import android.os.VibratorInfo;
import android.os.vibrator.VibrationEffectSegment;
import com.android.internal.util.Preconditions;
import java.util.Locale;
import java.util.Objects;

@FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
public class PwleSegment
extends VibrationEffectSegment {
    private final float mStartAmplitude;
    private final float mStartFrequencyHz;
    private final float mEndAmplitude;
    private final float mEndFrequencyHz;
    private final long mDuration;
    @NonNull
    public static final Parcelable.Creator<PwleSegment> CREATOR = new Parcelable.Creator<PwleSegment>(){

        @Override
        public PwleSegment createFromParcel(Parcel in) {
            in.readInt();
            return new PwleSegment(in);
        }

        public PwleSegment[] newArray(int size) {
            return new PwleSegment[size];
        }
    };

    PwleSegment(@NonNull Parcel in) {
        this(in.readFloat(), in.readFloat(), in.readFloat(), in.readFloat(), in.readLong());
    }

    @FlaggedApi(value="android.os.vibrator.normalized_pwle_effects")
    public PwleSegment(float startAmplitude, float endAmplitude, float startFrequencyHz, float endFrequencyHz, long duration) {
        this.mStartAmplitude = startAmplitude;
        this.mEndAmplitude = endAmplitude;
        this.mStartFrequencyHz = startFrequencyHz;
        this.mEndFrequencyHz = endFrequencyHz;
        this.mDuration = duration;
    }

    public float getStartAmplitude() {
        return this.mStartAmplitude;
    }

    public float getEndAmplitude() {
        return this.mEndAmplitude;
    }

    public float getStartFrequencyHz() {
        return this.mStartFrequencyHz;
    }

    public float getEndFrequencyHz() {
        return this.mEndFrequencyHz;
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    public boolean equals(Object o) {
        if (!(o instanceof PwleSegment)) {
            return false;
        }
        PwleSegment other = (PwleSegment)o;
        return Float.compare(this.mStartAmplitude, other.mStartAmplitude) == 0 && Float.compare(this.mEndAmplitude, other.mEndAmplitude) == 0 && Float.compare(this.mStartFrequencyHz, other.mStartFrequencyHz) == 0 && Float.compare(this.mEndFrequencyHz, other.mEndFrequencyHz) == 0 && this.mDuration == other.mDuration;
    }

    @Override
    public boolean areVibrationFeaturesSupported(@NonNull VibratorInfo vibratorInfo) {
        boolean areFeaturesSupported = vibratorInfo.areEnvelopeEffectsSupported();
        float minFrequency = vibratorInfo.getFrequencyProfile().getMinFrequencyHz();
        float maxFrequency = vibratorInfo.getFrequencyProfile().getMaxFrequencyHz();
        return areFeaturesSupported &= this.mStartFrequencyHz >= minFrequency && this.mStartFrequencyHz <= maxFrequency && this.mEndFrequencyHz >= minFrequency && this.mEndFrequencyHz <= maxFrequency;
    }

    @Override
    public boolean isHapticFeedbackCandidate() {
        return true;
    }

    @Override
    public void validate() {
        Preconditions.checkArgumentPositive(this.mStartFrequencyHz, "Start frequency must be greater than zero.");
        Preconditions.checkArgumentPositive(this.mEndFrequencyHz, "End frequency must be greater than zero.");
        Preconditions.checkArgumentPositive(this.mDuration, "Time must be greater than zero.");
        Preconditions.checkArgumentInRange(this.mStartAmplitude, 0.0f, 1.0f, "startAmplitude");
        Preconditions.checkArgumentInRange(this.mEndAmplitude, 0.0f, 1.0f, "endAmplitude");
    }

    @NonNull
    public PwleSegment resolve(int defaultAmplitude) {
        return this;
    }

    @NonNull
    public PwleSegment scale(float scaleFactor) {
        float newStartAmplitude = VibrationEffect.scale(this.mStartAmplitude, scaleFactor);
        float newEndAmplitude = VibrationEffect.scale(this.mEndAmplitude, scaleFactor);
        if (Float.compare(this.mStartAmplitude, newStartAmplitude) == 0 && Float.compare(this.mEndAmplitude, newEndAmplitude) == 0) {
            return this;
        }
        return new PwleSegment(newStartAmplitude, newEndAmplitude, this.mStartFrequencyHz, this.mEndFrequencyHz, this.mDuration);
    }

    @NonNull
    public PwleSegment scaleLinearly(float scaleFactor) {
        float newStartAmplitude = VibrationEffect.scaleLinearly(this.mStartAmplitude, scaleFactor);
        float newEndAmplitude = VibrationEffect.scaleLinearly(this.mEndAmplitude, scaleFactor);
        if (Float.compare(this.mStartAmplitude, newStartAmplitude) == 0 && Float.compare(this.mEndAmplitude, newEndAmplitude) == 0) {
            return this;
        }
        return new PwleSegment(newStartAmplitude, newEndAmplitude, this.mStartFrequencyHz, this.mEndFrequencyHz, this.mDuration);
    }

    @NonNull
    public PwleSegment applyEffectStrength(int effectStrength) {
        return this;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.mStartAmplitude), Float.valueOf(this.mEndAmplitude), Float.valueOf(this.mStartFrequencyHz), Float.valueOf(this.mEndFrequencyHz), this.mDuration);
    }

    public String toString() {
        return "Pwle{startAmplitude=" + this.mStartAmplitude + ", endAmplitude=" + this.mEndAmplitude + ", startFrequencyHz=" + this.mStartFrequencyHz + ", endFrequencyHz=" + this.mEndFrequencyHz + ", duration=" + this.mDuration + "}";
    }

    @Override
    public String toDebugString() {
        return String.format(Locale.US, "Pwle=%dms(amplitude=%.2f @ %.2fHz to %.2f @ %.2fHz)", this.mDuration, Float.valueOf(this.mStartAmplitude), Float.valueOf(this.mStartFrequencyHz), Float.valueOf(this.mEndAmplitude), Float.valueOf(this.mEndFrequencyHz));
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(5);
        dest.writeFloat(this.mStartAmplitude);
        dest.writeFloat(this.mEndAmplitude);
        dest.writeFloat(this.mStartFrequencyHz);
        dest.writeFloat(this.mEndFrequencyHz);
        dest.writeLong(this.mDuration);
    }
}

