/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.VibrationEffect;
import android.os.VibratorInfo;
import android.os.vibrator.VibrationEffectSegment;
import com.android.internal.util.Preconditions;
import java.util.Locale;
import java.util.Objects;

public class PrimitiveSegment
extends VibrationEffectSegment {
    public static final float DEFAULT_SCALE = 1.0f;
    public static final int DEFAULT_DELAY_MILLIS = 0;
    public static final int DEFAULT_DELAY_TYPE = 0;
    private final int mPrimitiveId;
    private final float mScale;
    private final int mDelay;
    private final int mDelayType;
    @NonNull
    public static final Parcelable.Creator<PrimitiveSegment> CREATOR = new Parcelable.Creator<PrimitiveSegment>(){

        @Override
        public PrimitiveSegment createFromParcel(Parcel in) {
            in.readInt();
            return new PrimitiveSegment(in);
        }

        public PrimitiveSegment[] newArray(int size) {
            return new PrimitiveSegment[size];
        }
    };

    PrimitiveSegment(@NonNull Parcel in) {
        this(in.readInt(), in.readFloat(), in.readInt(), in.readInt());
    }

    public PrimitiveSegment(int id2, float scale, int delay) {
        this(id2, scale, delay, 0);
    }

    public PrimitiveSegment(int id2, float scale, int delay, int delayType) {
        this.mPrimitiveId = id2;
        this.mScale = scale;
        this.mDelay = delay;
        this.mDelayType = delayType;
    }

    public int getPrimitiveId() {
        return this.mPrimitiveId;
    }

    public float getScale() {
        return this.mScale;
    }

    public int getDelay() {
        return this.mDelay;
    }

    public int getDelayType() {
        return this.mDelayType;
    }

    @Override
    public long getDuration() {
        return -1L;
    }

    @Override
    public long getDuration(@Nullable VibratorInfo vibratorInfo) {
        if (vibratorInfo == null) {
            return this.getDuration();
        }
        int duration = vibratorInfo.getPrimitiveDuration(this.mPrimitiveId);
        return duration > 0 ? (long)(duration + this.mDelay) : this.getDuration();
    }

    @Override
    public boolean areVibrationFeaturesSupported(@NonNull VibratorInfo vibratorInfo) {
        return vibratorInfo.isPrimitiveSupported(this.mPrimitiveId);
    }

    @Override
    public boolean isHapticFeedbackCandidate() {
        return true;
    }

    @NonNull
    public PrimitiveSegment resolve(int defaultAmplitude) {
        return this;
    }

    @NonNull
    public PrimitiveSegment scale(float scaleFactor) {
        float newScale = VibrationEffect.scale(this.mScale, scaleFactor);
        if (Float.compare(this.mScale, newScale) == 0) {
            return this;
        }
        return new PrimitiveSegment(this.mPrimitiveId, newScale, this.mDelay, this.mDelayType);
    }

    @NonNull
    public PrimitiveSegment scaleLinearly(float scaleFactor) {
        float newScale = VibrationEffect.scaleLinearly(this.mScale, scaleFactor);
        if (Float.compare(this.mScale, newScale) == 0) {
            return this;
        }
        return new PrimitiveSegment(this.mPrimitiveId, newScale, this.mDelay, this.mDelayType);
    }

    @NonNull
    public PrimitiveSegment applyEffectStrength(int effectStrength) {
        return this;
    }

    @Override
    public void validate() {
        Preconditions.checkArgumentInRange(this.mPrimitiveId, 0, 8, "primitiveId");
        Preconditions.checkArgumentInRange(this.mScale, 0.0f, 1.0f, "scale");
        VibrationEffectSegment.checkDurationArgument(this.mDelay, "delay");
        Preconditions.checkArgument(PrimitiveSegment.isValidDelayType(this.mDelayType), "delayType");
    }

    @Override
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(2);
        dest.writeInt(this.mPrimitiveId);
        dest.writeFloat(this.mScale);
        dest.writeInt(this.mDelay);
        dest.writeInt(this.mDelayType);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        return "Primitive{primitive=" + VibrationEffect.Composition.primitiveToString(this.mPrimitiveId) + ", scale=" + this.mScale + ", delay=" + this.mDelay + ", delayType=" + VibrationEffect.Composition.delayTypeToString(this.mDelayType) + '}';
    }

    @Override
    public String toDebugString() {
        return String.format(Locale.ROOT, "Primitive=%s(scale=%.2f, %s=%dms)", VibrationEffect.Composition.primitiveToString(this.mPrimitiveId), Float.valueOf(this.mScale), PrimitiveSegment.toDelayTypeDebugString(this.mDelayType), this.mDelay);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PrimitiveSegment that = (PrimitiveSegment)o;
        return this.mPrimitiveId == that.mPrimitiveId && Float.compare(that.mScale, this.mScale) == 0 && this.mDelay == that.mDelay && this.mDelayType == that.mDelayType;
    }

    public int hashCode() {
        return Objects.hash(this.mPrimitiveId, Float.valueOf(this.mScale), this.mDelay, this.mDelayType);
    }

    private static boolean isValidDelayType(int delayType) {
        boolean bl;
        switch (delayType) {
            case 0: 
            case 1: {
                bl = true;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    private static String toDelayTypeDebugString(int delayType) {
        String string2;
        switch (delayType) {
            case 1: {
                string2 = "startOffset";
                break;
            }
            default: {
                string2 = "pause";
            }
        }
        return string2;
    }
}

