/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.annotation.NonNull;
import android.annotation.Nullable;
import android.os.VibratorInfo;
import android.util.Range;
import android.util.Slog;
import android.util.SparseBooleanArray;
import android.util.SparseIntArray;
import com.android.internal.hidden_from_bootclasspath.android.os.vibrator.Flags;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.function.Function;

public class MultiVibratorInfo
extends VibratorInfo {
    private static final String TAG = "MultiVibratorInfo";
    private static final float EPSILON = 1.0E-5f;

    public MultiVibratorInfo(int id2, VibratorInfo[] vibrators) {
        this(id2, vibrators, MultiVibratorInfo.frequencyProfileLegacyIntersection(vibrators), MultiVibratorInfo.frequencyProfileIntersection(vibrators));
    }

    private MultiVibratorInfo(int id2, VibratorInfo[] vibrators, VibratorInfo.FrequencyProfileLegacy mergedLegacyProfile, VibratorInfo.FrequencyProfile mergedProfile) {
        super(id2, MultiVibratorInfo.capabilitiesIntersection(vibrators, Flags.normalizedPwleEffects() ? mergedProfile.isEmpty() : mergedLegacyProfile.isEmpty()), MultiVibratorInfo.supportedEffectsIntersection(vibrators), MultiVibratorInfo.supportedBrakingIntersection(vibrators), MultiVibratorInfo.supportedPrimitivesAndDurationsIntersection(vibrators), MultiVibratorInfo.integerLimitIntersection(vibrators, VibratorInfo::getPrimitiveDelayMax), MultiVibratorInfo.integerLimitIntersection(vibrators, VibratorInfo::getCompositionSizeMax), MultiVibratorInfo.integerLimitIntersection(vibrators, VibratorInfo::getPwlePrimitiveDurationMax), MultiVibratorInfo.integerLimitIntersection(vibrators, VibratorInfo::getPwleSizeMax), MultiVibratorInfo.floatPropertyIntersection(vibrators, VibratorInfo::getQFactor), mergedLegacyProfile, mergedProfile, MultiVibratorInfo.integerLimitIntersection(vibrators, VibratorInfo::getMaxEnvelopeEffectSize), MultiVibratorInfo.integerLimitIntersection(vibrators, VibratorInfo::getMinEnvelopeEffectControlPointDurationMillis), MultiVibratorInfo.integerLimitIntersection(vibrators, VibratorInfo::getMaxEnvelopeEffectControlPointDurationMillis));
    }

    private static int capabilitiesIntersection(VibratorInfo[] infos, boolean frequencyProfileIsEmpty) {
        int intersection = -1;
        for (VibratorInfo info : infos) {
            intersection = (int)((long)intersection & info.getCapabilities());
        }
        if (frequencyProfileIsEmpty) {
            intersection &= 0xFFFFFDFF;
        }
        return intersection;
    }

    @Nullable
    private static SparseBooleanArray supportedBrakingIntersection(VibratorInfo[] infos) {
        for (VibratorInfo info : infos) {
            if (info.isBrakingSupportKnown()) continue;
            return null;
        }
        SparseBooleanArray intersection = new SparseBooleanArray();
        SparseBooleanArray firstVibratorBraking = infos[0].getSupportedBraking();
        block1: for (int i = 0; i < firstVibratorBraking.size(); ++i) {
            int brakingId = firstVibratorBraking.keyAt(i);
            if (!firstVibratorBraking.valueAt(i)) continue;
            for (int j = 1; j < infos.length; ++j) {
                if (!infos[j].hasBrakingSupport(brakingId)) continue block1;
            }
            intersection.put(brakingId, true);
        }
        return intersection;
    }

    @Nullable
    private static SparseBooleanArray supportedEffectsIntersection(VibratorInfo[] infos) {
        for (VibratorInfo info : infos) {
            if (info.isEffectSupportKnown()) continue;
            return null;
        }
        SparseBooleanArray intersection = new SparseBooleanArray();
        SparseBooleanArray firstVibratorEffects = infos[0].getSupportedEffects();
        block1: for (int i = 0; i < firstVibratorEffects.size(); ++i) {
            int effectId = firstVibratorEffects.keyAt(i);
            if (!firstVibratorEffects.valueAt(i)) continue;
            for (int j = 1; j < infos.length; ++j) {
                if (infos[j].isEffectSupported(effectId) != 1) continue block1;
            }
            intersection.put(effectId, true);
        }
        return intersection;
    }

    @NonNull
    private static SparseIntArray supportedPrimitivesAndDurationsIntersection(VibratorInfo[] infos) {
        SparseIntArray intersection = new SparseIntArray();
        SparseIntArray firstVibratorPrimitives = infos[0].getSupportedPrimitives();
        block0: for (int i = 0; i < firstVibratorPrimitives.size(); ++i) {
            int primitiveId = firstVibratorPrimitives.keyAt(i);
            int primitiveDuration = firstVibratorPrimitives.valueAt(i);
            if (primitiveDuration == 0) continue;
            for (int j = 1; j < infos.length; ++j) {
                int vibratorPrimitiveDuration = infos[j].getPrimitiveDuration(primitiveId);
                if (vibratorPrimitiveDuration == 0) continue block0;
                primitiveDuration = Math.max(primitiveDuration, vibratorPrimitiveDuration);
            }
            intersection.put(primitiveId, primitiveDuration);
        }
        return intersection;
    }

    private static int integerLimitIntersection(VibratorInfo[] infos, Function<VibratorInfo, Integer> propertyGetter) {
        int limit = 0;
        for (VibratorInfo info : infos) {
            int vibratorLimit = propertyGetter.apply(info);
            if (limit != 0 && (vibratorLimit <= 0 || vibratorLimit >= limit)) continue;
            limit = vibratorLimit;
        }
        return limit;
    }

    private static float floatPropertyIntersection(VibratorInfo[] infos, Function<VibratorInfo, Float> propertyGetter) {
        float property = propertyGetter.apply(infos[0]).floatValue();
        if (Float.isNaN(property)) {
            return Float.NaN;
        }
        for (int i = 1; i < infos.length; ++i) {
            if (Float.compare(property, propertyGetter.apply(infos[i]).floatValue()) == 0) continue;
            return Float.NaN;
        }
        return property;
    }

    @NonNull
    private static VibratorInfo.FrequencyProfile frequencyProfileIntersection(VibratorInfo[] infos) {
        if (infos == null || infos.length == 0) {
            return new VibratorInfo.FrequencyProfile(Float.NaN, null, null);
        }
        float resonantFreq = MultiVibratorInfo.floatPropertyIntersection(infos, VibratorInfo::getResonantFrequencyHz);
        if (Float.isNaN(resonantFreq)) {
            return new VibratorInfo.FrequencyProfile(Float.NaN, null, null);
        }
        float minFrequency = 0.0f;
        float maxFrequency = Float.MAX_VALUE;
        TreeSet<Float> allFrequencies = new TreeSet<Float>();
        for (VibratorInfo info : infos) {
            float newMinFrequency = info.getFrequencyProfile().getMinFrequencyHz();
            float newMaxFrequency = info.getFrequencyProfile().getMaxFrequencyHz();
            if (Float.isNaN(newMinFrequency) || Float.isNaN(newMaxFrequency)) {
                return new VibratorInfo.FrequencyProfile(Float.NaN, null, null);
            }
            minFrequency = Math.max(minFrequency, newMinFrequency);
            maxFrequency = Math.min(maxFrequency, newMaxFrequency);
            if (info.getFrequencyProfile().getFrequenciesHz() == null) {
                return new VibratorInfo.FrequencyProfile(Float.NaN, null, null);
            }
            for (float frequency : info.getFrequencyProfile().getFrequenciesHz()) {
                allFrequencies.add(Float.valueOf(frequency));
            }
        }
        if (minFrequency > maxFrequency) {
            return new VibratorInfo.FrequencyProfile(Float.NaN, null, null);
        }
        Iterator iterator = allFrequencies.iterator();
        while (iterator.hasNext()) {
            float frequency = ((Float)iterator.next()).floatValue();
            if (!(frequency < minFrequency) && !(frequency > maxFrequency)) continue;
            iterator.remove();
        }
        float[] frequencies = new float[allFrequencies.size()];
        float[] accelerations = new float[allFrequencies.size()];
        int idx = 0;
        for (Float frequency : allFrequencies) {
            float outputAcceleration = Float.MAX_VALUE;
            for (VibratorInfo info : infos) {
                outputAcceleration = Math.min(outputAcceleration, info.getFrequencyProfile().getOutputAccelerationGs(frequency.floatValue()));
            }
            frequencies[idx] = frequency.floatValue();
            accelerations[idx] = outputAcceleration;
            ++idx;
        }
        return new VibratorInfo.FrequencyProfile(resonantFreq, frequencies, accelerations);
    }

    @NonNull
    private static VibratorInfo.FrequencyProfileLegacy frequencyProfileLegacyIntersection(VibratorInfo[] infos) {
        float freqResolution = MultiVibratorInfo.floatPropertyIntersection(infos, info -> Float.valueOf(info.getFrequencyProfileLegacy().getFrequencyResolutionHz()));
        float resonantFreq = MultiVibratorInfo.floatPropertyIntersection(infos, VibratorInfo::getResonantFrequencyHz);
        Range<Float> freqRange = MultiVibratorInfo.frequencyRangeIntersection(infos, freqResolution);
        if (freqRange == null || Float.isNaN(freqResolution)) {
            return new VibratorInfo.FrequencyProfileLegacy(resonantFreq, Float.NaN, freqResolution, null);
        }
        int amplitudeCount = Math.round(1.0f + (freqRange.getUpper().floatValue() - freqRange.getLower().floatValue()) / freqResolution);
        float[] maxAmplitudes = new float[amplitudeCount];
        Arrays.fill(maxAmplitudes, Float.MAX_VALUE);
        for (VibratorInfo info2 : infos) {
            Range<Float> vibratorFreqRange = info2.getFrequencyProfileLegacy().getFrequencyRangeHz();
            float[] vibratorMaxAmplitudes = info2.getFrequencyProfileLegacy().getMaxAmplitudes();
            int vibratorStartIdx = Math.round((freqRange.getLower().floatValue() - vibratorFreqRange.getLower().floatValue()) / freqResolution);
            int vibratorEndIdx = vibratorStartIdx + maxAmplitudes.length - 1;
            if (vibratorStartIdx < 0 || vibratorEndIdx >= vibratorMaxAmplitudes.length) {
                Slog.w(TAG, "Error calculating the intersection of vibrator frequency profiles: attempted to fetch from vibrator " + info2.getId() + " max amplitude with bad index " + vibratorStartIdx);
                return new VibratorInfo.FrequencyProfileLegacy(resonantFreq, Float.NaN, Float.NaN, null);
            }
            for (int i = 0; i < maxAmplitudes.length; ++i) {
                maxAmplitudes[i] = Math.min(maxAmplitudes[i], vibratorMaxAmplitudes[vibratorStartIdx + i]);
            }
        }
        return new VibratorInfo.FrequencyProfileLegacy(resonantFreq, freqRange.getLower().floatValue(), freqResolution, maxAmplitudes);
    }

    @Nullable
    private static Range<Float> frequencyRangeIntersection(VibratorInfo[] infos, float frequencyResolution) {
        Range<Float> firstRange = infos[0].getFrequencyProfileLegacy().getFrequencyRangeHz();
        if (firstRange == null) {
            return null;
        }
        float intersectionLower = firstRange.getLower().floatValue();
        float intersectionUpper = firstRange.getUpper().floatValue();
        for (int i = 1; i < infos.length; ++i) {
            Range<Float> vibratorRange = infos[i].getFrequencyProfileLegacy().getFrequencyRangeHz();
            if (vibratorRange == null) {
                return null;
            }
            if (vibratorRange.getLower().floatValue() >= intersectionUpper || vibratorRange.getUpper().floatValue() <= intersectionLower) {
                return null;
            }
            float frequencyDelta = Math.abs(intersectionLower - vibratorRange.getLower().floatValue());
            if (frequencyDelta % frequencyResolution > 1.0E-5f) {
                return null;
            }
            intersectionLower = Math.max(intersectionLower, vibratorRange.getLower().floatValue());
            intersectionUpper = Math.min(intersectionUpper, vibratorRange.getUpper().floatValue());
        }
        if (intersectionUpper - intersectionLower < frequencyResolution) {
            return null;
        }
        return Range.create(Float.valueOf(intersectionLower), Float.valueOf(intersectionUpper));
    }
}

