/*
 * Decompiled with CFR 0.152.
 */
package android.os.vibrator;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.vibrator.IVibrationSession;

public interface IVibrationSessionCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.os.vibrator.IVibrationSessionCallback";

    public void onStarted(IVibrationSession var1) throws RemoteException;

    public void onFinishing() throws RemoteException;

    public void onFinished(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IVibrationSessionCallback {
        static final int TRANSACTION_onStarted = 1;
        static final int TRANSACTION_onFinishing = 2;
        static final int TRANSACTION_onFinished = 3;

        public Stub() {
            this.attachInterface(this, IVibrationSessionCallback.DESCRIPTOR);
        }

        public static IVibrationSessionCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IVibrationSessionCallback.DESCRIPTOR);
            if (iin != null && iin instanceof IVibrationSessionCallback) {
                return (IVibrationSessionCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onStarted";
                }
                case 2: {
                    return "onFinishing";
                }
                case 3: {
                    return "onFinished";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IVibrationSessionCallback.DESCRIPTOR;
            if (code >= 1 && code <= 0xFFFFFF) {
                data.enforceInterface(descriptor);
            }
            if (code == 1598968902) {
                reply.writeString(descriptor);
                return true;
            }
            switch (code) {
                case 1: {
                    IVibrationSession _arg0 = IVibrationSession.Stub.asInterface(data.readStrongBinder());
                    data.enforceNoDataAvail();
                    this.onStarted(_arg0);
                    break;
                }
                case 2: {
                    this.onFinishing();
                    break;
                }
                case 3: {
                    int _arg0 = data.readInt();
                    data.enforceNoDataAvail();
                    this.onFinished(_arg0);
                    break;
                }
                default: {
                    return super.onTransact(code, data, reply, flags);
                }
            }
            return true;
        }

        @Override
        public int getMaxTransactionId() {
            return 2;
        }

        private static class Proxy
        implements IVibrationSessionCallback {
            private IBinder mRemote;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IVibrationSessionCallback.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStarted(IVibrationSession session) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVibrationSessionCallback.DESCRIPTOR);
                    _data.writeStrongInterface(session);
                    boolean bl = this.mRemote.transact(1, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onFinishing() throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVibrationSessionCallback.DESCRIPTOR);
                    boolean bl = this.mRemote.transact(2, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFinished(int status) throws RemoteException {
                Parcel _data = Parcel.obtain(this.asBinder());
                try {
                    _data.writeInterfaceToken(IVibrationSessionCallback.DESCRIPTOR);
                    _data.writeInt(status);
                    boolean bl = this.mRemote.transact(3, _data, null, 1);
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IVibrationSessionCallback {
        @Override
        public void onStarted(IVibrationSession session) throws RemoteException {
        }

        @Override
        public void onFinishing() throws RemoteException {
        }

        @Override
        public void onFinished(int status) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

